/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StackHciNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#custom_location_id StackHciNetworkInterface#custom_location_id}
    */
    readonly customLocationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#dns_servers StackHciNetworkInterface#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#id StackHciNetworkInterface#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#location StackHciNetworkInterface#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#mac_address StackHciNetworkInterface#mac_address}
    */
    readonly macAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#name StackHciNetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#resource_group_name StackHciNetworkInterface#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#tags StackHciNetworkInterface#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#ip_configuration StackHciNetworkInterface#ip_configuration}
    */
    readonly ipConfiguration: StackHciNetworkInterfaceIpConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#timeouts StackHciNetworkInterface#timeouts}
    */
    readonly timeouts?: StackHciNetworkInterfaceTimeouts;
}
export interface StackHciNetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#private_ip_address StackHciNetworkInterface#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#subnet_id StackHciNetworkInterface#subnet_id}
    */
    readonly subnetId: string;
}
export declare function stackHciNetworkInterfaceIpConfigurationToTerraform(struct?: StackHciNetworkInterfaceIpConfigurationOutputReference | StackHciNetworkInterfaceIpConfiguration): any;
export declare function stackHciNetworkInterfaceIpConfigurationToHclTerraform(struct?: StackHciNetworkInterfaceIpConfigurationOutputReference | StackHciNetworkInterfaceIpConfiguration): any;
export declare class StackHciNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciNetworkInterfaceIpConfiguration | undefined;
    set internalValue(value: StackHciNetworkInterfaceIpConfiguration | undefined);
    get gateway(): string;
    get prefixLength(): string;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface StackHciNetworkInterfaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#create StackHciNetworkInterface#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#delete StackHciNetworkInterface#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#read StackHciNetworkInterface#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#update StackHciNetworkInterface#update}
    */
    readonly update?: string;
}
export declare function stackHciNetworkInterfaceTimeoutsToTerraform(struct?: StackHciNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare function stackHciNetworkInterfaceTimeoutsToHclTerraform(struct?: StackHciNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare class StackHciNetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciNetworkInterfaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciNetworkInterfaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface azurerm_stack_hci_network_interface}
*/
export declare class StackHciNetworkInterface extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stack_hci_network_interface";
    /**
    * Generates CDKTF code for importing a StackHciNetworkInterface resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StackHciNetworkInterface to import
    * @param importFromId The id of the existing StackHciNetworkInterface that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StackHciNetworkInterface to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_network_interface azurerm_stack_hci_network_interface} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StackHciNetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: StackHciNetworkInterfaceConfig);
    private _customLocationId?;
    get customLocationId(): string;
    set customLocationId(value: string);
    get customLocationIdInput(): string | undefined;
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _macAddress?;
    get macAddress(): string;
    set macAddress(value: string);
    resetMacAddress(): void;
    get macAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ipConfiguration;
    get ipConfiguration(): StackHciNetworkInterfaceIpConfigurationOutputReference;
    putIpConfiguration(value: StackHciNetworkInterfaceIpConfiguration): void;
    get ipConfigurationInput(): StackHciNetworkInterfaceIpConfiguration | undefined;
    private _timeouts;
    get timeouts(): StackHciNetworkInterfaceTimeoutsOutputReference;
    putTimeouts(value: StackHciNetworkInterfaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StackHciNetworkInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
