/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StackHciVirtualHardDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#block_size_in_bytes StackHciVirtualHardDisk#block_size_in_bytes}
    */
    readonly blockSizeInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#custom_location_id StackHciVirtualHardDisk#custom_location_id}
    */
    readonly customLocationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#disk_file_format StackHciVirtualHardDisk#disk_file_format}
    */
    readonly diskFileFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#disk_size_in_gb StackHciVirtualHardDisk#disk_size_in_gb}
    */
    readonly diskSizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#dynamic_enabled StackHciVirtualHardDisk#dynamic_enabled}
    */
    readonly dynamicEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#hyperv_generation StackHciVirtualHardDisk#hyperv_generation}
    */
    readonly hypervGeneration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#id StackHciVirtualHardDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#location StackHciVirtualHardDisk#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#logical_sector_in_bytes StackHciVirtualHardDisk#logical_sector_in_bytes}
    */
    readonly logicalSectorInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#name StackHciVirtualHardDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#physical_sector_in_bytes StackHciVirtualHardDisk#physical_sector_in_bytes}
    */
    readonly physicalSectorInBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#resource_group_name StackHciVirtualHardDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#storage_path_id StackHciVirtualHardDisk#storage_path_id}
    */
    readonly storagePathId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#tags StackHciVirtualHardDisk#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#timeouts StackHciVirtualHardDisk#timeouts}
    */
    readonly timeouts?: StackHciVirtualHardDiskTimeouts;
}
export interface StackHciVirtualHardDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#create StackHciVirtualHardDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#delete StackHciVirtualHardDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#read StackHciVirtualHardDisk#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#update StackHciVirtualHardDisk#update}
    */
    readonly update?: string;
}
export declare function stackHciVirtualHardDiskTimeoutsToTerraform(struct?: StackHciVirtualHardDiskTimeouts | cdktf.IResolvable): any;
export declare function stackHciVirtualHardDiskTimeoutsToHclTerraform(struct?: StackHciVirtualHardDiskTimeouts | cdktf.IResolvable): any;
export declare class StackHciVirtualHardDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciVirtualHardDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciVirtualHardDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk azurerm_stack_hci_virtual_hard_disk}
*/
export declare class StackHciVirtualHardDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stack_hci_virtual_hard_disk";
    /**
    * Generates CDKTF code for importing a StackHciVirtualHardDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StackHciVirtualHardDisk to import
    * @param importFromId The id of the existing StackHciVirtualHardDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StackHciVirtualHardDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/stack_hci_virtual_hard_disk azurerm_stack_hci_virtual_hard_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StackHciVirtualHardDiskConfig
    */
    constructor(scope: Construct, id: string, config: StackHciVirtualHardDiskConfig);
    private _blockSizeInBytes?;
    get blockSizeInBytes(): number;
    set blockSizeInBytes(value: number);
    resetBlockSizeInBytes(): void;
    get blockSizeInBytesInput(): number | undefined;
    private _customLocationId?;
    get customLocationId(): string;
    set customLocationId(value: string);
    get customLocationIdInput(): string | undefined;
    private _diskFileFormat?;
    get diskFileFormat(): string;
    set diskFileFormat(value: string);
    resetDiskFileFormat(): void;
    get diskFileFormatInput(): string | undefined;
    private _diskSizeInGb?;
    get diskSizeInGb(): number;
    set diskSizeInGb(value: number);
    get diskSizeInGbInput(): number | undefined;
    private _dynamicEnabled?;
    get dynamicEnabled(): boolean | cdktf.IResolvable;
    set dynamicEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicEnabled(): void;
    get dynamicEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hypervGeneration?;
    get hypervGeneration(): string;
    set hypervGeneration(value: string);
    resetHypervGeneration(): void;
    get hypervGenerationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logicalSectorInBytes?;
    get logicalSectorInBytes(): number;
    set logicalSectorInBytes(value: number);
    resetLogicalSectorInBytes(): void;
    get logicalSectorInBytesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalSectorInBytes?;
    get physicalSectorInBytes(): number;
    set physicalSectorInBytes(value: number);
    resetPhysicalSectorInBytes(): void;
    get physicalSectorInBytesInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storagePathId?;
    get storagePathId(): string;
    set storagePathId(value: string);
    resetStoragePathId(): void;
    get storagePathIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): StackHciVirtualHardDiskTimeoutsOutputReference;
    putTimeouts(value: StackHciVirtualHardDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StackHciVirtualHardDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
