/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountLocalUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#home_directory StorageAccountLocalUser#home_directory}
    */
    readonly homeDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#id StorageAccountLocalUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#name StorageAccountLocalUser#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#ssh_key_enabled StorageAccountLocalUser#ssh_key_enabled}
    */
    readonly sshKeyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#ssh_password_enabled StorageAccountLocalUser#ssh_password_enabled}
    */
    readonly sshPasswordEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#storage_account_id StorageAccountLocalUser#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * permission_scope block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#permission_scope StorageAccountLocalUser#permission_scope}
    */
    readonly permissionScope?: StorageAccountLocalUserPermissionScope[] | cdktf.IResolvable;
    /**
    * ssh_authorized_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#ssh_authorized_key StorageAccountLocalUser#ssh_authorized_key}
    */
    readonly sshAuthorizedKey?: StorageAccountLocalUserSshAuthorizedKey[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#timeouts StorageAccountLocalUser#timeouts}
    */
    readonly timeouts?: StorageAccountLocalUserTimeouts;
}
export interface StorageAccountLocalUserPermissionScopePermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#create StorageAccountLocalUser#create}
    */
    readonly create?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#delete StorageAccountLocalUser#delete}
    */
    readonly delete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#list StorageAccountLocalUser#list}
    */
    readonly list?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#read StorageAccountLocalUser#read}
    */
    readonly read?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#write StorageAccountLocalUser#write}
    */
    readonly write?: boolean | cdktf.IResolvable;
}
export declare function storageAccountLocalUserPermissionScopePermissionsToTerraform(struct?: StorageAccountLocalUserPermissionScopePermissionsOutputReference | StorageAccountLocalUserPermissionScopePermissions): any;
export declare function storageAccountLocalUserPermissionScopePermissionsToHclTerraform(struct?: StorageAccountLocalUserPermissionScopePermissionsOutputReference | StorageAccountLocalUserPermissionScopePermissions): any;
export declare class StorageAccountLocalUserPermissionScopePermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountLocalUserPermissionScopePermissions | undefined;
    set internalValue(value: StorageAccountLocalUserPermissionScopePermissions | undefined);
    private _create?;
    get create(): boolean | cdktf.IResolvable;
    set create(value: boolean | cdktf.IResolvable);
    resetCreate(): void;
    get createInput(): boolean | cdktf.IResolvable | undefined;
    private _delete?;
    get delete(): boolean | cdktf.IResolvable;
    set delete(value: boolean | cdktf.IResolvable);
    resetDelete(): void;
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _list?;
    get list(): boolean | cdktf.IResolvable;
    set list(value: boolean | cdktf.IResolvable);
    resetList(): void;
    get listInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    get read(): boolean | cdktf.IResolvable;
    set read(value: boolean | cdktf.IResolvable);
    resetRead(): void;
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _write?;
    get write(): boolean | cdktf.IResolvable;
    set write(value: boolean | cdktf.IResolvable);
    resetWrite(): void;
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountLocalUserPermissionScope {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#resource_name StorageAccountLocalUser#resource_name}
    */
    readonly resourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#service StorageAccountLocalUser#service}
    */
    readonly service: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#permissions StorageAccountLocalUser#permissions}
    */
    readonly permissions: StorageAccountLocalUserPermissionScopePermissions;
}
export declare function storageAccountLocalUserPermissionScopeToTerraform(struct?: StorageAccountLocalUserPermissionScope | cdktf.IResolvable): any;
export declare function storageAccountLocalUserPermissionScopeToHclTerraform(struct?: StorageAccountLocalUserPermissionScope | cdktf.IResolvable): any;
export declare class StorageAccountLocalUserPermissionScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountLocalUserPermissionScope | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountLocalUserPermissionScope | cdktf.IResolvable | undefined);
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _permissions;
    get permissions(): StorageAccountLocalUserPermissionScopePermissionsOutputReference;
    putPermissions(value: StorageAccountLocalUserPermissionScopePermissions): void;
    get permissionsInput(): StorageAccountLocalUserPermissionScopePermissions | undefined;
}
export declare class StorageAccountLocalUserPermissionScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountLocalUserPermissionScope[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountLocalUserPermissionScopeOutputReference;
}
export interface StorageAccountLocalUserSshAuthorizedKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#description StorageAccountLocalUser#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#key StorageAccountLocalUser#key}
    */
    readonly key: string;
}
export declare function storageAccountLocalUserSshAuthorizedKeyToTerraform(struct?: StorageAccountLocalUserSshAuthorizedKey | cdktf.IResolvable): any;
export declare function storageAccountLocalUserSshAuthorizedKeyToHclTerraform(struct?: StorageAccountLocalUserSshAuthorizedKey | cdktf.IResolvable): any;
export declare class StorageAccountLocalUserSshAuthorizedKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountLocalUserSshAuthorizedKey | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountLocalUserSshAuthorizedKey | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class StorageAccountLocalUserSshAuthorizedKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountLocalUserSshAuthorizedKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountLocalUserSshAuthorizedKeyOutputReference;
}
export interface StorageAccountLocalUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#create StorageAccountLocalUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#delete StorageAccountLocalUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#read StorageAccountLocalUser#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#update StorageAccountLocalUser#update}
    */
    readonly update?: string;
}
export declare function storageAccountLocalUserTimeoutsToTerraform(struct?: StorageAccountLocalUserTimeouts | cdktf.IResolvable): any;
export declare function storageAccountLocalUserTimeoutsToHclTerraform(struct?: StorageAccountLocalUserTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountLocalUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountLocalUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountLocalUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user azurerm_storage_account_local_user}
*/
export declare class StorageAccountLocalUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_account_local_user";
    /**
    * Generates CDKTF code for importing a StorageAccountLocalUser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageAccountLocalUser to import
    * @param importFromId The id of the existing StorageAccountLocalUser that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageAccountLocalUser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_local_user azurerm_storage_account_local_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountLocalUserConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountLocalUserConfig);
    private _homeDirectory?;
    get homeDirectory(): string;
    set homeDirectory(value: string);
    resetHomeDirectory(): void;
    get homeDirectoryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get password(): string;
    get sid(): string;
    private _sshKeyEnabled?;
    get sshKeyEnabled(): boolean | cdktf.IResolvable;
    set sshKeyEnabled(value: boolean | cdktf.IResolvable);
    resetSshKeyEnabled(): void;
    get sshKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sshPasswordEnabled?;
    get sshPasswordEnabled(): boolean | cdktf.IResolvable;
    set sshPasswordEnabled(value: boolean | cdktf.IResolvable);
    resetSshPasswordEnabled(): void;
    get sshPasswordEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _permissionScope;
    get permissionScope(): StorageAccountLocalUserPermissionScopeList;
    putPermissionScope(value: StorageAccountLocalUserPermissionScope[] | cdktf.IResolvable): void;
    resetPermissionScope(): void;
    get permissionScopeInput(): cdktf.IResolvable | StorageAccountLocalUserPermissionScope[] | undefined;
    private _sshAuthorizedKey;
    get sshAuthorizedKey(): StorageAccountLocalUserSshAuthorizedKeyList;
    putSshAuthorizedKey(value: StorageAccountLocalUserSshAuthorizedKey[] | cdktf.IResolvable): void;
    resetSshAuthorizedKey(): void;
    get sshAuthorizedKeyInput(): cdktf.IResolvable | StorageAccountLocalUserSshAuthorizedKey[] | undefined;
    private _timeouts;
    get timeouts(): StorageAccountLocalUserTimeoutsOutputReference;
    putTimeouts(value: StorageAccountLocalUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountLocalUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
