/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountStaticWebsiteAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#error_404_document StorageAccountStaticWebsiteA#error_404_document}
    */
    readonly error404Document?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#id StorageAccountStaticWebsiteA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#index_document StorageAccountStaticWebsiteA#index_document}
    */
    readonly indexDocument?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#storage_account_id StorageAccountStaticWebsiteA#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#timeouts StorageAccountStaticWebsiteA#timeouts}
    */
    readonly timeouts?: StorageAccountStaticWebsiteTimeouts;
}
export interface StorageAccountStaticWebsiteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#create StorageAccountStaticWebsiteA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#delete StorageAccountStaticWebsiteA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#read StorageAccountStaticWebsiteA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#update StorageAccountStaticWebsiteA#update}
    */
    readonly update?: string;
}
export declare function storageAccountStaticWebsiteTimeoutsToTerraform(struct?: StorageAccountStaticWebsiteTimeouts | cdktf.IResolvable): any;
export declare function storageAccountStaticWebsiteTimeoutsToHclTerraform(struct?: StorageAccountStaticWebsiteTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountStaticWebsiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountStaticWebsiteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountStaticWebsiteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website azurerm_storage_account_static_website}
*/
export declare class StorageAccountStaticWebsiteA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_account_static_website";
    /**
    * Generates CDKTF code for importing a StorageAccountStaticWebsiteA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageAccountStaticWebsiteA to import
    * @param importFromId The id of the existing StorageAccountStaticWebsiteA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageAccountStaticWebsiteA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/storage_account_static_website azurerm_storage_account_static_website} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountStaticWebsiteAConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountStaticWebsiteAConfig);
    private _error404Document?;
    get error404Document(): string;
    set error404Document(value: string);
    resetError404Document(): void;
    get error404DocumentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _indexDocument?;
    get indexDocument(): string;
    set indexDocument(value: string);
    resetIndexDocument(): void;
    get indexDocumentInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageAccountStaticWebsiteTimeoutsOutputReference;
    putTimeouts(value: StorageAccountStaticWebsiteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountStaticWebsiteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
