/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#description SubscriptionPolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#display_name SubscriptionPolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#enforce SubscriptionPolicyAssignment#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#id SubscriptionPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#location SubscriptionPolicyAssignment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#metadata SubscriptionPolicyAssignment#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#name SubscriptionPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#not_scopes SubscriptionPolicyAssignment#not_scopes}
    */
    readonly notScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#parameters SubscriptionPolicyAssignment#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#policy_definition_id SubscriptionPolicyAssignment#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#subscription_id SubscriptionPolicyAssignment#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#identity SubscriptionPolicyAssignment#identity}
    */
    readonly identity?: SubscriptionPolicyAssignmentIdentity;
    /**
    * non_compliance_message block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#non_compliance_message SubscriptionPolicyAssignment#non_compliance_message}
    */
    readonly nonComplianceMessage?: SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#overrides SubscriptionPolicyAssignment#overrides}
    */
    readonly overrides?: SubscriptionPolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * resource_selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#resource_selectors SubscriptionPolicyAssignment#resource_selectors}
    */
    readonly resourceSelectors?: SubscriptionPolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#timeouts SubscriptionPolicyAssignment#timeouts}
    */
    readonly timeouts?: SubscriptionPolicyAssignmentTimeouts;
}
export interface SubscriptionPolicyAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#identity_ids SubscriptionPolicyAssignment#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#type SubscriptionPolicyAssignment#type}
    */
    readonly type: string;
}
export declare function subscriptionPolicyAssignmentIdentityToTerraform(struct?: SubscriptionPolicyAssignmentIdentityOutputReference | SubscriptionPolicyAssignmentIdentity): any;
export declare function subscriptionPolicyAssignmentIdentityToHclTerraform(struct?: SubscriptionPolicyAssignmentIdentityOutputReference | SubscriptionPolicyAssignmentIdentity): any;
export declare class SubscriptionPolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionPolicyAssignmentIdentity | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SubscriptionPolicyAssignmentNonComplianceMessage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#content SubscriptionPolicyAssignment#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#policy_definition_reference_id SubscriptionPolicyAssignment#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
}
export declare function subscriptionPolicyAssignmentNonComplianceMessageToTerraform(struct?: SubscriptionPolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentNonComplianceMessageToHclTerraform(struct?: SubscriptionPolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentNonComplianceMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionPolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _policyDefinitionReferenceId?;
    get policyDefinitionReferenceId(): string;
    set policyDefinitionReferenceId(value: string);
    resetPolicyDefinitionReferenceId(): void;
    get policyDefinitionReferenceIdInput(): string | undefined;
}
export declare class SubscriptionPolicyAssignmentNonComplianceMessageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionPolicyAssignmentNonComplianceMessageOutputReference;
}
export interface SubscriptionPolicyAssignmentOverridesSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#in SubscriptionPolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#not_in SubscriptionPolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function subscriptionPolicyAssignmentOverridesSelectorsToTerraform(struct?: SubscriptionPolicyAssignmentOverridesSelectors | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentOverridesSelectorsToHclTerraform(struct?: SubscriptionPolicyAssignmentOverridesSelectors | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentOverridesSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionPolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    get kind(): string;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class SubscriptionPolicyAssignmentOverridesSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionPolicyAssignmentOverridesSelectorsOutputReference;
}
export interface SubscriptionPolicyAssignmentOverrides {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#value SubscriptionPolicyAssignment#value}
    */
    readonly value: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#selectors SubscriptionPolicyAssignment#selectors}
    */
    readonly selectors?: SubscriptionPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
}
export declare function subscriptionPolicyAssignmentOverridesToTerraform(struct?: SubscriptionPolicyAssignmentOverrides | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentOverridesToHclTerraform(struct?: SubscriptionPolicyAssignmentOverrides | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionPolicyAssignmentOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentOverrides | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _selectors;
    get selectors(): SubscriptionPolicyAssignmentOverridesSelectorsList;
    putSelectors(value: SubscriptionPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable): void;
    resetSelectors(): void;
    get selectorsInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentOverridesSelectors[] | undefined;
}
export declare class SubscriptionPolicyAssignmentOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionPolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionPolicyAssignmentOverridesOutputReference;
}
export interface SubscriptionPolicyAssignmentResourceSelectorsSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#in SubscriptionPolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#kind SubscriptionPolicyAssignment#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#not_in SubscriptionPolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function subscriptionPolicyAssignmentResourceSelectorsSelectorsToTerraform(struct?: SubscriptionPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentResourceSelectorsSelectorsToHclTerraform(struct?: SubscriptionPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentResourceSelectorsSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class SubscriptionPolicyAssignmentResourceSelectorsSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionPolicyAssignmentResourceSelectorsSelectorsOutputReference;
}
export interface SubscriptionPolicyAssignmentResourceSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#name SubscriptionPolicyAssignment#name}
    */
    readonly name?: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#selectors SubscriptionPolicyAssignment#selectors}
    */
    readonly selectors: SubscriptionPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
}
export declare function subscriptionPolicyAssignmentResourceSelectorsToTerraform(struct?: SubscriptionPolicyAssignmentResourceSelectors | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentResourceSelectorsToHclTerraform(struct?: SubscriptionPolicyAssignmentResourceSelectors | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentResourceSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubscriptionPolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _selectors;
    get selectors(): SubscriptionPolicyAssignmentResourceSelectorsSelectorsList;
    putSelectors(value: SubscriptionPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable): void;
    get selectorsInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentResourceSelectorsSelectors[] | undefined;
}
export declare class SubscriptionPolicyAssignmentResourceSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubscriptionPolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubscriptionPolicyAssignmentResourceSelectorsOutputReference;
}
export interface SubscriptionPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#create SubscriptionPolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#delete SubscriptionPolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#read SubscriptionPolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#update SubscriptionPolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function subscriptionPolicyAssignmentTimeoutsToTerraform(struct?: SubscriptionPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare function subscriptionPolicyAssignmentTimeoutsToHclTerraform(struct?: SubscriptionPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionPolicyAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment azurerm_subscription_policy_assignment}
*/
export declare class SubscriptionPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subscription_policy_assignment";
    /**
    * Generates CDKTF code for importing a SubscriptionPolicyAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SubscriptionPolicyAssignment to import
    * @param importFromId The id of the existing SubscriptionPolicyAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SubscriptionPolicyAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/subscription_policy_assignment azurerm_subscription_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionPolicyAssignmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notScopes?;
    get notScopes(): string[];
    set notScopes(value: string[]);
    resetNotScopes(): void;
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _identity;
    get identity(): SubscriptionPolicyAssignmentIdentityOutputReference;
    putIdentity(value: SubscriptionPolicyAssignmentIdentity): void;
    resetIdentity(): void;
    get identityInput(): SubscriptionPolicyAssignmentIdentity | undefined;
    private _nonComplianceMessage;
    get nonComplianceMessage(): SubscriptionPolicyAssignmentNonComplianceMessageList;
    putNonComplianceMessage(value: SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable): void;
    resetNonComplianceMessage(): void;
    get nonComplianceMessageInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentNonComplianceMessage[] | undefined;
    private _overrides;
    get overrides(): SubscriptionPolicyAssignmentOverridesList;
    putOverrides(value: SubscriptionPolicyAssignmentOverrides[] | cdktf.IResolvable): void;
    resetOverrides(): void;
    get overridesInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentOverrides[] | undefined;
    private _resourceSelectors;
    get resourceSelectors(): SubscriptionPolicyAssignmentResourceSelectorsList;
    putResourceSelectors(value: SubscriptionPolicyAssignmentResourceSelectors[] | cdktf.IResolvable): void;
    resetResourceSelectors(): void;
    get resourceSelectorsInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentResourceSelectors[] | undefined;
    private _timeouts;
    get timeouts(): SubscriptionPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: SubscriptionPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
