/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerNestedEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#enabled TrafficManagerNestedEndpoint#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#endpoint_location TrafficManagerNestedEndpoint#endpoint_location}
    */
    readonly endpointLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#geo_mappings TrafficManagerNestedEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#id TrafficManagerNestedEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#minimum_child_endpoints TrafficManagerNestedEndpoint#minimum_child_endpoints}
    */
    readonly minimumChildEndpoints: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv4 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv4}
    */
    readonly minimumRequiredChildEndpointsIpv4?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv6 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv6}
    */
    readonly minimumRequiredChildEndpointsIpv6?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#priority TrafficManagerNestedEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#profile_id TrafficManagerNestedEndpoint#profile_id}
    */
    readonly profileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#target_resource_id TrafficManagerNestedEndpoint#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#weight TrafficManagerNestedEndpoint#weight}
    */
    readonly weight?: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#custom_header TrafficManagerNestedEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#subnet TrafficManagerNestedEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#timeouts TrafficManagerNestedEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerNestedEndpointTimeouts;
}
export interface TrafficManagerNestedEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#value TrafficManagerNestedEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerNestedEndpointCustomHeaderToTerraform(struct?: TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable): any;
export declare function trafficManagerNestedEndpointCustomHeaderToHclTerraform(struct?: TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable): any;
export declare class TrafficManagerNestedEndpointCustomHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class TrafficManagerNestedEndpointCustomHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TrafficManagerNestedEndpointCustomHeaderOutputReference;
}
export interface TrafficManagerNestedEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#first TrafficManagerNestedEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#last TrafficManagerNestedEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#scope TrafficManagerNestedEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerNestedEndpointSubnetToTerraform(struct?: TrafficManagerNestedEndpointSubnet | cdktf.IResolvable): any;
export declare function trafficManagerNestedEndpointSubnetToHclTerraform(struct?: TrafficManagerNestedEndpointSubnet | cdktf.IResolvable): any;
export declare class TrafficManagerNestedEndpointSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TrafficManagerNestedEndpointSubnet | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerNestedEndpointSubnet | cdktf.IResolvable | undefined);
    private _first?;
    get first(): string;
    set first(value: string);
    get firstInput(): string | undefined;
    private _last?;
    get last(): string;
    set last(value: string);
    resetLast(): void;
    get lastInput(): string | undefined;
    private _scope?;
    get scope(): number;
    set scope(value: number);
    resetScope(): void;
    get scopeInput(): number | undefined;
}
export declare class TrafficManagerNestedEndpointSubnetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TrafficManagerNestedEndpointSubnetOutputReference;
}
export interface TrafficManagerNestedEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#create TrafficManagerNestedEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#delete TrafficManagerNestedEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#read TrafficManagerNestedEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#update TrafficManagerNestedEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerNestedEndpointTimeoutsToTerraform(struct?: TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable): any;
export declare function trafficManagerNestedEndpointTimeoutsToHclTerraform(struct?: TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerNestedEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint}
*/
export declare class TrafficManagerNestedEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_nested_endpoint";
    /**
    * Generates CDKTF code for importing a TrafficManagerNestedEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TrafficManagerNestedEndpoint to import
    * @param importFromId The id of the existing TrafficManagerNestedEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TrafficManagerNestedEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerNestedEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerNestedEndpointConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    get endpointLocation(): string;
    set endpointLocation(value: string);
    resetEndpointLocation(): void;
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minimumChildEndpoints?;
    get minimumChildEndpoints(): number;
    set minimumChildEndpoints(value: number);
    get minimumChildEndpointsInput(): number | undefined;
    private _minimumRequiredChildEndpointsIpv4?;
    get minimumRequiredChildEndpointsIpv4(): number;
    set minimumRequiredChildEndpointsIpv4(value: number);
    resetMinimumRequiredChildEndpointsIpv4(): void;
    get minimumRequiredChildEndpointsIpv4Input(): number | undefined;
    private _minimumRequiredChildEndpointsIpv6?;
    get minimumRequiredChildEndpointsIpv6(): number;
    set minimumRequiredChildEndpointsIpv6(value: number);
    resetMinimumRequiredChildEndpointsIpv6(): void;
    get minimumRequiredChildEndpointsIpv6Input(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _customHeader;
    get customHeader(): TrafficManagerNestedEndpointCustomHeaderList;
    putCustomHeader(value: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable): void;
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerNestedEndpointCustomHeader[] | undefined;
    private _subnet;
    get subnet(): TrafficManagerNestedEndpointSubnetList;
    putSubnet(value: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable): void;
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerNestedEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerNestedEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerNestedEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TrafficManagerNestedEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
