/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnGatewayNatRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#id VpnGatewayNatRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#ip_configuration_id VpnGatewayNatRule#ip_configuration_id}
    */
    readonly ipConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#mode VpnGatewayNatRule#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#name VpnGatewayNatRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#type VpnGatewayNatRule#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#vpn_gateway_id VpnGatewayNatRule#vpn_gateway_id}
    */
    readonly vpnGatewayId: string;
    /**
    * external_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#external_mapping VpnGatewayNatRule#external_mapping}
    */
    readonly externalMapping?: VpnGatewayNatRuleExternalMapping[] | cdktf.IResolvable;
    /**
    * internal_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#internal_mapping VpnGatewayNatRule#internal_mapping}
    */
    readonly internalMapping?: VpnGatewayNatRuleInternalMapping[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#timeouts VpnGatewayNatRule#timeouts}
    */
    readonly timeouts?: VpnGatewayNatRuleTimeouts;
}
export interface VpnGatewayNatRuleExternalMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#address_space VpnGatewayNatRule#address_space}
    */
    readonly addressSpace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#port_range VpnGatewayNatRule#port_range}
    */
    readonly portRange?: string;
}
export declare function vpnGatewayNatRuleExternalMappingToTerraform(struct?: VpnGatewayNatRuleExternalMapping | cdktf.IResolvable): any;
export declare function vpnGatewayNatRuleExternalMappingToHclTerraform(struct?: VpnGatewayNatRuleExternalMapping | cdktf.IResolvable): any;
export declare class VpnGatewayNatRuleExternalMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayNatRuleExternalMapping | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayNatRuleExternalMapping | cdktf.IResolvable | undefined);
    private _addressSpace?;
    get addressSpace(): string;
    set addressSpace(value: string);
    get addressSpaceInput(): string | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
}
export declare class VpnGatewayNatRuleExternalMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayNatRuleExternalMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayNatRuleExternalMappingOutputReference;
}
export interface VpnGatewayNatRuleInternalMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#address_space VpnGatewayNatRule#address_space}
    */
    readonly addressSpace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#port_range VpnGatewayNatRule#port_range}
    */
    readonly portRange?: string;
}
export declare function vpnGatewayNatRuleInternalMappingToTerraform(struct?: VpnGatewayNatRuleInternalMapping | cdktf.IResolvable): any;
export declare function vpnGatewayNatRuleInternalMappingToHclTerraform(struct?: VpnGatewayNatRuleInternalMapping | cdktf.IResolvable): any;
export declare class VpnGatewayNatRuleInternalMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayNatRuleInternalMapping | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayNatRuleInternalMapping | cdktf.IResolvable | undefined);
    private _addressSpace?;
    get addressSpace(): string;
    set addressSpace(value: string);
    get addressSpaceInput(): string | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
}
export declare class VpnGatewayNatRuleInternalMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayNatRuleInternalMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayNatRuleInternalMappingOutputReference;
}
export interface VpnGatewayNatRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#create VpnGatewayNatRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#delete VpnGatewayNatRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#read VpnGatewayNatRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#update VpnGatewayNatRule#update}
    */
    readonly update?: string;
}
export declare function vpnGatewayNatRuleTimeoutsToTerraform(struct?: VpnGatewayNatRuleTimeouts | cdktf.IResolvable): any;
export declare function vpnGatewayNatRuleTimeoutsToHclTerraform(struct?: VpnGatewayNatRuleTimeouts | cdktf.IResolvable): any;
export declare class VpnGatewayNatRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayNatRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayNatRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule azurerm_vpn_gateway_nat_rule}
*/
export declare class VpnGatewayNatRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_gateway_nat_rule";
    /**
    * Generates CDKTF code for importing a VpnGatewayNatRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VpnGatewayNatRule to import
    * @param importFromId The id of the existing VpnGatewayNatRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VpnGatewayNatRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_gateway_nat_rule azurerm_vpn_gateway_nat_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnGatewayNatRuleConfig
    */
    constructor(scope: Construct, id: string, config: VpnGatewayNatRuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfigurationId?;
    get ipConfigurationId(): string;
    set ipConfigurationId(value: string);
    resetIpConfigurationId(): void;
    get ipConfigurationIdInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _vpnGatewayId?;
    get vpnGatewayId(): string;
    set vpnGatewayId(value: string);
    get vpnGatewayIdInput(): string | undefined;
    private _externalMapping;
    get externalMapping(): VpnGatewayNatRuleExternalMappingList;
    putExternalMapping(value: VpnGatewayNatRuleExternalMapping[] | cdktf.IResolvable): void;
    resetExternalMapping(): void;
    get externalMappingInput(): cdktf.IResolvable | VpnGatewayNatRuleExternalMapping[] | undefined;
    private _internalMapping;
    get internalMapping(): VpnGatewayNatRuleInternalMappingList;
    putInternalMapping(value: VpnGatewayNatRuleInternalMapping[] | cdktf.IResolvable): void;
    resetInternalMapping(): void;
    get internalMappingInput(): cdktf.IResolvable | VpnGatewayNatRuleInternalMapping[] | undefined;
    private _timeouts;
    get timeouts(): VpnGatewayNatRuleTimeoutsOutputReference;
    putTimeouts(value: VpnGatewayNatRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnGatewayNatRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
