/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnServerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#id VpnServerConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#location VpnServerConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#resource_group_name VpnServerConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#tags VpnServerConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#vpn_authentication_types VpnServerConfiguration#vpn_authentication_types}
    */
    readonly vpnAuthenticationTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#vpn_protocols VpnServerConfiguration#vpn_protocols}
    */
    readonly vpnProtocols?: string[];
    /**
    * azure_active_directory_authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#azure_active_directory_authentication VpnServerConfiguration#azure_active_directory_authentication}
    */
    readonly azureActiveDirectoryAuthentication?: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    /**
    * client_revoked_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#client_revoked_certificate VpnServerConfiguration#client_revoked_certificate}
    */
    readonly clientRevokedCertificate?: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    /**
    * client_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
    */
    readonly clientRootCertificate?: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    /**
    * ipsec_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#ipsec_policy VpnServerConfiguration#ipsec_policy}
    */
    readonly ipsecPolicy?: VpnServerConfigurationIpsecPolicy;
    /**
    * radius block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#radius VpnServerConfiguration#radius}
    */
    readonly radius?: VpnServerConfigurationRadius;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#timeouts VpnServerConfiguration#timeouts}
    */
    readonly timeouts?: VpnServerConfigurationTimeouts;
}
export interface VpnServerConfigurationAzureActiveDirectoryAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#audience VpnServerConfiguration#audience}
    */
    readonly audience: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#issuer VpnServerConfiguration#issuer}
    */
    readonly issuer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#tenant VpnServerConfiguration#tenant}
    */
    readonly tenant: string;
}
export declare function vpnServerConfigurationAzureActiveDirectoryAuthenticationToTerraform(struct?: VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable): any;
export declare function vpnServerConfigurationAzureActiveDirectoryAuthenticationToHclTerraform(struct?: VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable): any;
export declare class VpnServerConfigurationAzureActiveDirectoryAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    get audienceInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _tenant?;
    get tenant(): string;
    set tenant(value: string);
    get tenantInput(): string | undefined;
}
export declare class VpnServerConfigurationAzureActiveDirectoryAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationAzureActiveDirectoryAuthenticationOutputReference;
}
export interface VpnServerConfigurationClientRevokedCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationClientRevokedCertificateToTerraform(struct?: VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable): any;
export declare function vpnServerConfigurationClientRevokedCertificateToHclTerraform(struct?: VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable): any;
export declare class VpnServerConfigurationClientRevokedCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
}
export declare class VpnServerConfigurationClientRevokedCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationClientRevokedCertificateOutputReference;
}
export interface VpnServerConfigurationClientRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationClientRootCertificateToTerraform(struct?: VpnServerConfigurationClientRootCertificate | cdktf.IResolvable): any;
export declare function vpnServerConfigurationClientRootCertificateToHclTerraform(struct?: VpnServerConfigurationClientRootCertificate | cdktf.IResolvable): any;
export declare class VpnServerConfigurationClientRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationClientRootCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationClientRootCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicCertData?;
    get publicCertData(): string;
    set publicCertData(value: string);
    get publicCertDataInput(): string | undefined;
}
export declare class VpnServerConfigurationClientRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationClientRootCertificateOutputReference;
}
export interface VpnServerConfigurationIpsecPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#dh_group VpnServerConfiguration#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#ike_encryption VpnServerConfiguration#ike_encryption}
    */
    readonly ikeEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#ike_integrity VpnServerConfiguration#ike_integrity}
    */
    readonly ikeIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#ipsec_encryption VpnServerConfiguration#ipsec_encryption}
    */
    readonly ipsecEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#ipsec_integrity VpnServerConfiguration#ipsec_integrity}
    */
    readonly ipsecIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#pfs_group VpnServerConfiguration#pfs_group}
    */
    readonly pfsGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#sa_data_size_kilobytes VpnServerConfiguration#sa_data_size_kilobytes}
    */
    readonly saDataSizeKilobytes: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#sa_lifetime_seconds VpnServerConfiguration#sa_lifetime_seconds}
    */
    readonly saLifetimeSeconds: number;
}
export declare function vpnServerConfigurationIpsecPolicyToTerraform(struct?: VpnServerConfigurationIpsecPolicyOutputReference | VpnServerConfigurationIpsecPolicy): any;
export declare function vpnServerConfigurationIpsecPolicyToHclTerraform(struct?: VpnServerConfigurationIpsecPolicyOutputReference | VpnServerConfigurationIpsecPolicy): any;
export declare class VpnServerConfigurationIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationIpsecPolicy | undefined;
    set internalValue(value: VpnServerConfigurationIpsecPolicy | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    get ikeEncryption(): string;
    set ikeEncryption(value: string);
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    get ikeIntegrity(): string;
    set ikeIntegrity(value: string);
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    get ipsecEncryption(): string;
    set ipsecEncryption(value: string);
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    get ipsecIntegrity(): string;
    set ipsecIntegrity(value: string);
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    get pfsGroup(): string;
    set pfsGroup(value: string);
    get pfsGroupInput(): string | undefined;
    private _saDataSizeKilobytes?;
    get saDataSizeKilobytes(): number;
    set saDataSizeKilobytes(value: number);
    get saDataSizeKilobytesInput(): number | undefined;
    private _saLifetimeSeconds?;
    get saLifetimeSeconds(): number;
    set saLifetimeSeconds(value: number);
    get saLifetimeSecondsInput(): number | undefined;
}
export interface VpnServerConfigurationRadiusClientRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable): any;
export declare function vpnServerConfigurationRadiusClientRootCertificateToHclTerraform(struct?: VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable): any;
export declare class VpnServerConfigurationRadiusClientRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
}
export declare class VpnServerConfigurationRadiusClientRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationRadiusClientRootCertificateOutputReference;
}
export interface VpnServerConfigurationRadiusServer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#address VpnServerConfiguration#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#score VpnServerConfiguration#score}
    */
    readonly score: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#secret VpnServerConfiguration#secret}
    */
    readonly secret: string;
}
export declare function vpnServerConfigurationRadiusServerToTerraform(struct?: VpnServerConfigurationRadiusServer | cdktf.IResolvable): any;
export declare function vpnServerConfigurationRadiusServerToHclTerraform(struct?: VpnServerConfigurationRadiusServer | cdktf.IResolvable): any;
export declare class VpnServerConfigurationRadiusServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationRadiusServer | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationRadiusServer | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _score?;
    get score(): number;
    set score(value: number);
    get scoreInput(): number | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
}
export declare class VpnServerConfigurationRadiusServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationRadiusServerOutputReference;
}
export interface VpnServerConfigurationRadiusServerRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable): any;
export declare function vpnServerConfigurationRadiusServerRootCertificateToHclTerraform(struct?: VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable): any;
export declare class VpnServerConfigurationRadiusServerRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicCertData?;
    get publicCertData(): string;
    set publicCertData(value: string);
    get publicCertDataInput(): string | undefined;
}
export declare class VpnServerConfigurationRadiusServerRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnServerConfigurationRadiusServerRootCertificateOutputReference;
}
export interface VpnServerConfigurationRadius {
    /**
    * client_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
    */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    /**
    * server block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#server VpnServerConfiguration#server}
    */
    readonly server?: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    /**
    * server_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#server_root_certificate VpnServerConfiguration#server_root_certificate}
    */
    readonly serverRootCertificate?: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
}
export declare function vpnServerConfigurationRadiusToTerraform(struct?: VpnServerConfigurationRadiusOutputReference | VpnServerConfigurationRadius): any;
export declare function vpnServerConfigurationRadiusToHclTerraform(struct?: VpnServerConfigurationRadiusOutputReference | VpnServerConfigurationRadius): any;
export declare class VpnServerConfigurationRadiusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationRadius | undefined;
    set internalValue(value: VpnServerConfigurationRadius | undefined);
    private _clientRootCertificate;
    get clientRootCertificate(): VpnServerConfigurationRadiusClientRootCertificateList;
    putClientRootCertificate(value: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable): void;
    resetClientRootCertificate(): void;
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusClientRootCertificate[] | undefined;
    private _server;
    get server(): VpnServerConfigurationRadiusServerList;
    putServer(value: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable): void;
    resetServer(): void;
    get serverInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServer[] | undefined;
    private _serverRootCertificate;
    get serverRootCertificate(): VpnServerConfigurationRadiusServerRootCertificateList;
    putServerRootCertificate(value: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable): void;
    resetServerRootCertificate(): void;
    get serverRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerRootCertificate[] | undefined;
}
export interface VpnServerConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#create VpnServerConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#delete VpnServerConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#read VpnServerConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#update VpnServerConfiguration#update}
    */
    readonly update?: string;
}
export declare function vpnServerConfigurationTimeoutsToTerraform(struct?: VpnServerConfigurationTimeouts | cdktf.IResolvable): any;
export declare function vpnServerConfigurationTimeoutsToHclTerraform(struct?: VpnServerConfigurationTimeouts | cdktf.IResolvable): any;
export declare class VpnServerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnServerConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration azurerm_vpn_server_configuration}
*/
export declare class VpnServerConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_server_configuration";
    /**
    * Generates CDKTF code for importing a VpnServerConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VpnServerConfiguration to import
    * @param importFromId The id of the existing VpnServerConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VpnServerConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/vpn_server_configuration azurerm_vpn_server_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnServerConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: VpnServerConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpnAuthenticationTypes?;
    get vpnAuthenticationTypes(): string[];
    set vpnAuthenticationTypes(value: string[]);
    get vpnAuthenticationTypesInput(): string[] | undefined;
    private _vpnProtocols?;
    get vpnProtocols(): string[];
    set vpnProtocols(value: string[]);
    resetVpnProtocols(): void;
    get vpnProtocolsInput(): string[] | undefined;
    private _azureActiveDirectoryAuthentication;
    get azureActiveDirectoryAuthentication(): VpnServerConfigurationAzureActiveDirectoryAuthenticationList;
    putAzureActiveDirectoryAuthentication(value: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable): void;
    resetAzureActiveDirectoryAuthentication(): void;
    get azureActiveDirectoryAuthenticationInput(): cdktf.IResolvable | VpnServerConfigurationAzureActiveDirectoryAuthentication[] | undefined;
    private _clientRevokedCertificate;
    get clientRevokedCertificate(): VpnServerConfigurationClientRevokedCertificateList;
    putClientRevokedCertificate(value: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable): void;
    resetClientRevokedCertificate(): void;
    get clientRevokedCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRevokedCertificate[] | undefined;
    private _clientRootCertificate;
    get clientRootCertificate(): VpnServerConfigurationClientRootCertificateList;
    putClientRootCertificate(value: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable): void;
    resetClientRootCertificate(): void;
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRootCertificate[] | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): VpnServerConfigurationIpsecPolicyOutputReference;
    putIpsecPolicy(value: VpnServerConfigurationIpsecPolicy): void;
    resetIpsecPolicy(): void;
    get ipsecPolicyInput(): VpnServerConfigurationIpsecPolicy | undefined;
    private _radius;
    get radius(): VpnServerConfigurationRadiusOutputReference;
    putRadius(value: VpnServerConfigurationRadius): void;
    resetRadius(): void;
    get radiusInput(): VpnServerConfigurationRadius | undefined;
    private _timeouts;
    get timeouts(): VpnServerConfigurationTimeoutsOutputReference;
    putTimeouts(value: VpnServerConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnServerConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
