"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apigw = require("@aws-cdk/aws-apigateway");
const core_1 = require("@aws-cdk/core");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = `${target.node.uniqueId}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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