import dynamodb = require('@aws-cdk/aws-dynamodb');
import lambda = require('@aws-cdk/aws-lambda');
import { StreamEventSource, StreamEventSourceProps } from './stream';
export interface DynamoEventSourceProps extends StreamEventSourceProps {
}
/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 */
export declare class DynamoEventSource extends StreamEventSource {
    private readonly table;
    constructor(table: dynamodb.Table, props: DynamoEventSourceProps);
    bind(target: lambda.IFunction): void;
}
