import kinesis = require('@aws-cdk/aws-kinesis');
import lambda = require('@aws-cdk/aws-lambda');
import { StreamEventSource, StreamEventSourceProps } from './stream';
export interface KinesisEventSourceProps extends StreamEventSourceProps {
}
/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 */
export declare class KinesisEventSource extends StreamEventSource {
    readonly stream: kinesis.IStream;
    constructor(stream: kinesis.IStream, props: KinesisEventSourceProps);
    bind(target: lambda.IFunction): void;
}
