import lambda = require('@aws-cdk/aws-lambda');
import { Duration } from '@aws-cdk/core';
/**
 * The set of properties for event sources that follow the streaming model,
 * such as, Dynamo and Kinesis.
 */
export interface StreamEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event
     * source at the time of invoking your function. Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range:
     * * Minimum value of 1
     * * Maximum value of:
     *   * 1000 for {@link DynamoEventSource}
     *   * 10000 for {@link KinesisEventSource}
     *
     * @default 100
     */
    readonly batchSize?: number;
    /**
     * Where to begin consuming the stream.
     */
    readonly startingPosition: lambda.StartingPosition;
    /**
     * The maximum amount of time to gather records before invoking the function.
     * Maximum of Duration.minutes(5)
     *
     * @default Duration.seconds(0)
     */
    readonly maxBatchingWindow?: Duration;
}
/**
 * Use an stream as an event source for AWS Lambda.
 */
export declare abstract class StreamEventSource implements lambda.IEventSource {
    protected readonly props: StreamEventSourceProps;
    protected constructor(props: StreamEventSourceProps);
    abstract bind(_target: lambda.IFunction): void;
    protected enrichMappingOptions(options: lambda.EventSourceMappingOptions): lambda.EventSourceMappingOptions;
}
