"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class S3EventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const bucket = new s3.Bucket(this, 'B', {
            removalPolicy: cdk.RemovalPolicy.DESTROY
        });
        fn.addEventSource(new lib_1.S3EventSource(bucket, {
            events: [s3.EventType.OBJECT_CREATED],
            filters: [{ prefix: 'subdir/' }]
        }));
    }
}
const app = new cdk.App();
new S3EventSourceTest(app, 'lambda-event-source-s3');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuczMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5zMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHNDQUF1QztBQUN2QyxxQ0FBc0M7QUFDdEMsZ0NBQXVDO0FBQ3ZDLG1EQUErQztBQUUvQyxNQUFNLGlCQUFrQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQ3ZDLFlBQVksS0FBYyxFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsR0FBRyxJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3ZDLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFO1lBQ3RDLGFBQWEsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLE9BQU87U0FDekMsQ0FBQyxDQUFDO1FBRUgsRUFBRSxDQUFDLGNBQWMsQ0FBQyxJQUFJLG1CQUFhLENBQUMsTUFBTSxFQUFFO1lBQzFDLE1BQU0sRUFBRSxDQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFFO1lBQ3ZDLE9BQU8sRUFBRSxDQUFFLEVBQUUsTUFBTSxFQUFFLFNBQVMsRUFBRSxDQUFFO1NBQ25DLENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztBQUNyRCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgczMgPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtczMnKTtcbmltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jb3JlJyk7XG5pbXBvcnQgeyBTM0V2ZW50U291cmNlIH0gZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IFRlc3RGdW5jdGlvbiB9IGZyb20gJy4vdGVzdC1mdW5jdGlvbic7XG5cbmNsYXNzIFMzRXZlbnRTb3VyY2VUZXN0IGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgZm4gPSBuZXcgVGVzdEZ1bmN0aW9uKHRoaXMsICdGJyk7XG4gICAgY29uc3QgYnVja2V0ID0gbmV3IHMzLkJ1Y2tldCh0aGlzLCAnQicsIHtcbiAgICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1lcbiAgICB9KTtcblxuICAgIGZuLmFkZEV2ZW50U291cmNlKG5ldyBTM0V2ZW50U291cmNlKGJ1Y2tldCwge1xuICAgICAgZXZlbnRzOiBbIHMzLkV2ZW50VHlwZS5PQkpFQ1RfQ1JFQVRFRCBdLFxuICAgICAgZmlsdGVyczogWyB7IHByZWZpeDogJ3N1YmRpci8nIH0gXVxuICAgIH0pKTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IFMzRXZlbnRTb3VyY2VUZXN0KGFwcCwgJ2xhbWJkYS1ldmVudC1zb3VyY2UtczMnKTtcbmFwcC5zeW50aCgpO1xuIl19