"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sqs = require("@aws-cdk/aws-sqs");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class SqsEventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const queue = new sqs.Queue(this, 'Q');
        fn.addEventSource(new lib_1.SqsEventSource(queue, {
            batchSize: 5
        }));
    }
}
const app = new cdk.App();
new SqsEventSourceTest(app, 'lambda-event-source-sqs');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXlDO0FBQ3pDLHFDQUFzQztBQUN0QyxnQ0FBd0M7QUFDeEMsbURBQStDO0FBRS9DLE1BQU0sa0JBQW1CLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDeEMsWUFBWSxLQUFjLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sRUFBRSxHQUFHLElBQUksNEJBQVksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdkMsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQztRQUV2QyxFQUFFLENBQUMsY0FBYyxDQUFDLElBQUksb0JBQWMsQ0FBQyxLQUFLLEVBQUU7WUFDMUMsU0FBUyxFQUFFLENBQUM7U0FDYixDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLElBQUksa0JBQWtCLENBQUMsR0FBRyxFQUFFLHlCQUF5QixDQUFDLENBQUM7QUFDdkQsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHNxcyA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1zcXMnKTtcbmltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jb3JlJyk7XG5pbXBvcnQgeyBTcXNFdmVudFNvdXJjZSB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0RnVuY3Rpb24gfSBmcm9tICcuL3Rlc3QtZnVuY3Rpb24nO1xuXG5jbGFzcyBTcXNFdmVudFNvdXJjZVRlc3QgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkFwcCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBmbiA9IG5ldyBUZXN0RnVuY3Rpb24odGhpcywgJ0YnKTtcbiAgICBjb25zdCBxdWV1ZSA9IG5ldyBzcXMuUXVldWUodGhpcywgJ1EnKTtcblxuICAgIGZuLmFkZEV2ZW50U291cmNlKG5ldyBTcXNFdmVudFNvdXJjZShxdWV1ZSwge1xuICAgICAgYmF0Y2hTaXplOiA1XG4gICAgfSkpO1xuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgU3FzRXZlbnRTb3VyY2VUZXN0KGFwcCwgJ2xhbWJkYS1ldmVudC1zb3VyY2Utc3FzJyk7XG5hcHAuc3ludGgoKTsiXX0=