# 0.5.2
## What's Changed
* Bump ruff from 0.0.275 to 0.1.3 by @dependabot in https://github.com/python-ellar/ellar/pull/135
* Bump black from 23.9.1 to 23.10.1 by @dependabot in https://github.com/python-ellar/ellar/pull/136
* Bump types-redis from 4.6.0.5 to 4.6.0.8 by @dependabot in https://github.com/python-ellar/ellar/pull/133
* Bump mypy from 1.5.1 to 1.6.1 by @dependabot in https://github.com/python-ellar/ellar/pull/134
* Authentication Docs by @eadwinCode in https://github.com/python-ellar/ellar/pull/137

## Breaking Changes
* OpenAPI module Refactor by @eadwinCode in https://github.com/python-ellar/ellar/pull/138


**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.5.1...0.5.2

# 0.5.1
## What's Changed
* Fix grammar error in dynamic-modules.md by @artemyfmv in https://github.com/python-ellar/ellar/pull/132
* Exception Docs Update by @eadwinCode in https://github.com/python-ellar/ellar/pull/131
* Bump black from 22.12.0 to 23.9.1 by @dependabot in https://github.com/python-ellar/ellar/pull/129
* Bump aiohttp from 3.8.4 to 3.8.5 by @dependabot in https://github.com/python-ellar/ellar/pull/113

## New Contributors
* @artemyfmv made their first contribution in https://github.com/python-ellar/ellar/pull/132

**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.5.0...0.5.1

# 0.5.0
## What's Changed
* Bump uvicorn[standard] from 0.22.0 to 0.23.2 by @dependabot in https://github.com/python-ellar/ellar/pull/128
* Bump types-ujson from 5.8.0.0 to 5.8.0.1 by @dependabot in https://github.com/python-ellar/ellar/pull/127
* Bump actions/checkout from 3 to 4 by @dependabot in https://github.com/python-ellar/ellar/pull/126
* Route handlers dependencies type annotation support by @eadwinCode in https://github.com/python-ellar/ellar/pull/130


**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.4.9...0.5.0

# 0.4.9
## What's Changed
* fixed 400 error parsing body on windows by @eadwinCode in https://github.com/python-ellar/ellar/pull/125


**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.4.8...0.4.9

# 0.4.7
## What's Changed
* Libraries Bump up by @eadwinCode in https://github.com/python-ellar/ellar/pull/122


**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.4.6...0.4.7

# 0.4.6
## What's Changed
* drop python 3.7 by @eadwinCode in https://github.com/python-ellar/ellar/pull/118
* Added scope to provider config by @eadwinCode in https://github.com/python-ellar/ellar/pull/121


**Full Changelog**: https://github.com/python-ellar/ellar/compare/0.4.5...0.4.6

# 0.4.5
## What's Changed
* Added auth example by @eadwinCode in https://github.com/eadwinCode/ellar/pull/116
* MyPy Liniting Fix And Embedded Body by @eadwinCode in https://github.com/eadwinCode/ellar/pull/117
* Moved authorization guard to interceptor by @eadwinCode in https://github.com/eadwinCode/ellar/pull/117


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.4.4...0.4.5

# 0.4.4
## What's Changed
* Documentation update by @eadwinCode in https://github.com/eadwinCode/ellar/pull/102
* OPENAPI Refactor by @eadwinCode in https://github.com/eadwinCode/ellar/pull/103
* Bump starlette from 0.27.0 to 0.28.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/105
* Expanding Sessions by @eadwinCode in https://github.com/eadwinCode/ellar/pull/109
* Authentication and Authorization by @eadwinCode in https://github.com/eadwinCode/ellar/pull/104
* Bump types-ujson from 5.7.0.5 to 5.8.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/107
* Ruff linting and mypy upgrade by @eadwinCode in https://github.com/eadwinCode/ellar/pull/115
* Linting, MyPy Upgrade and Example fixes by @eadwinCode in https://github.com/eadwinCode/ellar/pull/111


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.4.2...0.4.4

# 0.4.2
## What's Changed
* Bump starlette from 0.26.1 to 0.27.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/97
* Update typer requirement from <0.8.0,>=0.6.1 to >=0.6.1,<0.10.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/96
* Bump uvicorn[standard] from 0.20.0 to 0.22.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/95
* Bump codecov/codecov-action from 3.1.3 to 3.1.4 by @dependabot in https://github.com/eadwinCode/ellar/pull/94
* Config with prefix by @eadwinCode in https://github.com/eadwinCode/ellar/pull/99
* Extended Lifespan to Module classes by @eadwinCode in https://github.com/eadwinCode/ellar/pull/100
* Ellar Documentation Redesign by @eadwinCode in https://github.com/eadwinCode/ellar/pull/100/commits/7b5d60b149b6ad786b6bf682278e6d7fac83fd8e
* Fixed register_services not calling in modules by @eadwinCode in https://github.com/eadwinCode/ellar/pull/101


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.4.0...0.4.2

# 0.4.0
## What's Changed
* [BREAKING] Renamed Guards decorator to UseGuards decorator by @eadwinCode in https://github.com/eadwinCode/ellar/pull/93

## New Features
* Background Task Feature by @eadwinCode in https://github.com/eadwinCode/ellar/pull/91
You can inject BackgroundTasks instance to you route handler

```python
async def send_welcome_email(email):
    print(f'Send Welcome Email Task Called with "{email}"')

@router.post('/signup')
def sign_up(username: str, password: str, email: str, tasks: BackgroundTasks):
    tasks.add_task(send_welcome_email, email=email)

    return {'status': 'Signup successful'}
```

* EllarInterceptors by @eadwinCode in https://github.com/eadwinCode/ellar/pull/92
Use of interceptors to add more custom implementation to your route handlers and controller as define by [Aspect Oriented Programming](https://en.wikipedia.org/wiki/Aspect-oriented_programming) (AOP) technique
```python
@injectable
class ResponseModifierInterceptor(EllarInterceptor):
    async def intercept(
        self, context: IExecutionContext, next_interceptor: t.Callable[..., t.Coroutine]
    ) -> t.Any:
        data = await next_interceptor()
        if data:
            data.update(ResponseModifierInterceptor="ResponseModifierInterceptor modified returned resulted")
        return data
        
@Controller("")
class InterceptorControllerTest(ControllerBase):
    @UseInterceptors(ResponseModifierInterceptor)
    @get("/interceptor-1")
    async def interceptor_1(self):
        return {"message": "intercepted okay"}
```


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.3.8...0.4.0

# 0.3.8
## What's Changed
* Socket IO integration and Websocket documentation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/82
* Bump codecov/codecov-action from 3.1.1 to 3.1.3 by @dependabot in https://github.com/eadwinCode/ellar/pull/83
* Update email-validator requirement from <2.0.0,>=1.1.1 to >=1.1.1,<3.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/84
* Update mkdocs-material requirement from <9.0.0,>=7.1.9 to >=7.1.9,<10.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/86
* Bump types-ujson from 5.7.0.1 to 5.7.0.5 by @dependabot in https://github.com/eadwinCode/ellar/pull/88
* ellar package dependency refactor by @eadwinCode in https://github.com/eadwinCode/ellar/pull/89
* 0.3.8 by @eadwinCode in https://github.com/eadwinCode/ellar/pull/90
* Breaking: any missing import from `ellar.core` can be found in `ellar.common`


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.3.6...0.3.8

# 0.3.6
## What's Changed
* Added doc on rate limiting by @eadwinCode in https://github.com/eadwinCode/ellar/pull/74
* Guard Documentation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/64
* Dynamic Setup Fix by @eadwinCode in https://github.com/eadwinCode/ellar/pull/75
* Versioning Documentation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/79
* Update python-multipart requirement from <0.0.6,>=0.0.5 to >=0.0.5,<0.0.7 by @dependabot in https://github.com/eadwinCode/ellar/pull/66
* Bump types-ujson from 5.7.0.0 to 5.7.0.1 by @dependabot in https://github.com/eadwinCode/ellar/pull/68
* Testing Documentation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/80
* Starlette Upgrade by @eadwinCode in https://github.com/eadwinCode/ellar/pull/81


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.3.4...0.3.6

# 0.3.4
## What's Changed
* Caching Featuring by @eadwinCode in https://github.com/eadwinCode/ellar/pull/65
* Cache attributes update by @eadwinCode in https://github.com/eadwinCode/ellar/pull/71
* Module Setup Feature  by @eadwinCode in https://github.com/eadwinCode/ellar/pull/73


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.3.2...0.3.4

# 0.3.2
## What's Changed
* fix itsdangerous bug in session middleware by @eadwinCode in https://github.com/eadwinCode/ellar/pull/63


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.3.0...0.3.2

# 0.3.0
## What's Changed
* Bump black from 22.8.0 to 22.12.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/50
* Bump types-ujson from 0.1.1 to 5.6.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/49
* Update typer requirement from <0.7.0,>=0.6.1 to >=0.6.1,<0.8.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/40
* Removed ASGI args from contextvar by @eadwinCode in https://github.com/eadwinCode/ellar/pull/53
* Document updates Jan 2023 by @eadwinCode in https://github.com/eadwinCode/ellar/pull/54
* Injectable Class should be resolved at runtime without errors by @eadwinCode in https://github.com/eadwinCode/ellar/pull/60
* More Doc Updates by @eadwinCode in https://github.com/eadwinCode/ellar/pull/55
* Guards Refactor by @eadwinCode in https://github.com/eadwinCode/ellar/pull/59
* restored commented tests by @eadwinCode in https://github.com/eadwinCode/ellar/pull/61
* Bump starlette from 0.21.0 to 0.23.1 by @dependabot in https://github.com/eadwinCode/ellar/pull/48
* Bump types-ujson from 5.6.0.0 to 5.7.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/58
* Bump types-dataclasses from 0.1.7 to 0.6.6 by @dependabot in https://github.com/eadwinCode/ellar/pull/57
* Update flake8 requirement from <4.0.0,>=3.8.3 to >=3.8.3,<7.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/56


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.2.8...0.3.0

# 0.2.8
## What's Changed
* Separated `IHostContext` from `IExecutionContext` and added factory class that manages their creation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/51
* Made Guards classes Injectable by @eadwinCode in https://github.com/eadwinCode/ellar/pull/52
* Switched from `thread.local` to `ContextVar` to manage `request_scopes` properly by @eadwinCode in https://github.com/eadwinCode/ellar/pull/52
* Added Documentation for `ExecutionContext`.
* Increased test coverage.

**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.2.6...0.2.8

# 0.2.6
## What's Changed
* Documentation Updates by @eadwinCode in https://github.com/eadwinCode/ellar/pull/43
* Reverted building routes from a single list to a list of routers with a well-managed route not found cross routes @eadwinCode in https://github.com/eadwinCode/ellar/pull/43
* Python 3.11 Support by @eadwinCode in https://github.com/eadwinCode/ellar/pull/44
* Changed ASCII drawing to the image by @eadwinCode in https://github.com/eadwinCode/ellar/pull/45
* Added an `IExceptionHandler` contract for defining custom exception handler by @eadwinCode in https://github.com/eadwinCode/ellar/pull/46. [Doc](https://eadwincode.github.io/ellar/overview/exception_handling/)
* Dropped use for `BaseHTTPMiddleware` from Starlette and added a `FunctionBasedMiddleware` by @eadwinCode in https://github.com/eadwinCode/ellar/pull/47
* Added `file` decorator for `FileResponseModel` and `StreamingResponseModel` by @eadwinCode in https://github.com/eadwinCode/ellar/pull/47

```python
import asyncio
from ellar.common import ModuleRouter, file

async def slow_numbers(minimum: int, maximum: int):
    yield ("<html><body><ul>")
    for number in range(minimum, maximum + 1):
        yield "<li>%d</li>" % number
        await asyncio.sleep(0.01)
    yield ("</ul></body></html>")

router = ModuleRouter('/file')

@router.get()
@file(media_type='text/html')
def file_download():
    return {'path': 'path/to/file.html', 'filename': 'code.html', 'content_disposition_type': 'attachment'}

@router.get('/stream')
@file(media_type='text/html', streaming=True)
def file_stream():
    return slow_numbers(1, 4)
```


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.2.4...0.2.6

# 0.2.4
## What's Changed
* Update mkdocs-material requirement from <8.0.0,>=7.1.9 to >=7.1.9,<9.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/37
* Update pytest-cov requirement from <4.0.0,>=2.12.0 to >=2.12.0,<5.0.0 by @dependabot in https://github.com/eadwinCode/ellar/pull/35
* Pydependencies upgrade by @eadwinCode in https://github.com/eadwinCode/ellar/pull/32
* Bump types-orjson from 3.6.0 to 3.6.2 by @dependabot in https://github.com/eadwinCode/ellar/pull/34
* Made CLI tool an optional requirement by @eadwinCode in https://github.com/eadwinCode/ellar/pull/38


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.2.2...0.2.4

# 0.2.2
## What's Changed
* update readme by @areski in https://github.com/eadwinCode/ellar/pull/30
* Cli help command fix by @eadwinCode in https://github.com/eadwinCode/ellar/pull/31

**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.2.0...0.2.2

# 0.2.0
## What's Changed
* Project dependency fix by @eadwinCode in https://github.com/eadwinCode/ellar/pull/29
* Python 3.6 support ends here

**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.1.8...0.2.0

# 0.1.8
## What's Changed
* starlette dependencies fix by @eadwinCode in https://github.com/eadwinCode/ellar/pull/28


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.1.6...0.1.8

# 0.1.6
## What's Changed 
* package stats update by @eadwinCode in https://github.com/eadwinCode/ellar/pull/17
* fixed static package type by @eadwinCode in https://github.com/eadwinCode/ellar/pull/18
* Doc Preparation by @eadwinCode in https://github.com/eadwinCode/ellar/pull/19
* Moved Configuration From File To Class Based by @eadwinCode in https://github.com/eadwinCode/ellar/pull/21
* Bump codecov/codecov-action from 3.1.0 to 3.1.1 by @dependabot in https://github.com/eadwinCode/ellar/pull/25
* CLI Commands And Basic Project Scaffolding by @eadwinCode in https://github.com/eadwinCode/ellar/pull/20
* Quick-Start Doc by @eadwinCode in https://github.com/eadwinCode/ellar/pull/27

### CLI Commands
To scaffold ellar project
```shell
ellar create-project `project-name`
```
To scaffold ellar app
```shell
ellar create-module `app-name`
```
To start application server
```shell
ellar runserver
```


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.1.4...0.1.6

# 0.1.4
## What's Changed
* Bump actions/setup-python from 3 to 4 by @dependabot in https://github.com/eadwinCode/ellar/pull/8
* Starlette Class Renames by @eadwinCode in https://github.com/eadwinCode/ellar/pull/9
* Common Package Testing by @eadwinCode in https://github.com/eadwinCode/ellar/pull/10
* Constant Value All Caps by @eadwinCode in https://github.com/eadwinCode/ellar/pull/11
* Openapi Module Test by @eadwinCode in https://github.com/eadwinCode/ellar/pull/12
* Guard Module Testing by @eadwinCode in https://github.com/eadwinCode/ellar/pull/13
* Configuration Module Test by @eadwinCode in https://github.com/eadwinCode/ellar/pull/14
* App Test by @eadwinCode in https://github.com/eadwinCode/ellar/pull/15
* AppFactory and TestClientFactory Test by @eadwinCode in https://github.com/eadwinCode/ellar/pull/16


**Full Changelog**: https://github.com/eadwinCode/ellar/compare/0.1.2...0.1.4


# Version 0.1.2
## What's Changed
* Refactored route operation functions @eadwinCode in https://github.com/eadwinCode/ellar/pull/7

# Version 0.1.0
## First Release

* Pydantic integration
* DI Container
* Templating with Jinja2
* OpenAPI Documentation (Swagger and ReDoc)
* Controller (MVC)
* Guards (Authentications, roles and permissions)
* Modularization (eg: flask blueprint)
* Websocket support
* Session and Cookie support
* CORS, GZip, Static Files, Streaming responses
* Test client built on requests
* In-process background tasks.
* Startup and shutdown events.
* Application Events

### New Contributors
* @eadwinCode made their first contribution in https://github.com/eadwinCode/ellar/pull/6
