from matplotlib.path import Path
import matplotlib.patches as mpatches
import numpy as np


def mulify(fig):
    """
    mulify(fig) adds the McMule logo to a figure fig.
    """
    points = [
        [
            #  neck
            (+03.5, -01.0), (+04.7, +05.9), (+09.5, +13.2),
            (+14.4, +20.5), (+16.0, +23.0), (+16.0, +23.0)
        ],[
            # mane
            (+12.5, -03.0), (+07.9, +01.4), (+07.3, +03.0),
            (+06.8, +04.6), (+08.6, +04.0), (+08.6, +04.0),
            (+08.6, +04.0), (+15.2, +01.9), (+12.5, +04.4),
            (+09.8, +06.9), (+07.0, +10.1), (+11.3, +08.7),
            (+15.5, +07.3), (+12.8, +09.2), (+12.3, +09.9),
            (+11.8, +10.5), (+09.9, +13.5), (+15.0, +11.1),
            (+20.1, +08.8), (+15.1, +16.0), (+15.1, +16.0)
        ],[
            # right-ear
            (+07.0, -13.6), (+11.9, -18.3), (+13.8, -20.7),
            (+15.7, -23.1), (+19.4, -28.3), (+20.8, -30.5),
            (+22.1, -32.7), (+25.2, -38.5), (+26.0, -40.4),
            (+26.7, -42.3), (+27.7, -46.4), (+27.8, -47.3),
            (+27.9, -48.1), (+28.3, -47.6), (+28.3, -46.6),
            (+28.2, -45.7), (+27.5, -42.8), (+25.0, -41.1),
            (+22.5, -39.3), (+15.5, -35.0), (+13.8, -34.1),
            (+12.1, -33.2), (+07.0, -29.5), (+05.0, -27.0),
            (+02.9, -24.5), (+00.7, -21.1), (+00.8, -19.3),
            (+00.9, -17.5), (+01.4, -18.0), (+01.4, -18.0)
        ],[
            # left-ear
            (-14.2, -20.8), (-16.3, -28.8), (-16.8, -30.2),
            (-17.3, -31.6), (-19.7, -36.8), (-20.4, -38.6),
            (-21.1, -40.3), (-25.3, -49.3), (-26.6, -51.7),
            (-27.8, -54.1), (-27.3, -53.4), (-28.0, -55.3),
            (-28.8, -57.2), (-29.4, -59.0), (-27.9, -58.2),
            (-26.5, -57.4), (-27.7, -54.8), (-28.6, -53.1),
            (-29.6, -51.4), (-32.3, -46.8), (-32.8, -43.9),
            (-33.3, -41.1), (-33.5, -35.2), (-29.5, -30.8),
            (-25.6, -26.3), (-22.3, -23.3), (-21.0, -21.5),
            (-19.6, -19.6), (-20.0, -19.3), (-20.0, -19.3)
        ],[
            # id-6
            (-22.6, +09.6), (-22.6, +10.0), (-21.6, +10.9)
        ],[
            # id-5
            (-26.7, +11.3), (-26.2, +12.4), (-25.2, +13.3)
        ],[
            # id-4
            (-29.8, +12.7), (-28.9, +14.6), (-27.8, +14.9)
        ],[
            # id-3
            (-34.1, +13.9), (-32.5, +16.3), (-31.3, +16.8)
        ],[
            # id-2
            (-37.8, +14.8), (-36.1, +17.7), (-35.1, +18.1)
        ],[
            # id-0
            (-47.2, +14.7), (-44.2, +18.6), (-43.4, +18.7),
            (-42.6, +18.8), (-36.9, +18.9), (-34.4, +18.2),
            (-31.9, +17.5), (-17.6, +09.6), (-17.6, +06.6)
        ],[
            # left-eye
            (-27.4, -03.9), (-27.8, -05.0), (-27.7, -05.6),
            (-27.6, -07.0), (-27.1, -08.5), (-26.3, -09.7),
            (-25.2, -11.3), (-23.8, -14.1), (-21.8, -13.7),
            (-21.1, -13.6), (-20.9, -12.3), (-20.9, -11.9),
            (-20.9, -11.6), (-21.1, -09.7), (-21.4, -08.6),
            (-21.9, -07.4), (-22.2, -05.9), (-23.3, -05.4),
            (-24.5, -05.0), (-25.0, -05.9), (-25.0, -06.6),
            (-24.9, -07.1), (-24.1, -07.7), (-23.5, -07.5),
            (-23.0, -07.4), (-22.5, -06.8), (-22.9, -06.2)
        ],[
            # right-eye
            (-14.6, -04.5), (-13.8, -05.6), (-13.7, -06.2),
            (-13.4, -07.2), (-13.3, -08.3), (-13.5, -09.3),
            (-13.7, -10.1), (-13.8, -11.4), (-14.6, -11.6),
            (-15.6, -11.9), (-16.3, -10.5), (-16.9, -09.8),
            (-17.9, -08.5), (-18.8, -07.1), (-19.1, -05.5),
            (-19.3, -04.5), (-19.8, -03.0), (-19.0, -02.5),
            (-18.5, -02.2), (-17.5, -02.5), (-17.3, -03.0),
            (-17.1, -03.7), (-17.7, -04.6), (-18.4, -04.9),
            (-18.7, -05.0), (-19.3, -04.7), (-19.3, -04.7)
        ],[
            # throat
            (-11.4, +12.7), (-09.3, +18.8), (-08.4, +20.2),
            (-07.5, +21.6), (-05.2, +25.8), (-05.0, +27.1)
        ],[
            # snout
            (-33.4, +21.5), (-32.7, +24.4), (-31.1, +25.0),
            (-29.5, +25.6), (-26.9, +23.2), (-26.6, +22.7),
            (-26.2, +22.1), (-22.1, +17.2), (-20.9, +15.5),
            (-19.7, +13.8), (-15.3, +07.0), (-14.2, +05.6),
            (-09.8, -00.3, 'line'),
            (-11.6, +02.2), (-12.5, +03.5), (-19.8, +07.9),
            (-24.4, +10.7), (-24.3, +10.4), (-28.5, +12.0),
            (-32.0, +13.4), (-35.6, +14.4), (-38.2, +14.8),
            (-40.8, +15.2), (-43.0, +15.3), (-44.9, +15.1),
            (-46.8, +14.9), (-48.5, +14.3), (-50.1, +13.3),
            (-51.5, +12.5), (-52.8, +11.5), (-53.6, +10.2),
            (-54.4, +09.0), (-54.8, +07.6), (-54.9, +06.2),
            (-55.0, +05.0), (-54.8, +03.8), (-54.4, +02.7),
            (-53.9, +01.3), (-53.1, -00.0), (-52.1, -01.1),
            (-47.2, -06.1), (-42.6, -08.2), (-34.2, -12.1),
            (-25.7, -16.0), (-19.5, -16.0), (-19.5, -16.0)
        ],[
            # top-hair
            (-08.3, -26.6, 'line'),
            (-09.1, -22.6, 'line'),
            (-09.1, -22.6), (-10.8, -15.6), (-07.7, -22.0),
            (-04.6, -28.4), (-05.6, -24.3), (-06.1, -21.7),
            (-06.5, -19.1), (-06.7, -18.1), (-04.6, -21.1),
            (-02.4, -24.1), (-03.4, -21.8), (-03.6, -19.9),
            (-03.8, -18.0), (-03.7, -16.9), (-02.4, -19.1)
        ],[
            # id-1
            (-41.7, +15.3, 'line'),
            (-39.3, +18.7, 'line')
        ]
    ]

    ax = fig.get_axes()[0]

    vertices = [[p[0]]+p for p in points]
    vertices = np.array([i[:2] for j in vertices for i in j])

    commands = [
        [Path.MOVETO] + [
            Path.CURVE4 if len(i) == 2 else Path.LINETO
            for i in p
        ] for p in points]
    commands = [i for j in commands for i in j]

    pp1 = mpatches.PathPatch(
        Path(
            (np.array([1/1.3,-1])*vertices+55.)/550.+np.array([0.13,0.66]),
            commands
        ),
        fc='none', ec='lightgray', transform=fig.transFigure
    )

    if '3D' in str(type(ax)):
        fig.patches.append(pp1)
        fig.text(
            0.21, 0.69,
            '$\\small\\textsc{McMule}$',
            transform=fig.transFigure, ha='center',va='top', color='lightgray'
        )
    else:
        ax.add_patch(pp1)
        ax.text(
            0.21, 0.69,
            '$\\textsc{McMule}$',
            size=10,
            transform=fig.transFigure, ha='center',va='top', color='lightgray',
            zorder=0
        )
