# -*- coding: utf-8 -*-
""" Copyright 2020 Marco Arrigoni

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import sys
from setuptools import Extension, setup
from Cython.Build import cythonize
import numpy

ext_modules = [
    Extension('finger_descriptors_cython',
              sources=['finger_descriptors_cython.pyx', 'finger_descriptors_c.c',
                       'basic_operations.c'],
              libraries=['m'],
              include_dirs=[numpy.get_include(), '.']
              )
]

setup(name='descriptors',
      ext_modules=cythonize(
          ext_modules, 
          compiler_directives={'language_level': sys.version_info[0]}))
