# autogenerated
from datetime import date
from typing import Optional, Union

from pynspd.schemas.feature import _BaseFeature
from pynspd.schemas.geometries import LineString, MultiPolygon, Point, Polygon
from pynspd.schemas.layer_configs import LayerNode
from pynspd.schemas.properties import NspdProperties, OptionProperties


class Options36992(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    brd_nmb: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    content_restrict_encumbrances: Optional[str] = None
    """Ограничение"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении (изменении) границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options38030(OptionProperties):
    obj_kind_value: Optional[str] = None
    """Тип"""
    name: Optional[str] = None
    """Наименование"""
    cad_num: Optional[str] = None
    """Учетный номер"""
    cnt_kr: Optional[float] = None
    """Количество кадастровых районов"""
    cnt_kk: Optional[float] = None
    """Количество кадастровых кварталов"""
    cnt_land: Optional[float] = None
    """Количество земельных участков"""
    cnt_land_geom: Optional[float] = None
    """c границами"""
    cnt_land_not_geom: Optional[float] = None
    """без границ"""
    cnt_oks: Optional[float] = None
    """Количество объектов капитального строительства"""
    cnt_oks_geom: Optional[float] = None
    """с границами"""
    cnt_oks_not_geom: Optional[float] = None
    """без границ"""
    cnt_enk: Optional[float] = None
    """Количество единых недвижимых комплексов"""
    cnt_pik: Optional[float] = None
    """Количество предприятий как имущественных комплексов"""


class Options36368(OptionProperties):
    land_record_type: Optional[str] = None
    """Вид объекта недвижимости"""
    land_record_subtype: Optional[str] = None
    """Вид земельного участка"""
    land_record_reg_date: Optional[date] = None
    """Дата присвоения"""
    cad_num: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    readable_address: Optional[str] = None
    """Адрес"""
    specified_area: Optional[str] = None
    """Площадь уточненная (кв. м)"""
    declared_area: Optional[str] = None
    """Площадь декларированная (кв. м)"""
    area: Optional[str] = None
    """Площадь (кв. м)"""
    status: Optional[str] = None
    """Статус"""
    land_record_category_type: Optional[str] = None
    """Категория земель"""
    permitted_use_established_by_document: Optional[str] = None
    """Вид разрешенного использования"""
    ownership_type: Optional[str] = None
    """Форма собственности"""
    cost_value: Optional[float] = None
    """Кадастровая стоимость (руб.)"""
    cost_index: Optional[float] = None
    """Удельный показатель кадастровой стоимости (руб./кв. м)"""


class Options36369(OptionProperties):
    build_record_type_value: Optional[str] = None
    """Вид объекта недвижимости"""
    build_record_registration_date: Optional[date] = None
    """Дата присвоения"""
    cad_num: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    readable_address: Optional[str] = None
    """Адрес"""
    building_name: Optional[str] = None
    """Наименование"""
    purpose: Optional[str] = None
    """Назначение"""
    build_record_area: Optional[float] = None
    """Площадь общая (кв. м)"""
    status: Optional[str] = None
    """Статус"""
    ownership_type: Optional[str] = None
    """Форма собственности"""
    cost_value: Optional[float] = None
    """Кадастровая стоимость (руб.)"""
    cost_index: Optional[float] = None
    """Удельный показатель кадастровой стоимости (руб./ кв. м)"""
    floors: Optional[str] = None
    """Количество этажей (в том числе подземных)"""
    underground_floors: Optional[str] = None
    """Количество подземных этажей"""
    materials: Optional[str] = None
    """Материал стен"""
    year_built: Optional[str] = None
    """Завершение строительства (г.)"""
    year_commisioning: Optional[str] = None
    """Ввод в эксплуатацию (г.)"""
    cultural_heritage_object: Optional[str] = None
    """Сведения о включении объекта недвижимости в единый государственный реестр объектов культурного наследия (памятников истории и культуры) народов Российской Федерации"""
    united_cad_number: Optional[str] = None
    """Кадастровый номер единого недвижимого комплекса, в состав которого входит здание"""
    facility_cad_number: Optional[str] = None
    """Кадастровый номер предприятия как имущественного комплекса, в состав которого входит здание (имущественное право на здание)"""


class Options37148(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    date: Optional[str] = None
    """Дата присвоения"""
    brd_nmb: Optional[str] = None
    """Реестровый номер границы"""
    cad_distr: Optional[str] = None
    """Кадастровый район"""
    name: Optional[str] = None
    """Наименование"""
    encumb: Optional[str] = None
    """Ограничение"""
    doc: Optional[str] = None
    """Реквизиты правовых актов об установлении или изменении границ"""


class Options36381(OptionProperties):
    obj_kind_value: Optional[str] = None
    """Тип"""
    name: Optional[str] = None
    """Наименование"""
    cad_num: Optional[str] = None
    """Учетный номер"""
    cad_num_ko: Optional[str] = None
    """Кадастровый округ"""
    cad_num_kr: Optional[str] = None
    """Кадастровый район"""
    cnt_land: Optional[float] = None
    """Количество земельных участков"""
    cnt_land_geom: Optional[float] = None
    """с границами"""
    cnt_land_not_geom: Optional[float] = None
    """без границ"""
    cnt_oks: Optional[float] = None
    """Количество объектов капитального строительства"""
    cnt_oks_geom: Optional[float] = None
    """с границами"""
    cnt_oks_not_geom: Optional[float] = None
    """без границ"""
    cnt_enk: Optional[float] = None
    """Количество единых недвижимых комплексов"""
    cnt_pik: Optional[float] = None
    """Количество предприятий как имущественных комплексов"""


class Options36382(OptionProperties):
    obj_kind_value: Optional[str] = None
    """Тип"""
    name: Optional[str] = None
    """Наименование"""
    cad_num: Optional[str] = None
    """Учетный номер"""
    cad_num_ko: Optional[str] = None
    """Кадастровый округ"""
    cnt_kk: Optional[float] = None
    """Количество кадастровых кварталов"""
    cnt_land: Optional[float] = None
    """Количество земельных участков"""
    cnt_land_geom: Optional[float] = None
    """с границами"""
    cnt_land_not_geom: Optional[float] = None
    """без границ"""
    cnt_oks: Optional[float] = None
    """Количество объектов капитального строительства"""
    cnt_oks_geom: Optional[float] = None
    """с границами"""
    cnt_oks_not_geom: Optional[float] = None
    """без границ"""
    cnt_enk: Optional[float] = None
    """Количество единых недвижимых комплексов"""
    cnt_pik: Optional[float] = None
    """Количество предприятий как имущественных комплексов"""


class Options38943(OptionProperties):
    id: Optional[str] = None
    """ID"""
    doc_guid: Optional[str] = None
    """GUID"""
    doc_type: Optional[str] = None
    """Наименование вида документа об утверждении схемы расположения земельного участка"""
    doc_gov: Optional[str] = None
    """наименование уполномоченного органа"""
    doc_date: Optional[date] = None
    """дата"""
    doc_number: Optional[str] = None
    """номер"""
    cond_numbe: Optional[str] = None
    """Условный номер образуемого земельного участка"""
    shape_area: Optional[float] = None
    """Площадь (кв. м)"""
    address: Optional[str] = None
    """Адрес или иное описание местоположения земельного участка"""
    kvartal_id: Optional[str] = None
    """Кадастровый номер земельного участка, из которого в соответствии со схемой расположения земельного участка предусмотрено образование земельного участка"""
    name_zone: Optional[str] = None
    """Территориальная зона, в границах которой образуется земельный участок"""
    category_code: Optional[str] = None
    """Категория земель образуемого земельного"""
    utilization: Optional[str] = None
    """Вид разрешенного использования образуемого земельного участка"""


class Options36383(OptionProperties):
    object_type_value: Optional[str] = None
    """Вид объекта недвижимости"""
    registration_date: Optional[date] = None
    """Дата присвоения"""
    cad_number: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    address_readable_address: Optional[str] = None
    """Адрес"""
    params_name: Optional[str] = None
    """Наименование"""
    params_purpose: Optional[str] = None
    """Назначение"""
    params_height: Optional[float] = None
    """высота (м.)"""
    params_depth: Optional[float] = None
    """глубина (м.)"""
    params_occurence_depth: Optional[float] = None
    """глубина залегания (м.)"""
    params_extension: Optional[float] = None
    """протяженность (м.)"""
    params_volume: Optional[float] = None
    """объем (куб. м)"""
    params_built_up_area: Optional[float] = None
    """Площадь застройки (кв. м)"""
    params_area: Optional[float] = None
    """Площадь (кв. м)"""
    object_previously_posted: Optional[str] = None
    """Статус"""
    ownership_type: Optional[str] = None
    """Форма собственности"""
    cost_value: Optional[float] = None
    """Кадастровая стоимость (руб.)"""
    cost_index: Optional[float] = None
    """Удельный показатель кадастровой стоимости (руб./кв. м)"""
    params_floors: Optional[str] = None
    """Количество этажей (в том числе подземных)"""
    params_underground_floors: Optional[str] = None
    """Количество подземных этажей"""
    params_year_built: Optional[str] = None
    """Завершение строительства"""
    params_year_commisioning: Optional[str] = None
    """Ввод в эксплуатацию"""
    cultural_heritage_object: Optional[str] = None
    """Сведения о включении объекта недвижимости в единый государственный реестр объектов культурного наследия (памятников истории и культуры) народов Российской Федерации"""
    united_cad_number: Optional[str] = None
    """Кадастровый номер единого недвижимого комплекса, в состав которого входит сооружение"""
    facility_cad_number: Optional[str] = None
    """Кадастровый номер предприятия как имущественного комплекса, в состав которого сооружение (имущественное право на здание) входит"""


class Options37153(OptionProperties):
    nominal_number: Optional[str] = None
    """Условный номер образуемого земельного участка"""
    area: Optional[str] = None
    """Площадь образуемого земельного участка (кв. м)"""
    land_use_text: Optional[str] = None
    """Вид разрешенного использования образуемого земельного участка"""
    nmb: Optional[str] = None
    """номер"""
    registration_date: Optional[date] = None
    """дата"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[date] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options36384(OptionProperties):
    object_under_construction_record_record_type_value: Optional[str] = None
    """Вид объекта недвижимости"""
    registration_date: Optional[date] = None
    """Дата присвоения"""
    cad_num: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    readable_address: Optional[str] = None
    """Адрес"""
    object_under_construction_record_name: Optional[str] = None
    """Наименование"""
    height: Optional[float] = None
    """Высота (м.)"""
    depth: Optional[float] = None
    """Глубина (м.)"""
    occurence_depth: Optional[float] = None
    """Глубина залегания (м.)"""
    extension: Optional[float] = None
    """Протяжённость (м.)"""
    volume: Optional[float] = None
    """Объем (куб. м)"""
    built_up_area: Optional[float] = None
    """Площадь застройки (кв. м)"""
    common_data_status: Optional[str] = None
    """Статус"""
    ownership_type: Optional[str] = None
    """Форма собственности"""
    cost_value: Optional[float] = None
    """Кадастровая стоимость (руб.)"""
    cost_index: Optional[float] = None
    """Удельный показатель кадастровой стоимости (руб./ кв. м)"""
    degree_readiness: Optional[str] = None
    """Степень готовности ОНС в процентах (%)"""
    purpose: Optional[str] = None
    """Проектируемое значение основной характеристики"""
    facility_cad_number: Optional[str] = None
    """Кадастровый номер предприятия как имущественного комплекса, если объект незавершенного строительства (имущественное право на объект незавершенного строительства) входит в состав предприятия как имущественного комплекса"""


class Options445347(OptionProperties):
    cn: Optional[str] = None
    """Кадастровый или условный номер"""
    kvartal_cn: Optional[str] = None
    """Кадастровый квартал"""
    reg_name: Optional[str] = None
    """Субъект Российской Федерации"""
    mun: Optional[str] = None
    """Муниципальное образование"""
    np: Optional[str] = None
    """Населенный пункт"""
    address: Optional[str] = None
    """Адрес"""
    area: Optional[float] = None
    """Площадь"""
    category_text: Optional[str] = None
    """Категория земель"""
    util_by_doc: Optional[str] = None
    """Вид разрешенного использования"""
    right: Optional[str] = None
    """Форма собственности"""
    potential: Optional[str] = None
    """Потенциал использования"""
    has_oks: Optional[str] = None
    """Объекты капитального строительства"""
    has_network: Optional[str] = None
    """Инженерные сети"""
    develop_build: Optional[str] = None
    """Входит в территорию, в отношении которой возможно (планируется) комплексное развитие территории жилой застройки"""
    privileges_peo: Optional[str] = None
    """Предназначена для предоставления льготным категориям граждан"""
    privileges: Optional[str] = None
    """Льготная категория"""
    dom_rf: Optional[str] = None
    """Агентом Российской Федерации в отношении земельного участка выступает АО «ДОМ. РФ»"""
    uo_name: Optional[str] = None
    """Наименование уполномоченного органа"""
    uo_address: Optional[str] = None
    """Адрес уполномоченного органа"""
    uo_phone: Optional[str] = None
    """Телефон уполномоченного органа"""
    uo_url: Optional[str] = None
    """Сайт в сети Интернет"""
    uo_email: Optional[str] = None
    """e-mail"""
    inves_portal: Optional[str] = None
    """Инвестиционный портал региона"""


class Options38942(OptionProperties):
    content_restrict_encumbrances: Optional[str] = None
    """Ограничения"""
    doc: Optional[str] = None
    """Реквизиты решения об утверждении документации по планировке территории"""
    DOC_TYPE: Optional[str] = None
    """документ"""
    DOC_NUMBER: Optional[str] = None
    """номер"""
    DOC_DATE: Optional[date] = None
    """дата"""
    DOC_GOV: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options38944(OptionProperties):
    schema1: Optional[str] = None
    """Тип"""
    name: Optional[str] = None
    """Наименование объекта"""
    part_type: Optional[str] = None
    """Тип части"""
    building: Optional[str] = None
    """Наличие объектов капитального строительства"""


class Options37158(OptionProperties):
    nominal_number: Optional[str] = None
    """Условный номер образуемого земельного участка"""
    area: Optional[str] = None
    """Площадь образуемого земельного участка (кв. м)"""
    land_use_text: Optional[str] = None
    """Вид разрешенного использования образуемого земельного участка"""
    brd_nmb: Optional[str] = None
    """номер"""
    registration_date: Optional[date] = None
    """дата"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[date] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options38967(OptionProperties):
    process_ty: Optional[str] = None
    """Тип"""
    reg_num: Optional[str] = None
    """Номер"""
    cad_distr: Optional[float] = None
    """Кадастровый округ"""
    district: Optional[str] = None
    """Район"""
    index_map: Optional[str] = None
    """Индекс"""
    process_ty_title: Optional[str] = None
    """Вид и степень развития негативного процесса (га.)"""
    shape_area: Optional[str] = None
    """Площадь проявления негативного процесса (% к площади работ)"""
    zone_proya: Optional[str] = None
    """Зона проявления"""
    soil_type: Optional[str] = None
    """Тип почвы"""
    recommend: Optional[str] = None
    """Рекомендации по использованию земель"""


class Options39228(OptionProperties):
    terr_name: Optional[str] = None
    """Наименование территории"""


class Options38979(OptionProperties): ...


class Options38981(OptionProperties):
    auc_thrf: Optional[str] = None
    """Ссылка на аукцион"""


class Options36940(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    type_zone: Optional[str] = None
    """Тип зоны"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    content_restrict_encumbrances: Optional[str] = None
    """Ограничение"""
    doc: Optional[str] = None
    """Реквизиты решения об установлении (изменении) ЗОУИТ"""
    legal_act_document_name: Optional[str] = None
    """документ"""
    legal_act_document_number: Optional[str] = None
    """номер"""
    legal_act_document_date: Optional[str] = None
    """дата"""
    legal_act_document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options36941(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    description: Optional[str] = None
    """Описание"""
    document_name: Optional[str] = None
    """Реквизиты правовых актов об установлении или изменении границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36942(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении (изменении) границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36943(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении или изменении границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36944(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении или изменении границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36945(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении (изменении) границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36946(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    type_zone: Optional[str] = None
    """Тип зоны"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    content_restrict_encumbrances: Optional[str] = None
    """Ограничение"""
    doc: Optional[str] = None
    """Реквизиты решения об установлении (изменении) территориальной зоны"""
    legal_act_document_name: Optional[str] = None
    """документ"""
    legal_act_document_number: Optional[str] = None
    """номер"""
    legal_act_document_date: Optional[str] = None
    """дата"""
    legal_act_document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""
    permitted_uses_name: Optional[str] = None
    """Вид разрешенного использования"""


class Options36947(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    content_restrict_encumbrances: Optional[str] = None
    """Ограничение"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении или изменении границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options38996(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    reg_code: Optional[str] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[str] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options445397(OptionProperties):
    cn: Optional[str] = None
    """Кадастровый или условный номер"""
    kvartal_cn: Optional[str] = None
    """Кадастровый квартал"""
    reg_name: Optional[str] = None
    """Субъект Российской Федерации"""
    mun: Optional[str] = None
    """Муниципальное образование"""
    np: Optional[str] = None
    """Населенный пункт"""
    address: Optional[str] = None
    """Адрес"""
    area: Optional[float] = None
    """Площадь, м"""
    category_text: Optional[str] = None
    """Категория земель"""
    terzone_name_by_pzz: Optional[str] = None
    """Территориальная зона"""
    util_by_doc: Optional[str] = None
    """Вид разрешенного использования"""
    right: Optional[str] = None
    """Форма собственности"""
    cad_cost: Optional[str] = None
    """Кадастровая стоимость"""
    power_supply: Optional[str] = None
    """Электроснабжение"""
    water_supply: Optional[str] = None
    """Водоснабжение"""
    gas_supply: Optional[str] = None
    """Газоснабжение"""
    sewerage: Optional[str] = None
    """Канализация"""
    heat_supply: Optional[str] = None
    """Теплоснабжение"""
    poi: Optional[str] = None
    """Наименование ближайшего объекта туристского интереса"""
    poi_cn: Optional[str] = None
    """Кадастровый или реестровый номер объекта туристского интереса"""
    distance_to_near_tour_object: Optional[float] = None
    """Расстояние до ближайшего объекта туристского интереса (км)"""
    id_oti: Optional[str] = None
    """Идентификационный номер объекта туристского интереса"""
    distance_to_near_fed_road: Optional[float] = None
    """Расстояние до ближайшей федеральной трассы (км)"""
    distance_to_near_hard_road: Optional[float] = None
    """Расстояние до ближайшей дороги с твердым покрытием (км)"""
    distance_to_near_district: Optional[float] = None
    """Расстояние до ближайшего центра муниципального района или городского округа (км)"""
    distance_to_near_locality: Optional[float] = None
    """Расстояние до ближайшего населенного пункта (км)"""
    distance_to_near_public_catering: Optional[float] = None
    """Расстояние до ближайшего объекта общественного питания (км)"""
    distance_to_near_health_care: Optional[float] = None
    """Расстояние до ближайшего объекта здравоохранения (км)"""
    distance_to_near_public_transport: Optional[float] = None
    """Расстояние до ближайшей остановки общественного транспорта (км)"""
    distance_to_near_railway_station: Optional[float] = None
    """Расстояние до ближайшей железнодорожной станции (км)"""
    distance_to_near_airport: Optional[float] = None
    """Расстояние до ближайшего аэропорта (км)"""
    additional_info: Optional[str] = None
    """Инвестиционный портал региона"""
    tour_object_description: Optional[str] = None
    """Информационной ресурс, содержащий информацию об объекте туристского интереса"""
    uo_name: Optional[str] = None
    """Наименование уполномоченного органа"""
    uo_phone: Optional[str] = None
    """Телефон уполномоченного органа"""
    uo_address: Optional[str] = None
    """Адрес уполномоченного органа"""
    uo_email: Optional[str] = None
    """e-mail"""


class Options38998(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    num: Optional[str] = None
    """Идентификационный номер"""


class Options38999(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    num: Optional[str] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    legal_act_document_name: Optional[str] = None
    """документ"""
    legal_act_document_number: Optional[str] = None
    """номер"""
    legal_act_document_date: Optional[str] = None
    """дата"""
    legal_act_document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options39000(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    num: Optional[str] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    legal_act_document_name: Optional[str] = None
    """документ"""
    legal_act_document_number: Optional[str] = None
    """номер"""
    legal_act_document_date: Optional[str] = None
    """дата"""
    legal_act_document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options36948(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[date] = None
    """Дата присвоения"""
    reg_numb_border: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    name_by_doc: Optional[str] = None
    """Наименование"""
    content_restrict_encumbrances: Optional[str] = None
    """Ограничение"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении (изменении) границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Options36829(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    reg_code: Optional[str] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[str] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options36830(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    num: Optional[float] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[str] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options36832(OptionProperties):
    type: Optional[str] = None
    """Вид"""
    brd_nmb: Optional[str] = None
    """Реестровый номер"""
    reg_code: Optional[str] = None
    """Идентификационный номер"""
    name: Optional[str] = None
    """Наименование"""
    doc: Optional[str] = None
    """Реквизиты правовых актов о согласовании и об утверждении изменения границ"""
    document_name: Optional[str] = None
    """документ"""
    document_number: Optional[str] = None
    """номер"""
    document_date: Optional[str] = None
    """дата"""
    document_issuer: Optional[str] = None
    """орган власти, организация выдавшие документ"""


class Options445547(OptionProperties):
    name: Optional[str] = None
    """Наименование объекта туристского интереса"""
    cn: Optional[str] = None
    """Кадастровый номер (при наличии)"""
    address: Optional[str] = None
    """Адрес объекта туристского интереса"""
    type: Optional[str] = None
    """Тип объекта туристского интереса"""
    vid_oopt: Optional[str] = None
    """Вид особо охраняемой природной территории"""
    unesko: Optional[str] = None
    """Наличие у объекта туристского интереса статуса ЮНЕСКО"""
    vid_okn: Optional[str] = None
    """Вид объекта культурного-исторического наследия"""
    status: Optional[str] = None
    """Статус объекта туристского интереса"""
    potential: Optional[str] = None
    """Потенциальный интерес к объекту"""
    tourist: Optional[str] = None
    """Среднее количество туристов, посетивших объект туристского интереса за два предыдущих года(тыс. чел.)"""
    paid_services: Optional[str] = None
    """Средний объем платных услуг, оказанных объектом туристского интереса за два предыдущих года(млн. руб.)"""
    url: Optional[str] = None
    """Ссылка на портал, содержащий информацию об объекте туристского интереса"""


class Options39663(OptionProperties):
    type: Optional[str] = None
    """Вид объекта недвижимости"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    cad_number: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    readable_address: Optional[str] = None
    """Адрес"""
    name: Optional[str] = None
    """Наименование"""
    purpose: Optional[str] = None
    """Назначение"""
    common_data_status: Optional[str] = None
    """Статус"""
    cost_value: Optional[float] = None
    """Кадастровая стоимость (руб.)"""
    facility_cad_number: Optional[str] = None
    """Кадастровый номер предприятия как имущественного комплекса, если единый недвижимый комплекс (имущественное право на него) входит в состав предприятия как имущественного комплекса"""


class Options39664(OptionProperties):
    type: Optional[str] = None
    """Вид объекта недвижимости"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    name: Optional[str] = None
    """Наименование ПИК при наличии такого наименования"""
    purpose: Optional[str] = None
    """Назначение ПИК"""
    cad_number: Optional[str] = None
    """Кадастровый номер"""
    quarter_cad_number: Optional[str] = None
    """Кадастровый квартал"""
    readable_address: Optional[str] = None
    """Адрес"""
    common_data_status: Optional[str] = None
    """Статус"""
    cost_value: Optional[str] = None
    """Стоимость предприятия (руб.)"""


class Options36991(OptionProperties):
    type_boundary_value: Optional[str] = None
    """Вид"""
    registration_date: Optional[str] = None
    """Дата присвоения"""
    brd_nmb: Optional[str] = None
    """Реестровый номер границы"""
    cadastral_district: Optional[str] = None
    """Кадастровый район"""
    loc: Optional[str] = None
    """Наименование"""
    document_name: Optional[str] = None
    """Реквизиты решения об установлении или изменении границ"""
    legal_act_document_name: Optional[str] = None
    """Наименование документа"""
    legal_act_document_number: Optional[str] = None
    """Номер"""
    legal_act_document_date: Optional[str] = None
    """Дата"""
    legal_act_document_issuer: Optional[str] = None
    """Орган власти, организация выдавшие документ"""


class Layer36945Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38030]]
):
    """Кадастровые округа"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Кадастровые округа",
            "layerTreeId": 3,
            "layerId": 36945,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Кадастровый округ тест",
            "layerVisibleByDefault": False,
            "categoryId": 38030,
        }
    )


class Layer36316Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36947]]
):
    """Территории объектов культурного наследия"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Территории объектов культурного наследия",
            "layerTreeId": 62,
            "layerId": 36316,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Территории объекта культурного наследия (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36947,
        }
    )


class Layer36070Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36382]]
):
    """Кадастровые районы"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Кадастровые районы ",
            "layerTreeId": 5873,
            "layerId": 36070,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЕГРН. Кадастровые районы",
            "layerVisibleByDefault": False,
            "categoryId": 36382,
        }
    )


class Layer36071Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36381]]
):
    """Кадастровые кварталы"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Кадастровые кварталы",
            "layerTreeId": 5,
            "layerId": 36071,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЕГРН. Кадастровые кварталы",
            "layerVisibleByDefault": False,
            "categoryId": 36381,
        }
    )


class Layer37313Feature(_BaseFeature[LineString, NspdProperties[Options38998]]):
    """Государственная граница Российской Федерации"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Государственная граница Российской Федерации",
            "layerTreeId": 7,
            "layerId": 37313,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Государственная граница Российской Федерации",
            "layerVisibleByDefault": False,
            "categoryId": 38998,
        }
    )


class Layer37314Feature(_BaseFeature[LineString, NspdProperties[Options38999]]):
    """Субъекты Российской Федерации (линии)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Субъекты Российской Федерации (линии)",
            "layerTreeId": 9,
            "layerId": 37314,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Границы между субъектами Российской Федерации (линии)",
            "layerVisibleByDefault": False,
            "categoryId": 38999,
        }
    )


class Layer37315Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options39000]]
):
    """Субъекты Российской Федерации (полигоны)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Субъекты Российской Федерации (полигоны)",
            "layerTreeId": 10,
            "layerId": 37315,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Границы между субъектами Российской Федерации (полигоны)",
            "layerVisibleByDefault": False,
            "categoryId": 39000,
        }
    )


class Layer36278Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36829]]
):
    """Муниципальные образования (полигональный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Муниципальные образования (полигональный)",
            "layerTreeId": 12,
            "layerId": 36278,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Муниципальные образования (полигональный)",
            "layerVisibleByDefault": False,
            "categoryId": 36829,
        }
    )


class Layer36279Feature(_BaseFeature[LineString, NspdProperties[Options36830]]):
    """Муниципальные образования (линейный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Муниципальные образования (линейный)",
            "layerTreeId": 13,
            "layerId": 36279,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Муниципальные образования (линейный)",
            "layerVisibleByDefault": False,
            "categoryId": 36830,
        }
    )


class Layer36281Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36832]]
):
    """Населённые пункты (полигоны)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Населённые пункты (полигоны)",
            "layerTreeId": 15,
            "layerId": 36281,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Границы населенных пунктов",
            "layerVisibleByDefault": False,
            "categoryId": 36832,
        }
    )


class Layer37316Feature(_BaseFeature[LineString, NspdProperties[Options38996]]):
    """Населённые пункты (линии)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Населённые пункты (линии)",
            "layerTreeId": 16,
            "layerId": 37316,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Границы населенных пунктов (линии)",
            "layerVisibleByDefault": False,
            "categoryId": 38996,
        }
    )


class Layer36048Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36368]]
):
    """Земельные участки из ЕГРН"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки из ЕГРН",
            "layerTreeId": 72,
            "layerId": 36048,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Земельные участки ЕГРН",
            "layerVisibleByDefault": False,
            "categoryId": 36368,
        }
    )


class Layer36472Feature(_BaseFeature[LineString, NspdProperties[Options37153]]):
    """Земельные участки, образуемые по проекту межевания территории (линейный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки, образуемые по проекту межевания территории (линейный)",
            "layerTreeId": 20,
            "layerId": 36472,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Земельные участки, образуемые по проекту межевания территории (линейный)",
            "layerVisibleByDefault": False,
            "categoryId": 37153,
        }
    )


class Layer36473Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options37158]]
):
    """Земельные участки, образуемые по проекту межевания территории (полигональный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки, образуемые по проекту межевания территории (полигональный)",
            "layerTreeId": 21,
            "layerId": 36473,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Земельные участки, образуемые по проекту межевания территории (полигональный)",
            "layerVisibleByDefault": False,
            "categoryId": 37158,
        }
    )


class Layer37294Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38943]]
):
    """Земельные участки, образуемые по схеме расположения земельного участка"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки, образуемые по схеме расположения земельного участка",
            "layerTreeId": 22,
            "layerId": 37294,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Схемы расположения земельных участков",
            "layerVisibleByDefault": False,
            "categoryId": 38943,
        }
    )


class Layer37299Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38981]]
):
    """Земельные участки, выставленные на аукцион"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки, выставленные на аукцион ",
            "layerTreeId": 23,
            "layerId": 37299,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Земельные участки, выставленные на аукцион",
            "layerVisibleByDefault": False,
            "categoryId": 38981,
        }
    )


class Layer37298Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38979]]
):
    """Земельные участки, свободные от прав третьих лиц"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земельные участки, свободные от прав третьих лиц",
            "layerTreeId": 24,
            "layerId": 37298,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Земельные участки свободные от прав третьих лиц",
            "layerVisibleByDefault": False,
            "categoryId": 38979,
        }
    )


class Layer849407Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options445347]]
):
    """Земля для стройки ПКК"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земля для стройки ПКК",
            "layerTreeId": 6409,
            "layerId": 849407,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Земля для стройки",
            "layerVisibleByDefault": False,
            "categoryId": 445347,
        }
    )


class Layer849453Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options445397]]
):
    """Земля для туризма ПКК"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Земля для туризма ПКК",
            "layerTreeId": 6410,
            "layerId": 849453,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Земля для туризма",
            "layerVisibleByDefault": False,
            "categoryId": 445397,
        }
    )


class Layer36049Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36369]]
):
    """Здания"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Здания",
            "layerTreeId": 29,
            "layerId": 36049,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Здания ЕГРН",
            "layerVisibleByDefault": False,
            "categoryId": 36369,
        }
    )


class Layer36328Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36383]]
):
    """Сооружения"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Сооружения",
            "layerTreeId": 30,
            "layerId": 36328,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Сооружения ЕГРН",
            "layerVisibleByDefault": False,
            "categoryId": 36383,
        }
    )


class Layer36329Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36384]]
):
    """Объекты незавершенного строительства"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Объекты незавершенного строительства",
            "layerTreeId": 31,
            "layerId": 36329,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Объекты незавершённого строительства ЕГРН",
            "layerVisibleByDefault": False,
            "categoryId": 36384,
        }
    )


class Layer37433Feature(_BaseFeature[Point, NspdProperties[Options39663]]):
    """Единые недвижимые комплексы"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Единые недвижимые комплексы",
            "layerTreeId": 35,
            "layerId": 37433,
            "layerType": "wms",
            "geometryType": "POINT",
            "layerName": "Единые недвижимые комплексы",
            "layerVisibleByDefault": False,
            "categoryId": 39663,
        }
    )


class Layer37434Feature(_BaseFeature[Point, NspdProperties[Options39664]]):
    """Предприятие как имущественный комплекс"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Предприятие как имущественный комплекс",
            "layerTreeId": 36,
            "layerId": 37434,
            "layerType": "wms",
            "geometryType": "POINT",
            "layerName": "Предприятие как имущественный комплекс",
            "layerVisibleByDefault": False,
            "categoryId": 39664,
        }
    )


class Layer37577Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36940]]
):
    """ЗОУИТ объектов культурного наследия"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "ЗОУИТ объектов культурного наследия",
            "layerTreeId": 39,
            "layerId": 37577,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЗОУИТ объектов культурного наследия",
            "layerVisibleByDefault": False,
            "categoryId": 36940,
        }
    )


class Layer37578Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36940]]
):
    """ЗОУИТ объектов энергетики, связи, транспорта"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "ЗОУИТ объектов энергетики, связи, транспорта",
            "layerTreeId": 40,
            "layerId": 37578,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЗОУИТ объектов энергетики, связи, транспорта",
            "layerVisibleByDefault": False,
            "categoryId": 36940,
        }
    )


class Layer37580Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36940]]
):
    """ЗОУИТ природных территорий"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "ЗОУИТ природных территорий",
            "layerTreeId": 41,
            "layerId": 37580,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЗОУИТ природных территорий",
            "layerVisibleByDefault": False,
            "categoryId": 36940,
        }
    )


class Layer37579Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36940]]
):
    """ЗОУИТ охраняемых объектов и безопасности"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "ЗОУИТ охраняемых объектов и безопасности",
            "layerTreeId": 42,
            "layerId": 37579,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЗОУИТ охраняемых объектов и безопасности",
            "layerVisibleByDefault": False,
            "categoryId": 36940,
        }
    )


class Layer37581Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36940]]
):
    """Иные ЗОУИТ"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Иные ЗОУИТ",
            "layerTreeId": 43,
            "layerId": 37581,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Иные ЗОУИТ",
            "layerVisibleByDefault": False,
            "categoryId": 36940,
        }
    )


class Layer36315Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36946]]
):
    """Территориальные зоны"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Территориальные зоны",
            "layerTreeId": 45,
            "layerId": 36315,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Территориальные зоны (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36946,
        }
    )


class Layer37293Feature(_BaseFeature[LineString, NspdProperties[Options38942]]):
    """Красные линии"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Красные линии ",
            "layerTreeId": 46,
            "layerId": 37293,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Красные линии",
            "layerVisibleByDefault": False,
            "categoryId": 38942,
        }
    )


class Layer36317Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36948]]
):
    """Особо охраняемые природные территории"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Особо охраняемые природные территории ",
            "layerTreeId": 49,
            "layerId": 36317,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Особо охраняемая природные территории (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36948,
        }
    )


class Layer36311Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36942]]
):
    """Охотничьи угодья"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Охотничьи угодья ",
            "layerTreeId": 50,
            "layerId": 36311,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Охотничьи угодья (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36942,
        }
    )


class Layer36314Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36945]]
):
    """Лесничества"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Лесничества",
            "layerTreeId": 51,
            "layerId": 36314,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Лесничества (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36945,
        }
    )


class Layer36469Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36992]]
):
    """Береговые линии (границы водных объектов) (полигональный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Береговые линии (границы водных объектов) (полигональный)",
            "layerTreeId": 55,
            "layerId": 36469,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Сведения о береговых линиях (границах водных объектов). (полигональный)",
            "layerVisibleByDefault": False,
            "categoryId": 36992,
        }
    )


class Layer36470Feature(_BaseFeature[LineString, NspdProperties[Options37148]]):
    """Береговые линии (границы водных объектов)(линейный)"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Береговые линии (границы водных объектов)(линейный)",
            "layerTreeId": 56,
            "layerId": 36470,
            "layerType": "wms",
            "geometryType": "LINESTRING",
            "layerName": "Сведения о береговых линиях (границах водных объектов). (линейный)",
            "layerVisibleByDefault": False,
            "categoryId": 37148,
        }
    )


class Layer36303Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36941]]
):
    """Особые экономические зоны"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Особые экономические зоны",
            "layerTreeId": 58,
            "layerId": 36303,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Особые экономические зоны (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36941,
        }
    )


class Layer36312Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36943]]
):
    """Территории опережающего развития"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Территории опережающего развития",
            "layerTreeId": 59,
            "layerId": 36312,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Территории опережающего развития (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36943,
        }
    )


class Layer36313Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36944]]
):
    """Зоны территориального развития в Российской Федерации"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Зоны территориального развития в Российской Федерации",
            "layerTreeId": 60,
            "layerId": 36313,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Зоны территориального развития в Российской Федерации (ЕГРН)",
            "layerVisibleByDefault": False,
            "categoryId": 36944,
        }
    )


class Layer36471Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36991]]
):
    """Игорные зоны"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Игорные зоны",
            "layerTreeId": 61,
            "layerId": 36471,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Границы игорных зон",
            "layerVisibleByDefault": False,
            "categoryId": 36991,
        }
    )


class Layer37430Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options39228]]
):
    """Территории выполнения комплексных кадастровых работ"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Территории выполнения комплексных кадастровых работ",
            "layerTreeId": 66,
            "layerId": 37430,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "ЕГРН.Территории выполнения комплексных кадастровых работ",
            "layerVisibleByDefault": False,
            "categoryId": 39228,
        }
    )


class Layer37295Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38944]]
):
    """Территория проведения мероприятий по ликвидации накопленного вреда окружающей среде, образовавшегося в результате производства химической продукции в г. Усолье-Сибирское Иркутской области"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Территория проведения мероприятий по ликвидации накопленного вреда окружающей среде, образовавшегося в результате производства химической продукции в г. Усолье-Сибирское Иркутской области",
            "layerTreeId": 64,
            "layerId": 37295,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Территория проведения мероприятий по ликвидации накопленного вреда окружающей среде, образовавшегося в результате производства химической продукции в г. Усолье-Сибирское Иркутской области",
            "layerVisibleByDefault": False,
            "categoryId": 38944,
        }
    )


class Layer37296Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options38967]]
):
    """Негативные процессы"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Негативные процессы",
            "layerTreeId": 65,
            "layerId": 37296,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Негативные процессы",
            "layerVisibleByDefault": False,
            "categoryId": 38967,
        }
    )


class Layer849601Feature(_BaseFeature[Point, NspdProperties[Options445547]]):
    """Объекты туристского интереса"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Объекты туристского интереса",
            "layerTreeId": 6487,
            "layerId": 849601,
            "layerType": "wms",
            "geometryType": "POINT",
            "layerName": "Объекты туристского интереса",
            "layerVisibleByDefault": False,
            "categoryId": 445547,
        }
    )


class Layer37236Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36368]]
):
    """Кадастровая стоимость объекта"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Кадастровая стоимость объекта",
            "layerTreeId": 69,
            "layerId": 37236,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Земельные участки ЕГРН. Кадастровая стоимость Тепловая карта",
            "layerVisibleByDefault": False,
            "categoryId": 36368,
        }
    )


class Layer37758Feature(
    _BaseFeature[Union[MultiPolygon, Polygon, Point], NspdProperties[Options36368]]
):
    """Удельный показатель кадастровой стоимости"""

    layer_meta = LayerNode.model_validate(
        {
            "title": "Удельный показатель кадастровой стоимости",
            "layerTreeId": 70,
            "layerId": 37758,
            "layerType": "wms",
            "geometryType": "POLYGON",
            "layerName": "Росреестр: Земельные участки ЕГРН. Удельный Показатель Кадастровой Стоимости Тепловая карта",
            "layerVisibleByDefault": False,
            "categoryId": 36368,
        }
    )
