from enum import Enum


class Airline(Enum):
    """Airline codes for most airlines in the world.

    This is auto-generated from data/airlines.csv.
    """

    A0 = "Macair Jet"
    A1 = "APG Distribution System"
    A2 = "Astra Airlines"
    A3 = "Aegean Airlines"
    A4 = "Azimuth"
    A5 = "HOP!"
    A6 = "Yunnan Hongtu Airline"
    A7 = "Aéreo Calafia"
    A8 = "Aerolink Uganda"
    A9 = "Georgian Airways"
    AA = "American Airlines"
    AB = "Bonza"
    AC = "Air Canada"
    AD = "Azul Brazilian Airlines"
    AE = "Mandarin Airlines"
    AF = "Air France"
    AG = "Aruba Airlines"
    AH = "Air Algerie"
    AI = "Air India"
    AJ = "Aztec Worldwide Airlines"
    AK = "AirAsia"
    AL = "Air Leisure"
    AM = "AeroMexico"
    AN = "HOP Airlinair"
    AO = "Air Juan Aviation"
    AP = "AlbaStar"
    AQ = "9 Air"
    AR = "Aerolíneas Argentinas"
    AS = "Alaska Airlines"
    AT = "Royal Air Maroc"
    AU = "Austral Líneas Aéreas"
    AV = "Avianca"
    AW = "Africa World Airlines"
    AX = "Trans States Airlines"
    AY = "Finnair"
    AZ = "Alitalia"
    B0 = "La Compagnie"
    B1 = "Cions Software"
    B2 = "Belavia"
    B3 = "Bhutan Airlines"
    B4 = "Zanair"
    B5 = "Fly-SAX"
    B6 = "JetBlue"
    B7 = "Uni Airways"
    B8 = "Eritrean Airlines"
    B9 = "Iran Air Tours"
    BA = "British Airways"
    BB = "Seaborne Airlines"
    BC = "Skymark Airlines"
    BD = "Cambodia Bayon Airlines"
    BE = "Flybe"
    BF = "French Bee"
    BG = "Biman Bangladesh Airline"
    BH = "Hawkair"
    BI = "Royal Brunei"
    BJ = "Nouvelair"
    BK = "Okay Airways"
    BL = "Jetstar Pacific Airlines"
    BM = "bmi regional"
    BN = "Luxwing Ltd"
    BO = "BB Airways"
    BP = "Air Botswana"
    BR = "EVA Air"
    BS = "US-Bangla Airlines"
    BT = "airBaltic"
    BU = "Compagnie Africaine d'Aviation"
    BV = "Blue Panorama Airlines"
    BW = "Caribbean Airlines"
    BX = "Air Busan"
    BY = "Thomson Airways"
    BZ = "Bluebird Airways"
    C0 = "Centralwings"
    C1 = "Tectimes Sudamerica"
    C2 = "Ceiba Intercontinental"
    C3 = "Trade Air"
    C4 = "Alma De Mexico"
    C5 = "CommutAir"
    C6 = "Canjet Airlines"
    C7 = "Cinnamon Air"
    C8 = "Cronos Airlines"
    C9 = "Skywise"
    CA = "Air China"
    CB = "Trans Caribbean Air ExportImport"
    CC = "CM Airlines"
    CD = "Corendon Dutch Airlines"
    CE = "Chalair Aviation"
    CF = "China Postal Airlines"
    CG = "PNG Air"
    CH = "Bemidji Airlines"
    CI = "China Airlines"
    CJ = "BA CityFlyer"
    CK = "China Cargo Airlines"
    CL = "Lufthansa CityLine"
    CM = "Copa Airlines"
    CN = "Grand China Air"
    CO = "Cobalt Air"
    CP = "Compass Airlines"
    CQ = "Coastal Travels"
    CR = "OAG Worldwide"
    CS = "Comlux Aruba"
    CT = "Alitalia CityLiner"
    CU = "Cubana De Aviacion"
    CV = "Cargolux"
    CX = "Cathay Pacific"
    CY = "Charlie Airlines"
    CZ = "China Southern Airlines"
    D0 = "DHL Air UK"
    D2 = "Severstal Air Company"
    D3 = "Daallo Airlines"
    D4 = "DART Ltd"
    D6 = "Interair"
    D7 = "AirAsia X"
    D8 = "Norwegian Air International"
    D9 = "Donavia"
    DA = "Air Georgia"
    DB = "HOP Brit Air"
    DC = "Braathens Regional Airways"
    DD = "Nok Air"
    DE = "Condor"
    DF = "Condor Berlin"
    DG = "Cebgo"
    DH = "Douniah Airlines"
    DI = "Norwegian Air UK"
    DJ = "AirAsia Japan"
    DK = "Thomas Cook Airlines"
    DL = "Delta Air Lines"
    DM = "Arajet"
    DN = "Norwegian Air Argentina"
    DO = "Discovery Airways"
    DP = "Pobeda"
    DQ = "Delta Connection"
    DR = "Ruili Airlines"
    DS = "easyJet Switzerland"
    DT = "Taag"
    DU = "Norwegian Long Haul"
    DV = "SCAT Airlines"
    DW = "Great Dane Airlines"
    DX = "Danish Air Transport"
    DY = "Norwegian Air Shuttle (NAS)"
    DZ = "Donghai Airlines"
    E2 = "Eurowings Europe"
    E3 = "New Gen Airways"
    E4 = "Enter Air"
    E5 = "Air Arabia Egypt"
    E6 = "Bringer Air Cargo"
    E7 = "Equaflight Service"
    E8 = "City Airways"
    E9 = "Evelop Airlines"
    EB = "Wamos Air"
    EC = "easyJet Europe"
    ED = "Air Explore"
    EE = "Nordica"
    EF = "Fly CamInter"
    EG = "East Air"
    EH = "ANA Wings"
    EI = "Aer Lingus"
    EJ = "New England Airlines"
    EK = "Emirates"
    EL = "Ellinair"
    EM = "Aero Benin"
    EN = "Air Dolomiti"
    EO = "Air Go Egypt"
    EP = "Iran Aseman Airlines"
    EQ = "TAME"
    ER = "SereneAir"
    ES = "DHL International Aviation ME"
    ET = "Ethiopian Airlines"
    EU = "Chengdu Airlines"
    EV = "ExpressJet Airlines"
    EW = "Eurowings"
    EX = "Avianca Express"
    EY = "Etihad Airways"
    EZ = "Sun Air of Scandinavia"
    F1 = "Farelogix"
    F2 = "Safarilink Aviation"
    F3 = "Flyadeal"
    F4 = "Air Flamenco"
    F6 = "Fly2sky"
    F7 = "Etihad Regional"
    F8 = "Flair Airlines"
    F9 = "Frontier Airlines"
    FA = "Safair"
    FB = "Bulgaria Air"
    FC = "Fly Corporate"
    FD = "Thai AirAsia"
    FE = "Far Eastern Air Transport"
    FG = "Ariana Afghan Airlines"
    FH = "Freebird Airlines"
    FI = "Icelandair"
    FJ = "Fiji Airways"
    FK = "Kelowna Flightcraft Air Charter"
    FL = "Airtran Airways"
    FM = "Shanghai Airlines"
    FN = "Royal Air Maroc Express"
    FO = "Felix Airways"
    FP = "Pelican Airlines"
    FQ = "SOL SA LINEAS AEREAS (DBA Flyest Lineas Aereas)"
    FR = "Ryanair"
    FS = "Flyr"
    FT = "FlyEgypt"
    FU = "Fuzhou Airlines"
    FV = "Rossiya"
    FW = "Ibex Airlines"
    FX = "Fedex"
    FY = "Flyfirefly"
    FZ = "flydubai"
    G0 = "Alianza Glancelot"
    G2 = "Galeyr Airline"
    G3 = "Gol Transportes Aéreos"
    G4 = "Allegiant Air"
    G5 = "China Express Airlines"
    G6 = "Denim Air"
    G7 = "GoJet Airlines"
    G8 = "Go First"
    G9 = "Air Arabia"
    GA = "Garuda Indonesia"
    GB = "ABX Air"
    GC = "Global Feeder Services"
    GD = "Aviair"
    GE = "TransAsia Airways"
    GF = "Gulf Air"
    GG = "Sky Lease Cargo"
    GH = "Globus"
    GI = "Itek Air"
    GJ = "Zhejiang Loong Airlines"
    GK = "Jetstar Japan"
    GL = "Air Greenland"
    GM = "Chair Airlines"
    GO = "Go"
    GP = "APG Airlines"
    GQ = "Sky Express"
    GR = "Aurigny Air Services"
    GS = "Tianjin Airlines"
    GT = "Air Guilin"
    GU = "Aviateca"
    GV = "Grant Aviation"
    GW = "SkyGreece Airlines"
    GX = "Guangxi Beibu Gulf Airlines"
    GY = "Colorful Guizhou Airlines"
    GZ = "Air Rarotonga"
    H1 = "Hahn Air Systems"
    H2 = "Sky Airline"
    H3 = "Harbour Air"
    H6 = "Bulgarian Air Charter"
    H7 = "Eagle Air"
    H8 = "Chilejet"
    H9 = "Himalaya Airlines"
    HA = "Hawaiian Airlines"
    HB = "Asia Atlantic Airlines"
    HC = "Air Senegal"
    HD = "Air Do"
    HE = "LGW Luftfahrtges Walter"
    HF = "Air Cote D Ivoire"
    HH = "Taban Airlines"
    HI = "Papillon Airways"
    HJ = "Hellas Jet"
    HK = "Skippers Aviation"
    HL = ""
    HM = "Air Seychelles"
    HN = "Afghan Jet International"
    HO = "Juneyao Airlines"
    HP = "Amapola Flyg"
    HQ = "Thomas Cook Airlines Belgium"
    HR = "Hahn Air"
    HS = "Heli Sécurité"
    HU = "Hainan Airlines"
    HV = "Transavia Airlines"
    HW = "North Wright Air"
    HX = "Hong Kong Airlines"
    HY = "Uzbekistan Airways"
    HZ = "Aurora Airlines"
    I1 = "CTS Viaggi"
    I2 = "Iberia Express"
    I3 = "ATA Airlines"
    I4 = "Scott Air"
    I5 = "AirAsia India"
    I6 = "Air Indus"
    I7 = "Int'Air Îles"
    I8 = "Izhavia"
    IA = "Iraqi Airways"
    IB = "Iberia"
    IC = "Nacil Indian Airline"
    ID = "Batik Air"
    IE = "Solomon Airlines"
    IF = "FlyBaghdad"
    IG = "Air Italy"
    IH = "Jsc Irtysh Air"
    II = "IBC Airways"
    IJ = "Spring Airlines Japan"
    IK = "Air Kiribati"
    IL = "Trigana Air Service"
    IM = "Mint Líneas Aéreas"
    IN = "NAM Air"
    IO = "IrAero"
    IP = "Iberworld Airlines"
    IQ = "Qazaq Air"
    IR = "Iran Air"
    IS = "AIS Airlines"
    IT = "Tigerair Taiwan"
    IU = "Hevilift"
    IV = "Air Djibouti"
    IW = "Wings Air"
    IX = "Air India Express"
    IY = "Yemen Airways"
    IZ = "Arkia"
    J0 = "Jetlink Express"
    J1 = "OntJet"
    J2 = "Azerbaijan Airlines"
    J3 = "Northwestern Air Lease"
    J4 = "Badr Airlines"
    J5 = "Alaska Seaplane Service"
    J6 = "Jet-Ops"
    J7 = "Afrijet Business Service"
    J8 = "Berjaya Air"
    J9 = "Jazeera Airways"
    JA = "Jetsmart"
    JB = "Helijet International"
    JC = "Japan Air Commuter"
    JD = "Beijing Capital Airlines"
    JE = "Mango"
    JF = "Jet Asia Airways"
    JG = "Jetgo Australia"
    JH = "Fuji Dream Airlines"
    JI = "Eastern Caribbean Airlines"
    JJ = "LATAM Brasil"
    JL = "Japan Airlines"
    JM = "Jambojet"
    JN = "Alaska Air Transit"
    JO = "Jet Time"
    JQ = "Jetstar"
    JR = "Joy Air"
    JS = "Air Koryo"
    JT = "Lion Air"
    JU = "Air Serbia"
    JV = "Bearskin Airlines"
    JW = "Vanilla Air"
    JX = "DAC East Africa"
    JY = "InterCaribbean Airways"
    K3 = "Taquan Air Services"
    K4 = "ALS"
    K5 = "SeaPort"
    K6 = "Cambodia Angkor Air"
    K7 = "Air KBZ"
    K8 = "Kan Air"
    K9 = "Kalitta Charters"
    KA = "Cathay Dragon"
    KB = "Druk Air"
    KC = "Air Astana"
    KD = "Western Global Airlines"
    KE = "Korean Air"
    KF = "Air Belgium"
    KG = "Aerogaviota"
    KH = "Aloha Air Cargo"
    KI = "KrasAvia"
    KJ = "Air Incheon"
    KK = "AtlasGlobal"
    KL = "KLM"
    KM = "Air Malta"
    KN = "China United Airlines"
    KO = "Komiaviatrans"
    KP = "ASKY Airlines"
    KQ = "Kenya Airways"
    KR = "Air Bishkek"
    KS = "Penair"
    KT = "Fly Kiss"
    KU = "Kuwait Airways"
    KV = "Sky Regional Airlines"
    KW = "Kharkiv Airlines"
    KX = "Cayman Airways"
    KY = "Kunming Airlines"
    KZ = "Nippon Cargo Airlines"
    L1 = "E Savtravel"
    L3 = "Lynx Aviation"
    L4 = "Air Service Liege (ASL)"
    L5 = "Atlantique Air Assistance"
    L6 = "Mauritanian Airlines Int"
    L7 = "Lugansk Airlines"
    L8 = "Afric Aviation"
    L9 = "Belle Air Europe"
    LA = "LATAM Chile"
    LB = "Air Costa"
    LC = "ECAir"
    LE = "Norwegian Air Sweden AB"
    LF = "Contour Airlines"
    LG = "Luxair"
    LH = "Lufthansa Cargo"
    LI = "LIAT"
    LJ = "Jin Air"
    LK = "Lao Skyway"
    LL = "Miami Air International"
    LM = "Loganair"
    LN = "Libyan Airlines"
    LO = "LOT Polish Airlines"
    LP = "LATAM Perú"
    LQ = "Lanmei Airlines"
    LR = "Avianca Costa Rica"
    LS = "Jet2.com"
    LT = "Longjiang Airlines"
    LU = "LAN Express"
    LV = "Level"
    LW = "Pacific Wings"
    LX = "Swiss International Air Lines"
    LY = "El Al"
    LZ = "Swiss Global Air Lines"
    M0 = "Aero Mongolia"
    M2 = "MHS Aviation"
    M3 = "Air Norway"
    M4 = "Mistral Air"
    M5 = "Kenmore Air"
    M6 = "Amerijet International"
    M8 = "SKYJET Airlines"
    M9 = "Motor Sich Jsc"
    MB = "Mng Airlines Cargo"
    MC = "Air Mobility Command"
    MD = "Air Madagascar"
    ME = "Middle East Airlines"
    MF = "XiamenAir"
    MG = "Miami Air Lease"
    MH = "Malaysia Airlines"
    MI = "SilkAir"
    MJ = "Mihin Lanka"
    MK = "Air Mauritius"
    ML = "Sky Mali"
    MM = "Peach Aviation"
    MN = "Comair"
    MO = "Calm Air International"
    MP = "Martinair"
    MQ = "Envoy Air"
    MR = "Hunnu Air"
    MS = "EgyptAir"
    MT = "Thomas Cook Airlines"
    MU = "China Eastern Airlines"
    MV = "Air Mediterranean"
    MW = "Mokulele Airlines"
    MX = "Breeze Airways"
    MY = "MASwings"
    MZ = "Amakusa Airlines"
    N0 = "Norse Atlantic Airways"
    N2 = "Dagestan Airlines"
    N3 = "Aerolineas Mas"
    N4 = "Nord Wind"
    N5 = "Nolinor Aviation"
    N6 = "Nomad Aviation"
    N7 = "Nordic Regional Airlines"
    N8 = "National Airlines"
    N9 = "Novair"
    NB = "Skypower Express Airways"
    NC = "Cobham Aviation Services Australia"
    ND = "FMI Air"
    NE = "Nesma Airlines"
    NF = "Air Vanuatu"
    NG = "NovAir"
    NH = "All Nippon Airways"
    NI = "Portugalia"
    NJ = "Niger Airways"
    NK = "Spirit Airlines"
    NL = "Aero4M"
    NM = "Manx"
    NN = "Vim Airlines"
    NO = "Neos"
    NP = "Nile Air"
    NQ = "Air Japan"
    NR = "Manta Air"
    NS = "Hebei Airlines"
    NT = "Binter Canarias"
    NU = "Japan Transocean Air"
    NV = "Iranian Naft Airline"
    NW = "Northwest Airlines"
    NX = "Air Macau"
    NY = "Air Iceland"
    NZ = "Air New Zealand"
    O2 = "Jet Air"
    O4 = "Antrak Air"
    O5 = "Comores Aviation International"
    O7 = "Orenburg Region Airlines"
    O9 = "Nova Airways"
    OA = "Olympic Air"
    OB = "Boliviana de Aviación (BoA)"
    OC = "Oriental Air Bridge"
    OD = "Malindo Airways"
    OE = "Lauda"
    OF = "Overland Airways"
    OG = "Air Freight NZ"
    OH = "PSA Airlines"
    OI = "Hinterland Aviation"
    OJ = "Fly Jamaica Airways"
    OK = "Czech Airlines"
    OL = "Polynesian Airlines"
    OM = "Miat Mongolian Airlines"
    ON = "Nauru Airlines"
    OO = "SkyWest Airlines"
    OP = "Air Pegasus"
    OQ = "Chongqing Airlines"
    OR = "TUI Airlines Netherlands"
    OS = "Austrian Airlines"
    OT = "Tchadia Airlines"
    OU = "Croatia Airlines"
    OV = "SalamAir"
    OW = "Skyward Express"
    OX = "Orient Thai Airlines"
    OY = "Andes Líneas Aéreas"
    OZ = "Asiana Airlines"
    P0 = "Proflight Commuter"
    P1 = "Publiccharters Com"
    P2 = "Airkenya Express"
    P3 = "CargoLogicAir"
    P4 = "Aerolineas Sosa"
    P5 = "Copa Airlines Colombia"
    P6 = "Pascan Aviation"
    P8 = "SprintAir"
    P9 = "Peruvian Airlines"
    PA = "Airblue"
    PB = "Provincial Airlines"
    PC = "Pegasus Airlines"
    PD = "Porter Airlines"
    PE = "Peoples Viennaline"
    PF = "Primera Air Scandinavia"
    PG = "Bangkok Airways"
    PH = "Transavia Denmark"
    PI = "Polar Airlines"
    PJ = "Air Saint Pierre"
    PK = "Pakistan International Airlines (PIA)"
    PL = "Southern Air Charter"
    PM = "Canaryfly"
    PN = "China West Air"
    PO = "Polar Air Cargo"
    PP = "Jet Aviation Business"
    PQ = "AirAsia Philippines"
    PR = "Philippine Airlines"
    PS = "Ukraine International Airlines"
    PT = "Piedmont Airlines"
    PU = "Plus Ultra Líneas Aéreas"
    PV = "Saint Barth Commuter"
    PW = "Precision Air"
    PX = "Air Niugini"
    PY = "Surinam Airways"
    PZ = "LATAM Paraguay"
    Q0 = "Quebecair Express"
    Q1 = "Sqiva Sistem"
    Q2 = "Maldivian"
    Q3 = "Anguilla Air Services"
    Q4 = "Aviation Starlink"
    Q5 = "Forty Mile Air"
    Q7 = "Sky Bahamas Airlines"
    Q8 = "Trans Air Congo"
    Q9 = "Airliaison"
    QA = "Cimber"
    QB = "Qeshm Air"
    QC = "Camair-Co"
    QD = "Dobrolet Airlines"
    QE = "Fars Qeshm Airlines"
    QF = "Qantas"
    QG = "Citilink Indonesia"
    QH = "Air Bamboo"
    QJ = "Latpass Airlines"
    QK = "Jazz Aviation"
    QL = "Linea Aerea De Servicio"
    QM = "Monacair"
    QN = "Skytrans Regional"
    QO = "Quantum Air"
    QP = "Air Kenya Aviation"
    QQ = "Alliance Airlines"
    QR = "Qatar Airways"
    QS = "Smartwings"
    QT = "Tampa Cargo"
    QU = "UTair Ukraine"
    QV = "Lao Airlines"
    QW = "Qingdao Airlines"
    QX = "Horizon Air"
    QY = "European Air Transport"
    QZ = "Indonesia AirAsia"
    R0 = "MS Royal Airlines"
    R2 = "Transair"
    R3 = "Yakutia Airlines"
    R4 = "Real Tonga"
    R5 = "Jordan Aviation"
    R6 = "DOT LT"
    R7 = "Aserca"
    R8 = "Kyrgyzstan Airlines"
    R9 = "TAF Linhas Aereas"
    RA = "Nepal Airlines"
    RB = "Syrian Arab Airlines"
    RC = "Atlantic Airways"
    RE = "Stobart Air"
    RF = "Aero K"
    RG = "Rotana Jet"
    RH = "Robin Hood Aviation"
    RI = "Air Costa Rica"
    RJ = "Royal Jordanian"
    RK = "Region Airline"
    RL = "Royal Flight"
    RM = "Aircompany Armenia"
    RN = "Rayani Air"
    RO = "TAROM"
    RP = "Chautauqua Airlines"
    RQ = "Kam Air"
    RR = "Royal Air Force"
    RS = "Air Seoul"
    RT = "Rainbow Airlines"
    RU = "Air Bridge Cargo"
    RV = "Air Canada Rouge"
    RW = "Royal Air Charter Service"
    RX = "Regent Airways"
    RY = "Jiangxi Air"
    RZ = "SANSA Airlines"
    S0 = "Aerolineas Sosa"
    S1 = "Lufthansa Systems"
    S2 = "Jet Lite"
    S3 = "SBA Airlines"
    S4 = "SATA International"
    S5 = "Shuttle America"
    S6 = "Sunrise Airways"
    S7 = "S7 Airlines"
    S8 = "Sounds Air"
    S9 = "Starbow"
    SA = "South African Airways"
    SB = "Aircalin"
    SC = "Shandong Airlines"
    SD = "Sudan Airways"
    SF = "Tassili Airlines"
    SG = "SpiceJet"
    SH = "Sharp Aviation"
    SI = "Blue Islands"
    SJ = "Sriwijaya Air"
    SK = "Scandinavian Airlines"
    SL = "Thai Lion Air"
    SM = "Air Cairo"
    SN = "Brussels Airlines"
    SO = "Apex Airline"
    SP = "SATA Air Açores"
    SQ = "Singapore Airlines"
    SR = "SundAir"
    SS = "Corsair"
    ST = "Germania"
    SU = "Aeroflot"
    SV = "Saudia"
    SW = "Air Namibia"
    SX = "SkyWork Airlines"
    SY = "Sun Country"
    SZ = "Somon Air"
    T0 = "Avianca Perú"
    T1 = "Tik Systems"
    T2 = "Fly Art"
    T3 = "Eastern Airways"
    T4 = "Trip"
    T5 = "Turkmenistan Airlines"
    T6 = "ITI Air"
    T7 = "Twin Jet"
    T9 = "Aviator Aviation"
    TA = "Avianca El Salvador"
    TB = "TUIfly Belgium"
    TC = "Air Tanzania"
    TD = "Atlantis European Airways"
    TE = "Sky Taxi"
    TF = "Braathens Regional Aviation"
    TG = "Thai Airways"
    TH = "Raya Airways"
    TI = "Tailwind Hava Yollari As"
    TJ = "Tradewind Aviation"
    TK = "Turkish Airlines"
    TL = "Airnorth"
    TM = "Lam Mozambique"
    TN = "Air Tahiti Nui"
    TO = "Transavia France"
    TP = "TAP Portugal"
    TQ = "Tandem Aero"
    TR = "Scoot"
    TS = "Air Transat"
    TT = "Tigerair Australia"
    TU = "Tunisair"
    TV = "Tibet Airlines"
    TW = "T'way Air"
    TX = "Air Caraibes"
    TY = "Air Caledonie"
    U1 = "Videcom International"
    U2 = "easyJet"
    U3 = "Avies"
    U4 = "Buddha Air"
    U5 = "Karinou Airlines"
    U6 = "Ural Airlines"
    U7 = "Air Uganda"
    U8 = "Tus Airways"
    U9 = "Tatarstan Air"
    UA = "United Airlines"
    UB = "Myanmar National Airlines"
    UC = "LAN Cargo"
    UD = "Hex Air"
    UE = "Nasair"
    UF = "Um Air"
    UG = "Tunisair Express"
    UH = "AtlasJet Ukraine"
    UI = "Auric Air Services"
    UJ = "AlMasria Universal Airlines"
    UK = "Vistara"
    UL = "SriLankan Airlines"
    UM = "Air Zimbabwe"
    UN = "Transaero Airlines"
    UO = "Hong Kong Express Airways"
    UP = "Bahamasair"
    UQ = "Business Aviation Centre"
    UR = "Uganda Airlines"
    US = "US Airways"
    UT = "UTair Aviation"
    UU = "Air Austral"
    UV = "Helicopteros Del Sureste"
    UX = "Air Europa"
    UY = "Sky Prime Charter"
    UZ = "Buraq Air"
    V0 = "Conviasa"
    V1 = "IBS Software Services Americas"
    V2 = "Vision Airlines"
    V3 = "Carpatair"
    V4 = "Vieques Air Link"
    V5 = "Aerovias DAP"
    V6 = "Air Link"
    V7 = "Volotea"
    V8 = "Iliamna Air"
    V9 = "Van Air Europe"
    VA = "Virgin Australia"
    VB = "Aeroenlaces Nacionales"
    VC = "ViaAir"
    VD = "Hennan Airlines"
    VE = "EasyFly"
    VF = "Fly Armenia Airways"
    VG = "VLM Airlines"
    VH = "Viva Air Colombia"
    VI = "Volga Dnepr Airline"
    VJ = "VietJet Air"
    VK = "Anisec Luftfahrt"
    VL = "Air VIA"
    VM = "Max Air"
    VN = "Vietnam Airlines"
    VO = "VLM Airlines Slovenia"
    VP = "Villa Air"
    VQ = "Novoair"
    VR = "Tacv Cabo Verde Airlines"
    VS = "Virgin Atlantic"
    VT = "Air Tahiti"
    VU = "Vuelos Economicos"
    VV = "Viva Airlines Peru"
    VW = "Aeromar"
    VX = "Virgin America"
    VY = "Vueling"
    VZ = "Thai Vietjet Air"
    W1 = "WorldTicket"
    W2 = "Flexflight"
    W3 = "Arik Air"
    W4 = "LC Péru"
    W5 = "Mahan Airlines"
    W6 = "Wizz Air"
    W7 = "Sayakhat Airlines"
    W8 = "Caribbean Winds Airlines"
    W9 = "Wizz Air"
    WA = "KLM Cityhopper"
    WB = "Rwandair"
    WC = "Islena Airlines"
    WD = "Amsterdam Airlines Bv"
    WE = "Thai Smile Airways"
    WF = "Widerøe"
    WG = "Sunwing Airlines"
    WH = "West African Airlines"
    WI = "White Airways"
    WJ = "Air Labrador"
    WK = "Edelweiss Air"
    WL = "European Coastal Airlines"
    WM = "Windward Island Airways"
    WN = "Southwest Airlines"
    WO = "World Airways"
    WP = "Island Air"
    WQ = "Romavia"
    WR = "WestJet Encore"
    WS = "WestJet"
    WT = "Swiftair"
    WU = "Tikal Jets Airlines"
    WV = "Aero VIP"
    WW = "Wow Air"
    WX = "CityJet"
    WY = "Oman Air"
    WZ = "Red Wings Airlines"
    X1 = "Hahn Air Technologies"
    X3 = "TUIfly"
    X4 = "Air Excursions"
    X6 = "Airlines Reporting Corp"
    X7 = "Challenge Aero"
    X9 = "Avion Express"
    XB = "IATA"
    XC = "Corendon Airlines"
    XD = "Scheduled Airlines Traffic Offices"
    XE = "Delux Public Charter"
    XF = "Vladivostok Air"
    XG = "Sun Express Germany"
    XH = "Non Iata Codeshare Carrier"
    XJ = "Thai AirAsia X"
    XK = "Air Corsica"
    XL = "LATAM Ecuador"
    XM = "Zimex Aviation"
    XN = "XpressAir"
    XO = "Seair"
    XP = "Xtra Airways"
    XQ = "SunExpress"
    XR = "Corendon Airlines Europe"
    XS = "SITA"
    XT = "Indonesia AirAsia X"
    XU = "African Express Airways"
    XW = "NokScoot"
    XY = "Flynas"
    XZ = "South African Express"
    Y0 = "Yellow Airtaxi"
    Y1 = "Travel Technology Interactive"
    Y2 = "Air Century, S.A."
    Y3 = "Gryphon Airlines"
    Y4 = "Volaris"
    Y5 = "Golden Myanmar Airlines"
    Y6 = "AB Aviation"
    Y7 = "NordStar"
    Y8 = "Yangtze River Express"
    Y9 = "Kish Airlines"
    YA = "Nego Airline One"
    YB = "Harbour Air Seaplanes"
    YC = "Yamal Airlines"
    YD = "Mauritania Airways"
    YE = "Yan Air"
    YG = "South Airlines"
    YH = "Yangon Airways"
    YI = "Yunnan Yingan Airline"
    YJ = "Asian Wings Airways"
    YK = "Avia Traffic Company"
    YL = "Libyan Wings"
    YM = "Montenegro Airlines"
    YN = "Air Creebec"
    YO = "Heli Air Monaco"
    YP = "Perimeter Aviation"
    YQ = "TAR Aerolíneas"
    YR = "Scenic Airlines"
    YS = "Regional"
    YT = "Yeti Airlines"
    YU = "Euroatlantic Airways"
    YV = "Mesa Airlines"
    YW = "Air Nostrum"
    YX = "Republic Airline"
    YZ = "Alas Uruguay"
    Z2 = "AirAsia Zest"
    Z3 = "PM Air"
    Z4 = "Zagrosjet"
    Z5 = "GMG Airlines"
    Z6 = "Dniproavia"
    Z7 = "Amaszonas Uruguay"
    Z8 = "Línea Aérea Amaszonas"
    Z9 = "Jsc Bek Air"
    ZA = "Sky Angkor Airlines"
    ZB = "Monarch Airlines"
    ZC = "Fly Africa Zimbabwe"
    ZD = "Ewa Air"
    ZE = "Eastar Jet"
    ZF = "Azur Air"
    ZG = "Groznyy Avia"
    ZH = "Shenzhen Airlines"
    ZI = "Aigle Azur"
    ZJ = "Zambezi Airlines"
    ZK = "Great Lakes Airlines"
    ZL = "Regional Express"
    ZM = "Pegasus Asia"
    ZN = "Naysa"
    ZP = "Paranair"
    ZQ = "Azman Air"
    ZR = "Punto Azul"
    ZS = "Kazaviaspas"
    ZT = "Titan Airways"
    ZU = "Sunair"
    ZV = "V Air"
    ZW = "Air Wisconsin"
    ZX = "Air Georgian"
    ZY = "China Air Cargo"
    ZZ = "Airline Service"
    _0B = "Blue Air"
    _0C = "Catovair"
    _0J = "Premium Jet AG"
    _0O = "STA Travel"
    _0P = "Palau Pacific Airways"
    _0V = "Vietnam Air Services Company"
    _0W = "W Caribbean Costa Rica"
    _1A = "Amadeus"
    _1B = "Abacus"
    _1C = "EDS Information Business"
    _1D = "Raddix Solutions"
    _1E = "Travelsky Technology"
    _1F = "Infini Travel Information"
    _1G = "Travelport Galileo"
    _1H = "Sirena Travel"
    _1I = "Netjets Aviation"
    _1J = "Axess International"
    _1K = "Sutra"
    _1L = "Navitaire Open Skies"
    _1M = "Sirena Jsc"
    _1N = "Navitaire New Skies"
    _1O = "Phoenix Systems Dertours"
    _1P = "Travelport Worldspan"
    _1Q = "Joint Stock Company Ital"
    _1R = "Bird Information Systems"
    _1S = "Sabre"
    _1T = "East Line"
    _1U = "ITA Software"
    _1V = "Galileo International"
    _1W = "Sabre"
    _1X = "Branson Air Express"
    _1Y = "Electronic Data Systems (EDS)"
    _1Z = "Fantasia Info Network"
    _2A = "Deutsche Bahn"
    _2B = "Albawings"
    _2C = "SNCF"
    _2D = "Eastern Airlines, LLC"
    _2E = "Smokey Bay Air"
    _2F = "Fair Aviation"
    _2G = "Angara Airlines"
    _2H = "Thalys"
    _2I = "Star Perú"
    _2J = "Air Burkina"
    _2K = "Aerolineas Galapagos"
    _2L = "Helvetic Airways"
    _2M = "Maya Island Air"
    _2N = "Nextjet"
    _2O = "Redemption"
    _2P = "PAL Express"
    _2Q = "Air Cargo Carriers"
    _2R = "VIA Rail Canada"
    _2S = "Air Carnival"
    _2T = "Timbis Air"
    _2U = "Ero Sun d'Or"
    _2V = "Amtrak"
    _2W = "World 2 Fly, S.L"
    _2Z = "Passaredo Transportes"
    _3A = "Chu Kong Passenger Transport"
    _3B = "Job Air"
    _3C = "Air Chathams"
    _3D = "Dokasch"
    _3E = "Multi Aero"
    _3F = "Pacific Airways"
    _3G = "AsiaCargo Express"
    _3H = "Air Inuit"
    _3I = "Pison Airways Ltd"
    _3J = "Jubba Airways Kenya"
    _3K = "Jetstar Asia Airways"
    _3L = "Air Arabia Abu Dhabi"
    _3M = "Silver Airways"
    _3N = "Air Urga"
    _3O = "Air Arabia Maroc"
    _3P = "World 2 Fly Portugal"
    _3Q = "Carib Aviation Limited"
    _3R = "Divi Divi Air"
    _3S = "Air Antilles Express"
    _3T = "Tarco Air"
    _3U = "Sichuan Airlines"
    _3V = "Tnt Airways"
    _3W = "Malawian Airlines"
    _3X = "Premier Trans Aire"
    _3Z = "Travel Service Polska"
    _4A = "Aero Transporte"
    _4B = "Aviastar TU"
    _4C = "LATAM Colombia"
    _4D = "Air Sinai"
    _4E = "Tanana Air Service"
    _4F = "Freedom Airline Express"
    _4G = "Gazpromavia"
    _4H = "United Airways Bangladesh"
    _4I = "Ihy Izmir Havayollari"
    _4J = "Flydamas Airlines"
    _4K = "Air Askari Aviation"
    _4L = "Palau National Airlines"
    _4M = "LATAM Argentina"
    _4N = "Air North"
    _4O = "Interjet"
    _4P = "Travel Air"
    _4Q = "Safi Airways"
    _4R = "Star East Airline"
    _4S = "Star Airways"
    _4T = "Belair Airlines"
    _4U = "Germanwings"
    _4V = "Lacbravo"
    _4W = "Warbelows Air Ventures"
    _4X = "Atlantic Express Airline"
    _4Y = "Discover Airlines"
    _4Z = "Airlink"
    _5B = "Bassaka Air"
    _5C = "Challenge Aero"
    _5D = "Aeroméxico Connect"
    _5E = "Aero"
    _5F = "Fly One"
    _5H = "Five Fourty Aviation"
    _5I = "ALSA"
    _5J = "Cebu Pacific"
    _5K = "Hi Fly"
    _5L = "Fly Salone"
    _5M = "Montserrat Airways"
    _5N = "Jsc Nordavia"
    _5O = "ASL Airlines France"
    _5P = "PAL Airlines"
    _5R = "RUTACA Airlines"
    _5S = "Servicios Aereos Profesionales"
    _5T = "Canadian North"
    _5U = "Transportes Aéreos Guatemaltecos"
    _5V = "Everts"
    _5W = "WESTBahn"
    _5X = "UPS Airlines"
    _5Y = "Atlas Air"
    _5Z = "CemAir"
    _6A = "Armenia Airways"
    _6B = "Tuifly Nordic"
    _6C = "Air Timor"
    _6D = "Travel Service Slovensko"
    _6E = "IndiGo"
    _6F = "Primera Air Nordic"
    _6G = "Executive Express Aviation"
    _6H = "Israir Airlines"
    _6I = "Air Alsie"
    _6J = "Solaseed Air"
    _6K = "Songbird Airways"
    _6L = "Aklak Air"
    _6M = "Air Minas Linhas Aereas"
    _6N = "Niger Airlines"
    _6O = "Orbest"
    _6Q = "Cham Wings Airlines"
    _6R = "ALROSA"
    _6S = "Saudi Gulf Airlines"
    _6T = "Air Mandalay"
    _6V = "Avanza"
    _6W = "Saratov Airlines"
    _6Y = "SmartLynx Airlines"
    _6Z = "Eurasia Air"
    _7A = "Express Air Cargo"
    _7B = "Fly Blue Crane"
    _7C = "Jeju Air"
    _7D = "MGC Aviation"
    _7E = "Sylt Air"
    _7F = "First Air"
    _7G = "StarFlyer"
    _7H = "Ravn Alaska"
    _7I = "Insel Air International"
    _7J = "Tajik Air"
    _7K = "Kogalymavia Airlines"
    _7L = "Aero Caribbean"
    _7M = "Mayair"
    _7N = "PAWA Dominicana"
    _7O = "Travel Service Hungary"
    _7P = "Air Panama"
    _7Q = "Elite Airways"
    _7R = "RusLine"
    _7S = "Ryan Air Services"
    _7T = "Trenitalia"
    _7U = "Alpha Air Transport"
    _7V = "Federal Airlines"
    _7W = "Wind Rose Aviation"
    _7Y = "Mann Yadanarpon Airlines"
    _7Z = "Halcyon Air Cabo Verde"
    _8A = "Panama Airways"
    _8B = "TransNusa Air Services"
    _8C = "Air Transport International"
    _8D = "FitsAir"
    _8E = "Bering Air"
    _8F = "STP Airways"
    _8G = "Mid Africa Aviation"
    _8H = "BH Air"
    _8I = "Insel Air Aruba"
    _8J = "Línea Aerea Eco Jet"
    _8L = "Lucky Air"
    _8M = "Myanmar Airways International"
    _8N = "Regional Air Services"
    _8P = "Pacific Coastal Airlines"
    _8Q = "Onur Air"
    _8R = "Sol Líneas Aéreas"
    _8S = "Shun Tak China"
    _8T = "Air Tindi"
    _8U = "Afriqiyah Airways"
    _8V = "Astral Aviation"
    _8W = "Fly All Ways Airlines"
    _8Y = "Pan Pacific Airlines"
    _8Z = "Congo Airways"
    _9A = "Aladia Airlines"
    _9B = "AccesRail"
    _9C = "Spring Airlines"
    _9D = "Genghis Khan Airlines"
    _9E = "Endeavor Air"
    _9F = "Eurostar"
    _9G = "9G Rail"
    _9H = "Chang An Airlines"
    _9I = "Air India Regional"
    _9J = "Dana Air"
    _9K = "Cape Air"
    _9L = "West Link Airways"
    _9M = "Central Mountain Air"
    _9N = "Tropic Air"
    _9P = "Air Arabia Jordan"
    _9Q = "Caicos Express Airways"
    _9R = "SATENA"
    _9S = "Southern Air"
    _9T = "MyCargo Airlines"
    _9U = "Air Moldova"
    _9V = "Avior Airlines"
    _9W = "Jet Airways"
    _9X = "Southern Airways Express"
    _9Y = "National Airways"
