# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AnalyticsInstanceVanityUrlArgs', 'AnalyticsInstanceVanityUrl']

@pulumi.input_type
class AnalyticsInstanceVanityUrlArgs:
    def __init__(__self__, *,
                 analytics_instance_id: pulumi.Input[builtins.str],
                 ca_certificate: pulumi.Input[builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 private_key: pulumi.Input[builtins.str],
                 public_certificate: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AnalyticsInstanceVanityUrl resource.
        :param pulumi.Input[builtins.str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[builtins.str] ca_certificate: (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        :param pulumi.Input[builtins.str] private_key: (Updatable) PEM Private key for HTTPS connections.
        :param pulumi.Input[builtins.str] public_certificate: (Updatable) PEM certificate for HTTPS connections. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] description: Optional description.
        :param pulumi.Input[builtins.str] passphrase: (Updatable) Passphrase for the PEM Private key (if any).
        """
        pulumi.set(__self__, "analytics_instance_id", analytics_instance_id)
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "public_certificate", public_certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @analytics_instance_id.setter
    def analytics_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "analytics_instance_id", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) PEM Private key for HTTPS connections.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) PEM certificate for HTTPS connections. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_certificate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Passphrase for the PEM Private key (if any).
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passphrase", value)


@pulumi.input_type
class _AnalyticsInstanceVanityUrlState:
    def __init__(__self__, *,
                 analytics_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsInstanceVanityUrl resources.
        :param pulumi.Input[builtins.str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[builtins.str] ca_certificate: (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        :param pulumi.Input[builtins.str] description: Optional description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        :param pulumi.Input[builtins.str] passphrase: (Updatable) Passphrase for the PEM Private key (if any).
        :param pulumi.Input[builtins.str] private_key: (Updatable) PEM Private key for HTTPS connections.
        :param pulumi.Input[builtins.str] public_certificate: (Updatable) PEM certificate for HTTPS connections. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if analytics_instance_id is not None:
            pulumi.set(__self__, "analytics_instance_id", analytics_instance_id)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @analytics_instance_id.setter
    def analytics_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "analytics_instance_id", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Passphrase for the PEM Private key (if any).
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) PEM Private key for HTTPS connections.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) PEM certificate for HTTPS connections. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_certificate", value)


@pulumi.type_token("oci:Analytics/analyticsInstanceVanityUrl:AnalyticsInstanceVanityUrl")
class AnalyticsInstanceVanityUrl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Analytics Instance Vanity Url resource in Oracle Cloud Infrastructure Analytics service.

        Allows specifying a custom host name to be used to access the analytics instance.  This requires prior setup of DNS entry and certificate
        for this host.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance_vanity_url = oci.analytics.AnalyticsInstanceVanityUrl("test_analytics_instance_vanity_url",
            analytics_instance_id=test_analytics_instance["id"],
            ca_certificate=analytics_instance_vanity_url_ca_certificate,
            hosts=analytics_instance_vanity_url_hosts,
            private_key=analytics_instance_vanity_url_private_key,
            public_certificate=analytics_instance_vanity_url_public_certificate,
            description=analytics_instance_vanity_url_description,
            passphrase=analytics_instance_vanity_url_passphrase)
        ```

        ## Import

        AnalyticsInstanceVanityUrls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Analytics/analyticsInstanceVanityUrl:AnalyticsInstanceVanityUrl test_analytics_instance_vanity_url "analyticsInstances/{analyticsInstanceId}/vanityUrls/{vanityUrlKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[builtins.str] ca_certificate: (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        :param pulumi.Input[builtins.str] description: Optional description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        :param pulumi.Input[builtins.str] passphrase: (Updatable) Passphrase for the PEM Private key (if any).
        :param pulumi.Input[builtins.str] private_key: (Updatable) PEM Private key for HTTPS connections.
        :param pulumi.Input[builtins.str] public_certificate: (Updatable) PEM certificate for HTTPS connections. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsInstanceVanityUrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Analytics Instance Vanity Url resource in Oracle Cloud Infrastructure Analytics service.

        Allows specifying a custom host name to be used to access the analytics instance.  This requires prior setup of DNS entry and certificate
        for this host.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance_vanity_url = oci.analytics.AnalyticsInstanceVanityUrl("test_analytics_instance_vanity_url",
            analytics_instance_id=test_analytics_instance["id"],
            ca_certificate=analytics_instance_vanity_url_ca_certificate,
            hosts=analytics_instance_vanity_url_hosts,
            private_key=analytics_instance_vanity_url_private_key,
            public_certificate=analytics_instance_vanity_url_public_certificate,
            description=analytics_instance_vanity_url_description,
            passphrase=analytics_instance_vanity_url_passphrase)
        ```

        ## Import

        AnalyticsInstanceVanityUrls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Analytics/analyticsInstanceVanityUrl:AnalyticsInstanceVanityUrl test_analytics_instance_vanity_url "analyticsInstances/{analyticsInstanceId}/vanityUrls/{vanityUrlKey}"
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsInstanceVanityUrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsInstanceVanityUrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsInstanceVanityUrlArgs.__new__(AnalyticsInstanceVanityUrlArgs)

            if analytics_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'analytics_instance_id'")
            __props__.__dict__["analytics_instance_id"] = analytics_instance_id
            if ca_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'ca_certificate'")
            __props__.__dict__["ca_certificate"] = ca_certificate
            __props__.__dict__["description"] = description
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["passphrase"] = None if passphrase is None else pulumi.Output.secret(passphrase)
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if public_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'public_certificate'")
            __props__.__dict__["public_certificate"] = public_certificate
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passphrase", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AnalyticsInstanceVanityUrl, __self__).__init__(
            'oci:Analytics/analyticsInstanceVanityUrl:AnalyticsInstanceVanityUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            passphrase: Optional[pulumi.Input[builtins.str]] = None,
            private_key: Optional[pulumi.Input[builtins.str]] = None,
            public_certificate: Optional[pulumi.Input[builtins.str]] = None) -> 'AnalyticsInstanceVanityUrl':
        """
        Get an existing AnalyticsInstanceVanityUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[builtins.str] ca_certificate: (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        :param pulumi.Input[builtins.str] description: Optional description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        :param pulumi.Input[builtins.str] passphrase: (Updatable) Passphrase for the PEM Private key (if any).
        :param pulumi.Input[builtins.str] private_key: (Updatable) PEM Private key for HTTPS connections.
        :param pulumi.Input[builtins.str] public_certificate: (Updatable) PEM certificate for HTTPS connections. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsInstanceVanityUrlState.__new__(_AnalyticsInstanceVanityUrlState)

        __props__.__dict__["analytics_instance_id"] = analytics_instance_id
        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["description"] = description
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["passphrase"] = passphrase
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_certificate"] = public_certificate
        return AnalyticsInstanceVanityUrl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) PEM CA certificate(s) for HTTPS connections. This may include multiple PEM certificates.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of fully qualified hostnames supported by this vanity URL definition (max of 3).
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Passphrase for the PEM Private key (if any).
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) PEM Private key for HTTPS connections.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) PEM certificate for HTTPS connections. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "public_certificate")

