# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AutoScalingConfigurationAutoScalingResources',
    'AutoScalingConfigurationPolicy',
    'AutoScalingConfigurationPolicyCapacity',
    'AutoScalingConfigurationPolicyExecutionSchedule',
    'AutoScalingConfigurationPolicyResourceAction',
    'AutoScalingConfigurationPolicyRule',
    'AutoScalingConfigurationPolicyRuleAction',
    'AutoScalingConfigurationPolicyRuleMetric',
    'AutoScalingConfigurationPolicyRuleMetricThreshold',
    'GetAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsFilterResult',
]

@pulumi.output_type
class AutoScalingConfigurationAutoScalingResources(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param builtins.str type: The type of resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "executionSchedule":
            suggest = "execution_schedule"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resourceAction":
            suggest = "resource_action"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: builtins.str,
                 capacity: Optional['outputs.AutoScalingConfigurationPolicyCapacity'] = None,
                 display_name: Optional[builtins.str] = None,
                 execution_schedule: Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule'] = None,
                 id: Optional[builtins.str] = None,
                 is_enabled: Optional[builtins.bool] = None,
                 resource_action: Optional['outputs.AutoScalingConfigurationPolicyResourceAction'] = None,
                 rules: Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str policy_type: The type of autoscaling policy.
        :param 'AutoScalingConfigurationPolicyCapacityArgs' capacity: The capacity requirements of the autoscaling policy.
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param 'AutoScalingConfigurationPolicyExecutionScheduleArgs' execution_schedule: An execution schedule for an autoscaling policy.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param 'AutoScalingConfigurationPolicyResourceActionArgs' resource_action: An action that can be executed against a resource.
        :param builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "policy_type", policy_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_schedule is not None:
            pulumi.set(__self__, "execution_schedule", execution_schedule)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if resource_action is not None:
            pulumi.set(__self__, "resource_action", resource_action)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.AutoScalingConfigurationPolicyCapacity']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule']:
        """
        An execution schedule for an autoscaling policy.
        """
        return pulumi.get(self, "execution_schedule")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> Optional['outputs.AutoScalingConfigurationPolicyResourceAction']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_action")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']]:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class AutoScalingConfigurationPolicyCapacity(dict):
    def __init__(__self__, *,
                 initial: Optional[builtins.int] = None,
                 max: Optional[builtins.int] = None,
                 min: Optional[builtins.int] = None):
        """
        :param builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
               
               For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        :param builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
               
               For a schedule-based autoscaling policy, this value is not used.
        :param builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
               
               For a schedule-based autoscaling policy, this value is not used.
        """
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def initial(self) -> Optional[builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.

        For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> Optional[builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingConfigurationPolicyExecutionSchedule(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 timezone: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
               
               Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`
               
               You can use special characters that are supported with the Quartz cron implementation.
               
               You must specify `0` as the value for seconds.
               
               Example: `0 15 10 ? * *`
        :param builtins.str timezone: The time zone for the execution schedule.
        :param builtins.str type: The type of execution schedule.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.

        Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`

        You can use special characters that are supported with the Quartz cron implementation.

        You must specify `0` as the value for seconds.

        Example: `0 15 10 ? * *`
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of execution schedule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicyResourceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyResourceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 action_type: builtins.str):
        """
        :param builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class AutoScalingConfigurationPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: builtins.str,
                 action: Optional['outputs.AutoScalingConfigurationPolicyRuleAction'] = None,
                 id: Optional[builtins.str] = None,
                 metric: Optional['outputs.AutoScalingConfigurationPolicyRuleMetric'] = None):
        """
        :param 'AutoScalingConfigurationPolicyRuleActionArgs' action: The action to take when autoscaling is triggered.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param 'AutoScalingConfigurationPolicyRuleMetricArgs' metric: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "display_name", display_name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleAction']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metric(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetric']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleAction(dict):
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.int] = None):
        """
        :param builtins.str type: The type of action to take.
        :param builtins.int value: To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.int]:
        """
        To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricType":
            suggest = "metric_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRuleMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_type: Optional[builtins.str] = None,
                 threshold: Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold'] = None):
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold']:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetricThreshold(dict):
    def __init__(__self__, *,
                 operator: Optional[builtins.str] = None,
                 value: Optional[builtins.int] = None):
        """
        :param builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        :param builtins.int value: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.int]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: builtins.str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: builtins.str,
                 is_enabled: builtins.bool,
                 policy_type: builtins.str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult'],
                 time_created: builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param Sequence['GetAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param builtins.str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_schedules", execution_schedules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_actions", resource_actions)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: builtins.int,
                 max: builtins.int,
                 min: builtins.int):
        """
        :param builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        pulumi.set(__self__, "initial", initial)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def initial(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 timezone: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param builtins.str timezone: The time zone for the execution schedule.
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 action_type: builtins.str):
        """
        :param builtins.str action: The action to take when autoscaling is triggered.
        :param builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: builtins.str,
                 id: builtins.str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: builtins.str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "thresholds", thresholds)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> builtins.str:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationResult(dict):
    def __init__(__self__, *,
                 auto_scaling_resources: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult'],
                 compartment_id: builtins.str,
                 cool_down_in_seconds: builtins.int,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_enabled: builtins.bool,
                 max_resource_count: builtins.int,
                 min_resource_count: builtins.int,
                 policies: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult'],
                 time_created: builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceArgs'] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        :param builtins.int cool_down_in_seconds: For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param builtins.int max_resource_count: The maximum number of resources to scale out to.
        :param builtins.int min_resource_count: The minimum number of resources to scale in to.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyArgs'] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "auto_scaling_resources", auto_scaling_resources)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cool_down_in_seconds", cool_down_in_seconds)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_resource_count", max_resource_count)
        pulumi.set(__self__, "min_resource_count", min_resource_count)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        """
        return pulumi.get(self, "auto_scaling_resources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> builtins.int:
        """
        For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> builtins.int:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> builtins.int:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult']:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: builtins.str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: builtins.str,
                 is_enabled: builtins.bool,
                 policy_type: builtins.str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult'],
                 time_created: builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param builtins.str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_schedules", execution_schedules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_actions", resource_actions)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: builtins.int,
                 max: builtins.int,
                 min: builtins.int):
        """
        :param builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        pulumi.set(__self__, "initial", initial)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def initial(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 timezone: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param builtins.str timezone: The time zone for the execution schedule.
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 action_type: builtins.str):
        """
        :param builtins.str action: The action to take when autoscaling is triggered.
        :param builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: builtins.str,
                 id: builtins.str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: builtins.str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "thresholds", thresholds)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> builtins.str:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


