# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SessionKeyDetailsArgs',
    'SessionKeyDetailsArgsDict',
    'SessionTargetResourceDetailsArgs',
    'SessionTargetResourceDetailsArgsDict',
    'GetBastionsFilterArgs',
    'GetBastionsFilterArgsDict',
    'GetSessionsFilterArgs',
    'GetSessionsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class SessionKeyDetailsArgsDict(TypedDict):
        public_key_content: pulumi.Input[builtins.str]
        """
        The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
elif False:
    SessionKeyDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SessionKeyDetailsArgs:
    def __init__(__self__, *,
                 public_key_content: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] public_key_content: The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        pulumi.set(__self__, "public_key_content", public_key_content)

    @property
    @pulumi.getter(name="publicKeyContent")
    def public_key_content(self) -> pulumi.Input[builtins.str]:
        """
        The public key in OpenSSH format of the SSH key pair for the session. When you connect to the session, you must provide the private key of the same SSH key pair.
        """
        return pulumi.get(self, "public_key_content")

    @public_key_content.setter
    def public_key_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_key_content", value)


if not MYPY:
    class SessionTargetResourceDetailsArgsDict(TypedDict):
        session_type: pulumi.Input[builtins.str]
        """
        The session type.
        """
        target_resource_display_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The display name of the target Compute instance that the session connects to.
        """
        target_resource_fqdn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Fully Qualified Domain Name of the target resource that the session connects to.
        """
        target_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        """
        target_resource_operating_system_user_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the user on the target resource operating system that the session uses for the connection.
        """
        target_resource_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port number to connect to on the target resource.
        """
        target_resource_private_ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The private IP address of the target resource that the session connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    SessionTargetResourceDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SessionTargetResourceDetailsArgs:
    def __init__(__self__, *,
                 session_type: pulumi.Input[builtins.str],
                 target_resource_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_operating_system_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_port: Optional[pulumi.Input[builtins.int]] = None,
                 target_resource_private_ip_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] session_type: The session type.
        :param pulumi.Input[builtins.str] target_resource_display_name: The display name of the target Compute instance that the session connects to.
        :param pulumi.Input[builtins.str] target_resource_fqdn: The Fully Qualified Domain Name of the target resource that the session connects to.
        :param pulumi.Input[builtins.str] target_resource_id: The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        :param pulumi.Input[builtins.str] target_resource_operating_system_user_name: The name of the user on the target resource operating system that the session uses for the connection.
        :param pulumi.Input[builtins.int] target_resource_port: The port number to connect to on the target resource.
        :param pulumi.Input[builtins.str] target_resource_private_ip_address: The private IP address of the target resource that the session connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "session_type", session_type)
        if target_resource_display_name is not None:
            pulumi.set(__self__, "target_resource_display_name", target_resource_display_name)
        if target_resource_fqdn is not None:
            pulumi.set(__self__, "target_resource_fqdn", target_resource_fqdn)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_operating_system_user_name is not None:
            pulumi.set(__self__, "target_resource_operating_system_user_name", target_resource_operating_system_user_name)
        if target_resource_port is not None:
            pulumi.set(__self__, "target_resource_port", target_resource_port)
        if target_resource_private_ip_address is not None:
            pulumi.set(__self__, "target_resource_private_ip_address", target_resource_private_ip_address)

    @property
    @pulumi.getter(name="sessionType")
    def session_type(self) -> pulumi.Input[builtins.str]:
        """
        The session type.
        """
        return pulumi.get(self, "session_type")

    @session_type.setter
    def session_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "session_type", value)

    @property
    @pulumi.getter(name="targetResourceDisplayName")
    def target_resource_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the target Compute instance that the session connects to.
        """
        return pulumi.get(self, "target_resource_display_name")

    @target_resource_display_name.setter
    def target_resource_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_display_name", value)

    @property
    @pulumi.getter(name="targetResourceFqdn")
    def target_resource_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Fully Qualified Domain Name of the target resource that the session connects to.
        """
        return pulumi.get(self, "target_resource_fqdn")

    @target_resource_fqdn.setter
    def target_resource_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_fqdn", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="targetResourceOperatingSystemUserName")
    def target_resource_operating_system_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user on the target resource operating system that the session uses for the connection.
        """
        return pulumi.get(self, "target_resource_operating_system_user_name")

    @target_resource_operating_system_user_name.setter
    def target_resource_operating_system_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_operating_system_user_name", value)

    @property
    @pulumi.getter(name="targetResourcePort")
    def target_resource_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number to connect to on the target resource.
        """
        return pulumi.get(self, "target_resource_port")

    @target_resource_port.setter
    def target_resource_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "target_resource_port", value)

    @property
    @pulumi.getter(name="targetResourcePrivateIpAddress")
    def target_resource_private_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address of the target resource that the session connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_resource_private_ip_address")

    @target_resource_private_ip_address.setter
    def target_resource_private_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_private_ip_address", value)


if not MYPY:
    class GetBastionsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetBastionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBastionsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetSessionsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetSessionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSessionsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


