# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBdsInstanceResourcePrincipalConfigurationResult',
    'AwaitableGetBdsInstanceResourcePrincipalConfigurationResult',
    'get_bds_instance_resource_principal_configuration',
    'get_bds_instance_resource_principal_configuration_output',
]

@pulumi.output_type
class GetBdsInstanceResourcePrincipalConfigurationResult:
    """
    A collection of values returned by getBdsInstanceResourcePrincipalConfiguration.
    """
    def __init__(__self__, bds_instance_id=None, cluster_admin_password=None, display_name=None, force_refresh_resource_principal_trigger=None, id=None, resource_principal_configuration_id=None, session_token_life_span_duration_in_hours=None, state=None, time_created=None, time_token_expiry=None, time_token_refreshed=None, time_updated=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password and not isinstance(cluster_admin_password, str):
            raise TypeError("Expected argument 'cluster_admin_password' to be a str")
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if force_refresh_resource_principal_trigger and not isinstance(force_refresh_resource_principal_trigger, int):
            raise TypeError("Expected argument 'force_refresh_resource_principal_trigger' to be a int")
        pulumi.set(__self__, "force_refresh_resource_principal_trigger", force_refresh_resource_principal_trigger)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_principal_configuration_id and not isinstance(resource_principal_configuration_id, str):
            raise TypeError("Expected argument 'resource_principal_configuration_id' to be a str")
        pulumi.set(__self__, "resource_principal_configuration_id", resource_principal_configuration_id)
        if session_token_life_span_duration_in_hours and not isinstance(session_token_life_span_duration_in_hours, int):
            raise TypeError("Expected argument 'session_token_life_span_duration_in_hours' to be a int")
        pulumi.set(__self__, "session_token_life_span_duration_in_hours", session_token_life_span_duration_in_hours)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_token_expiry and not isinstance(time_token_expiry, str):
            raise TypeError("Expected argument 'time_token_expiry' to be a str")
        pulumi.set(__self__, "time_token_expiry", time_token_expiry)
        if time_token_refreshed and not isinstance(time_token_refreshed, str):
            raise TypeError("Expected argument 'time_token_refreshed' to be a str")
        pulumi.set(__self__, "time_token_refreshed", time_token_refreshed)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> builtins.str:
        """
        The OCID of the bdsInstance which is the parent resource id.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> builtins.str:
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="forceRefreshResourcePrincipalTrigger")
    def force_refresh_resource_principal_trigger(self) -> builtins.int:
        return pulumi.get(self, "force_refresh_resource_principal_trigger")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the ResourcePrincipalConfiguration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourcePrincipalConfigurationId")
    def resource_principal_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "resource_principal_configuration_id")

    @property
    @pulumi.getter(name="sessionTokenLifeSpanDurationInHours")
    def session_token_life_span_duration_in_hours(self) -> builtins.int:
        """
        Life span in hours of each resource principal session token.
        """
        return pulumi.get(self, "session_token_life_span_duration_in_hours")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the ResourcePrincipalConfiguration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the ResourcePrincipalConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTokenExpiry")
    def time_token_expiry(self) -> builtins.str:
        """
        the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_expiry")

    @property
    @pulumi.getter(name="timeTokenRefreshed")
    def time_token_refreshed(self) -> builtins.str:
        """
        the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_refreshed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the ResourcePrincipalConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetBdsInstanceResourcePrincipalConfigurationResult(GetBdsInstanceResourcePrincipalConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceResourcePrincipalConfigurationResult(
            bds_instance_id=self.bds_instance_id,
            cluster_admin_password=self.cluster_admin_password,
            display_name=self.display_name,
            force_refresh_resource_principal_trigger=self.force_refresh_resource_principal_trigger,
            id=self.id,
            resource_principal_configuration_id=self.resource_principal_configuration_id,
            session_token_life_span_duration_in_hours=self.session_token_life_span_duration_in_hours,
            state=self.state,
            time_created=self.time_created,
            time_token_expiry=self.time_token_expiry,
            time_token_refreshed=self.time_token_refreshed,
            time_updated=self.time_updated)


def get_bds_instance_resource_principal_configuration(bds_instance_id: Optional[builtins.str] = None,
                                                      resource_principal_configuration_id: Optional[builtins.str] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceResourcePrincipalConfigurationResult:
    """
    This data source provides details about a specific Bds Instance Resource Principal Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the resourcePrincipalConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_resource_principal_configuration = oci.BigDataService.get_bds_instance_resource_principal_configuration(bds_instance_id=test_bds_instance["id"],
        resource_principal_configuration_id=test_configuration["id"])
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str resource_principal_configuration_id: Unique Oracle-assigned identifier of the ResourcePrincipalConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['resourcePrincipalConfigurationId'] = resource_principal_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceResourcePrincipalConfiguration:getBdsInstanceResourcePrincipalConfiguration', __args__, opts=opts, typ=GetBdsInstanceResourcePrincipalConfigurationResult).value

    return AwaitableGetBdsInstanceResourcePrincipalConfigurationResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__ret__, 'cluster_admin_password'),
        display_name=pulumi.get(__ret__, 'display_name'),
        force_refresh_resource_principal_trigger=pulumi.get(__ret__, 'force_refresh_resource_principal_trigger'),
        id=pulumi.get(__ret__, 'id'),
        resource_principal_configuration_id=pulumi.get(__ret__, 'resource_principal_configuration_id'),
        session_token_life_span_duration_in_hours=pulumi.get(__ret__, 'session_token_life_span_duration_in_hours'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_token_expiry=pulumi.get(__ret__, 'time_token_expiry'),
        time_token_refreshed=pulumi.get(__ret__, 'time_token_refreshed'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_bds_instance_resource_principal_configuration_output(bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                                             resource_principal_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceResourcePrincipalConfigurationResult]:
    """
    This data source provides details about a specific Bds Instance Resource Principal Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of the resourcePrincipalConfiguration identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_resource_principal_configuration = oci.BigDataService.get_bds_instance_resource_principal_configuration(bds_instance_id=test_bds_instance["id"],
        resource_principal_configuration_id=test_configuration["id"])
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str resource_principal_configuration_id: Unique Oracle-assigned identifier of the ResourcePrincipalConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['resourcePrincipalConfigurationId'] = resource_principal_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceResourcePrincipalConfiguration:getBdsInstanceResourcePrincipalConfiguration', __args__, opts=opts, typ=GetBdsInstanceResourcePrincipalConfigurationResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceResourcePrincipalConfigurationResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__response__, 'cluster_admin_password'),
        display_name=pulumi.get(__response__, 'display_name'),
        force_refresh_resource_principal_trigger=pulumi.get(__response__, 'force_refresh_resource_principal_trigger'),
        id=pulumi.get(__response__, 'id'),
        resource_principal_configuration_id=pulumi.get(__response__, 'resource_principal_configuration_id'),
        session_token_life_span_duration_in_hours=pulumi.get(__response__, 'session_token_life_span_duration_in_hours'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_token_expiry=pulumi.get(__response__, 'time_token_expiry'),
        time_token_refreshed=pulumi.get(__response__, 'time_token_refreshed'),
        time_updated=pulumi.get(__response__, 'time_updated')))
