# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAtCustomerCccInfrastructuresResult',
    'AwaitableGetAtCustomerCccInfrastructuresResult',
    'get_at_customer_ccc_infrastructures',
    'get_at_customer_ccc_infrastructures_output',
]

@pulumi.output_type
class GetAtCustomerCccInfrastructuresResult:
    """
    A collection of values returned by getAtCustomerCccInfrastructures.
    """
    def __init__(__self__, access_level=None, ccc_infrastructure_collections=None, ccc_infrastructure_id=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, display_name_contains=None, filters=None, id=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if ccc_infrastructure_collections and not isinstance(ccc_infrastructure_collections, list):
            raise TypeError("Expected argument 'ccc_infrastructure_collections' to be a list")
        pulumi.set(__self__, "ccc_infrastructure_collections", ccc_infrastructure_collections)
        if ccc_infrastructure_id and not isinstance(ccc_infrastructure_id, str):
            raise TypeError("Expected argument 'ccc_infrastructure_id' to be a str")
        pulumi.set(__self__, "ccc_infrastructure_id", ccc_infrastructure_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="cccInfrastructureCollections")
    def ccc_infrastructure_collections(self) -> Sequence['outputs.GetAtCustomerCccInfrastructuresCccInfrastructureCollectionResult']:
        """
        The list of ccc_infrastructure_collection.
        """
        return pulumi.get(self, "ccc_infrastructure_collections")

    @property
    @pulumi.getter(name="cccInfrastructureId")
    def ccc_infrastructure_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ccc_infrastructure_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The infrastructure compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAtCustomerCccInfrastructuresFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "state")


class AwaitableGetAtCustomerCccInfrastructuresResult(GetAtCustomerCccInfrastructuresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAtCustomerCccInfrastructuresResult(
            access_level=self.access_level,
            ccc_infrastructure_collections=self.ccc_infrastructure_collections,
            ccc_infrastructure_id=self.ccc_infrastructure_id,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_at_customer_ccc_infrastructures(access_level: Optional[builtins.str] = None,
                                        ccc_infrastructure_id: Optional[builtins.str] = None,
                                        compartment_id: Optional[builtins.str] = None,
                                        compartment_id_in_subtree: Optional[builtins.bool] = None,
                                        display_name: Optional[builtins.str] = None,
                                        display_name_contains: Optional[builtins.str] = None,
                                        filters: Optional[Sequence[Union['GetAtCustomerCccInfrastructuresFilterArgs', 'GetAtCustomerCccInfrastructuresFilterArgsDict']]] = None,
                                        state: Optional[builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAtCustomerCccInfrastructuresResult:
    """
    This data source provides the list of Ccc Infrastructures in Oracle Cloud Infrastructure Compute Cloud At Customer service.

    Returns a list of Compute Cloud@Customer infrastructures.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ccc_infrastructures = oci.ComputeCloud.get_at_customer_ccc_infrastructures(access_level=ccc_infrastructure_access_level,
        ccc_infrastructure_id=test_ccc_infrastructure["id"],
        compartment_id=compartment_id,
        compartment_id_in_subtree=ccc_infrastructure_compartment_id_in_subtree,
        display_name=ccc_infrastructure_display_name,
        display_name_contains=ccc_infrastructure_display_name_contains,
        state=ccc_infrastructure_state)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str ccc_infrastructure_id: An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for a  Compute Cloud@Customer Infrastructure.
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and sub-compartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str display_name_contains: A filter to return only resources whose display name contains the substring.
    :param builtins.str state: A filter used to return only resources that match the given lifecycleState.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['cccInfrastructureId'] = ccc_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ComputeCloud/getAtCustomerCccInfrastructures:getAtCustomerCccInfrastructures', __args__, opts=opts, typ=GetAtCustomerCccInfrastructuresResult).value

    return AwaitableGetAtCustomerCccInfrastructuresResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        ccc_infrastructure_collections=pulumi.get(__ret__, 'ccc_infrastructure_collections'),
        ccc_infrastructure_id=pulumi.get(__ret__, 'ccc_infrastructure_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_at_customer_ccc_infrastructures_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               ccc_infrastructure_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                               display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               display_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAtCustomerCccInfrastructuresFilterArgs', 'GetAtCustomerCccInfrastructuresFilterArgsDict']]]]] = None,
                                               state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAtCustomerCccInfrastructuresResult]:
    """
    This data source provides the list of Ccc Infrastructures in Oracle Cloud Infrastructure Compute Cloud At Customer service.

    Returns a list of Compute Cloud@Customer infrastructures.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ccc_infrastructures = oci.ComputeCloud.get_at_customer_ccc_infrastructures(access_level=ccc_infrastructure_access_level,
        ccc_infrastructure_id=test_ccc_infrastructure["id"],
        compartment_id=compartment_id,
        compartment_id_in_subtree=ccc_infrastructure_compartment_id_in_subtree,
        display_name=ccc_infrastructure_display_name,
        display_name_contains=ccc_infrastructure_display_name_contains,
        state=ccc_infrastructure_state)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str ccc_infrastructure_id: An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for a  Compute Cloud@Customer Infrastructure.
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and sub-compartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str display_name_contains: A filter to return only resources whose display name contains the substring.
    :param builtins.str state: A filter used to return only resources that match the given lifecycleState.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['cccInfrastructureId'] = ccc_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ComputeCloud/getAtCustomerCccInfrastructures:getAtCustomerCccInfrastructures', __args__, opts=opts, typ=GetAtCustomerCccInfrastructuresResult)
    return __ret__.apply(lambda __response__: GetAtCustomerCccInfrastructuresResult(
        access_level=pulumi.get(__response__, 'access_level'),
        ccc_infrastructure_collections=pulumi.get(__response__, 'ccc_infrastructure_collections'),
        ccc_infrastructure_id=pulumi.get(__response__, 'ccc_infrastructure_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
