# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CrossConnectGroupArgs', 'CrossConnectGroup']

@pulumi.input_type
class CrossConnectGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 macsec_properties: Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']] = None):
        """
        The set of arguments for constructing a CrossConnectGroup resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['CrossConnectGroupMacsecPropertiesArgs'] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if customer_reference_name is not None:
            pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if macsec_properties is not None:
            pulumi.set(__self__, "macsec_properties", macsec_properties)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @customer_reference_name.setter
    def customer_reference_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_reference_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']]:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @macsec_properties.setter
    def macsec_properties(self, value: Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']]):
        pulumi.set(self, "macsec_properties", value)


@pulumi.input_type
class _CrossConnectGroupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 macsec_properties: Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']] = None,
                 oci_logical_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 oci_physical_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CrossConnectGroup resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['CrossConnectGroupMacsecPropertiesArgs'] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] oci_logical_device_name: The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        :param pulumi.Input[builtins.str] oci_physical_device_name: The FastConnect device that terminates the physical connection.
        :param pulumi.Input[builtins.str] state: The cross-connect group's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the cross-connect group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if customer_reference_name is not None:
            pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if macsec_properties is not None:
            pulumi.set(__self__, "macsec_properties", macsec_properties)
        if oci_logical_device_name is not None:
            pulumi.set(__self__, "oci_logical_device_name", oci_logical_device_name)
        if oci_physical_device_name is not None:
            pulumi.set(__self__, "oci_physical_device_name", oci_physical_device_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @customer_reference_name.setter
    def customer_reference_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_reference_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']]:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @macsec_properties.setter
    def macsec_properties(self, value: Optional[pulumi.Input['CrossConnectGroupMacsecPropertiesArgs']]):
        pulumi.set(self, "macsec_properties", value)

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @oci_logical_device_name.setter
    def oci_logical_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oci_logical_device_name", value)

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @oci_physical_device_name.setter
    def oci_physical_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oci_physical_device_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cross-connect group's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the cross-connect group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Core/crossConnectGroup:CrossConnectGroup")
class CrossConnectGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 macsec_properties: Optional[pulumi.Input[Union['CrossConnectGroupMacsecPropertiesArgs', 'CrossConnectGroupMacsecPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Cross Connect Group resource in Oracle Cloud Infrastructure Core service.

        Creates a new cross-connect group to use with Oracle Cloud Infrastructure
        FastConnect. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
        compartment where you want the cross-connect group to reside. If you're
        not sure which compartment to use, put the cross-connect group in the
        same compartment with your VCN. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the cross-connect group.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cross_connect_group = oci.core.CrossConnectGroup("test_cross_connect_group",
            compartment_id=compartment_id,
            customer_reference_name=cross_connect_group_customer_reference_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cross_connect_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            macsec_properties={
                "state": cross_connect_group_macsec_properties_state,
                "encryption_cipher": cross_connect_group_macsec_properties_encryption_cipher,
                "is_unprotected_traffic_allowed": cross_connect_group_macsec_properties_is_unprotected_traffic_allowed,
                "primary_key": {
                    "connectivity_association_key_secret_id": test_secret["id"],
                    "connectivity_association_name_secret_id": test_secret["id"],
                },
            })
        ```

        ## Import

        CrossConnectGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/crossConnectGroup:CrossConnectGroup test_cross_connect_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['CrossConnectGroupMacsecPropertiesArgs', 'CrossConnectGroupMacsecPropertiesArgsDict']] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CrossConnectGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cross Connect Group resource in Oracle Cloud Infrastructure Core service.

        Creates a new cross-connect group to use with Oracle Cloud Infrastructure
        FastConnect. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
        compartment where you want the cross-connect group to reside. If you're
        not sure which compartment to use, put the cross-connect group in the
        same compartment with your VCN. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the cross-connect group.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cross_connect_group = oci.core.CrossConnectGroup("test_cross_connect_group",
            compartment_id=compartment_id,
            customer_reference_name=cross_connect_group_customer_reference_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cross_connect_group_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            macsec_properties={
                "state": cross_connect_group_macsec_properties_state,
                "encryption_cipher": cross_connect_group_macsec_properties_encryption_cipher,
                "is_unprotected_traffic_allowed": cross_connect_group_macsec_properties_is_unprotected_traffic_allowed,
                "primary_key": {
                    "connectivity_association_key_secret_id": test_secret["id"],
                    "connectivity_association_name_secret_id": test_secret["id"],
                },
            })
        ```

        ## Import

        CrossConnectGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/crossConnectGroup:CrossConnectGroup test_cross_connect_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param CrossConnectGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrossConnectGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 macsec_properties: Optional[pulumi.Input[Union['CrossConnectGroupMacsecPropertiesArgs', 'CrossConnectGroupMacsecPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrossConnectGroupArgs.__new__(CrossConnectGroupArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["customer_reference_name"] = customer_reference_name
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["macsec_properties"] = macsec_properties
            __props__.__dict__["oci_logical_device_name"] = None
            __props__.__dict__["oci_physical_device_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(CrossConnectGroup, __self__).__init__(
            'oci:Core/crossConnectGroup:CrossConnectGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            macsec_properties: Optional[pulumi.Input[Union['CrossConnectGroupMacsecPropertiesArgs', 'CrossConnectGroupMacsecPropertiesArgsDict']]] = None,
            oci_logical_device_name: Optional[pulumi.Input[builtins.str]] = None,
            oci_physical_device_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'CrossConnectGroup':
        """
        Get an existing CrossConnectGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['CrossConnectGroupMacsecPropertiesArgs', 'CrossConnectGroupMacsecPropertiesArgsDict']] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] oci_logical_device_name: The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        :param pulumi.Input[builtins.str] oci_physical_device_name: The FastConnect device that terminates the physical connection.
        :param pulumi.Input[builtins.str] state: The cross-connect group's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the cross-connect group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CrossConnectGroupState.__new__(_CrossConnectGroupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["customer_reference_name"] = customer_reference_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["macsec_properties"] = macsec_properties
        __props__.__dict__["oci_logical_device_name"] = oci_logical_device_name
        __props__.__dict__["oci_physical_device_name"] = oci_physical_device_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return CrossConnectGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> pulumi.Output['outputs.CrossConnectGroupMacsecProperties']:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> pulumi.Output[builtins.str]:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> pulumi.Output[builtins.str]:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The cross-connect group's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the cross-connect group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

