# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceMaintenanceEventArgs', 'InstanceMaintenanceEvent']

@pulumi.input_type
class InstanceMaintenanceEventArgs:
    def __init__(__self__, *,
                 instance_maintenance_event_id: pulumi.Input[builtins.str],
                 alternative_resolution_action: Optional[pulumi.Input[builtins.str]] = None,
                 can_delete_local_storage: Optional[pulumi.Input[builtins.bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_window_start: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceMaintenanceEvent resource.
        :param pulumi.Input[builtins.str] instance_maintenance_event_id: The OCID of the instance maintenance event.
        :param pulumi.Input[builtins.str] alternative_resolution_action: (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        :param pulumi.Input[builtins.bool] can_delete_local_storage: (Updatable) This field is only applicable when setting the alternativeResolutionAction.
               
               For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.
               
               In cases where the local storage will be lost, this parameter must be set or the request will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] time_window_start: (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.
               
               The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "instance_maintenance_event_id", instance_maintenance_event_id)
        if alternative_resolution_action is not None:
            pulumi.set(__self__, "alternative_resolution_action", alternative_resolution_action)
        if can_delete_local_storage is not None:
            pulumi.set(__self__, "can_delete_local_storage", can_delete_local_storage)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if time_window_start is not None:
            pulumi.set(__self__, "time_window_start", time_window_start)

    @property
    @pulumi.getter(name="instanceMaintenanceEventId")
    def instance_maintenance_event_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the instance maintenance event.
        """
        return pulumi.get(self, "instance_maintenance_event_id")

    @instance_maintenance_event_id.setter
    def instance_maintenance_event_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_maintenance_event_id", value)

    @property
    @pulumi.getter(name="alternativeResolutionAction")
    def alternative_resolution_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        """
        return pulumi.get(self, "alternative_resolution_action")

    @alternative_resolution_action.setter
    def alternative_resolution_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alternative_resolution_action", value)

    @property
    @pulumi.getter(name="canDeleteLocalStorage")
    def can_delete_local_storage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) This field is only applicable when setting the alternativeResolutionAction.

        For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.

        In cases where the local storage will be lost, this parameter must be set or the request will fail.
        """
        return pulumi.get(self, "can_delete_local_storage")

    @can_delete_local_storage.setter
    def can_delete_local_storage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_delete_local_storage", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="timeWindowStart")
    def time_window_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.

        The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_window_start")

    @time_window_start.setter
    def time_window_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_window_start", value)


@pulumi.input_type
class _InstanceMaintenanceEventState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 alternative_resolution_action: Optional[pulumi.Input[builtins.str]] = None,
                 alternative_resolution_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 can_delete_local_storage: Optional[pulumi.Input[builtins.bool]] = None,
                 can_reschedule: Optional[pulumi.Input[builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 correlation_token: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 estimated_duration: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_action: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_maintenance_event_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_category: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_reason: Optional[pulumi.Input[builtins.str]] = None,
                 start_window_duration: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_finished: Optional[pulumi.Input[builtins.str]] = None,
                 time_hard_due_date: Optional[pulumi.Input[builtins.str]] = None,
                 time_started: Optional[pulumi.Input[builtins.str]] = None,
                 time_window_start: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceMaintenanceEvent resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: Additional details of the maintenance in the form of json.
        :param pulumi.Input[builtins.str] alternative_resolution_action: (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_resolution_actions: These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.
        :param pulumi.Input[builtins.bool] can_delete_local_storage: (Updatable) This field is only applicable when setting the alternativeResolutionAction.
               
               For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.
               
               In cases where the local storage will be lost, this parameter must be set or the request will fail.
        :param pulumi.Input[builtins.bool] can_reschedule: Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the instance.
        :param pulumi.Input[builtins.str] correlation_token: A unique identifier that will group Instances that have a relationship with one another and must be scheduled together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance perspective will have a matching correlationToken.
        :param pulumi.Input[builtins.str] created_by: The creator of the maintenance event.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: It is the descriptive information about the maintenance taking place on the customer instance.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] estimated_duration: This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_action: This is the action that will be performed on the Instance by Oracle Cloud Infrastructure when the Maintenance begins.
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance.
        :param pulumi.Input[builtins.str] instance_maintenance_event_id: The OCID of the instance maintenance event.
        :param pulumi.Input[builtins.str] maintenance_category: This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled, deferred, or even cancelled. Please see the [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        :param pulumi.Input[builtins.str] maintenance_reason: This is the reason that Maintenance is being performed. See [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        :param pulumi.Input[builtins.str] start_window_duration: The duration of the time window Maintenance is scheduled to begin within.
        :param pulumi.Input[builtins.str] state: The current state of the maintenance event.
        :param pulumi.Input[builtins.str] time_created: The date and time the maintenance event was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_finished: The time at which the Maintenance actually finished.
        :param pulumi.Input[builtins.str] time_hard_due_date: It is the scheduled hard due date and time of the maintenance event. The maintenance event will happen at this time and the due date will not be extended.
        :param pulumi.Input[builtins.str] time_started: The time at which the Maintenance actually started.
        :param pulumi.Input[builtins.str] time_window_start: (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.
               
               The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if alternative_resolution_action is not None:
            pulumi.set(__self__, "alternative_resolution_action", alternative_resolution_action)
        if alternative_resolution_actions is not None:
            pulumi.set(__self__, "alternative_resolution_actions", alternative_resolution_actions)
        if can_delete_local_storage is not None:
            pulumi.set(__self__, "can_delete_local_storage", can_delete_local_storage)
        if can_reschedule is not None:
            pulumi.set(__self__, "can_reschedule", can_reschedule)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if correlation_token is not None:
            pulumi.set(__self__, "correlation_token", correlation_token)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_duration is not None:
            pulumi.set(__self__, "estimated_duration", estimated_duration)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_action is not None:
            pulumi.set(__self__, "instance_action", instance_action)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_maintenance_event_id is not None:
            pulumi.set(__self__, "instance_maintenance_event_id", instance_maintenance_event_id)
        if maintenance_category is not None:
            pulumi.set(__self__, "maintenance_category", maintenance_category)
        if maintenance_reason is not None:
            pulumi.set(__self__, "maintenance_reason", maintenance_reason)
        if start_window_duration is not None:
            pulumi.set(__self__, "start_window_duration", start_window_duration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_hard_due_date is not None:
            pulumi.set(__self__, "time_hard_due_date", time_hard_due_date)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if time_window_start is not None:
            pulumi.set(__self__, "time_window_start", time_window_start)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional details of the maintenance in the form of json.
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="alternativeResolutionAction")
    def alternative_resolution_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        """
        return pulumi.get(self, "alternative_resolution_action")

    @alternative_resolution_action.setter
    def alternative_resolution_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alternative_resolution_action", value)

    @property
    @pulumi.getter(name="alternativeResolutionActions")
    def alternative_resolution_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.
        """
        return pulumi.get(self, "alternative_resolution_actions")

    @alternative_resolution_actions.setter
    def alternative_resolution_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_resolution_actions", value)

    @property
    @pulumi.getter(name="canDeleteLocalStorage")
    def can_delete_local_storage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) This field is only applicable when setting the alternativeResolutionAction.

        For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.

        In cases where the local storage will be lost, this parameter must be set or the request will fail.
        """
        return pulumi.get(self, "can_delete_local_storage")

    @can_delete_local_storage.setter
    def can_delete_local_storage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_delete_local_storage", value)

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.
        """
        return pulumi.get(self, "can_reschedule")

    @can_reschedule.setter
    def can_reschedule(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_reschedule", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="correlationToken")
    def correlation_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier that will group Instances that have a relationship with one another and must be scheduled together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance perspective will have a matching correlationToken.
        """
        return pulumi.get(self, "correlation_token")

    @correlation_token.setter
    def correlation_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "correlation_token", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creator of the maintenance event.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        It is the descriptive information about the maintenance taking place on the customer instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedDuration")
    def estimated_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.
        """
        return pulumi.get(self, "estimated_duration")

    @estimated_duration.setter
    def estimated_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "estimated_duration", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceAction")
    def instance_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is the action that will be performed on the Instance by Oracle Cloud Infrastructure when the Maintenance begins.
        """
        return pulumi.get(self, "instance_action")

    @instance_action.setter
    def instance_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_action", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceMaintenanceEventId")
    def instance_maintenance_event_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the instance maintenance event.
        """
        return pulumi.get(self, "instance_maintenance_event_id")

    @instance_maintenance_event_id.setter
    def instance_maintenance_event_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_maintenance_event_id", value)

    @property
    @pulumi.getter(name="maintenanceCategory")
    def maintenance_category(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled, deferred, or even cancelled. Please see the [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_category")

    @maintenance_category.setter
    def maintenance_category(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_category", value)

    @property
    @pulumi.getter(name="maintenanceReason")
    def maintenance_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is the reason that Maintenance is being performed. See [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_reason")

    @maintenance_reason.setter
    def maintenance_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_reason", value)

    @property
    @pulumi.getter(name="startWindowDuration")
    def start_window_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The duration of the time window Maintenance is scheduled to begin within.
        """
        return pulumi.get(self, "start_window_duration")

    @start_window_duration.setter
    def start_window_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_window_duration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the maintenance event.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the maintenance event was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Maintenance actually finished.
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeHardDueDate")
    def time_hard_due_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        It is the scheduled hard due date and time of the maintenance event. The maintenance event will happen at this time and the due date will not be extended.
        """
        return pulumi.get(self, "time_hard_due_date")

    @time_hard_due_date.setter
    def time_hard_due_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_hard_due_date", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Maintenance actually started.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="timeWindowStart")
    def time_window_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.

        The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_window_start")

    @time_window_start.setter
    def time_window_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_window_start", value)


@pulumi.type_token("oci:Core/instanceMaintenanceEvent:InstanceMaintenanceEvent")
class InstanceMaintenanceEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_resolution_action: Optional[pulumi.Input[builtins.str]] = None,
                 can_delete_local_storage: Optional[pulumi.Input[builtins.bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_maintenance_event_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_window_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Instance Maintenance Event resource in Oracle Cloud Infrastructure Core service.

        Updates the maintenance event for the given instance.

        ## Import

        InstanceMaintenanceEvents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceMaintenanceEvent:InstanceMaintenanceEvent test_instance_maintenance_event "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alternative_resolution_action: (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        :param pulumi.Input[builtins.bool] can_delete_local_storage: (Updatable) This field is only applicable when setting the alternativeResolutionAction.
               
               For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.
               
               In cases where the local storage will be lost, this parameter must be set or the request will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_maintenance_event_id: The OCID of the instance maintenance event.
        :param pulumi.Input[builtins.str] time_window_start: (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.
               
               The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceMaintenanceEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Instance Maintenance Event resource in Oracle Cloud Infrastructure Core service.

        Updates the maintenance event for the given instance.

        ## Import

        InstanceMaintenanceEvents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceMaintenanceEvent:InstanceMaintenanceEvent test_instance_maintenance_event "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceMaintenanceEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceMaintenanceEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_resolution_action: Optional[pulumi.Input[builtins.str]] = None,
                 can_delete_local_storage: Optional[pulumi.Input[builtins.bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_maintenance_event_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_window_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceMaintenanceEventArgs.__new__(InstanceMaintenanceEventArgs)

            __props__.__dict__["alternative_resolution_action"] = alternative_resolution_action
            __props__.__dict__["can_delete_local_storage"] = can_delete_local_storage
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if instance_maintenance_event_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_maintenance_event_id'")
            __props__.__dict__["instance_maintenance_event_id"] = instance_maintenance_event_id
            __props__.__dict__["time_window_start"] = time_window_start
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["alternative_resolution_actions"] = None
            __props__.__dict__["can_reschedule"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["correlation_token"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["estimated_duration"] = None
            __props__.__dict__["instance_action"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["maintenance_category"] = None
            __props__.__dict__["maintenance_reason"] = None
            __props__.__dict__["start_window_duration"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_hard_due_date"] = None
            __props__.__dict__["time_started"] = None
        super(InstanceMaintenanceEvent, __self__).__init__(
            'oci:Core/instanceMaintenanceEvent:InstanceMaintenanceEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            alternative_resolution_action: Optional[pulumi.Input[builtins.str]] = None,
            alternative_resolution_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            can_delete_local_storage: Optional[pulumi.Input[builtins.bool]] = None,
            can_reschedule: Optional[pulumi.Input[builtins.bool]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            correlation_token: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            estimated_duration: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            instance_action: Optional[pulumi.Input[builtins.str]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_maintenance_event_id: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_category: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_reason: Optional[pulumi.Input[builtins.str]] = None,
            start_window_duration: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_finished: Optional[pulumi.Input[builtins.str]] = None,
            time_hard_due_date: Optional[pulumi.Input[builtins.str]] = None,
            time_started: Optional[pulumi.Input[builtins.str]] = None,
            time_window_start: Optional[pulumi.Input[builtins.str]] = None) -> 'InstanceMaintenanceEvent':
        """
        Get an existing InstanceMaintenanceEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: Additional details of the maintenance in the form of json.
        :param pulumi.Input[builtins.str] alternative_resolution_action: (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_resolution_actions: These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.
        :param pulumi.Input[builtins.bool] can_delete_local_storage: (Updatable) This field is only applicable when setting the alternativeResolutionAction.
               
               For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.
               
               In cases where the local storage will be lost, this parameter must be set or the request will fail.
        :param pulumi.Input[builtins.bool] can_reschedule: Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the instance.
        :param pulumi.Input[builtins.str] correlation_token: A unique identifier that will group Instances that have a relationship with one another and must be scheduled together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance perspective will have a matching correlationToken.
        :param pulumi.Input[builtins.str] created_by: The creator of the maintenance event.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: It is the descriptive information about the maintenance taking place on the customer instance.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] estimated_duration: This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_action: This is the action that will be performed on the Instance by Oracle Cloud Infrastructure when the Maintenance begins.
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance.
        :param pulumi.Input[builtins.str] instance_maintenance_event_id: The OCID of the instance maintenance event.
        :param pulumi.Input[builtins.str] maintenance_category: This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled, deferred, or even cancelled. Please see the [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        :param pulumi.Input[builtins.str] maintenance_reason: This is the reason that Maintenance is being performed. See [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        :param pulumi.Input[builtins.str] start_window_duration: The duration of the time window Maintenance is scheduled to begin within.
        :param pulumi.Input[builtins.str] state: The current state of the maintenance event.
        :param pulumi.Input[builtins.str] time_created: The date and time the maintenance event was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_finished: The time at which the Maintenance actually finished.
        :param pulumi.Input[builtins.str] time_hard_due_date: It is the scheduled hard due date and time of the maintenance event. The maintenance event will happen at this time and the due date will not be extended.
        :param pulumi.Input[builtins.str] time_started: The time at which the Maintenance actually started.
        :param pulumi.Input[builtins.str] time_window_start: (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.
               
               The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceMaintenanceEventState.__new__(_InstanceMaintenanceEventState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["alternative_resolution_action"] = alternative_resolution_action
        __props__.__dict__["alternative_resolution_actions"] = alternative_resolution_actions
        __props__.__dict__["can_delete_local_storage"] = can_delete_local_storage
        __props__.__dict__["can_reschedule"] = can_reschedule
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["correlation_token"] = correlation_token
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_duration"] = estimated_duration
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_action"] = instance_action
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_maintenance_event_id"] = instance_maintenance_event_id
        __props__.__dict__["maintenance_category"] = maintenance_category
        __props__.__dict__["maintenance_reason"] = maintenance_reason
        __props__.__dict__["start_window_duration"] = start_window_duration
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_hard_due_date"] = time_hard_due_date
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_window_start"] = time_window_start
        return InstanceMaintenanceEvent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Additional details of the maintenance in the form of json.
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="alternativeResolutionAction")
    def alternative_resolution_action(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.
        """
        return pulumi.get(self, "alternative_resolution_action")

    @property
    @pulumi.getter(name="alternativeResolutionActions")
    def alternative_resolution_actions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.
        """
        return pulumi.get(self, "alternative_resolution_actions")

    @property
    @pulumi.getter(name="canDeleteLocalStorage")
    def can_delete_local_storage(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) This field is only applicable when setting the alternativeResolutionAction.

        For Instances that have local storage, this must be set to true to verify that the local storage will be deleted during the migration. For instances without, this parameter has no effect.

        In cases where the local storage will be lost, this parameter must be set or the request will fail.
        """
        return pulumi.get(self, "can_delete_local_storage")

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.
        """
        return pulumi.get(self, "can_reschedule")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="correlationToken")
    def correlation_token(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier that will group Instances that have a relationship with one another and must be scheduled together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance perspective will have a matching correlationToken.
        """
        return pulumi.get(self, "correlation_token")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The creator of the maintenance event.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        It is the descriptive information about the maintenance taking place on the customer instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedDuration")
    def estimated_duration(self) -> pulumi.Output[builtins.str]:
        """
        This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.
        """
        return pulumi.get(self, "estimated_duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="instanceAction")
    def instance_action(self) -> pulumi.Output[builtins.str]:
        """
        This is the action that will be performed on the Instance by Oracle Cloud Infrastructure when the Maintenance begins.
        """
        return pulumi.get(self, "instance_action")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceMaintenanceEventId")
    def instance_maintenance_event_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the instance maintenance event.
        """
        return pulumi.get(self, "instance_maintenance_event_id")

    @property
    @pulumi.getter(name="maintenanceCategory")
    def maintenance_category(self) -> pulumi.Output[builtins.str]:
        """
        This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled, deferred, or even cancelled. Please see the [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_category")

    @property
    @pulumi.getter(name="maintenanceReason")
    def maintenance_reason(self) -> pulumi.Output[builtins.str]:
        """
        This is the reason that Maintenance is being performed. See [Instance Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm) documentation for details.
        """
        return pulumi.get(self, "maintenance_reason")

    @property
    @pulumi.getter(name="startWindowDuration")
    def start_window_duration(self) -> pulumi.Output[builtins.str]:
        """
        The duration of the time window Maintenance is scheduled to begin within.
        """
        return pulumi.get(self, "start_window_duration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the maintenance event.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the maintenance event was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Maintenance actually finished.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeHardDueDate")
    def time_hard_due_date(self) -> pulumi.Output[builtins.str]:
        """
        It is the scheduled hard due date and time of the maintenance event. The maintenance event will happen at this time and the due date will not be extended.
        """
        return pulumi.get(self, "time_hard_due_date")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Maintenance actually started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeWindowStart")
    def time_window_start(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before this time.

        The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_window_start")

