# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutonomousDatabaseRegionalWalletManagementArgs', 'AutonomousDatabaseRegionalWalletManagement']

@pulumi.input_type
class AutonomousDatabaseRegionalWalletManagementArgs:
    def __init__(__self__, *,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 should_rotate: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseRegionalWalletManagement resource.
        :param pulumi.Input[builtins.int] grace_period: (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        :param pulumi.Input[builtins.bool] should_rotate: (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if should_rotate is not None:
            pulumi.set(__self__, "should_rotate", should_rotate)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="shouldRotate")
    def should_rotate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_rotate")

    @should_rotate.setter
    def should_rotate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_rotate", value)


@pulumi.input_type
class _AutonomousDatabaseRegionalWalletManagementState:
    def __init__(__self__, *,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 should_rotate: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_rotated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseRegionalWalletManagement resources.
        :param pulumi.Input[builtins.int] grace_period: (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        :param pulumi.Input[builtins.bool] should_rotate: (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the Autonomous Database wallet.
        :param pulumi.Input[builtins.str] time_rotated: The date and time the wallet was last rotated.
        """
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if should_rotate is not None:
            pulumi.set(__self__, "should_rotate", should_rotate)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_rotated is not None:
            pulumi.set(__self__, "time_rotated", time_rotated)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="shouldRotate")
    def should_rotate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_rotate")

    @should_rotate.setter
    def should_rotate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_rotate", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the Autonomous Database wallet.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeRotated")
    def time_rotated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the wallet was last rotated.
        """
        return pulumi.get(self, "time_rotated")

    @time_rotated.setter
    def time_rotated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_rotated", value)


@pulumi.type_token("oci:Database/autonomousDatabaseRegionalWalletManagement:AutonomousDatabaseRegionalWalletManagement")
class AutonomousDatabaseRegionalWalletManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 should_rotate: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database Regional Wallet Management resource in Oracle Cloud Infrastructure Database service.

        Updates the Autonomous Database regional wallet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_regional_wallet_management = oci.database.AutonomousDatabaseRegionalWalletManagement("test_autonomous_database_regional_wallet_management",
            grace_period=autonomous_database_regional_wallet_management_grace_period,
            should_rotate=autonomous_database_regional_wallet_management_should_rotate)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] grace_period: (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        :param pulumi.Input[builtins.bool] should_rotate: (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AutonomousDatabaseRegionalWalletManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database Regional Wallet Management resource in Oracle Cloud Infrastructure Database service.

        Updates the Autonomous Database regional wallet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_regional_wallet_management = oci.database.AutonomousDatabaseRegionalWalletManagement("test_autonomous_database_regional_wallet_management",
            grace_period=autonomous_database_regional_wallet_management_grace_period,
            should_rotate=autonomous_database_regional_wallet_management_should_rotate)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseRegionalWalletManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseRegionalWalletManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grace_period: Optional[pulumi.Input[builtins.int]] = None,
                 should_rotate: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseRegionalWalletManagementArgs.__new__(AutonomousDatabaseRegionalWalletManagementArgs)

            __props__.__dict__["grace_period"] = grace_period
            __props__.__dict__["should_rotate"] = should_rotate
            __props__.__dict__["state"] = None
            __props__.__dict__["time_rotated"] = None
        super(AutonomousDatabaseRegionalWalletManagement, __self__).__init__(
            'oci:Database/autonomousDatabaseRegionalWalletManagement:AutonomousDatabaseRegionalWalletManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grace_period: Optional[pulumi.Input[builtins.int]] = None,
            should_rotate: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_rotated: Optional[pulumi.Input[builtins.str]] = None) -> 'AutonomousDatabaseRegionalWalletManagement':
        """
        Get an existing AutonomousDatabaseRegionalWalletManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] grace_period: (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        :param pulumi.Input[builtins.bool] should_rotate: (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the Autonomous Database wallet.
        :param pulumi.Input[builtins.str] time_rotated: The date and time the wallet was last rotated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseRegionalWalletManagementState.__new__(_AutonomousDatabaseRegionalWalletManagementState)

        __props__.__dict__["grace_period"] = grace_period
        __props__.__dict__["should_rotate"] = should_rotate
        __props__.__dict__["state"] = state
        __props__.__dict__["time_rotated"] = time_rotated
        return AutonomousDatabaseRegionalWalletManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of hours that the old wallet can be used after it has been rotated. The old wallet will no longer be valid after the number of hours in the wallet rotation grace period has passed. During the grace period, both the old wallet and the current wallet can be used.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="shouldRotate")
    def should_rotate(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_rotate")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the Autonomous Database wallet.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeRotated")
    def time_rotated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the wallet was last rotated.
        """
        return pulumi.get(self, "time_rotated")

