# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalExadataStorageServerArgs', 'ExternalExadataStorageServer']

@pulumi.input_type
class ExternalExadataStorageServerArgs:
    def __init__(__self__, *,
                 external_exadata_storage_server_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExternalExadataStorageServer resource.
        :param pulumi.Input[builtins.str] external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "external_exadata_storage_server_id", external_exadata_storage_server_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        """
        return pulumi.get(self, "external_exadata_storage_server_id")

    @external_exadata_storage_server_id.setter
    def external_exadata_storage_server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "external_exadata_storage_server_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExternalExadataStorageServerState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataStorageServerConnectorArgs']]]] = None,
                 cpu_count: Optional[pulumi.Input[builtins.float]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_exadata_storage_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 internal_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 make_model: Optional[pulumi.Input[builtins.str]] = None,
                 max_flash_disk_iops: Optional[pulumi.Input[builtins.int]] = None,
                 max_flash_disk_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 max_hard_disk_iops: Optional[pulumi.Input[builtins.int]] = None,
                 max_hard_disk_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 memory_gb: Optional[pulumi.Input[builtins.float]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 storage_grid_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalExadataStorageServer resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ExternalExadataStorageServerConnectorArgs']]] connectors: The connector of the Exadata storage server.
        :param pulumi.Input[builtins.float] cpu_count: The CPU count of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[builtins.str] external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] internal_id: The internal ID of the Exadata resource.
        :param pulumi.Input[builtins.str] ip_address: The IP address of the Exadata storage server.
        :param pulumi.Input[builtins.str] lifecycle_details: The details of the lifecycle state of the Exadata resource.
        :param pulumi.Input[builtins.str] make_model: The make model of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_flash_disk_iops: The maximum flash disk IO operations per second of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_flash_disk_throughput: The maximum flash disk IO throughput in MB/s of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_hard_disk_iops: The maximum hard disk IO operations per second of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_hard_disk_throughput: The maximum hard disk IO throughput in MB/s of the Exadata storage server.
        :param pulumi.Input[builtins.float] memory_gb: The Exadata storage server memory size in GB.
        :param pulumi.Input[builtins.str] resource_type: The type of Exadata resource.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the database resource.
        :param pulumi.Input[builtins.str] status: The status of the Exadata resource.
        :param pulumi.Input[builtins.str] storage_grid_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server grid.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The timestamp of the creation of the Exadata resource.
        :param pulumi.Input[builtins.str] time_updated: The timestamp of the last update of the Exadata resource.
        :param pulumi.Input[builtins.str] version: The version of the Exadata resource.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if external_exadata_storage_server_id is not None:
            pulumi.set(__self__, "external_exadata_storage_server_id", external_exadata_storage_server_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if internal_id is not None:
            pulumi.set(__self__, "internal_id", internal_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if make_model is not None:
            pulumi.set(__self__, "make_model", make_model)
        if max_flash_disk_iops is not None:
            pulumi.set(__self__, "max_flash_disk_iops", max_flash_disk_iops)
        if max_flash_disk_throughput is not None:
            pulumi.set(__self__, "max_flash_disk_throughput", max_flash_disk_throughput)
        if max_hard_disk_iops is not None:
            pulumi.set(__self__, "max_hard_disk_iops", max_hard_disk_iops)
        if max_hard_disk_throughput is not None:
            pulumi.set(__self__, "max_hard_disk_throughput", max_hard_disk_throughput)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_grid_id is not None:
            pulumi.set(__self__, "storage_grid_id", storage_grid_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataStorageServerConnectorArgs']]]]:
        """
        The connector of the Exadata storage server.
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataStorageServerConnectorArgs']]]]):
        pulumi.set(self, "connectors", value)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The CPU count of the Exadata storage server.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        """
        return pulumi.get(self, "external_exadata_storage_server_id")

    @external_exadata_storage_server_id.setter
    def external_exadata_storage_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_exadata_storage_server_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @internal_id.setter
    def internal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "internal_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the Exadata storage server.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="makeModel")
    def make_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The make model of the Exadata storage server.
        """
        return pulumi.get(self, "make_model")

    @make_model.setter
    def make_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "make_model", value)

    @property
    @pulumi.getter(name="maxFlashDiskIops")
    def max_flash_disk_iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum flash disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_iops")

    @max_flash_disk_iops.setter
    def max_flash_disk_iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_flash_disk_iops", value)

    @property
    @pulumi.getter(name="maxFlashDiskThroughput")
    def max_flash_disk_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum flash disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_throughput")

    @max_flash_disk_throughput.setter
    def max_flash_disk_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_flash_disk_throughput", value)

    @property
    @pulumi.getter(name="maxHardDiskIops")
    def max_hard_disk_iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum hard disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_iops")

    @max_hard_disk_iops.setter
    def max_hard_disk_iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_hard_disk_iops", value)

    @property
    @pulumi.getter(name="maxHardDiskThroughput")
    def max_hard_disk_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum hard disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_throughput")

    @max_hard_disk_throughput.setter
    def max_hard_disk_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_hard_disk_throughput", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The Exadata storage server memory size in GB.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Exadata resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageGridId")
    def storage_grid_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server grid.
        """
        return pulumi.get(self, "storage_grid_id")

    @storage_grid_id.setter
    def storage_grid_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_grid_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:DatabaseManagement/externalExadataStorageServer:ExternalExadataStorageServer")
class ExternalExadataStorageServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_exadata_storage_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the External Exadata Storage Server resource in Oracle Cloud Infrastructure Database Management service.

        Updates the Exadata storage server specified by exadataStorageServerId.

        ## Import

        ExternalExadataStorageServers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalExadataStorageServer:ExternalExadataStorageServer test_external_exadata_storage_server "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalExadataStorageServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Exadata Storage Server resource in Oracle Cloud Infrastructure Database Management service.

        Updates the Exadata storage server specified by exadataStorageServerId.

        ## Import

        ExternalExadataStorageServers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalExadataStorageServer:ExternalExadataStorageServer test_external_exadata_storage_server "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalExadataStorageServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalExadataStorageServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_exadata_storage_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalExadataStorageServerArgs.__new__(ExternalExadataStorageServerArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            if external_exadata_storage_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_exadata_storage_server_id'")
            __props__.__dict__["external_exadata_storage_server_id"] = external_exadata_storage_server_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["connectors"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["exadata_infrastructure_id"] = None
            __props__.__dict__["internal_id"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["make_model"] = None
            __props__.__dict__["max_flash_disk_iops"] = None
            __props__.__dict__["max_flash_disk_throughput"] = None
            __props__.__dict__["max_hard_disk_iops"] = None
            __props__.__dict__["max_hard_disk_throughput"] = None
            __props__.__dict__["memory_gb"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_grid_id"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(ExternalExadataStorageServer, __self__).__init__(
            'oci:DatabaseManagement/externalExadataStorageServer:ExternalExadataStorageServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalExadataStorageServerConnectorArgs', 'ExternalExadataStorageServerConnectorArgsDict']]]]] = None,
            cpu_count: Optional[pulumi.Input[builtins.float]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
            external_exadata_storage_server_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            internal_id: Optional[pulumi.Input[builtins.str]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            make_model: Optional[pulumi.Input[builtins.str]] = None,
            max_flash_disk_iops: Optional[pulumi.Input[builtins.int]] = None,
            max_flash_disk_throughput: Optional[pulumi.Input[builtins.int]] = None,
            max_hard_disk_iops: Optional[pulumi.Input[builtins.int]] = None,
            max_hard_disk_throughput: Optional[pulumi.Input[builtins.int]] = None,
            memory_gb: Optional[pulumi.Input[builtins.float]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            storage_grid_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'ExternalExadataStorageServer':
        """
        Get an existing ExternalExadataStorageServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalExadataStorageServerConnectorArgs', 'ExternalExadataStorageServerConnectorArgsDict']]]] connectors: The connector of the Exadata storage server.
        :param pulumi.Input[builtins.float] cpu_count: The CPU count of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[builtins.str] external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] internal_id: The internal ID of the Exadata resource.
        :param pulumi.Input[builtins.str] ip_address: The IP address of the Exadata storage server.
        :param pulumi.Input[builtins.str] lifecycle_details: The details of the lifecycle state of the Exadata resource.
        :param pulumi.Input[builtins.str] make_model: The make model of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_flash_disk_iops: The maximum flash disk IO operations per second of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_flash_disk_throughput: The maximum flash disk IO throughput in MB/s of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_hard_disk_iops: The maximum hard disk IO operations per second of the Exadata storage server.
        :param pulumi.Input[builtins.int] max_hard_disk_throughput: The maximum hard disk IO throughput in MB/s of the Exadata storage server.
        :param pulumi.Input[builtins.float] memory_gb: The Exadata storage server memory size in GB.
        :param pulumi.Input[builtins.str] resource_type: The type of Exadata resource.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the database resource.
        :param pulumi.Input[builtins.str] status: The status of the Exadata resource.
        :param pulumi.Input[builtins.str] storage_grid_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server grid.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The timestamp of the creation of the Exadata resource.
        :param pulumi.Input[builtins.str] time_updated: The timestamp of the last update of the Exadata resource.
        :param pulumi.Input[builtins.str] version: The version of the Exadata resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalExadataStorageServerState.__new__(_ExternalExadataStorageServerState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["connectors"] = connectors
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["external_exadata_storage_server_id"] = external_exadata_storage_server_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["internal_id"] = internal_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["make_model"] = make_model
        __props__.__dict__["max_flash_disk_iops"] = max_flash_disk_iops
        __props__.__dict__["max_flash_disk_throughput"] = max_flash_disk_throughput
        __props__.__dict__["max_hard_disk_iops"] = max_hard_disk_iops
        __props__.__dict__["max_hard_disk_throughput"] = max_hard_disk_throughput
        __props__.__dict__["memory_gb"] = memory_gb
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_grid_id"] = storage_grid_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return ExternalExadataStorageServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter
    def connectors(self) -> pulumi.Output[Sequence['outputs.ExternalExadataStorageServerConnector']]:
        """
        The connector of the Exadata storage server.
        """
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[builtins.float]:
        """
        The CPU count of the Exadata storage server.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        """
        return pulumi.get(self, "external_exadata_storage_server_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> pulumi.Output[builtins.str]:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address of the Exadata storage server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="makeModel")
    def make_model(self) -> pulumi.Output[builtins.str]:
        """
        The make model of the Exadata storage server.
        """
        return pulumi.get(self, "make_model")

    @property
    @pulumi.getter(name="maxFlashDiskIops")
    def max_flash_disk_iops(self) -> pulumi.Output[builtins.int]:
        """
        The maximum flash disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_iops")

    @property
    @pulumi.getter(name="maxFlashDiskThroughput")
    def max_flash_disk_throughput(self) -> pulumi.Output[builtins.int]:
        """
        The maximum flash disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_throughput")

    @property
    @pulumi.getter(name="maxHardDiskIops")
    def max_hard_disk_iops(self) -> pulumi.Output[builtins.int]:
        """
        The maximum hard disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_iops")

    @property
    @pulumi.getter(name="maxHardDiskThroughput")
    def max_hard_disk_throughput(self) -> pulumi.Output[builtins.int]:
        """
        The maximum hard disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_throughput")

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> pulumi.Output[builtins.float]:
        """
        The Exadata storage server memory size in GB.
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of Exadata resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageGridId")
    def storage_grid_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server grid.
        """
        return pulumi.get(self, "storage_grid_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")

