# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalListenerArgs', 'ExternalListener']

@pulumi.input_type
class ExternalListenerArgs:
    def __init__(__self__, *,
                 external_listener_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExternalListener resource.
        :param pulumi.Input[builtins.str] external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "external_listener_id", external_listener_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        """
        return pulumi.get(self, "external_listener_id")

    @external_listener_id.setter
    def external_listener_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "external_listener_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_connector_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExternalListenerState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 adr_home_directory: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 component_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerEndpointArgs']]]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_listener_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 listener_alias: Optional[pulumi.Input[builtins.str]] = None,
                 listener_ora_location: Optional[pulumi.Input[builtins.str]] = None,
                 listener_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_directory: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_home: Optional[pulumi.Input[builtins.str]] = None,
                 serviced_asms: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedAsmArgs']]]] = None,
                 serviced_databases: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedDatabaseArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 trace_directory: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalListener resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] adr_home_directory: The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        :param pulumi.Input[builtins.str] component_name: The name of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the database. The name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalListenerEndpointArgs']]] endpoints: The list of protocol addresses the listener is configured to listen on.
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[builtins.str] external_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        :param pulumi.Input[builtins.str] external_db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        :param pulumi.Input[builtins.str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        :param pulumi.Input[builtins.str] external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] host_name: The name of the host on which the external listener is running.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] listener_alias: The listener alias.
        :param pulumi.Input[builtins.str] listener_ora_location: The location of the listener configuration file listener.ora.
        :param pulumi.Input[builtins.str] listener_type: The type of listener.
        :param pulumi.Input[builtins.str] log_directory: The destination directory of the listener log file.
        :param pulumi.Input[builtins.str] oracle_home: The Oracle home location of the listener.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedAsmArgs']]] serviced_asms: The list of ASMs that are serviced by the listener.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedDatabaseArgs']]] serviced_databases: The list of databases that are serviced by the listener.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external listener was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external listener was last updated.
        :param pulumi.Input[builtins.str] trace_directory: The destination directory of the listener trace file.
        :param pulumi.Input[builtins.str] version: The listener version.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if adr_home_directory is not None:
            pulumi.set(__self__, "adr_home_directory", adr_home_directory)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)
        if external_db_home_id is not None:
            pulumi.set(__self__, "external_db_home_id", external_db_home_id)
        if external_db_node_id is not None:
            pulumi.set(__self__, "external_db_node_id", external_db_node_id)
        if external_db_system_id is not None:
            pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if external_listener_id is not None:
            pulumi.set(__self__, "external_listener_id", external_listener_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_alias is not None:
            pulumi.set(__self__, "listener_alias", listener_alias)
        if listener_ora_location is not None:
            pulumi.set(__self__, "listener_ora_location", listener_ora_location)
        if listener_type is not None:
            pulumi.set(__self__, "listener_type", listener_type)
        if log_directory is not None:
            pulumi.set(__self__, "log_directory", log_directory)
        if oracle_home is not None:
            pulumi.set(__self__, "oracle_home", oracle_home)
        if serviced_asms is not None:
            pulumi.set(__self__, "serviced_asms", serviced_asms)
        if serviced_databases is not None:
            pulumi.set(__self__, "serviced_databases", serviced_databases)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trace_directory is not None:
            pulumi.set(__self__, "trace_directory", trace_directory)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="adrHomeDirectory")
    def adr_home_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        """
        return pulumi.get(self, "adr_home_directory")

    @adr_home_directory.setter
    def adr_home_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "adr_home_directory", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the external listener.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerEndpointArgs']]]]:
        """
        The list of protocol addresses the listener is configured to listen on.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_connector_id", value)

    @property
    @pulumi.getter(name="externalDbHomeId")
    def external_db_home_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        """
        return pulumi.get(self, "external_db_home_id")

    @external_db_home_id.setter
    def external_db_home_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_db_home_id", value)

    @property
    @pulumi.getter(name="externalDbNodeId")
    def external_db_node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        """
        return pulumi.get(self, "external_db_node_id")

    @external_db_node_id.setter
    def external_db_node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_db_node_id", value)

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @external_db_system_id.setter
    def external_db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_db_system_id", value)

    @property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        """
        return pulumi.get(self, "external_listener_id")

    @external_listener_id.setter
    def external_listener_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_listener_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the host on which the external listener is running.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="listenerAlias")
    def listener_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The listener alias.
        """
        return pulumi.get(self, "listener_alias")

    @listener_alias.setter
    def listener_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listener_alias", value)

    @property
    @pulumi.getter(name="listenerOraLocation")
    def listener_ora_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the listener configuration file listener.ora.
        """
        return pulumi.get(self, "listener_ora_location")

    @listener_ora_location.setter
    def listener_ora_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listener_ora_location", value)

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of listener.
        """
        return pulumi.get(self, "listener_type")

    @listener_type.setter
    def listener_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listener_type", value)

    @property
    @pulumi.getter(name="logDirectory")
    def log_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination directory of the listener log file.
        """
        return pulumi.get(self, "log_directory")

    @log_directory.setter
    def log_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_directory", value)

    @property
    @pulumi.getter(name="oracleHome")
    def oracle_home(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle home location of the listener.
        """
        return pulumi.get(self, "oracle_home")

    @oracle_home.setter
    def oracle_home(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_home", value)

    @property
    @pulumi.getter(name="servicedAsms")
    def serviced_asms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedAsmArgs']]]]:
        """
        The list of ASMs that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_asms")

    @serviced_asms.setter
    def serviced_asms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedAsmArgs']]]]):
        pulumi.set(self, "serviced_asms", value)

    @property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedDatabaseArgs']]]]:
        """
        The list of databases that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_databases")

    @serviced_databases.setter
    def serviced_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalListenerServicedDatabaseArgs']]]]):
        pulumi.set(self, "serviced_databases", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the external listener.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external listener was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external listener was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="traceDirectory")
    def trace_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination directory of the listener trace file.
        """
        return pulumi.get(self, "trace_directory")

    @trace_directory.setter
    def trace_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trace_directory", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The listener version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:DatabaseManagement/externalListener:ExternalListener")
class ExternalListener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_listener_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the External Listener resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external listener specified by `externalListenerId`.

        ## Import

        ExternalListeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalListener:ExternalListener test_external_listener "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[builtins.str] external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Listener resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external listener specified by `externalListenerId`.

        ## Import

        ExternalListeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalListener:ExternalListener test_external_listener "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_listener_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalListenerArgs.__new__(ExternalListenerArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["external_connector_id"] = external_connector_id
            if external_listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_listener_id'")
            __props__.__dict__["external_listener_id"] = external_listener_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["adr_home_directory"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["component_name"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["external_db_home_id"] = None
            __props__.__dict__["external_db_node_id"] = None
            __props__.__dict__["external_db_system_id"] = None
            __props__.__dict__["host_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["listener_alias"] = None
            __props__.__dict__["listener_ora_location"] = None
            __props__.__dict__["listener_type"] = None
            __props__.__dict__["log_directory"] = None
            __props__.__dict__["oracle_home"] = None
            __props__.__dict__["serviced_asms"] = None
            __props__.__dict__["serviced_databases"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trace_directory"] = None
            __props__.__dict__["version"] = None
        super(ExternalListener, __self__).__init__(
            'oci:DatabaseManagement/externalListener:ExternalListener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            adr_home_directory: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            component_name: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerEndpointArgs', 'ExternalListenerEndpointArgsDict']]]]] = None,
            external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            external_db_home_id: Optional[pulumi.Input[builtins.str]] = None,
            external_db_node_id: Optional[pulumi.Input[builtins.str]] = None,
            external_db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            external_listener_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            host_name: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            listener_alias: Optional[pulumi.Input[builtins.str]] = None,
            listener_ora_location: Optional[pulumi.Input[builtins.str]] = None,
            listener_type: Optional[pulumi.Input[builtins.str]] = None,
            log_directory: Optional[pulumi.Input[builtins.str]] = None,
            oracle_home: Optional[pulumi.Input[builtins.str]] = None,
            serviced_asms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerServicedAsmArgs', 'ExternalListenerServicedAsmArgsDict']]]]] = None,
            serviced_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerServicedDatabaseArgs', 'ExternalListenerServicedDatabaseArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            trace_directory: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'ExternalListener':
        """
        Get an existing ExternalListener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] adr_home_directory: The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        :param pulumi.Input[builtins.str] component_name: The name of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the database. The name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerEndpointArgs', 'ExternalListenerEndpointArgsDict']]]] endpoints: The list of protocol addresses the listener is configured to listen on.
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[builtins.str] external_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        :param pulumi.Input[builtins.str] external_db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        :param pulumi.Input[builtins.str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        :param pulumi.Input[builtins.str] external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] host_name: The name of the host on which the external listener is running.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] listener_alias: The listener alias.
        :param pulumi.Input[builtins.str] listener_ora_location: The location of the listener configuration file listener.ora.
        :param pulumi.Input[builtins.str] listener_type: The type of listener.
        :param pulumi.Input[builtins.str] log_directory: The destination directory of the listener log file.
        :param pulumi.Input[builtins.str] oracle_home: The Oracle home location of the listener.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerServicedAsmArgs', 'ExternalListenerServicedAsmArgsDict']]]] serviced_asms: The list of ASMs that are serviced by the listener.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalListenerServicedDatabaseArgs', 'ExternalListenerServicedDatabaseArgsDict']]]] serviced_databases: The list of databases that are serviced by the listener.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external listener was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external listener was last updated.
        :param pulumi.Input[builtins.str] trace_directory: The destination directory of the listener trace file.
        :param pulumi.Input[builtins.str] version: The listener version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalListenerState.__new__(_ExternalListenerState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["adr_home_directory"] = adr_home_directory
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_name"] = component_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["external_connector_id"] = external_connector_id
        __props__.__dict__["external_db_home_id"] = external_db_home_id
        __props__.__dict__["external_db_node_id"] = external_db_node_id
        __props__.__dict__["external_db_system_id"] = external_db_system_id
        __props__.__dict__["external_listener_id"] = external_listener_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["listener_alias"] = listener_alias
        __props__.__dict__["listener_ora_location"] = listener_ora_location
        __props__.__dict__["listener_type"] = listener_type
        __props__.__dict__["log_directory"] = log_directory
        __props__.__dict__["oracle_home"] = oracle_home
        __props__.__dict__["serviced_asms"] = serviced_asms
        __props__.__dict__["serviced_databases"] = serviced_databases
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trace_directory"] = trace_directory
        __props__.__dict__["version"] = version
        return ExternalListener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="adrHomeDirectory")
    def adr_home_directory(self) -> pulumi.Output[builtins.str]:
        """
        The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        """
        return pulumi.get(self, "adr_home_directory")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the external listener.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ExternalListenerEndpoint']]:
        """
        The list of protocol addresses the listener is configured to listen on.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @property
    @pulumi.getter(name="externalDbHomeId")
    def external_db_home_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        """
        return pulumi.get(self, "external_db_home_id")

    @property
    @pulumi.getter(name="externalDbNodeId")
    def external_db_node_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        """
        return pulumi.get(self, "external_db_node_id")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
        """
        return pulumi.get(self, "external_listener_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the host on which the external listener is running.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerAlias")
    def listener_alias(self) -> pulumi.Output[builtins.str]:
        """
        The listener alias.
        """
        return pulumi.get(self, "listener_alias")

    @property
    @pulumi.getter(name="listenerOraLocation")
    def listener_ora_location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the listener configuration file listener.ora.
        """
        return pulumi.get(self, "listener_ora_location")

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of listener.
        """
        return pulumi.get(self, "listener_type")

    @property
    @pulumi.getter(name="logDirectory")
    def log_directory(self) -> pulumi.Output[builtins.str]:
        """
        The destination directory of the listener log file.
        """
        return pulumi.get(self, "log_directory")

    @property
    @pulumi.getter(name="oracleHome")
    def oracle_home(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle home location of the listener.
        """
        return pulumi.get(self, "oracle_home")

    @property
    @pulumi.getter(name="servicedAsms")
    def serviced_asms(self) -> pulumi.Output[Sequence['outputs.ExternalListenerServicedAsm']]:
        """
        The list of ASMs that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_asms")

    @property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> pulumi.Output[Sequence['outputs.ExternalListenerServicedDatabase']]:
        """
        The list of databases that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_databases")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the external listener.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external listener was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external listener was last updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="traceDirectory")
    def trace_directory(self) -> pulumi.Output[builtins.str]:
        """
        The destination directory of the listener trace file.
        """
        return pulumi.get(self, "trace_directory")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The listener version.
        """
        return pulumi.get(self, "version")

