# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 annotation_format: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 dataset_format_details: pulumi.Input['DatasetDatasetFormatDetailsArgs'],
                 dataset_source_details: pulumi.Input['DatasetDatasetSourceDetailsArgs'],
                 label_set: pulumi.Input['DatasetLabelSetArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_import_dataset_configuration: Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']] = None,
                 initial_record_generation_configuration: Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']] = None,
                 labeling_instructions: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input[builtins.str] annotation_format: The annotation format name required for labeling records.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment of the resource.
        :param pulumi.Input['DatasetDatasetFormatDetailsArgs'] dataset_format_details: It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        :param pulumi.Input['DatasetDatasetSourceDetailsArgs'] dataset_source_details: This allows the customer to specify the source of the dataset.
        :param pulumi.Input['DatasetLabelSetArgs'] label_set: An ordered collection of labels that are unique by name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user provided description of the dataset
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input['DatasetInitialImportDatasetConfigurationArgs'] initial_import_dataset_configuration: Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        :param pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs'] initial_record_generation_configuration: The initial generate records configuration. It generates records from the dataset's source.
        :param pulumi.Input[builtins.str] labeling_instructions: (Updatable) The labeling instructions for human labelers in rich text format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "annotation_format", annotation_format)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "dataset_format_details", dataset_format_details)
        pulumi.set(__self__, "dataset_source_details", dataset_source_details)
        pulumi.set(__self__, "label_set", label_set)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_import_dataset_configuration is not None:
            pulumi.set(__self__, "initial_import_dataset_configuration", initial_import_dataset_configuration)
        if initial_record_generation_configuration is not None:
            pulumi.set(__self__, "initial_record_generation_configuration", initial_record_generation_configuration)
        if labeling_instructions is not None:
            pulumi.set(__self__, "labeling_instructions", labeling_instructions)

    @property
    @pulumi.getter(name="annotationFormat")
    def annotation_format(self) -> pulumi.Input[builtins.str]:
        """
        The annotation format name required for labeling records.
        """
        return pulumi.get(self, "annotation_format")

    @annotation_format.setter
    def annotation_format(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "annotation_format", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment of the resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="datasetFormatDetails")
    def dataset_format_details(self) -> pulumi.Input['DatasetDatasetFormatDetailsArgs']:
        """
        It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        """
        return pulumi.get(self, "dataset_format_details")

    @dataset_format_details.setter
    def dataset_format_details(self, value: pulumi.Input['DatasetDatasetFormatDetailsArgs']):
        pulumi.set(self, "dataset_format_details", value)

    @property
    @pulumi.getter(name="datasetSourceDetails")
    def dataset_source_details(self) -> pulumi.Input['DatasetDatasetSourceDetailsArgs']:
        """
        This allows the customer to specify the source of the dataset.
        """
        return pulumi.get(self, "dataset_source_details")

    @dataset_source_details.setter
    def dataset_source_details(self, value: pulumi.Input['DatasetDatasetSourceDetailsArgs']):
        pulumi.set(self, "dataset_source_details", value)

    @property
    @pulumi.getter(name="labelSet")
    def label_set(self) -> pulumi.Input['DatasetLabelSetArgs']:
        """
        An ordered collection of labels that are unique by name.
        """
        return pulumi.get(self, "label_set")

    @label_set.setter
    def label_set(self, value: pulumi.Input['DatasetLabelSetArgs']):
        pulumi.set(self, "label_set", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user provided description of the dataset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialImportDatasetConfiguration")
    def initial_import_dataset_configuration(self) -> Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']]:
        """
        Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        """
        return pulumi.get(self, "initial_import_dataset_configuration")

    @initial_import_dataset_configuration.setter
    def initial_import_dataset_configuration(self, value: Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']]):
        pulumi.set(self, "initial_import_dataset_configuration", value)

    @property
    @pulumi.getter(name="initialRecordGenerationConfiguration")
    def initial_record_generation_configuration(self) -> Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']]:
        """
        The initial generate records configuration. It generates records from the dataset's source.
        """
        return pulumi.get(self, "initial_record_generation_configuration")

    @initial_record_generation_configuration.setter
    def initial_record_generation_configuration(self, value: Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']]):
        pulumi.set(self, "initial_record_generation_configuration", value)

    @property
    @pulumi.getter(name="labelingInstructions")
    def labeling_instructions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The labeling instructions for human labelers in rich text format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "labeling_instructions")

    @labeling_instructions.setter
    def labeling_instructions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "labeling_instructions", value)


@pulumi.input_type
class _DatasetState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 annotation_format: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_format_details: Optional[pulumi.Input['DatasetDatasetFormatDetailsArgs']] = None,
                 dataset_source_details: Optional[pulumi.Input['DatasetDatasetSourceDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_import_dataset_configuration: Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']] = None,
                 initial_record_generation_configuration: Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']] = None,
                 label_set: Optional[pulumi.Input['DatasetLabelSetArgs']] = None,
                 labeling_instructions: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_substate: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Dataset resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] annotation_format: The annotation format name required for labeling records.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment of the resource.
        :param pulumi.Input['DatasetDatasetFormatDetailsArgs'] dataset_format_details: It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        :param pulumi.Input['DatasetDatasetSourceDetailsArgs'] dataset_source_details: This allows the customer to specify the source of the dataset.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user provided description of the dataset
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input['DatasetInitialImportDatasetConfigurationArgs'] initial_import_dataset_configuration: Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        :param pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs'] initial_record_generation_configuration: The initial generate records configuration. It generates records from the dataset's source.
        :param pulumi.Input['DatasetLabelSetArgs'] label_set: An ordered collection of labels that are unique by name.
        :param pulumi.Input[builtins.str] labeling_instructions: (Updatable) The labeling instructions for human labelers in rich text format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in FAILED or NEEDS_ATTENTION state.
        :param pulumi.Input[builtins.str] lifecycle_substate: The sub-state of the dataset. IMPORT_DATASET - The dataset is being imported.
        :param pulumi.Input[builtins.str] state: The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was last updated, in the timestamp format defined by RFC3339.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotation_format is not None:
            pulumi.set(__self__, "annotation_format", annotation_format)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if dataset_format_details is not None:
            pulumi.set(__self__, "dataset_format_details", dataset_format_details)
        if dataset_source_details is not None:
            pulumi.set(__self__, "dataset_source_details", dataset_source_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_import_dataset_configuration is not None:
            pulumi.set(__self__, "initial_import_dataset_configuration", initial_import_dataset_configuration)
        if initial_record_generation_configuration is not None:
            pulumi.set(__self__, "initial_record_generation_configuration", initial_record_generation_configuration)
        if label_set is not None:
            pulumi.set(__self__, "label_set", label_set)
        if labeling_instructions is not None:
            pulumi.set(__self__, "labeling_instructions", labeling_instructions)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate is not None:
            pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @property
    @pulumi.getter(name="annotationFormat")
    def annotation_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The annotation format name required for labeling records.
        """
        return pulumi.get(self, "annotation_format")

    @annotation_format.setter
    def annotation_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "annotation_format", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment of the resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="datasetFormatDetails")
    def dataset_format_details(self) -> Optional[pulumi.Input['DatasetDatasetFormatDetailsArgs']]:
        """
        It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        """
        return pulumi.get(self, "dataset_format_details")

    @dataset_format_details.setter
    def dataset_format_details(self, value: Optional[pulumi.Input['DatasetDatasetFormatDetailsArgs']]):
        pulumi.set(self, "dataset_format_details", value)

    @property
    @pulumi.getter(name="datasetSourceDetails")
    def dataset_source_details(self) -> Optional[pulumi.Input['DatasetDatasetSourceDetailsArgs']]:
        """
        This allows the customer to specify the source of the dataset.
        """
        return pulumi.get(self, "dataset_source_details")

    @dataset_source_details.setter
    def dataset_source_details(self, value: Optional[pulumi.Input['DatasetDatasetSourceDetailsArgs']]):
        pulumi.set(self, "dataset_source_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user provided description of the dataset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialImportDatasetConfiguration")
    def initial_import_dataset_configuration(self) -> Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']]:
        """
        Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        """
        return pulumi.get(self, "initial_import_dataset_configuration")

    @initial_import_dataset_configuration.setter
    def initial_import_dataset_configuration(self, value: Optional[pulumi.Input['DatasetInitialImportDatasetConfigurationArgs']]):
        pulumi.set(self, "initial_import_dataset_configuration", value)

    @property
    @pulumi.getter(name="initialRecordGenerationConfiguration")
    def initial_record_generation_configuration(self) -> Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']]:
        """
        The initial generate records configuration. It generates records from the dataset's source.
        """
        return pulumi.get(self, "initial_record_generation_configuration")

    @initial_record_generation_configuration.setter
    def initial_record_generation_configuration(self, value: Optional[pulumi.Input['DatasetInitialRecordGenerationConfigurationArgs']]):
        pulumi.set(self, "initial_record_generation_configuration", value)

    @property
    @pulumi.getter(name="labelSet")
    def label_set(self) -> Optional[pulumi.Input['DatasetLabelSetArgs']]:
        """
        An ordered collection of labels that are unique by name.
        """
        return pulumi.get(self, "label_set")

    @label_set.setter
    def label_set(self, value: Optional[pulumi.Input['DatasetLabelSetArgs']]):
        pulumi.set(self, "label_set", value)

    @property
    @pulumi.getter(name="labelingInstructions")
    def labeling_instructions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The labeling instructions for human labelers in rich text format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "labeling_instructions")

    @labeling_instructions.setter
    def labeling_instructions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "labeling_instructions", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in FAILED or NEEDS_ATTENTION state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sub-state of the dataset. IMPORT_DATASET - The dataset is being imported.
        """
        return pulumi.get(self, "lifecycle_substate")

    @lifecycle_substate.setter
    def lifecycle_substate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_substate", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was last updated, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataLabellingService/dataset:Dataset")
class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation_format: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_format_details: Optional[pulumi.Input[Union['DatasetDatasetFormatDetailsArgs', 'DatasetDatasetFormatDetailsArgsDict']]] = None,
                 dataset_source_details: Optional[pulumi.Input[Union['DatasetDatasetSourceDetailsArgs', 'DatasetDatasetSourceDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_import_dataset_configuration: Optional[pulumi.Input[Union['DatasetInitialImportDatasetConfigurationArgs', 'DatasetInitialImportDatasetConfigurationArgsDict']]] = None,
                 initial_record_generation_configuration: Optional[pulumi.Input[Union['DatasetInitialRecordGenerationConfigurationArgs', 'DatasetInitialRecordGenerationConfigurationArgsDict']]] = None,
                 label_set: Optional[pulumi.Input[Union['DatasetLabelSetArgs', 'DatasetLabelSetArgsDict']]] = None,
                 labeling_instructions: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Dataset resource in Oracle Cloud Infrastructure Data Labeling Service service.

        Creates a new Dataset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dataset = oci.data_labelling_service.Dataset("test_dataset",
            annotation_format=dataset_annotation_format,
            compartment_id=compartment_id,
            dataset_format_details={
                "format_type": dataset_dataset_format_details_format_type,
                "text_file_type_metadata": {
                    "column_index": dataset_dataset_format_details_text_file_type_metadata_column_index,
                    "format_type": dataset_dataset_format_details_text_file_type_metadata_format_type,
                    "column_delimiter": dataset_dataset_format_details_text_file_type_metadata_column_delimiter,
                    "column_name": dataset_dataset_format_details_text_file_type_metadata_column_name,
                    "escape_character": dataset_dataset_format_details_text_file_type_metadata_escape_character,
                    "line_delimiter": dataset_dataset_format_details_text_file_type_metadata_line_delimiter,
                },
            },
            dataset_source_details={
                "bucket": dataset_dataset_source_details_bucket,
                "namespace": dataset_dataset_source_details_namespace,
                "source_type": dataset_dataset_source_details_source_type,
                "prefix": dataset_dataset_source_details_prefix,
            },
            label_set={
                "items": [{
                    "name": dataset_label_set_items_name,
                }],
            },
            defined_tags=dataset_defined_tags,
            description=dataset_description,
            display_name=dataset_display_name,
            freeform_tags=dataset_freeform_tags,
            initial_import_dataset_configuration={
                "import_format": {
                    "name": dataset_initial_import_dataset_configuration_import_format_name,
                    "version": dataset_initial_import_dataset_configuration_import_format_version,
                },
                "import_metadata_path": {
                    "bucket": dataset_initial_import_dataset_configuration_import_metadata_path_bucket,
                    "namespace": dataset_initial_import_dataset_configuration_import_metadata_path_namespace,
                    "path": dataset_initial_import_dataset_configuration_import_metadata_path_path,
                    "source_type": dataset_initial_import_dataset_configuration_import_metadata_path_source_type,
                },
            },
            initial_record_generation_configuration={},
            labeling_instructions=dataset_labeling_instructions)
        ```

        ## Import

        Datasets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataLabellingService/dataset:Dataset test_dataset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] annotation_format: The annotation format name required for labeling records.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment of the resource.
        :param pulumi.Input[Union['DatasetDatasetFormatDetailsArgs', 'DatasetDatasetFormatDetailsArgsDict']] dataset_format_details: It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        :param pulumi.Input[Union['DatasetDatasetSourceDetailsArgs', 'DatasetDatasetSourceDetailsArgsDict']] dataset_source_details: This allows the customer to specify the source of the dataset.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user provided description of the dataset
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['DatasetInitialImportDatasetConfigurationArgs', 'DatasetInitialImportDatasetConfigurationArgsDict']] initial_import_dataset_configuration: Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        :param pulumi.Input[Union['DatasetInitialRecordGenerationConfigurationArgs', 'DatasetInitialRecordGenerationConfigurationArgsDict']] initial_record_generation_configuration: The initial generate records configuration. It generates records from the dataset's source.
        :param pulumi.Input[Union['DatasetLabelSetArgs', 'DatasetLabelSetArgsDict']] label_set: An ordered collection of labels that are unique by name.
        :param pulumi.Input[builtins.str] labeling_instructions: (Updatable) The labeling instructions for human labelers in rich text format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dataset resource in Oracle Cloud Infrastructure Data Labeling Service service.

        Creates a new Dataset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dataset = oci.data_labelling_service.Dataset("test_dataset",
            annotation_format=dataset_annotation_format,
            compartment_id=compartment_id,
            dataset_format_details={
                "format_type": dataset_dataset_format_details_format_type,
                "text_file_type_metadata": {
                    "column_index": dataset_dataset_format_details_text_file_type_metadata_column_index,
                    "format_type": dataset_dataset_format_details_text_file_type_metadata_format_type,
                    "column_delimiter": dataset_dataset_format_details_text_file_type_metadata_column_delimiter,
                    "column_name": dataset_dataset_format_details_text_file_type_metadata_column_name,
                    "escape_character": dataset_dataset_format_details_text_file_type_metadata_escape_character,
                    "line_delimiter": dataset_dataset_format_details_text_file_type_metadata_line_delimiter,
                },
            },
            dataset_source_details={
                "bucket": dataset_dataset_source_details_bucket,
                "namespace": dataset_dataset_source_details_namespace,
                "source_type": dataset_dataset_source_details_source_type,
                "prefix": dataset_dataset_source_details_prefix,
            },
            label_set={
                "items": [{
                    "name": dataset_label_set_items_name,
                }],
            },
            defined_tags=dataset_defined_tags,
            description=dataset_description,
            display_name=dataset_display_name,
            freeform_tags=dataset_freeform_tags,
            initial_import_dataset_configuration={
                "import_format": {
                    "name": dataset_initial_import_dataset_configuration_import_format_name,
                    "version": dataset_initial_import_dataset_configuration_import_format_version,
                },
                "import_metadata_path": {
                    "bucket": dataset_initial_import_dataset_configuration_import_metadata_path_bucket,
                    "namespace": dataset_initial_import_dataset_configuration_import_metadata_path_namespace,
                    "path": dataset_initial_import_dataset_configuration_import_metadata_path_path,
                    "source_type": dataset_initial_import_dataset_configuration_import_metadata_path_source_type,
                },
            },
            initial_record_generation_configuration={},
            labeling_instructions=dataset_labeling_instructions)
        ```

        ## Import

        Datasets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataLabellingService/dataset:Dataset test_dataset "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotation_format: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_format_details: Optional[pulumi.Input[Union['DatasetDatasetFormatDetailsArgs', 'DatasetDatasetFormatDetailsArgsDict']]] = None,
                 dataset_source_details: Optional[pulumi.Input[Union['DatasetDatasetSourceDetailsArgs', 'DatasetDatasetSourceDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_import_dataset_configuration: Optional[pulumi.Input[Union['DatasetInitialImportDatasetConfigurationArgs', 'DatasetInitialImportDatasetConfigurationArgsDict']]] = None,
                 initial_record_generation_configuration: Optional[pulumi.Input[Union['DatasetInitialRecordGenerationConfigurationArgs', 'DatasetInitialRecordGenerationConfigurationArgsDict']]] = None,
                 label_set: Optional[pulumi.Input[Union['DatasetLabelSetArgs', 'DatasetLabelSetArgsDict']]] = None,
                 labeling_instructions: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            if annotation_format is None and not opts.urn:
                raise TypeError("Missing required property 'annotation_format'")
            __props__.__dict__["annotation_format"] = annotation_format
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if dataset_format_details is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_format_details'")
            __props__.__dict__["dataset_format_details"] = dataset_format_details
            if dataset_source_details is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_source_details'")
            __props__.__dict__["dataset_source_details"] = dataset_source_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["initial_import_dataset_configuration"] = initial_import_dataset_configuration
            __props__.__dict__["initial_record_generation_configuration"] = initial_record_generation_configuration
            if label_set is None and not opts.urn:
                raise TypeError("Missing required property 'label_set'")
            __props__.__dict__["label_set"] = label_set
            __props__.__dict__["labeling_instructions"] = labeling_instructions
            __props__.__dict__["additional_properties"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_substate"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Dataset, __self__).__init__(
            'oci:DataLabellingService/dataset:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            annotation_format: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            dataset_format_details: Optional[pulumi.Input[Union['DatasetDatasetFormatDetailsArgs', 'DatasetDatasetFormatDetailsArgsDict']]] = None,
            dataset_source_details: Optional[pulumi.Input[Union['DatasetDatasetSourceDetailsArgs', 'DatasetDatasetSourceDetailsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            initial_import_dataset_configuration: Optional[pulumi.Input[Union['DatasetInitialImportDatasetConfigurationArgs', 'DatasetInitialImportDatasetConfigurationArgsDict']]] = None,
            initial_record_generation_configuration: Optional[pulumi.Input[Union['DatasetInitialRecordGenerationConfigurationArgs', 'DatasetInitialRecordGenerationConfigurationArgsDict']]] = None,
            label_set: Optional[pulumi.Input[Union['DatasetLabelSetArgs', 'DatasetLabelSetArgsDict']]] = None,
            labeling_instructions: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_substate: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_properties: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] annotation_format: The annotation format name required for labeling records.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment of the resource.
        :param pulumi.Input[Union['DatasetDatasetFormatDetailsArgs', 'DatasetDatasetFormatDetailsArgsDict']] dataset_format_details: It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        :param pulumi.Input[Union['DatasetDatasetSourceDetailsArgs', 'DatasetDatasetSourceDetailsArgsDict']] dataset_source_details: This allows the customer to specify the source of the dataset.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user provided description of the dataset
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['DatasetInitialImportDatasetConfigurationArgs', 'DatasetInitialImportDatasetConfigurationArgsDict']] initial_import_dataset_configuration: Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        :param pulumi.Input[Union['DatasetInitialRecordGenerationConfigurationArgs', 'DatasetInitialRecordGenerationConfigurationArgsDict']] initial_record_generation_configuration: The initial generate records configuration. It generates records from the dataset's source.
        :param pulumi.Input[Union['DatasetLabelSetArgs', 'DatasetLabelSetArgsDict']] label_set: An ordered collection of labels that are unique by name.
        :param pulumi.Input[builtins.str] labeling_instructions: (Updatable) The labeling instructions for human labelers in rich text format
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in FAILED or NEEDS_ATTENTION state.
        :param pulumi.Input[builtins.str] lifecycle_substate: The sub-state of the dataset. IMPORT_DATASET - The dataset is being imported.
        :param pulumi.Input[builtins.str] state: The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was last updated, in the timestamp format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetState.__new__(_DatasetState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotation_format"] = annotation_format
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["dataset_format_details"] = dataset_format_details
        __props__.__dict__["dataset_source_details"] = dataset_source_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["initial_import_dataset_configuration"] = initial_import_dataset_configuration
        __props__.__dict__["initial_record_generation_configuration"] = initial_record_generation_configuration
        __props__.__dict__["label_set"] = label_set
        __props__.__dict__["labeling_instructions"] = labeling_instructions
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_substate"] = lifecycle_substate
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="annotationFormat")
    def annotation_format(self) -> pulumi.Output[builtins.str]:
        """
        The annotation format name required for labeling records.
        """
        return pulumi.get(self, "annotation_format")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment of the resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="datasetFormatDetails")
    def dataset_format_details(self) -> pulumi.Output['outputs.DatasetDatasetFormatDetails']:
        """
        It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        """
        return pulumi.get(self, "dataset_format_details")

    @property
    @pulumi.getter(name="datasetSourceDetails")
    def dataset_source_details(self) -> pulumi.Output['outputs.DatasetDatasetSourceDetails']:
        """
        This allows the customer to specify the source of the dataset.
        """
        return pulumi.get(self, "dataset_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user provided description of the dataset
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initialImportDatasetConfiguration")
    def initial_import_dataset_configuration(self) -> pulumi.Output['outputs.DatasetInitialImportDatasetConfiguration']:
        """
        Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        """
        return pulumi.get(self, "initial_import_dataset_configuration")

    @property
    @pulumi.getter(name="initialRecordGenerationConfiguration")
    def initial_record_generation_configuration(self) -> pulumi.Output['outputs.DatasetInitialRecordGenerationConfiguration']:
        """
        The initial generate records configuration. It generates records from the dataset's source.
        """
        return pulumi.get(self, "initial_record_generation_configuration")

    @property
    @pulumi.getter(name="labelSet")
    def label_set(self) -> pulumi.Output['outputs.DatasetLabelSet']:
        """
        An ordered collection of labels that are unique by name.
        """
        return pulumi.get(self, "label_set")

    @property
    @pulumi.getter(name="labelingInstructions")
    def labeling_instructions(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The labeling instructions for human labelers in rich text format


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "labeling_instructions")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in FAILED or NEEDS_ATTENTION state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> pulumi.Output[builtins.str]:
        """
        The sub-state of the dataset. IMPORT_DATASET - The dataset is being imported.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was last updated, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

