# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['ScheduleActionArgs'],
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 trigger: pulumi.Input['ScheduleTriggerArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 log_details: Optional[pulumi.Input['ScheduleLogDetailsArgs']] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input['ScheduleActionArgs'] action: (Updatable) The schedule action
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        :param pulumi.Input['ScheduleTriggerArgs'] trigger: (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['ScheduleLogDetailsArgs'] log_details: (Updatable) Custom logging details for schedule execution.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "trigger", trigger)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if log_details is not None:
            pulumi.set(__self__, "log_details", log_details)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['ScheduleActionArgs']:
        """
        (Updatable) The schedule action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['ScheduleActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input['ScheduleTriggerArgs']:
        """
        (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input['ScheduleTriggerArgs']):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Optional[pulumi.Input['ScheduleLogDetailsArgs']]:
        """
        (Updatable) Custom logging details for schedule execution.
        """
        return pulumi.get(self, "log_details")

    @log_details.setter
    def log_details(self, value: Optional[pulumi.Input['ScheduleLogDetailsArgs']]):
        pulumi.set(self, "log_details", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['ScheduleActionArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 last_schedule_run_details: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 log_details: Optional[pulumi.Input['ScheduleLogDetailsArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_schedule_run: Optional[pulumi.Input[builtins.str]] = None,
                 time_next_scheduled_run: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input['ScheduleTriggerArgs']] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input['ScheduleActionArgs'] action: (Updatable) The schedule action
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        :param pulumi.Input[builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the schedule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_schedule_run_details: Details about the action performed by the last schedule execution. Example: `Invoked ML Application trigger.`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input['ScheduleLogDetailsArgs'] log_details: (Updatable) Custom logging details for schedule execution.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        :param pulumi.Input[builtins.str] state: The current state of the schedule.           Example: `ACTIVE`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the schedule was created. Format is defined by RFC3339.           Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_last_schedule_run: The last schedule execution time. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_next_scheduled_run: The next scheduled execution time for the schedule. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the schedule was updated. Format is defined by RFC3339.           Example: `2022-09-05T01:02:29.600Z`
        :param pulumi.Input['ScheduleTriggerArgs'] trigger: (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_schedule_run_details is not None:
            pulumi.set(__self__, "last_schedule_run_details", last_schedule_run_details)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_details is not None:
            pulumi.set(__self__, "log_details", log_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_schedule_run is not None:
            pulumi.set(__self__, "time_last_schedule_run", time_last_schedule_run)
        if time_next_scheduled_run is not None:
            pulumi.set(__self__, "time_next_scheduled_run", time_next_scheduled_run)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['ScheduleActionArgs']]:
        """
        (Updatable) The schedule action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['ScheduleActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lastScheduleRunDetails")
    def last_schedule_run_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Details about the action performed by the last schedule execution. Example: `Invoked ML Application trigger.`
        """
        return pulumi.get(self, "last_schedule_run_details")

    @last_schedule_run_details.setter
    def last_schedule_run_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_schedule_run_details", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Optional[pulumi.Input['ScheduleLogDetailsArgs']]:
        """
        (Updatable) Custom logging details for schedule execution.
        """
        return pulumi.get(self, "log_details")

    @log_details.setter
    def log_details(self, value: Optional[pulumi.Input['ScheduleLogDetailsArgs']]):
        pulumi.set(self, "log_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the schedule.           Example: `ACTIVE`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the schedule was created. Format is defined by RFC3339.           Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastScheduleRun")
    def time_last_schedule_run(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last schedule execution time. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_last_schedule_run")

    @time_last_schedule_run.setter
    def time_last_schedule_run(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_schedule_run", value)

    @property
    @pulumi.getter(name="timeNextScheduledRun")
    def time_next_scheduled_run(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next scheduled execution time for the schedule. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_next_scheduled_run")

    @time_next_scheduled_run.setter
    def time_next_scheduled_run(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_next_scheduled_run", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the schedule was updated. Format is defined by RFC3339.           Example: `2022-09-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['ScheduleTriggerArgs']]:
        """
        (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['ScheduleTriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.type_token("oci:DataScience/schedule:Schedule")
class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduleActionArgs', 'ScheduleActionArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 log_details: Optional[pulumi.Input[Union['ScheduleLogDetailsArgs', 'ScheduleLogDetailsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input[Union['ScheduleTriggerArgs', 'ScheduleTriggerArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Schedule resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_schedule = oci.data_science.Schedule("test_schedule",
            action={
                "action_details": {
                    "http_action_type": schedule_action_action_details_http_action_type,
                    "create_job_run_details": {
                        "compartment_id": compartment_id,
                        "defined_tags": {
                            "Operations.CostCenter": "42",
                        },
                        "display_name": schedule_action_action_details_create_job_run_details_display_name,
                        "freeform_tags": {
                            "Department": "Finance",
                        },
                        "job_configuration_override_details": {
                            "job_type": schedule_action_action_details_create_job_run_details_job_configuration_override_details_job_type,
                            "command_line_arguments": schedule_action_action_details_create_job_run_details_job_configuration_override_details_command_line_arguments,
                            "environment_variables": schedule_action_action_details_create_job_run_details_job_configuration_override_details_environment_variables,
                            "maximum_runtime_in_minutes": schedule_action_action_details_create_job_run_details_job_configuration_override_details_maximum_runtime_in_minutes,
                        },
                        "job_environment_configuration_override_details": {
                            "image": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_image,
                            "job_environment_type": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_job_environment_type,
                            "cmds": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_cmd,
                            "entrypoints": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_entrypoint,
                            "image_digest": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_image_digest,
                            "image_signature_id": test_image_signature["id"],
                        },
                        "job_id": test_job["id"],
                        "job_log_configuration_override_details": {
                            "enable_auto_log_creation": schedule_action_action_details_create_job_run_details_job_log_configuration_override_details_enable_auto_log_creation,
                            "enable_logging": schedule_action_action_details_create_job_run_details_job_log_configuration_override_details_enable_logging,
                            "log_group_id": test_log_group["id"],
                            "log_id": test_log["id"],
                        },
                        "project_id": test_project["id"],
                    },
                    "create_pipeline_run_details": {
                        "compartment_id": compartment_id,
                        "configuration_override_details": {
                            "type": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_type,
                            "command_line_arguments": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_command_line_arguments,
                            "environment_variables": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_environment_variables,
                            "maximum_runtime_in_minutes": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_maximum_runtime_in_minutes,
                        },
                        "defined_tags": {
                            "Operations.CostCenter": "42",
                        },
                        "display_name": schedule_action_action_details_create_pipeline_run_details_display_name,
                        "freeform_tags": {
                            "Department": "Finance",
                        },
                        "log_configuration_override_details": {
                            "enable_auto_log_creation": schedule_action_action_details_create_pipeline_run_details_log_configuration_override_details_enable_auto_log_creation,
                            "enable_logging": schedule_action_action_details_create_pipeline_run_details_log_configuration_override_details_enable_logging,
                            "log_group_id": test_log_group["id"],
                            "log_id": test_log["id"],
                        },
                        "pipeline_id": test_pipeline["id"],
                        "project_id": test_project["id"],
                        "step_override_details": [{
                            "step_configuration_details": {
                                "command_line_arguments": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_command_line_arguments,
                                "environment_variables": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_environment_variables,
                                "maximum_runtime_in_minutes": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_maximum_runtime_in_minutes,
                            },
                            "step_container_configuration_details": {
                                "container_type": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_container_type,
                                "image": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_image,
                                "cmds": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_cmd,
                                "entrypoints": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_entrypoint,
                                "image_digest": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_image_digest,
                                "image_signature_id": test_image_signature["id"],
                            },
                            "step_name": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_name,
                        }],
                        "system_tags": schedule_action_action_details_create_pipeline_run_details_system_tags,
                    },
                    "ml_application_instance_view_id": test_view["id"],
                    "trigger_ml_application_instance_view_flow_details": {
                        "parameters": [{
                            "name": schedule_action_action_details_trigger_ml_application_instance_view_flow_details_parameters_name,
                            "value": schedule_action_action_details_trigger_ml_application_instance_view_flow_details_parameters_value,
                        }],
                        "trigger_name": test_trigger["name"],
                    },
                },
                "action_type": schedule_action_action_type,
            },
            compartment_id=compartment_id,
            display_name=schedule_display_name,
            project_id=test_project["id"],
            trigger={
                "trigger_type": schedule_trigger_trigger_type,
                "cron_expression": schedule_trigger_cron_expression,
                "frequency": schedule_trigger_frequency,
                "interval": schedule_trigger_interval,
                "is_random_start_time": schedule_trigger_is_random_start_time,
                "recurrence": schedule_trigger_recurrence,
                "time_end": schedule_trigger_time_end,
                "time_start": schedule_trigger_time_start,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=schedule_description,
            freeform_tags={
                "Department": "Finance",
            },
            log_details={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            })
        ```

        ## Import

        Schedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/schedule:Schedule test_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduleActionArgs', 'ScheduleActionArgsDict']] action: (Updatable) The schedule action
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the schedule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['ScheduleLogDetailsArgs', 'ScheduleLogDetailsArgsDict']] log_details: (Updatable) Custom logging details for schedule execution.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        :param pulumi.Input[Union['ScheduleTriggerArgs', 'ScheduleTriggerArgsDict']] trigger: (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Schedule resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_schedule = oci.data_science.Schedule("test_schedule",
            action={
                "action_details": {
                    "http_action_type": schedule_action_action_details_http_action_type,
                    "create_job_run_details": {
                        "compartment_id": compartment_id,
                        "defined_tags": {
                            "Operations.CostCenter": "42",
                        },
                        "display_name": schedule_action_action_details_create_job_run_details_display_name,
                        "freeform_tags": {
                            "Department": "Finance",
                        },
                        "job_configuration_override_details": {
                            "job_type": schedule_action_action_details_create_job_run_details_job_configuration_override_details_job_type,
                            "command_line_arguments": schedule_action_action_details_create_job_run_details_job_configuration_override_details_command_line_arguments,
                            "environment_variables": schedule_action_action_details_create_job_run_details_job_configuration_override_details_environment_variables,
                            "maximum_runtime_in_minutes": schedule_action_action_details_create_job_run_details_job_configuration_override_details_maximum_runtime_in_minutes,
                        },
                        "job_environment_configuration_override_details": {
                            "image": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_image,
                            "job_environment_type": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_job_environment_type,
                            "cmds": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_cmd,
                            "entrypoints": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_entrypoint,
                            "image_digest": schedule_action_action_details_create_job_run_details_job_environment_configuration_override_details_image_digest,
                            "image_signature_id": test_image_signature["id"],
                        },
                        "job_id": test_job["id"],
                        "job_log_configuration_override_details": {
                            "enable_auto_log_creation": schedule_action_action_details_create_job_run_details_job_log_configuration_override_details_enable_auto_log_creation,
                            "enable_logging": schedule_action_action_details_create_job_run_details_job_log_configuration_override_details_enable_logging,
                            "log_group_id": test_log_group["id"],
                            "log_id": test_log["id"],
                        },
                        "project_id": test_project["id"],
                    },
                    "create_pipeline_run_details": {
                        "compartment_id": compartment_id,
                        "configuration_override_details": {
                            "type": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_type,
                            "command_line_arguments": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_command_line_arguments,
                            "environment_variables": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_environment_variables,
                            "maximum_runtime_in_minutes": schedule_action_action_details_create_pipeline_run_details_configuration_override_details_maximum_runtime_in_minutes,
                        },
                        "defined_tags": {
                            "Operations.CostCenter": "42",
                        },
                        "display_name": schedule_action_action_details_create_pipeline_run_details_display_name,
                        "freeform_tags": {
                            "Department": "Finance",
                        },
                        "log_configuration_override_details": {
                            "enable_auto_log_creation": schedule_action_action_details_create_pipeline_run_details_log_configuration_override_details_enable_auto_log_creation,
                            "enable_logging": schedule_action_action_details_create_pipeline_run_details_log_configuration_override_details_enable_logging,
                            "log_group_id": test_log_group["id"],
                            "log_id": test_log["id"],
                        },
                        "pipeline_id": test_pipeline["id"],
                        "project_id": test_project["id"],
                        "step_override_details": [{
                            "step_configuration_details": {
                                "command_line_arguments": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_command_line_arguments,
                                "environment_variables": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_environment_variables,
                                "maximum_runtime_in_minutes": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_configuration_details_maximum_runtime_in_minutes,
                            },
                            "step_container_configuration_details": {
                                "container_type": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_container_type,
                                "image": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_image,
                                "cmds": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_cmd,
                                "entrypoints": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_entrypoint,
                                "image_digest": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_container_configuration_details_image_digest,
                                "image_signature_id": test_image_signature["id"],
                            },
                            "step_name": schedule_action_action_details_create_pipeline_run_details_step_override_details_step_name,
                        }],
                        "system_tags": schedule_action_action_details_create_pipeline_run_details_system_tags,
                    },
                    "ml_application_instance_view_id": test_view["id"],
                    "trigger_ml_application_instance_view_flow_details": {
                        "parameters": [{
                            "name": schedule_action_action_details_trigger_ml_application_instance_view_flow_details_parameters_name,
                            "value": schedule_action_action_details_trigger_ml_application_instance_view_flow_details_parameters_value,
                        }],
                        "trigger_name": test_trigger["name"],
                    },
                },
                "action_type": schedule_action_action_type,
            },
            compartment_id=compartment_id,
            display_name=schedule_display_name,
            project_id=test_project["id"],
            trigger={
                "trigger_type": schedule_trigger_trigger_type,
                "cron_expression": schedule_trigger_cron_expression,
                "frequency": schedule_trigger_frequency,
                "interval": schedule_trigger_interval,
                "is_random_start_time": schedule_trigger_is_random_start_time,
                "recurrence": schedule_trigger_recurrence,
                "time_end": schedule_trigger_time_end,
                "time_start": schedule_trigger_time_start,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=schedule_description,
            freeform_tags={
                "Department": "Finance",
            },
            log_details={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            })
        ```

        ## Import

        Schedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/schedule:Schedule test_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduleActionArgs', 'ScheduleActionArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 log_details: Optional[pulumi.Input[Union['ScheduleLogDetailsArgs', 'ScheduleLogDetailsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input[Union['ScheduleTriggerArgs', 'ScheduleTriggerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["log_details"] = log_details
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["created_by"] = None
            __props__.__dict__["last_schedule_run_details"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_schedule_run"] = None
            __props__.__dict__["time_next_scheduled_run"] = None
            __props__.__dict__["time_updated"] = None
        super(Schedule, __self__).__init__(
            'oci:DataScience/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['ScheduleActionArgs', 'ScheduleActionArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            last_schedule_run_details: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            log_details: Optional[pulumi.Input[Union['ScheduleLogDetailsArgs', 'ScheduleLogDetailsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_schedule_run: Optional[pulumi.Input[builtins.str]] = None,
            time_next_scheduled_run: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            trigger: Optional[pulumi.Input[Union['ScheduleTriggerArgs', 'ScheduleTriggerArgsDict']]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduleActionArgs', 'ScheduleActionArgsDict']] action: (Updatable) The schedule action
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        :param pulumi.Input[builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the schedule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_schedule_run_details: Details about the action performed by the last schedule execution. Example: `Invoked ML Application trigger.`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input[Union['ScheduleLogDetailsArgs', 'ScheduleLogDetailsArgsDict']] log_details: (Updatable) Custom logging details for schedule execution.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        :param pulumi.Input[builtins.str] state: The current state of the schedule.           Example: `ACTIVE`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the schedule was created. Format is defined by RFC3339.           Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_last_schedule_run: The last schedule execution time. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_next_scheduled_run: The next scheduled execution time for the schedule. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the schedule was updated. Format is defined by RFC3339.           Example: `2022-09-05T01:02:29.600Z`
        :param pulumi.Input[Union['ScheduleTriggerArgs', 'ScheduleTriggerArgsDict']] trigger: (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_schedule_run_details"] = last_schedule_run_details
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["log_details"] = log_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_schedule_run"] = time_last_schedule_run
        __props__.__dict__["time_next_scheduled_run"] = time_next_scheduled_run
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trigger"] = trigger
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.ScheduleAction']:
        """
        (Updatable) The schedule action
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the schedule.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A short description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lastScheduleRunDetails")
    def last_schedule_run_details(self) -> pulumi.Output[builtins.str]:
        """
        Details about the action performed by the last schedule execution. Example: `Invoked ML Application trigger.`
        """
        return pulumi.get(self, "last_schedule_run_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> pulumi.Output[Optional['outputs.ScheduleLogDetails']]:
        """
        (Updatable) Custom logging details for schedule execution.
        """
        return pulumi.get(self, "log_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the schedule with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the schedule.           Example: `ACTIVE`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the schedule was created. Format is defined by RFC3339.           Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastScheduleRun")
    def time_last_schedule_run(self) -> pulumi.Output[builtins.str]:
        """
        The last schedule execution time. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_last_schedule_run")

    @property
    @pulumi.getter(name="timeNextScheduledRun")
    def time_next_scheduled_run(self) -> pulumi.Output[builtins.str]:
        """
        The next scheduled execution time for the schedule. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_next_scheduled_run")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the schedule was updated. Format is defined by RFC3339.           Example: `2022-09-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output['outputs.ScheduleTrigger']:
        """
        (Updatable) The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        return pulumi.get(self, "trigger")

