# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVulnerabilityScanResult',
    'AwaitableGetVulnerabilityScanResult',
    'get_vulnerability_scan',
    'get_vulnerability_scan_output',
]

@pulumi.output_type
class GetVulnerabilityScanResult:
    """
    A collection of values returned by getVulnerabilityScan.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, state=None, system_tags=None, time_created=None, time_ended=None, vulnerability_scan_id=None, vulnerability_scan_message=None, vulnerability_scan_status=None, vulnerability_scan_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if vulnerability_scan_id and not isinstance(vulnerability_scan_id, str):
            raise TypeError("Expected argument 'vulnerability_scan_id' to be a str")
        pulumi.set(__self__, "vulnerability_scan_id", vulnerability_scan_id)
        if vulnerability_scan_message and not isinstance(vulnerability_scan_message, str):
            raise TypeError("Expected argument 'vulnerability_scan_message' to be a str")
        pulumi.set(__self__, "vulnerability_scan_message", vulnerability_scan_message)
        if vulnerability_scan_status and not isinstance(vulnerability_scan_status, str):
            raise TypeError("Expected argument 'vulnerability_scan_status' to be a str")
        pulumi.set(__self__, "vulnerability_scan_status", vulnerability_scan_status)
        if vulnerability_scan_type and not isinstance(vulnerability_scan_type, str):
            raise TypeError("Expected argument 'vulnerability_scan_type' to be a str")
        pulumi.set(__self__, "vulnerability_scan_type", vulnerability_scan_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VulnerabilityScan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the VulnerabilityScan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the VulnerabilityScan was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> builtins.str:
        """
        The date and time the VulnerabilityScan was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="vulnerabilityScanId")
    def vulnerability_scan_id(self) -> builtins.str:
        return pulumi.get(self, "vulnerability_scan_id")

    @property
    @pulumi.getter(name="vulnerabilityScanMessage")
    def vulnerability_scan_message(self) -> builtins.str:
        """
        The message of the vulnerability scan status.
        """
        return pulumi.get(self, "vulnerability_scan_message")

    @property
    @pulumi.getter(name="vulnerabilityScanStatus")
    def vulnerability_scan_status(self) -> builtins.str:
        """
        The status of the vulnerability scan.
        """
        return pulumi.get(self, "vulnerability_scan_status")

    @property
    @pulumi.getter(name="vulnerabilityScanType")
    def vulnerability_scan_type(self) -> builtins.str:
        """
        Scan type is CVE, PATCH or IMAGE_PATCH
        """
        return pulumi.get(self, "vulnerability_scan_type")


class AwaitableGetVulnerabilityScanResult(GetVulnerabilityScanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityScanResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_ended=self.time_ended,
            vulnerability_scan_id=self.vulnerability_scan_id,
            vulnerability_scan_message=self.vulnerability_scan_message,
            vulnerability_scan_status=self.vulnerability_scan_status,
            vulnerability_scan_type=self.vulnerability_scan_type)


def get_vulnerability_scan(vulnerability_scan_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityScanResult:
    """
    This data source provides details about a specific Vulnerability Scan resource in Oracle Cloud Infrastructure Dblm service.

    Gets information about a VulnerabilityScan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_scan = oci.Dblm.get_vulnerability_scan(vulnerability_scan_id=test_vulnerability_scan_oci_dblm_vulnerability_scan["id"])
    ```


    :param builtins.str vulnerability_scan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VulnerabilityScan.
    """
    __args__ = dict()
    __args__['vulnerabilityScanId'] = vulnerability_scan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerabilityScan:getVulnerabilityScan', __args__, opts=opts, typ=GetVulnerabilityScanResult).value

    return AwaitableGetVulnerabilityScanResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        vulnerability_scan_id=pulumi.get(__ret__, 'vulnerability_scan_id'),
        vulnerability_scan_message=pulumi.get(__ret__, 'vulnerability_scan_message'),
        vulnerability_scan_status=pulumi.get(__ret__, 'vulnerability_scan_status'),
        vulnerability_scan_type=pulumi.get(__ret__, 'vulnerability_scan_type'))
def get_vulnerability_scan_output(vulnerability_scan_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityScanResult]:
    """
    This data source provides details about a specific Vulnerability Scan resource in Oracle Cloud Infrastructure Dblm service.

    Gets information about a VulnerabilityScan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_scan = oci.Dblm.get_vulnerability_scan(vulnerability_scan_id=test_vulnerability_scan_oci_dblm_vulnerability_scan["id"])
    ```


    :param builtins.str vulnerability_scan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VulnerabilityScan.
    """
    __args__ = dict()
    __args__['vulnerabilityScanId'] = vulnerability_scan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerabilityScan:getVulnerabilityScan', __args__, opts=opts, typ=GetVulnerabilityScanResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityScanResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        vulnerability_scan_id=pulumi.get(__response__, 'vulnerability_scan_id'),
        vulnerability_scan_message=pulumi.get(__response__, 'vulnerability_scan_message'),
        vulnerability_scan_status=pulumi.get(__response__, 'vulnerability_scan_status'),
        vulnerability_scan_type=pulumi.get(__response__, 'vulnerability_scan_type')))
