# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DesktopPoolArgs', 'DesktopPool']

@pulumi.input_type
class DesktopPoolArgs:
    def __init__(__self__, *,
                 are_privileged_users: pulumi.Input[builtins.bool],
                 availability_domain: pulumi.Input[builtins.str],
                 availability_policy: pulumi.Input['DesktopPoolAvailabilityPolicyArgs'],
                 compartment_id: pulumi.Input[builtins.str],
                 contact_details: pulumi.Input[builtins.str],
                 device_policy: pulumi.Input['DesktopPoolDevicePolicyArgs'],
                 display_name: pulumi.Input[builtins.str],
                 image: pulumi.Input['DesktopPoolImageArgs'],
                 is_storage_enabled: pulumi.Input[builtins.bool],
                 maximum_size: pulumi.Input[builtins.int],
                 network_configuration: pulumi.Input['DesktopPoolNetworkConfigurationArgs'],
                 shape_name: pulumi.Input[builtins.str],
                 standby_size: pulumi.Input[builtins.int],
                 storage_backup_policy_id: pulumi.Input[builtins.str],
                 storage_size_in_gbs: pulumi.Input[builtins.int],
                 are_volumes_preserved: Optional[pulumi.Input[builtins.bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_access_details: Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']] = None,
                 session_lifecycle_actions: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']] = None,
                 shape_config: Optional[pulumi.Input['DesktopPoolShapeConfigArgs']] = None,
                 time_start_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_stop_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 use_dedicated_vm_host: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DesktopPool resource.
        :param pulumi.Input[builtins.bool] are_privileged_users: Indicates whether desktop pool users have administrative privileges on their desktop.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the desktop pool.
        :param pulumi.Input['DesktopPoolAvailabilityPolicyArgs'] availability_policy: (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment which will contain the desktop pool.
        :param pulumi.Input[builtins.str] contact_details: (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        :param pulumi.Input['DesktopPoolDevicePolicyArgs'] device_policy: (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user friendly display name. Avoid entering confidential information.
        :param pulumi.Input['DesktopPoolImageArgs'] image: Provides information about the desktop image.
        :param pulumi.Input[builtins.bool] is_storage_enabled: Indicates whether storage is enabled for the desktop pool.
        :param pulumi.Input[builtins.int] maximum_size: (Updatable) The maximum number of desktops permitted in the desktop pool.
        :param pulumi.Input['DesktopPoolNetworkConfigurationArgs'] network_configuration: Provides information about the network configuration of the desktop pool.
        :param pulumi.Input[builtins.str] shape_name: The shape of the desktop pool.
        :param pulumi.Input[builtins.int] standby_size: (Updatable) The maximum number of standby desktops available in the desktop pool.
        :param pulumi.Input[builtins.str] storage_backup_policy_id: The backup policy OCID of the storage.
        :param pulumi.Input[builtins.int] storage_size_in_gbs: The size in GBs of the storage for the desktop pool.
        :param pulumi.Input[builtins.bool] are_volumes_preserved: (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: A list of network security groups for the private access.
        :param pulumi.Input['DesktopPoolPrivateAccessDetailsArgs'] private_access_details: The details of the desktop's private access network connectivity to be set up for the desktop pool.
        :param pulumi.Input['DesktopPoolSessionLifecycleActionsArgs'] session_lifecycle_actions: The details of action to be triggered in case of inactivity or disconnect
        :param pulumi.Input['DesktopPoolShapeConfigArgs'] shape_config: The compute instance shape configuration requested for each desktop in the desktop pool.
        :param pulumi.Input[builtins.str] time_start_scheduled: (Updatable) The start time of the desktop pool.
        :param pulumi.Input[builtins.str] time_stop_scheduled: (Updatable) The stop time of the desktop pool.
        :param pulumi.Input[builtins.str] use_dedicated_vm_host: Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        pulumi.set(__self__, "are_privileged_users", are_privileged_users)
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "availability_policy", availability_policy)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "device_policy", device_policy)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "is_storage_enabled", is_storage_enabled)
        pulumi.set(__self__, "maximum_size", maximum_size)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "standby_size", standby_size)
        pulumi.set(__self__, "storage_backup_policy_id", storage_backup_policy_id)
        pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if are_volumes_preserved is not None:
            pulumi.set(__self__, "are_volumes_preserved", are_volumes_preserved)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_access_details is not None:
            pulumi.set(__self__, "private_access_details", private_access_details)
        if session_lifecycle_actions is not None:
            pulumi.set(__self__, "session_lifecycle_actions", session_lifecycle_actions)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)
        if time_start_scheduled is not None:
            pulumi.set(__self__, "time_start_scheduled", time_start_scheduled)
        if time_stop_scheduled is not None:
            pulumi.set(__self__, "time_stop_scheduled", time_stop_scheduled)
        if use_dedicated_vm_host is not None:
            pulumi.set(__self__, "use_dedicated_vm_host", use_dedicated_vm_host)

    @property
    @pulumi.getter(name="arePrivilegedUsers")
    def are_privileged_users(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether desktop pool users have administrative privileges on their desktop.
        """
        return pulumi.get(self, "are_privileged_users")

    @are_privileged_users.setter
    def are_privileged_users(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "are_privileged_users", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain of the desktop pool.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availabilityPolicy")
    def availability_policy(self) -> pulumi.Input['DesktopPoolAvailabilityPolicyArgs']:
        """
        (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        """
        return pulumi.get(self, "availability_policy")

    @availability_policy.setter
    def availability_policy(self, value: pulumi.Input['DesktopPoolAvailabilityPolicyArgs']):
        pulumi.set(self, "availability_policy", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment which will contain the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> pulumi.Input['DesktopPoolDevicePolicyArgs']:
        """
        (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: pulumi.Input['DesktopPoolDevicePolicyArgs']):
        pulumi.set(self, "device_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input['DesktopPoolImageArgs']:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input['DesktopPoolImageArgs']):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="isStorageEnabled")
    def is_storage_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether storage is enabled for the desktop pool.
        """
        return pulumi.get(self, "is_storage_enabled")

    @is_storage_enabled.setter
    def is_storage_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_storage_enabled", value)

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The maximum number of desktops permitted in the desktop pool.
        """
        return pulumi.get(self, "maximum_size")

    @maximum_size.setter
    def maximum_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "maximum_size", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['DesktopPoolNetworkConfigurationArgs']:
        """
        Provides information about the network configuration of the desktop pool.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['DesktopPoolNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[builtins.str]:
        """
        The shape of the desktop pool.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="standbySize")
    def standby_size(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The maximum number of standby desktops available in the desktop pool.
        """
        return pulumi.get(self, "standby_size")

    @standby_size.setter
    def standby_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "standby_size", value)

    @property
    @pulumi.getter(name="storageBackupPolicyId")
    def storage_backup_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The backup policy OCID of the storage.
        """
        return pulumi.get(self, "storage_backup_policy_id")

    @storage_backup_policy_id.setter
    def storage_backup_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_backup_policy_id", value)

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> pulumi.Input[builtins.int]:
        """
        The size in GBs of the storage for the desktop pool.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @storage_size_in_gbs.setter
    def storage_size_in_gbs(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="areVolumesPreserved")
    def are_volumes_preserved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "are_volumes_preserved")

    @are_volumes_preserved.setter
    def are_volumes_preserved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "are_volumes_preserved", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network security groups for the private access.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateAccessDetails")
    def private_access_details(self) -> Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']]:
        """
        The details of the desktop's private access network connectivity to be set up for the desktop pool.
        """
        return pulumi.get(self, "private_access_details")

    @private_access_details.setter
    def private_access_details(self, value: Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']]):
        pulumi.set(self, "private_access_details", value)

    @property
    @pulumi.getter(name="sessionLifecycleActions")
    def session_lifecycle_actions(self) -> Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']]:
        """
        The details of action to be triggered in case of inactivity or disconnect
        """
        return pulumi.get(self, "session_lifecycle_actions")

    @session_lifecycle_actions.setter
    def session_lifecycle_actions(self, value: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']]):
        pulumi.set(self, "session_lifecycle_actions", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['DesktopPoolShapeConfigArgs']]:
        """
        The compute instance shape configuration requested for each desktop in the desktop pool.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['DesktopPoolShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter(name="timeStartScheduled")
    def time_start_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The start time of the desktop pool.
        """
        return pulumi.get(self, "time_start_scheduled")

    @time_start_scheduled.setter
    def time_start_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_start_scheduled", value)

    @property
    @pulumi.getter(name="timeStopScheduled")
    def time_stop_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The stop time of the desktop pool.
        """
        return pulumi.get(self, "time_stop_scheduled")

    @time_stop_scheduled.setter
    def time_stop_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_stop_scheduled", value)

    @property
    @pulumi.getter(name="useDedicatedVmHost")
    def use_dedicated_vm_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        return pulumi.get(self, "use_dedicated_vm_host")

    @use_dedicated_vm_host.setter
    def use_dedicated_vm_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "use_dedicated_vm_host", value)


@pulumi.input_type
class _DesktopPoolState:
    def __init__(__self__, *,
                 active_desktops: Optional[pulumi.Input[builtins.int]] = None,
                 are_privileged_users: Optional[pulumi.Input[builtins.bool]] = None,
                 are_volumes_preserved: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 availability_policy: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 contact_details: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_policy: Optional[pulumi.Input['DesktopPoolDevicePolicyArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image: Optional[pulumi.Input['DesktopPoolImageArgs']] = None,
                 is_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maximum_size: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input['DesktopPoolNetworkConfigurationArgs']] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_access_details: Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']] = None,
                 session_lifecycle_actions: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']] = None,
                 shape_config: Optional[pulumi.Input['DesktopPoolShapeConfigArgs']] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 standby_size: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 storage_backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_start_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_stop_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 use_dedicated_vm_host: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DesktopPool resources.
        :param pulumi.Input[builtins.int] active_desktops: The number of active desktops in the desktop pool.
        :param pulumi.Input[builtins.bool] are_privileged_users: Indicates whether desktop pool users have administrative privileges on their desktop.
        :param pulumi.Input[builtins.bool] are_volumes_preserved: (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the desktop pool.
        :param pulumi.Input['DesktopPoolAvailabilityPolicyArgs'] availability_policy: (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment which will contain the desktop pool.
        :param pulumi.Input[builtins.str] contact_details: (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        :param pulumi.Input['DesktopPoolDevicePolicyArgs'] device_policy: (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user friendly display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['DesktopPoolImageArgs'] image: Provides information about the desktop image.
        :param pulumi.Input[builtins.bool] is_storage_enabled: Indicates whether storage is enabled for the desktop pool.
        :param pulumi.Input[builtins.int] maximum_size: (Updatable) The maximum number of desktops permitted in the desktop pool.
        :param pulumi.Input['DesktopPoolNetworkConfigurationArgs'] network_configuration: Provides information about the network configuration of the desktop pool.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: A list of network security groups for the private access.
        :param pulumi.Input['DesktopPoolPrivateAccessDetailsArgs'] private_access_details: The details of the desktop's private access network connectivity to be set up for the desktop pool.
        :param pulumi.Input['DesktopPoolSessionLifecycleActionsArgs'] session_lifecycle_actions: The details of action to be triggered in case of inactivity or disconnect
        :param pulumi.Input['DesktopPoolShapeConfigArgs'] shape_config: The compute instance shape configuration requested for each desktop in the desktop pool.
        :param pulumi.Input[builtins.str] shape_name: The shape of the desktop pool.
        :param pulumi.Input[builtins.int] standby_size: (Updatable) The maximum number of standby desktops available in the desktop pool.
        :param pulumi.Input[builtins.str] state: The current state of the desktop pool.
        :param pulumi.Input[builtins.str] storage_backup_policy_id: The backup policy OCID of the storage.
        :param pulumi.Input[builtins.int] storage_size_in_gbs: The size in GBs of the storage for the desktop pool.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created.
        :param pulumi.Input[builtins.str] time_start_scheduled: (Updatable) The start time of the desktop pool.
        :param pulumi.Input[builtins.str] time_stop_scheduled: (Updatable) The stop time of the desktop pool.
        :param pulumi.Input[builtins.str] use_dedicated_vm_host: Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        if active_desktops is not None:
            pulumi.set(__self__, "active_desktops", active_desktops)
        if are_privileged_users is not None:
            pulumi.set(__self__, "are_privileged_users", are_privileged_users)
        if are_volumes_preserved is not None:
            pulumi.set(__self__, "are_volumes_preserved", are_volumes_preserved)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if availability_policy is not None:
            pulumi.set(__self__, "availability_policy", availability_policy)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if contact_details is not None:
            pulumi.set(__self__, "contact_details", contact_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if is_storage_enabled is not None:
            pulumi.set(__self__, "is_storage_enabled", is_storage_enabled)
        if maximum_size is not None:
            pulumi.set(__self__, "maximum_size", maximum_size)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_access_details is not None:
            pulumi.set(__self__, "private_access_details", private_access_details)
        if session_lifecycle_actions is not None:
            pulumi.set(__self__, "session_lifecycle_actions", session_lifecycle_actions)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if standby_size is not None:
            pulumi.set(__self__, "standby_size", standby_size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_backup_policy_id is not None:
            pulumi.set(__self__, "storage_backup_policy_id", storage_backup_policy_id)
        if storage_size_in_gbs is not None:
            pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_start_scheduled is not None:
            pulumi.set(__self__, "time_start_scheduled", time_start_scheduled)
        if time_stop_scheduled is not None:
            pulumi.set(__self__, "time_stop_scheduled", time_stop_scheduled)
        if use_dedicated_vm_host is not None:
            pulumi.set(__self__, "use_dedicated_vm_host", use_dedicated_vm_host)

    @property
    @pulumi.getter(name="activeDesktops")
    def active_desktops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of active desktops in the desktop pool.
        """
        return pulumi.get(self, "active_desktops")

    @active_desktops.setter
    def active_desktops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "active_desktops", value)

    @property
    @pulumi.getter(name="arePrivilegedUsers")
    def are_privileged_users(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether desktop pool users have administrative privileges on their desktop.
        """
        return pulumi.get(self, "are_privileged_users")

    @are_privileged_users.setter
    def are_privileged_users(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "are_privileged_users", value)

    @property
    @pulumi.getter(name="areVolumesPreserved")
    def are_volumes_preserved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "are_volumes_preserved")

    @are_volumes_preserved.setter
    def are_volumes_preserved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "are_volumes_preserved", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain of the desktop pool.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availabilityPolicy")
    def availability_policy(self) -> Optional[pulumi.Input['DesktopPoolAvailabilityPolicyArgs']]:
        """
        (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        """
        return pulumi.get(self, "availability_policy")

    @availability_policy.setter
    def availability_policy(self, value: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyArgs']]):
        pulumi.set(self, "availability_policy", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment which will contain the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input['DesktopPoolDevicePolicyArgs']]:
        """
        (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input['DesktopPoolDevicePolicyArgs']]):
        pulumi.set(self, "device_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['DesktopPoolImageArgs']]:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['DesktopPoolImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="isStorageEnabled")
    def is_storage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether storage is enabled for the desktop pool.
        """
        return pulumi.get(self, "is_storage_enabled")

    @is_storage_enabled.setter
    def is_storage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_storage_enabled", value)

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum number of desktops permitted in the desktop pool.
        """
        return pulumi.get(self, "maximum_size")

    @maximum_size.setter
    def maximum_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_size", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['DesktopPoolNetworkConfigurationArgs']]:
        """
        Provides information about the network configuration of the desktop pool.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['DesktopPoolNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network security groups for the private access.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateAccessDetails")
    def private_access_details(self) -> Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']]:
        """
        The details of the desktop's private access network connectivity to be set up for the desktop pool.
        """
        return pulumi.get(self, "private_access_details")

    @private_access_details.setter
    def private_access_details(self, value: Optional[pulumi.Input['DesktopPoolPrivateAccessDetailsArgs']]):
        pulumi.set(self, "private_access_details", value)

    @property
    @pulumi.getter(name="sessionLifecycleActions")
    def session_lifecycle_actions(self) -> Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']]:
        """
        The details of action to be triggered in case of inactivity or disconnect
        """
        return pulumi.get(self, "session_lifecycle_actions")

    @session_lifecycle_actions.setter
    def session_lifecycle_actions(self, value: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsArgs']]):
        pulumi.set(self, "session_lifecycle_actions", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['DesktopPoolShapeConfigArgs']]:
        """
        The compute instance shape configuration requested for each desktop in the desktop pool.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['DesktopPoolShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shape of the desktop pool.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="standbySize")
    def standby_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum number of standby desktops available in the desktop pool.
        """
        return pulumi.get(self, "standby_size")

    @standby_size.setter
    def standby_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "standby_size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the desktop pool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageBackupPolicyId")
    def storage_backup_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backup policy OCID of the storage.
        """
        return pulumi.get(self, "storage_backup_policy_id")

    @storage_backup_policy_id.setter
    def storage_backup_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_backup_policy_id", value)

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size in GBs of the storage for the desktop pool.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @storage_size_in_gbs.setter
    def storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeStartScheduled")
    def time_start_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The start time of the desktop pool.
        """
        return pulumi.get(self, "time_start_scheduled")

    @time_start_scheduled.setter
    def time_start_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_start_scheduled", value)

    @property
    @pulumi.getter(name="timeStopScheduled")
    def time_stop_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The stop time of the desktop pool.
        """
        return pulumi.get(self, "time_stop_scheduled")

    @time_stop_scheduled.setter
    def time_stop_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_stop_scheduled", value)

    @property
    @pulumi.getter(name="useDedicatedVmHost")
    def use_dedicated_vm_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        return pulumi.get(self, "use_dedicated_vm_host")

    @use_dedicated_vm_host.setter
    def use_dedicated_vm_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "use_dedicated_vm_host", value)


@pulumi.type_token("oci:Desktops/desktopPool:DesktopPool")
class DesktopPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_privileged_users: Optional[pulumi.Input[builtins.bool]] = None,
                 are_volumes_preserved: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 availability_policy: Optional[pulumi.Input[Union['DesktopPoolAvailabilityPolicyArgs', 'DesktopPoolAvailabilityPolicyArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 contact_details: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_policy: Optional[pulumi.Input[Union['DesktopPoolDevicePolicyArgs', 'DesktopPoolDevicePolicyArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image: Optional[pulumi.Input[Union['DesktopPoolImageArgs', 'DesktopPoolImageArgsDict']]] = None,
                 is_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maximum_size: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['DesktopPoolNetworkConfigurationArgs', 'DesktopPoolNetworkConfigurationArgsDict']]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_access_details: Optional[pulumi.Input[Union['DesktopPoolPrivateAccessDetailsArgs', 'DesktopPoolPrivateAccessDetailsArgsDict']]] = None,
                 session_lifecycle_actions: Optional[pulumi.Input[Union['DesktopPoolSessionLifecycleActionsArgs', 'DesktopPoolSessionLifecycleActionsArgsDict']]] = None,
                 shape_config: Optional[pulumi.Input[Union['DesktopPoolShapeConfigArgs', 'DesktopPoolShapeConfigArgsDict']]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 standby_size: Optional[pulumi.Input[builtins.int]] = None,
                 storage_backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 time_start_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_stop_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 use_dedicated_vm_host: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Desktop Pool resource in Oracle Cloud Infrastructure Desktops service.

        Creates a desktop pool with the given configuration parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_desktop_pool = oci.desktops.DesktopPool("test_desktop_pool",
            are_privileged_users=desktop_pool_are_privileged_users,
            availability_domain=desktop_pool_availability_domain,
            availability_policy={
                "start_schedule": {
                    "cron_expression": "0 10 8 ? * 2",
                    "timezone": "America/Denver",
                },
                "stop_schedule": {
                    "cron_expression": "0 20 18 ? * 6",
                    "timezone": "America/Denver",
                },
            },
            compartment_id=compartment_id,
            contact_details=desktop_pool_contact_details,
            device_policy={
                "audio_mode": desktop_pool_device_policy_audio_mode,
                "cdm_mode": desktop_pool_device_policy_cdm_mode,
                "clipboard_mode": desktop_pool_device_policy_clipboard_mode,
                "is_display_enabled": desktop_pool_device_policy_is_display_enabled,
                "is_keyboard_enabled": desktop_pool_device_policy_is_keyboard_enabled,
                "is_pointer_enabled": desktop_pool_device_policy_is_pointer_enabled,
                "is_printing_enabled": desktop_pool_device_policy_is_printing_enabled,
            },
            display_name=desktop_pool_display_name,
            image={
                "image_id": test_image["id"],
                "image_name": desktop_pool_image_image_name,
                "operating_system": desktop_pool_image_operating_system,
            },
            is_storage_enabled=desktop_pool_is_storage_enabled,
            maximum_size=desktop_pool_maximum_size,
            network_configuration={
                "subnet_id": test_subnet["id"],
                "vcn_id": test_vcn["id"],
            },
            shape_name="VM.Standard.E4.Flex",
            standby_size=desktop_pool_standby_size,
            storage_backup_policy_id="ocid1.volumebackuppolicy.oc1.xxxxyyyyyzzzz",
            storage_size_in_gbs=desktop_pool_storage_size_in_gbs,
            are_volumes_preserved=desktop_pool_are_volumes_preserved,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=desktop_pool_description,
            freeform_tags={
                "Department": "Finance",
            },
            nsg_ids=desktop_pool_nsg_ids,
            shape_config={
                "baseline_ocpu_utilization": desktop_pool_shape_config_baseline_ocpu_utilization,
                "memory_in_gbs": desktop_pool_shape_config_memory_in_gbs,
                "ocpus": desktop_pool_shape_config_ocpus,
            },
            private_access_details={
                "subnet_id": test_subnet["id"],
                "nsg_ids": desktop_pool_private_access_details_nsg_ids,
                "private_ip": desktop_pool_private_access_details_private_ip,
            },
            session_lifecycle_actions={
                "disconnect": {
                    "action": "STOP",
                    "grace_period_in_minutes": desktop_pool_session_lifecycle_actions_disconnect_grace_period_in_minutes,
                },
                "inactivity": {
                    "action": "DISCONNECT",
                    "grace_period_in_minutes": desktop_pool_session_lifecycle_actions_inactivity_grace_period_in_minutes,
                },
            },
            time_start_scheduled=desktop_pool_time_start_scheduled,
            time_stop_scheduled=desktop_pool_time_stop_scheduled,
            use_dedicated_vm_host=desktop_pool_use_dedicated_vm_host)
        ```

        ## Import

        DesktopPools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Desktops/desktopPool:DesktopPool test_desktop_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] are_privileged_users: Indicates whether desktop pool users have administrative privileges on their desktop.
        :param pulumi.Input[builtins.bool] are_volumes_preserved: (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the desktop pool.
        :param pulumi.Input[Union['DesktopPoolAvailabilityPolicyArgs', 'DesktopPoolAvailabilityPolicyArgsDict']] availability_policy: (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment which will contain the desktop pool.
        :param pulumi.Input[builtins.str] contact_details: (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        :param pulumi.Input[Union['DesktopPoolDevicePolicyArgs', 'DesktopPoolDevicePolicyArgsDict']] device_policy: (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user friendly display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DesktopPoolImageArgs', 'DesktopPoolImageArgsDict']] image: Provides information about the desktop image.
        :param pulumi.Input[builtins.bool] is_storage_enabled: Indicates whether storage is enabled for the desktop pool.
        :param pulumi.Input[builtins.int] maximum_size: (Updatable) The maximum number of desktops permitted in the desktop pool.
        :param pulumi.Input[Union['DesktopPoolNetworkConfigurationArgs', 'DesktopPoolNetworkConfigurationArgsDict']] network_configuration: Provides information about the network configuration of the desktop pool.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: A list of network security groups for the private access.
        :param pulumi.Input[Union['DesktopPoolPrivateAccessDetailsArgs', 'DesktopPoolPrivateAccessDetailsArgsDict']] private_access_details: The details of the desktop's private access network connectivity to be set up for the desktop pool.
        :param pulumi.Input[Union['DesktopPoolSessionLifecycleActionsArgs', 'DesktopPoolSessionLifecycleActionsArgsDict']] session_lifecycle_actions: The details of action to be triggered in case of inactivity or disconnect
        :param pulumi.Input[Union['DesktopPoolShapeConfigArgs', 'DesktopPoolShapeConfigArgsDict']] shape_config: The compute instance shape configuration requested for each desktop in the desktop pool.
        :param pulumi.Input[builtins.str] shape_name: The shape of the desktop pool.
        :param pulumi.Input[builtins.int] standby_size: (Updatable) The maximum number of standby desktops available in the desktop pool.
        :param pulumi.Input[builtins.str] storage_backup_policy_id: The backup policy OCID of the storage.
        :param pulumi.Input[builtins.int] storage_size_in_gbs: The size in GBs of the storage for the desktop pool.
        :param pulumi.Input[builtins.str] time_start_scheduled: (Updatable) The start time of the desktop pool.
        :param pulumi.Input[builtins.str] time_stop_scheduled: (Updatable) The stop time of the desktop pool.
        :param pulumi.Input[builtins.str] use_dedicated_vm_host: Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DesktopPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Desktop Pool resource in Oracle Cloud Infrastructure Desktops service.

        Creates a desktop pool with the given configuration parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_desktop_pool = oci.desktops.DesktopPool("test_desktop_pool",
            are_privileged_users=desktop_pool_are_privileged_users,
            availability_domain=desktop_pool_availability_domain,
            availability_policy={
                "start_schedule": {
                    "cron_expression": "0 10 8 ? * 2",
                    "timezone": "America/Denver",
                },
                "stop_schedule": {
                    "cron_expression": "0 20 18 ? * 6",
                    "timezone": "America/Denver",
                },
            },
            compartment_id=compartment_id,
            contact_details=desktop_pool_contact_details,
            device_policy={
                "audio_mode": desktop_pool_device_policy_audio_mode,
                "cdm_mode": desktop_pool_device_policy_cdm_mode,
                "clipboard_mode": desktop_pool_device_policy_clipboard_mode,
                "is_display_enabled": desktop_pool_device_policy_is_display_enabled,
                "is_keyboard_enabled": desktop_pool_device_policy_is_keyboard_enabled,
                "is_pointer_enabled": desktop_pool_device_policy_is_pointer_enabled,
                "is_printing_enabled": desktop_pool_device_policy_is_printing_enabled,
            },
            display_name=desktop_pool_display_name,
            image={
                "image_id": test_image["id"],
                "image_name": desktop_pool_image_image_name,
                "operating_system": desktop_pool_image_operating_system,
            },
            is_storage_enabled=desktop_pool_is_storage_enabled,
            maximum_size=desktop_pool_maximum_size,
            network_configuration={
                "subnet_id": test_subnet["id"],
                "vcn_id": test_vcn["id"],
            },
            shape_name="VM.Standard.E4.Flex",
            standby_size=desktop_pool_standby_size,
            storage_backup_policy_id="ocid1.volumebackuppolicy.oc1.xxxxyyyyyzzzz",
            storage_size_in_gbs=desktop_pool_storage_size_in_gbs,
            are_volumes_preserved=desktop_pool_are_volumes_preserved,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=desktop_pool_description,
            freeform_tags={
                "Department": "Finance",
            },
            nsg_ids=desktop_pool_nsg_ids,
            shape_config={
                "baseline_ocpu_utilization": desktop_pool_shape_config_baseline_ocpu_utilization,
                "memory_in_gbs": desktop_pool_shape_config_memory_in_gbs,
                "ocpus": desktop_pool_shape_config_ocpus,
            },
            private_access_details={
                "subnet_id": test_subnet["id"],
                "nsg_ids": desktop_pool_private_access_details_nsg_ids,
                "private_ip": desktop_pool_private_access_details_private_ip,
            },
            session_lifecycle_actions={
                "disconnect": {
                    "action": "STOP",
                    "grace_period_in_minutes": desktop_pool_session_lifecycle_actions_disconnect_grace_period_in_minutes,
                },
                "inactivity": {
                    "action": "DISCONNECT",
                    "grace_period_in_minutes": desktop_pool_session_lifecycle_actions_inactivity_grace_period_in_minutes,
                },
            },
            time_start_scheduled=desktop_pool_time_start_scheduled,
            time_stop_scheduled=desktop_pool_time_stop_scheduled,
            use_dedicated_vm_host=desktop_pool_use_dedicated_vm_host)
        ```

        ## Import

        DesktopPools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Desktops/desktopPool:DesktopPool test_desktop_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param DesktopPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DesktopPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_privileged_users: Optional[pulumi.Input[builtins.bool]] = None,
                 are_volumes_preserved: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 availability_policy: Optional[pulumi.Input[Union['DesktopPoolAvailabilityPolicyArgs', 'DesktopPoolAvailabilityPolicyArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 contact_details: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_policy: Optional[pulumi.Input[Union['DesktopPoolDevicePolicyArgs', 'DesktopPoolDevicePolicyArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image: Optional[pulumi.Input[Union['DesktopPoolImageArgs', 'DesktopPoolImageArgsDict']]] = None,
                 is_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maximum_size: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['DesktopPoolNetworkConfigurationArgs', 'DesktopPoolNetworkConfigurationArgsDict']]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_access_details: Optional[pulumi.Input[Union['DesktopPoolPrivateAccessDetailsArgs', 'DesktopPoolPrivateAccessDetailsArgsDict']]] = None,
                 session_lifecycle_actions: Optional[pulumi.Input[Union['DesktopPoolSessionLifecycleActionsArgs', 'DesktopPoolSessionLifecycleActionsArgsDict']]] = None,
                 shape_config: Optional[pulumi.Input[Union['DesktopPoolShapeConfigArgs', 'DesktopPoolShapeConfigArgsDict']]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 standby_size: Optional[pulumi.Input[builtins.int]] = None,
                 storage_backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 time_start_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_stop_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 use_dedicated_vm_host: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DesktopPoolArgs.__new__(DesktopPoolArgs)

            if are_privileged_users is None and not opts.urn:
                raise TypeError("Missing required property 'are_privileged_users'")
            __props__.__dict__["are_privileged_users"] = are_privileged_users
            __props__.__dict__["are_volumes_preserved"] = are_volumes_preserved
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if availability_policy is None and not opts.urn:
                raise TypeError("Missing required property 'availability_policy'")
            __props__.__dict__["availability_policy"] = availability_policy
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if contact_details is None and not opts.urn:
                raise TypeError("Missing required property 'contact_details'")
            __props__.__dict__["contact_details"] = contact_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if device_policy is None and not opts.urn:
                raise TypeError("Missing required property 'device_policy'")
            __props__.__dict__["device_policy"] = device_policy
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            if is_storage_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_storage_enabled'")
            __props__.__dict__["is_storage_enabled"] = is_storage_enabled
            if maximum_size is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_size'")
            __props__.__dict__["maximum_size"] = maximum_size
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["private_access_details"] = private_access_details
            __props__.__dict__["session_lifecycle_actions"] = session_lifecycle_actions
            __props__.__dict__["shape_config"] = shape_config
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
            if standby_size is None and not opts.urn:
                raise TypeError("Missing required property 'standby_size'")
            __props__.__dict__["standby_size"] = standby_size
            if storage_backup_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_backup_policy_id'")
            __props__.__dict__["storage_backup_policy_id"] = storage_backup_policy_id
            if storage_size_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'storage_size_in_gbs'")
            __props__.__dict__["storage_size_in_gbs"] = storage_size_in_gbs
            __props__.__dict__["time_start_scheduled"] = time_start_scheduled
            __props__.__dict__["time_stop_scheduled"] = time_stop_scheduled
            __props__.__dict__["use_dedicated_vm_host"] = use_dedicated_vm_host
            __props__.__dict__["active_desktops"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(DesktopPool, __self__).__init__(
            'oci:Desktops/desktopPool:DesktopPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_desktops: Optional[pulumi.Input[builtins.int]] = None,
            are_privileged_users: Optional[pulumi.Input[builtins.bool]] = None,
            are_volumes_preserved: Optional[pulumi.Input[builtins.bool]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            availability_policy: Optional[pulumi.Input[Union['DesktopPoolAvailabilityPolicyArgs', 'DesktopPoolAvailabilityPolicyArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            contact_details: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_policy: Optional[pulumi.Input[Union['DesktopPoolDevicePolicyArgs', 'DesktopPoolDevicePolicyArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            image: Optional[pulumi.Input[Union['DesktopPoolImageArgs', 'DesktopPoolImageArgsDict']]] = None,
            is_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            maximum_size: Optional[pulumi.Input[builtins.int]] = None,
            network_configuration: Optional[pulumi.Input[Union['DesktopPoolNetworkConfigurationArgs', 'DesktopPoolNetworkConfigurationArgsDict']]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            private_access_details: Optional[pulumi.Input[Union['DesktopPoolPrivateAccessDetailsArgs', 'DesktopPoolPrivateAccessDetailsArgsDict']]] = None,
            session_lifecycle_actions: Optional[pulumi.Input[Union['DesktopPoolSessionLifecycleActionsArgs', 'DesktopPoolSessionLifecycleActionsArgsDict']]] = None,
            shape_config: Optional[pulumi.Input[Union['DesktopPoolShapeConfigArgs', 'DesktopPoolShapeConfigArgsDict']]] = None,
            shape_name: Optional[pulumi.Input[builtins.str]] = None,
            standby_size: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            storage_backup_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_start_scheduled: Optional[pulumi.Input[builtins.str]] = None,
            time_stop_scheduled: Optional[pulumi.Input[builtins.str]] = None,
            use_dedicated_vm_host: Optional[pulumi.Input[builtins.str]] = None) -> 'DesktopPool':
        """
        Get an existing DesktopPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] active_desktops: The number of active desktops in the desktop pool.
        :param pulumi.Input[builtins.bool] are_privileged_users: Indicates whether desktop pool users have administrative privileges on their desktop.
        :param pulumi.Input[builtins.bool] are_volumes_preserved: (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the desktop pool.
        :param pulumi.Input[Union['DesktopPoolAvailabilityPolicyArgs', 'DesktopPoolAvailabilityPolicyArgsDict']] availability_policy: (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment which will contain the desktop pool.
        :param pulumi.Input[builtins.str] contact_details: (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        :param pulumi.Input[Union['DesktopPoolDevicePolicyArgs', 'DesktopPoolDevicePolicyArgsDict']] device_policy: (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user friendly display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DesktopPoolImageArgs', 'DesktopPoolImageArgsDict']] image: Provides information about the desktop image.
        :param pulumi.Input[builtins.bool] is_storage_enabled: Indicates whether storage is enabled for the desktop pool.
        :param pulumi.Input[builtins.int] maximum_size: (Updatable) The maximum number of desktops permitted in the desktop pool.
        :param pulumi.Input[Union['DesktopPoolNetworkConfigurationArgs', 'DesktopPoolNetworkConfigurationArgsDict']] network_configuration: Provides information about the network configuration of the desktop pool.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: A list of network security groups for the private access.
        :param pulumi.Input[Union['DesktopPoolPrivateAccessDetailsArgs', 'DesktopPoolPrivateAccessDetailsArgsDict']] private_access_details: The details of the desktop's private access network connectivity to be set up for the desktop pool.
        :param pulumi.Input[Union['DesktopPoolSessionLifecycleActionsArgs', 'DesktopPoolSessionLifecycleActionsArgsDict']] session_lifecycle_actions: The details of action to be triggered in case of inactivity or disconnect
        :param pulumi.Input[Union['DesktopPoolShapeConfigArgs', 'DesktopPoolShapeConfigArgsDict']] shape_config: The compute instance shape configuration requested for each desktop in the desktop pool.
        :param pulumi.Input[builtins.str] shape_name: The shape of the desktop pool.
        :param pulumi.Input[builtins.int] standby_size: (Updatable) The maximum number of standby desktops available in the desktop pool.
        :param pulumi.Input[builtins.str] state: The current state of the desktop pool.
        :param pulumi.Input[builtins.str] storage_backup_policy_id: The backup policy OCID of the storage.
        :param pulumi.Input[builtins.int] storage_size_in_gbs: The size in GBs of the storage for the desktop pool.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created.
        :param pulumi.Input[builtins.str] time_start_scheduled: (Updatable) The start time of the desktop pool.
        :param pulumi.Input[builtins.str] time_stop_scheduled: (Updatable) The stop time of the desktop pool.
        :param pulumi.Input[builtins.str] use_dedicated_vm_host: Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DesktopPoolState.__new__(_DesktopPoolState)

        __props__.__dict__["active_desktops"] = active_desktops
        __props__.__dict__["are_privileged_users"] = are_privileged_users
        __props__.__dict__["are_volumes_preserved"] = are_volumes_preserved
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["availability_policy"] = availability_policy
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["contact_details"] = contact_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["device_policy"] = device_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image"] = image
        __props__.__dict__["is_storage_enabled"] = is_storage_enabled
        __props__.__dict__["maximum_size"] = maximum_size
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["private_access_details"] = private_access_details
        __props__.__dict__["session_lifecycle_actions"] = session_lifecycle_actions
        __props__.__dict__["shape_config"] = shape_config
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["standby_size"] = standby_size
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_backup_policy_id"] = storage_backup_policy_id
        __props__.__dict__["storage_size_in_gbs"] = storage_size_in_gbs
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_start_scheduled"] = time_start_scheduled
        __props__.__dict__["time_stop_scheduled"] = time_stop_scheduled
        __props__.__dict__["use_dedicated_vm_host"] = use_dedicated_vm_host
        return DesktopPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDesktops")
    def active_desktops(self) -> pulumi.Output[builtins.int]:
        """
        The number of active desktops in the desktop pool.
        """
        return pulumi.get(self, "active_desktops")

    @property
    @pulumi.getter(name="arePrivilegedUsers")
    def are_privileged_users(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether desktop pool users have administrative privileges on their desktop.
        """
        return pulumi.get(self, "are_privileged_users")

    @property
    @pulumi.getter(name="areVolumesPreserved")
    def are_volumes_preserved(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) Indicates whether the volumes are preserved when a desktop pool is deleted. Default value is false.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "are_volumes_preserved")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain of the desktop pool.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availabilityPolicy")
    def availability_policy(self) -> pulumi.Output['outputs.DesktopPoolAvailabilityPolicy']:
        """
        (Updatable) Provides the start and stop schedule information for desktop availability of the desktop pool. Use `availability_policy { }` to not set a schedule.
        """
        return pulumi.get(self, "availability_policy")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment which will contain the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Contact information of the desktop pool administrator. Avoid entering confidential information.
        """
        return pulumi.get(self, "contact_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user friendly description providing additional information about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> pulumi.Output['outputs.DesktopPoolDevicePolicy']:
        """
        (Updatable) Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output['outputs.DesktopPoolImage']:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="isStorageEnabled")
    def is_storage_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether storage is enabled for the desktop pool.
        """
        return pulumi.get(self, "is_storage_enabled")

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The maximum number of desktops permitted in the desktop pool.
        """
        return pulumi.get(self, "maximum_size")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.DesktopPoolNetworkConfiguration']:
        """
        Provides information about the network configuration of the desktop pool.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of network security groups for the private access.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateAccessDetails")
    def private_access_details(self) -> pulumi.Output['outputs.DesktopPoolPrivateAccessDetails']:
        """
        The details of the desktop's private access network connectivity to be set up for the desktop pool.
        """
        return pulumi.get(self, "private_access_details")

    @property
    @pulumi.getter(name="sessionLifecycleActions")
    def session_lifecycle_actions(self) -> pulumi.Output[Optional['outputs.DesktopPoolSessionLifecycleActions']]:
        """
        The details of action to be triggered in case of inactivity or disconnect
        """
        return pulumi.get(self, "session_lifecycle_actions")

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> pulumi.Output['outputs.DesktopPoolShapeConfig']:
        """
        The compute instance shape configuration requested for each desktop in the desktop pool.
        """
        return pulumi.get(self, "shape_config")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[builtins.str]:
        """
        The shape of the desktop pool.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter(name="standbySize")
    def standby_size(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The maximum number of standby desktops available in the desktop pool.
        """
        return pulumi.get(self, "standby_size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the desktop pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageBackupPolicyId")
    def storage_backup_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The backup policy OCID of the storage.
        """
        return pulumi.get(self, "storage_backup_policy_id")

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> pulumi.Output[builtins.int]:
        """
        The size in GBs of the storage for the desktop pool.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStartScheduled")
    def time_start_scheduled(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The start time of the desktop pool.
        """
        return pulumi.get(self, "time_start_scheduled")

    @property
    @pulumi.getter(name="timeStopScheduled")
    def time_stop_scheduled(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The stop time of the desktop pool.
        """
        return pulumi.get(self, "time_stop_scheduled")

    @property
    @pulumi.getter(name="useDedicatedVmHost")
    def use_dedicated_vm_host(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether the desktop pool uses dedicated virtual machine hosts.
        """
        return pulumi.get(self, "use_dedicated_vm_host")

