# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 are_quota_rules_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 clone_attach_status: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 detach_clone_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]] = None,
                 source_snapshot_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[builtins.bool] are_quota_rules_enabled: (Updatable) Specifies the enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.str] clone_attach_status: Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] detach_clone_trigger: (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[builtins.str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if are_quota_rules_enabled is not None:
            pulumi.set(__self__, "are_quota_rules_enabled", are_quota_rules_enabled)
        if clone_attach_status is not None:
            pulumi.set(__self__, "clone_attach_status", clone_attach_status)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detach_clone_trigger is not None:
            pulumi.set(__self__, "detach_clone_trigger", detach_clone_trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filesystem_snapshot_policy_id is not None:
            pulumi.set(__self__, "filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if source_snapshot_id is not None:
            pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="areQuotaRulesEnabled")
    def are_quota_rules_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies the enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "are_quota_rules_enabled")

    @are_quota_rules_enabled.setter
    def are_quota_rules_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "are_quota_rules_enabled", value)

    @property
    @pulumi.getter(name="cloneAttachStatus")
    def clone_attach_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        """
        return pulumi.get(self, "clone_attach_status")

    @clone_attach_status.setter
    def clone_attach_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clone_attach_status", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="detachCloneTrigger")
    def detach_clone_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "detach_clone_trigger")

    @detach_clone_trigger.setter
    def detach_clone_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "detach_clone_trigger", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filesystem_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_snapshot_id", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 are_quota_rules_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 clone_attach_status: Optional[pulumi.Input[builtins.str]] = None,
                 clone_count: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 detach_clone_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_clone_parent: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hydrated: Optional[pulumi.Input[builtins.bool]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 is_targetable: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]] = None,
                 metered_bytes: Optional[pulumi.Input[builtins.str]] = None,
                 quota_enforcement_state: Optional[pulumi.Input[builtins.str]] = None,
                 replication_source_count: Optional[pulumi.Input[builtins.int]] = None,
                 replication_target_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_details: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]] = None,
                 source_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[builtins.bool] are_quota_rules_enabled: (Updatable) Specifies the enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] clone_attach_status: Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        :param pulumi.Input[builtins.int] clone_count: Specifies the total number of children of a file system.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] detach_clone_trigger: (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[builtins.str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_clone_parent: Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[builtins.bool] is_hydrated: Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        :param pulumi.Input[builtins.bool] is_targetable: Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] metered_bytes: The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        :param pulumi.Input[builtins.str] quota_enforcement_state: Displays the state of enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.int] replication_source_count: Specifies the total number of replications for which this file system is a source.
        :param pulumi.Input[builtins.str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]] source_details: Source information for the file system.
        :param pulumi.Input[builtins.str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[builtins.str] state: The current state of the file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[builtins.str] time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if are_quota_rules_enabled is not None:
            pulumi.set(__self__, "are_quota_rules_enabled", are_quota_rules_enabled)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if clone_attach_status is not None:
            pulumi.set(__self__, "clone_attach_status", clone_attach_status)
        if clone_count is not None:
            pulumi.set(__self__, "clone_count", clone_count)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detach_clone_trigger is not None:
            pulumi.set(__self__, "detach_clone_trigger", detach_clone_trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filesystem_snapshot_policy_id is not None:
            pulumi.set(__self__, "filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_clone_parent is not None:
            pulumi.set(__self__, "is_clone_parent", is_clone_parent)
        if is_hydrated is not None:
            pulumi.set(__self__, "is_hydrated", is_hydrated)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if is_targetable is not None:
            pulumi.set(__self__, "is_targetable", is_targetable)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if metered_bytes is not None:
            pulumi.set(__self__, "metered_bytes", metered_bytes)
        if quota_enforcement_state is not None:
            pulumi.set(__self__, "quota_enforcement_state", quota_enforcement_state)
        if replication_source_count is not None:
            pulumi.set(__self__, "replication_source_count", replication_source_count)
        if replication_target_id is not None:
            pulumi.set(__self__, "replication_target_id", replication_target_id)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if source_snapshot_id is not None:
            pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="areQuotaRulesEnabled")
    def are_quota_rules_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Specifies the enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "are_quota_rules_enabled")

    @are_quota_rules_enabled.setter
    def are_quota_rules_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "are_quota_rules_enabled", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="cloneAttachStatus")
    def clone_attach_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        """
        return pulumi.get(self, "clone_attach_status")

    @clone_attach_status.setter
    def clone_attach_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clone_attach_status", value)

    @property
    @pulumi.getter(name="cloneCount")
    def clone_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the total number of children of a file system.
        """
        return pulumi.get(self, "clone_count")

    @clone_count.setter
    def clone_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "clone_count", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="detachCloneTrigger")
    def detach_clone_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "detach_clone_trigger")

    @detach_clone_trigger.setter
    def detach_clone_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "detach_clone_trigger", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filesystem_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCloneParent")
    def is_clone_parent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_parent")

    @is_clone_parent.setter
    def is_clone_parent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_clone_parent", value)

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        """
        return pulumi.get(self, "is_hydrated")

    @is_hydrated.setter
    def is_hydrated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hydrated", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter(name="isTargetable")
    def is_targetable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        """
        return pulumi.get(self, "is_targetable")

    @is_targetable.setter
    def is_targetable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_targetable", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="meteredBytes")
    def metered_bytes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        """
        return pulumi.get(self, "metered_bytes")

    @metered_bytes.setter
    def metered_bytes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metered_bytes", value)

    @property
    @pulumi.getter(name="quotaEnforcementState")
    def quota_enforcement_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Displays the state of enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "quota_enforcement_state")

    @quota_enforcement_state.setter
    def quota_enforcement_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quota_enforcement_state", value)

    @property
    @pulumi.getter(name="replicationSourceCount")
    def replication_source_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the total number of replications for which this file system is a source.
        """
        return pulumi.get(self, "replication_source_count")

    @replication_source_count.setter
    def replication_source_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_source_count", value)

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        """
        return pulumi.get(self, "replication_target_id")

    @replication_target_id.setter
    def replication_target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_target_id", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]]:
        """
        Source information for the file system.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_snapshot_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the file system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:FileStorage/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_quota_rules_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 clone_attach_status: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 detach_clone_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSystemLockArgs', 'FileSystemLockArgsDict']]]]] = None,
                 source_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the File System resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new file system in the specified compartment and
        availability domain. Instances can mount file systems in
        another availability domain, but doing so might increase
        latency when compared to mounting instances in the same
        availability domain.

        After you create a file system, you can associate it with a mount
        target. Instances can then mount the file system by connecting to the
        mount target's IP address. You can associate a file system with
        more than one mount target at a time.

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about Network Security Groups access control, see
        [Network Security Groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure resources, including
        file systems, get an Oracle-assigned, unique ID called an Oracle
        Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system = oci.file_storage.FileSystem("test_file_system",
            availability_domain=file_system_availability_domain,
            compartment_id=compartment_id,
            are_quota_rules_enabled=file_system_are_quota_rules_enabled,
            clone_attach_status=file_system_clone_attach_status,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=file_system_display_name,
            filesystem_snapshot_policy_id=test_filesystem_snapshot_policy["id"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            locks=[{
                "type": file_system_locks_type,
                "message": file_system_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": file_system_locks_time_created,
            }],
            source_snapshot_id=test_snapshot["id"])
        ```

        ## Import

        FileSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/fileSystem:FileSystem test_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] are_quota_rules_enabled: (Updatable) Specifies the enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] clone_attach_status: Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] detach_clone_trigger: (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[builtins.str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSystemLockArgs', 'FileSystemLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the File System resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new file system in the specified compartment and
        availability domain. Instances can mount file systems in
        another availability domain, but doing so might increase
        latency when compared to mounting instances in the same
        availability domain.

        After you create a file system, you can associate it with a mount
        target. Instances can then mount the file system by connecting to the
        mount target's IP address. You can associate a file system with
        more than one mount target at a time.

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about Network Security Groups access control, see
        [Network Security Groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure resources, including
        file systems, get an Oracle-assigned, unique ID called an Oracle
        Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system = oci.file_storage.FileSystem("test_file_system",
            availability_domain=file_system_availability_domain,
            compartment_id=compartment_id,
            are_quota_rules_enabled=file_system_are_quota_rules_enabled,
            clone_attach_status=file_system_clone_attach_status,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=file_system_display_name,
            filesystem_snapshot_policy_id=test_filesystem_snapshot_policy["id"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            locks=[{
                "type": file_system_locks_type,
                "message": file_system_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": file_system_locks_time_created,
            }],
            source_snapshot_id=test_snapshot["id"])
        ```

        ## Import

        FileSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/fileSystem:FileSystem test_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_quota_rules_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 clone_attach_status: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 detach_clone_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSystemLockArgs', 'FileSystemLockArgsDict']]]]] = None,
                 source_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["are_quota_rules_enabled"] = are_quota_rules_enabled
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["clone_attach_status"] = clone_attach_status
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["detach_clone_trigger"] = detach_clone_trigger
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["filesystem_snapshot_policy_id"] = filesystem_snapshot_policy_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_lock_override"] = is_lock_override
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["locks"] = locks
            __props__.__dict__["source_snapshot_id"] = source_snapshot_id
            __props__.__dict__["clone_count"] = None
            __props__.__dict__["is_clone_parent"] = None
            __props__.__dict__["is_hydrated"] = None
            __props__.__dict__["is_targetable"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metered_bytes"] = None
            __props__.__dict__["quota_enforcement_state"] = None
            __props__.__dict__["replication_source_count"] = None
            __props__.__dict__["replication_target_id"] = None
            __props__.__dict__["source_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(FileSystem, __self__).__init__(
            'oci:FileStorage/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_quota_rules_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            clone_attach_status: Optional[pulumi.Input[builtins.str]] = None,
            clone_count: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            detach_clone_trigger: Optional[pulumi.Input[builtins.int]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            filesystem_snapshot_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_clone_parent: Optional[pulumi.Input[builtins.bool]] = None,
            is_hydrated: Optional[pulumi.Input[builtins.bool]] = None,
            is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
            is_targetable: Optional[pulumi.Input[builtins.bool]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSystemLockArgs', 'FileSystemLockArgsDict']]]]] = None,
            metered_bytes: Optional[pulumi.Input[builtins.str]] = None,
            quota_enforcement_state: Optional[pulumi.Input[builtins.str]] = None,
            replication_source_count: Optional[pulumi.Input[builtins.int]] = None,
            replication_target_id: Optional[pulumi.Input[builtins.str]] = None,
            source_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSystemSourceDetailArgs', 'FileSystemSourceDetailArgsDict']]]]] = None,
            source_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] are_quota_rules_enabled: (Updatable) Specifies the enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] clone_attach_status: Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        :param pulumi.Input[builtins.int] clone_count: Specifies the total number of children of a file system.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] detach_clone_trigger: (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[builtins.str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_clone_parent: Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[builtins.bool] is_hydrated: Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        :param pulumi.Input[builtins.bool] is_targetable: Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        :param pulumi.Input[builtins.str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSystemLockArgs', 'FileSystemLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] metered_bytes: The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        :param pulumi.Input[builtins.str] quota_enforcement_state: Displays the state of enforcement of quota rules on the file system.
        :param pulumi.Input[builtins.int] replication_source_count: Specifies the total number of replications for which this file system is a source.
        :param pulumi.Input[builtins.str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSystemSourceDetailArgs', 'FileSystemSourceDetailArgsDict']]]] source_details: Source information for the file system.
        :param pulumi.Input[builtins.str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[builtins.str] state: The current state of the file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[builtins.str] time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["are_quota_rules_enabled"] = are_quota_rules_enabled
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["clone_attach_status"] = clone_attach_status
        __props__.__dict__["clone_count"] = clone_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["detach_clone_trigger"] = detach_clone_trigger
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filesystem_snapshot_policy_id"] = filesystem_snapshot_policy_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_clone_parent"] = is_clone_parent
        __props__.__dict__["is_hydrated"] = is_hydrated
        __props__.__dict__["is_lock_override"] = is_lock_override
        __props__.__dict__["is_targetable"] = is_targetable
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locks"] = locks
        __props__.__dict__["metered_bytes"] = metered_bytes
        __props__.__dict__["quota_enforcement_state"] = quota_enforcement_state
        __props__.__dict__["replication_source_count"] = replication_source_count
        __props__.__dict__["replication_target_id"] = replication_target_id
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["source_snapshot_id"] = source_snapshot_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areQuotaRulesEnabled")
    def are_quota_rules_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Specifies the enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "are_quota_rules_enabled")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloneAttachStatus")
    def clone_attach_status(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the clone file system is attached to its parent file system. If the value is set to 'DETACH', then the file system will be created, which is deep copied from the snapshot specified by sourceSnapshotId, else will remain attached to its parent.
        """
        return pulumi.get(self, "clone_attach_status")

    @property
    @pulumi.getter(name="cloneCount")
    def clone_count(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the total number of children of a file system.
        """
        return pulumi.get(self, "clone_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachCloneTrigger")
    def detach_clone_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Detach Clone. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "detach_clone_trigger")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isCloneParent")
    def is_clone_parent(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_parent")

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        """
        return pulumi.get(self, "is_hydrated")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="isTargetable")
    def is_targetable(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        """
        return pulumi.get(self, "is_targetable")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.FileSystemLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="meteredBytes")
    def metered_bytes(self) -> pulumi.Output[builtins.str]:
        """
        The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        """
        return pulumi.get(self, "metered_bytes")

    @property
    @pulumi.getter(name="quotaEnforcementState")
    def quota_enforcement_state(self) -> pulumi.Output[builtins.str]:
        """
        Displays the state of enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "quota_enforcement_state")

    @property
    @pulumi.getter(name="replicationSourceCount")
    def replication_source_count(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the total number of replications for which this file system is a source.
        """
        return pulumi.get(self, "replication_source_count")

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        """
        return pulumi.get(self, "replication_target_id")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output[Sequence['outputs.FileSystemSourceDetail']]:
        """
        Source information for the file system.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the file system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

