# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentEndpointArgs', 'AgentAgentEndpoint']

@pulumi.input_type
class AgentAgentEndpointArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 content_moderation_config: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 session_config: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']] = None,
                 should_enable_citation: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AgentAgentEndpoint resource.
        :param pulumi.Input[builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input['AgentAgentEndpointContentModerationConfigArgs'] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['AgentAgentEndpointSessionConfigArgs'] session_config: (Updatable) **SessionConfig**
               
               Session Configuration on AgentEndpoint.
        :param pulumi.Input[builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content_moderation_config is not None:
            pulumi.set(__self__, "content_moderation_config", content_moderation_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if session_config is not None:
            pulumi.set(__self__, "session_config", session_config)
        if should_enable_citation is not None:
            pulumi.set(__self__, "should_enable_citation", should_enable_citation)
        if should_enable_session is not None:
            pulumi.set(__self__, "should_enable_session", should_enable_session)
        if should_enable_trace is not None:
            pulumi.set(__self__, "should_enable_trace", should_enable_trace)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @content_moderation_config.setter
    def content_moderation_config(self, value: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]):
        pulumi.set(self, "content_moderation_config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]:
        """
        (Updatable) **SessionConfig**

        Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @session_config.setter
    def session_config(self, value: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]):
        pulumi.set(self, "session_config", value)

    @property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @should_enable_citation.setter
    def should_enable_citation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_citation", value)

    @property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @should_enable_session.setter
    def should_enable_session(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_session", value)

    @property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @should_enable_trace.setter
    def should_enable_trace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_trace", value)


@pulumi.input_type
class _AgentAgentEndpointState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 session_config: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']] = None,
                 should_enable_citation: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentAgentEndpoint resources.
        :param pulumi.Input[builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input['AgentAgentEndpointContentModerationConfigArgs'] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input['AgentAgentEndpointSessionConfigArgs'] session_config: (Updatable) **SessionConfig**
               
               Session Configuration on AgentEndpoint.
        :param pulumi.Input[builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if content_moderation_config is not None:
            pulumi.set(__self__, "content_moderation_config", content_moderation_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if session_config is not None:
            pulumi.set(__self__, "session_config", session_config)
        if should_enable_citation is not None:
            pulumi.set(__self__, "should_enable_citation", should_enable_citation)
        if should_enable_session is not None:
            pulumi.set(__self__, "should_enable_session", should_enable_session)
        if should_enable_trace is not None:
            pulumi.set(__self__, "should_enable_trace", should_enable_trace)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @content_moderation_config.setter
    def content_moderation_config(self, value: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]):
        pulumi.set(self, "content_moderation_config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]:
        """
        (Updatable) **SessionConfig**

        Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @session_config.setter
    def session_config(self, value: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]):
        pulumi.set(self, "session_config", value)

    @property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @should_enable_citation.setter
    def should_enable_citation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_citation", value)

    @property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @should_enable_session.setter
    def should_enable_session(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_session", value)

    @property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @should_enable_trace.setter
    def should_enable_trace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_enable_trace", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint")
class AgentAgentEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
                 should_enable_citation: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Agent Endpoint resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        **CreateAgentEndpoint**

        Creates an endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_endpoint = oci.generative_ai.AgentAgentEndpoint("test_agent_endpoint",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            content_moderation_config={
                "should_enable_on_input": agent_endpoint_content_moderation_config_should_enable_on_input,
                "should_enable_on_output": agent_endpoint_content_moderation_config_should_enable_on_output,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=agent_endpoint_description,
            display_name=agent_endpoint_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            session_config={
                "idle_timeout_in_seconds": agent_endpoint_session_config_idle_timeout_in_seconds,
            },
            should_enable_citation=agent_endpoint_should_enable_citation,
            should_enable_session=agent_endpoint_should_enable_session,
            should_enable_trace=agent_endpoint_should_enable_trace)
        ```

        ## Import

        AgentEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint test_agent_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']] session_config: (Updatable) **SessionConfig**
               
               Session Configuration on AgentEndpoint.
        :param pulumi.Input[builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Agent Endpoint resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        **CreateAgentEndpoint**

        Creates an endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_endpoint = oci.generative_ai.AgentAgentEndpoint("test_agent_endpoint",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            content_moderation_config={
                "should_enable_on_input": agent_endpoint_content_moderation_config_should_enable_on_input,
                "should_enable_on_output": agent_endpoint_content_moderation_config_should_enable_on_output,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=agent_endpoint_description,
            display_name=agent_endpoint_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            session_config={
                "idle_timeout_in_seconds": agent_endpoint_session_config_idle_timeout_in_seconds,
            },
            should_enable_citation=agent_endpoint_should_enable_citation,
            should_enable_session=agent_endpoint_should_enable_session,
            should_enable_trace=agent_endpoint_should_enable_trace)
        ```

        ## Import

        AgentEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint test_agent_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
                 should_enable_citation: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentEndpointArgs.__new__(AgentAgentEndpointArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["content_moderation_config"] = content_moderation_config
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["session_config"] = session_config
            __props__.__dict__["should_enable_citation"] = should_enable_citation
            __props__.__dict__["should_enable_session"] = should_enable_session
            __props__.__dict__["should_enable_trace"] = should_enable_trace
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AgentAgentEndpoint, __self__).__init__(
            'oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
            should_enable_citation: Optional[pulumi.Input[builtins.bool]] = None,
            should_enable_session: Optional[pulumi.Input[builtins.bool]] = None,
            should_enable_trace: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'AgentAgentEndpoint':
        """
        Get an existing AgentAgentEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']] session_config: (Updatable) **SessionConfig**
               
               Session Configuration on AgentEndpoint.
        :param pulumi.Input[builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentEndpointState.__new__(_AgentAgentEndpointState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["content_moderation_config"] = content_moderation_config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["session_config"] = session_config
        __props__.__dict__["should_enable_citation"] = should_enable_citation
        __props__.__dict__["should_enable_session"] = should_enable_session
        __props__.__dict__["should_enable_trace"] = should_enable_trace
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AgentAgentEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> pulumi.Output['outputs.AgentAgentEndpointContentModerationConfig']:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> pulumi.Output['outputs.AgentAgentEndpointSessionConfig']:
        """
        (Updatable) **SessionConfig**

        Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

