# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeploymentPeersResult',
    'AwaitableGetDeploymentPeersResult',
    'get_deployment_peers',
    'get_deployment_peers_output',
]

@pulumi.output_type
class GetDeploymentPeersResult:
    """
    A collection of values returned by getDeploymentPeers.
    """
    def __init__(__self__, deployment_id=None, deployment_peer_collections=None, display_name=None, filters=None, id=None, state=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_peer_collections and not isinstance(deployment_peer_collections, list):
            raise TypeError("Expected argument 'deployment_peer_collections' to be a list")
        pulumi.set(__self__, "deployment_peer_collections", deployment_peer_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentPeerCollections")
    def deployment_peer_collections(self) -> Sequence['outputs.GetDeploymentPeersDeploymentPeerCollectionResult']:
        """
        The list of deployment_peer_collection.
        """
        return pulumi.get(self, "deployment_peer_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeploymentPeersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Possible lifecycle states for deployment peer.
        """
        return pulumi.get(self, "state")


class AwaitableGetDeploymentPeersResult(GetDeploymentPeersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentPeersResult(
            deployment_id=self.deployment_id,
            deployment_peer_collections=self.deployment_peer_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_deployment_peers(deployment_id: Optional[builtins.str] = None,
                         display_name: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetDeploymentPeersFilterArgs', 'GetDeploymentPeersFilterArgsDict']]] = None,
                         state: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentPeersResult:
    """
    This data source provides the list of Deployment Peers in Oracle Cloud Infrastructure Golden Gate service.

    Lists the local and remote peers in a deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_peers = oci.GoldenGate.get_deployment_peers(deployment_id=test_deployment["id"],
        display_name=deployment_peer_display_name,
        state=deployment_peer_state)
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str state: A filter to return only the resources that match the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentPeers:getDeploymentPeers', __args__, opts=opts, typ=GetDeploymentPeersResult).value

    return AwaitableGetDeploymentPeersResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_peer_collections=pulumi.get(__ret__, 'deployment_peer_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_deployment_peers_output(deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDeploymentPeersFilterArgs', 'GetDeploymentPeersFilterArgsDict']]]]] = None,
                                state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentPeersResult]:
    """
    This data source provides the list of Deployment Peers in Oracle Cloud Infrastructure Golden Gate service.

    Lists the local and remote peers in a deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_peers = oci.GoldenGate.get_deployment_peers(deployment_id=test_deployment["id"],
        display_name=deployment_peer_display_name,
        state=deployment_peer_state)
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str state: A filter to return only the resources that match the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDeploymentPeers:getDeploymentPeers', __args__, opts=opts, typ=GetDeploymentPeersResult)
    return __ret__.apply(lambda __response__: GetDeploymentPeersResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        deployment_peer_collections=pulumi.get(__response__, 'deployment_peer_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
