# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsSelfRegistrationProfileArgs', 'DomainsSelfRegistrationProfile']

@pulumi.input_type
class DomainsSelfRegistrationProfileArgs:
    def __init__(__self__, *,
                 activation_email_required: pulumi.Input[builtins.bool],
                 consent_text_present: pulumi.Input[builtins.bool],
                 display_names: pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]],
                 email_template: pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs'],
                 idcs_endpoint: pulumi.Input[builtins.str],
                 number_of_days_redirect_url_is_valid: pulumi.Input[builtins.int],
                 redirect_url: pulumi.Input[builtins.str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 show_on_login_page: pulumi.Input[builtins.bool],
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 after_submit_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]] = None,
                 allowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 consent_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]] = None,
                 default_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]] = None,
                 disallowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 footer_logo: Optional[pulumi.Input[builtins.str]] = None,
                 footer_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]] = None,
                 header_logo: Optional[pulumi.Input[builtins.str]] = None,
                 header_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsSelfRegistrationProfile resource.
        :param pulumi.Input[builtins.bool] activation_email_required: (Updatable) **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        :param pulumi.Input[builtins.bool] consent_text_present: (Updatable) A boolean value that indicates whether the consent text is present.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]] display_names: (Updatable) Registration page name
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs'] email_template: (Updatable) Email template
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.int] number_of_days_redirect_url_is_valid: (Updatable) Number of days redirect URL is valid
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login_page: (Updatable) A Boolean value that indicates whether the profile should be displayed on login page
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] active: (Updatable) A Boolean value that indicates whether the profile is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]] after_submit_texts: (Updatable) Text to be displayed on UI after doing self registration
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_email_domains: (Updatable) A Multivalue String value for Email domains which are valid for this profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]] consent_texts: (Updatable) Consent text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]] default_groups: (Updatable) Default groups assigned to the user
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_email_domains: (Updatable) A Multivalue String Value for Email domains to be handled as exceptions
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] footer_logo: (Updatable) References to footer logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]] footer_texts: (Updatable) Footer text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] header_logo: (Updatable) Reference to header logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]] header_texts: (Updatable) Header text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: (Updatable) Name of the profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]] user_attributes: (Updatable) **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none User Attributes
        """
        pulumi.set(__self__, "activation_email_required", activation_email_required)
        pulumi.set(__self__, "consent_text_present", consent_text_present)
        pulumi.set(__self__, "display_names", display_names)
        pulumi.set(__self__, "email_template", email_template)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "number_of_days_redirect_url_is_valid", number_of_days_redirect_url_is_valid)
        pulumi.set(__self__, "redirect_url", redirect_url)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "show_on_login_page", show_on_login_page)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if after_submit_texts is not None:
            pulumi.set(__self__, "after_submit_texts", after_submit_texts)
        if allowed_email_domains is not None:
            pulumi.set(__self__, "allowed_email_domains", allowed_email_domains)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if consent_texts is not None:
            pulumi.set(__self__, "consent_texts", consent_texts)
        if default_groups is not None:
            pulumi.set(__self__, "default_groups", default_groups)
        if disallowed_email_domains is not None:
            pulumi.set(__self__, "disallowed_email_domains", disallowed_email_domains)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if footer_logo is not None:
            pulumi.set(__self__, "footer_logo", footer_logo)
        if footer_texts is not None:
            pulumi.set(__self__, "footer_texts", footer_texts)
        if header_logo is not None:
            pulumi.set(__self__, "header_logo", header_logo)
        if header_texts is not None:
            pulumi.set(__self__, "header_texts", header_texts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_attributes is not None:
            pulumi.set(__self__, "user_attributes", user_attributes)

    @property
    @pulumi.getter(name="activationEmailRequired")
    def activation_email_required(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        """
        return pulumi.get(self, "activation_email_required")

    @activation_email_required.setter
    def activation_email_required(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "activation_email_required", value)

    @property
    @pulumi.getter(name="consentTextPresent")
    def consent_text_present(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) A boolean value that indicates whether the consent text is present.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "consent_text_present")

    @consent_text_present.setter
    def consent_text_present(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "consent_text_present", value)

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]]:
        """
        (Updatable) Registration page name

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "display_names")

    @display_names.setter
    def display_names(self, value: pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]]):
        pulumi.set(self, "display_names", value)

    @property
    @pulumi.getter(name="emailTemplate")
    def email_template(self) -> pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs']:
        """
        (Updatable) Email template

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "email_template")

    @email_template.setter
    def email_template(self, value: pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs']):
        pulumi.set(self, "email_template", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="numberOfDaysRedirectUrlIsValid")
    def number_of_days_redirect_url_is_valid(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) Number of days redirect URL is valid

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "number_of_days_redirect_url_is_valid")

    @number_of_days_redirect_url_is_valid.setter
    def number_of_days_redirect_url_is_valid(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "number_of_days_redirect_url_is_valid", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="showOnLoginPage")
    def show_on_login_page(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) A Boolean value that indicates whether the profile should be displayed on login page

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login_page")

    @show_on_login_page.setter
    def show_on_login_page(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "show_on_login_page", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A Boolean value that indicates whether the profile is enabled or not

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="afterSubmitTexts")
    def after_submit_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]]:
        """
        (Updatable) Text to be displayed on UI after doing self registration

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "after_submit_texts")

    @after_submit_texts.setter
    def after_submit_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]]):
        pulumi.set(self, "after_submit_texts", value)

    @property
    @pulumi.getter(name="allowedEmailDomains")
    def allowed_email_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A Multivalue String value for Email domains which are valid for this profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_email_domains")

    @allowed_email_domains.setter
    def allowed_email_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_email_domains", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="consentTexts")
    def consent_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]]:
        """
        (Updatable) Consent text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "consent_texts")

    @consent_texts.setter
    def consent_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]]):
        pulumi.set(self, "consent_texts", value)

    @property
    @pulumi.getter(name="defaultGroups")
    def default_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]]:
        """
        (Updatable) Default groups assigned to the user

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "default_groups")

    @default_groups.setter
    def default_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]]):
        pulumi.set(self, "default_groups", value)

    @property
    @pulumi.getter(name="disallowedEmailDomains")
    def disallowed_email_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A Multivalue String Value for Email domains to be handled as exceptions

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_email_domains")

    @disallowed_email_domains.setter
    def disallowed_email_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "disallowed_email_domains", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="footerLogo")
    def footer_logo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) References to footer logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "footer_logo")

    @footer_logo.setter
    def footer_logo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "footer_logo", value)

    @property
    @pulumi.getter(name="footerTexts")
    def footer_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]]:
        """
        (Updatable) Footer text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "footer_texts")

    @footer_texts.setter
    def footer_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]]):
        pulumi.set(self, "footer_texts", value)

    @property
    @pulumi.getter(name="headerLogo")
    def header_logo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Reference to header logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "header_logo")

    @header_logo.setter
    def header_logo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_logo", value)

    @property
    @pulumi.getter(name="headerTexts")
    def header_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]]:
        """
        (Updatable) Header text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "header_texts")

    @header_texts.setter
    def header_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]]):
        pulumi.set(self, "header_texts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]]:
        """
        (Updatable) **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none User Attributes
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]]):
        pulumi.set(self, "user_attributes", value)


@pulumi.input_type
class _DomainsSelfRegistrationProfileState:
    def __init__(__self__, *,
                 activation_email_required: Optional[pulumi.Input[builtins.bool]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 after_submit_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]] = None,
                 allowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 consent_text_present: Optional[pulumi.Input[builtins.bool]] = None,
                 consent_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]] = None,
                 default_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 disallowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 email_template: Optional[pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs']] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 footer_logo: Optional[pulumi.Input[builtins.str]] = None,
                 footer_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]] = None,
                 header_logo: Optional[pulumi.Input[builtins.str]] = None,
                 header_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileMetaArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_days_redirect_url_is_valid: Optional[pulumi.Input[builtins.int]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 show_on_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainsSelfRegistrationProfile resources.
        :param pulumi.Input[builtins.bool] activation_email_required: (Updatable) **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        :param pulumi.Input[builtins.bool] active: (Updatable) A Boolean value that indicates whether the profile is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]] after_submit_texts: (Updatable) Text to be displayed on UI after doing self registration
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_email_domains: (Updatable) A Multivalue String value for Email domains which are valid for this profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] consent_text_present: (Updatable) A boolean value that indicates whether the consent text is present.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]] consent_texts: (Updatable) Consent text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]] default_groups: (Updatable) Default groups assigned to the user
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_email_domains: (Updatable) A Multivalue String Value for Email domains to be handled as exceptions
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]] display_names: (Updatable) Registration page name
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs'] email_template: (Updatable) Email template
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] footer_logo: (Updatable) References to footer logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]] footer_texts: (Updatable) Footer text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] header_logo: (Updatable) Reference to header logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]] header_texts: (Updatable) Header text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) Name of the profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.int] number_of_days_redirect_url_is_valid: (Updatable) Number of days redirect URL is valid
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login_page: (Updatable) A Boolean value that indicates whether the profile should be displayed on login page
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]] user_attributes: (Updatable) **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none User Attributes
        """
        if activation_email_required is not None:
            pulumi.set(__self__, "activation_email_required", activation_email_required)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if after_submit_texts is not None:
            pulumi.set(__self__, "after_submit_texts", after_submit_texts)
        if allowed_email_domains is not None:
            pulumi.set(__self__, "allowed_email_domains", allowed_email_domains)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if consent_text_present is not None:
            pulumi.set(__self__, "consent_text_present", consent_text_present)
        if consent_texts is not None:
            pulumi.set(__self__, "consent_texts", consent_texts)
        if default_groups is not None:
            pulumi.set(__self__, "default_groups", default_groups)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if disallowed_email_domains is not None:
            pulumi.set(__self__, "disallowed_email_domains", disallowed_email_domains)
        if display_names is not None:
            pulumi.set(__self__, "display_names", display_names)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if email_template is not None:
            pulumi.set(__self__, "email_template", email_template)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if footer_logo is not None:
            pulumi.set(__self__, "footer_logo", footer_logo)
        if footer_texts is not None:
            pulumi.set(__self__, "footer_texts", footer_texts)
        if header_logo is not None:
            pulumi.set(__self__, "header_logo", header_logo)
        if header_texts is not None:
            pulumi.set(__self__, "header_texts", header_texts)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_days_redirect_url_is_valid is not None:
            pulumi.set(__self__, "number_of_days_redirect_url_is_valid", number_of_days_redirect_url_is_valid)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if show_on_login_page is not None:
            pulumi.set(__self__, "show_on_login_page", show_on_login_page)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if user_attributes is not None:
            pulumi.set(__self__, "user_attributes", user_attributes)

    @property
    @pulumi.getter(name="activationEmailRequired")
    def activation_email_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        """
        return pulumi.get(self, "activation_email_required")

    @activation_email_required.setter
    def activation_email_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activation_email_required", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A Boolean value that indicates whether the profile is enabled or not

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="afterSubmitTexts")
    def after_submit_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]]:
        """
        (Updatable) Text to be displayed on UI after doing self registration

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "after_submit_texts")

    @after_submit_texts.setter
    def after_submit_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileAfterSubmitTextArgs']]]]):
        pulumi.set(self, "after_submit_texts", value)

    @property
    @pulumi.getter(name="allowedEmailDomains")
    def allowed_email_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A Multivalue String value for Email domains which are valid for this profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_email_domains")

    @allowed_email_domains.setter
    def allowed_email_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_email_domains", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="consentTextPresent")
    def consent_text_present(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean value that indicates whether the consent text is present.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "consent_text_present")

    @consent_text_present.setter
    def consent_text_present(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "consent_text_present", value)

    @property
    @pulumi.getter(name="consentTexts")
    def consent_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]]:
        """
        (Updatable) Consent text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "consent_texts")

    @consent_texts.setter
    def consent_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileConsentTextArgs']]]]):
        pulumi.set(self, "consent_texts", value)

    @property
    @pulumi.getter(name="defaultGroups")
    def default_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]]:
        """
        (Updatable) Default groups assigned to the user

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "default_groups")

    @default_groups.setter
    def default_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDefaultGroupArgs']]]]):
        pulumi.set(self, "default_groups", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="disallowedEmailDomains")
    def disallowed_email_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A Multivalue String Value for Email domains to be handled as exceptions

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_email_domains")

    @disallowed_email_domains.setter
    def disallowed_email_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "disallowed_email_domains", value)

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]]]:
        """
        (Updatable) Registration page name

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "display_names")

    @display_names.setter
    def display_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileDisplayNameArgs']]]]):
        pulumi.set(self, "display_names", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="emailTemplate")
    def email_template(self) -> Optional[pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs']]:
        """
        (Updatable) Email template

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "email_template")

    @email_template.setter
    def email_template(self, value: Optional[pulumi.Input['DomainsSelfRegistrationProfileEmailTemplateArgs']]):
        pulumi.set(self, "email_template", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="footerLogo")
    def footer_logo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) References to footer logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "footer_logo")

    @footer_logo.setter
    def footer_logo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "footer_logo", value)

    @property
    @pulumi.getter(name="footerTexts")
    def footer_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]]:
        """
        (Updatable) Footer text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "footer_texts")

    @footer_texts.setter
    def footer_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileFooterTextArgs']]]]):
        pulumi.set(self, "footer_texts", value)

    @property
    @pulumi.getter(name="headerLogo")
    def header_logo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Reference to header logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "header_logo")

    @header_logo.setter
    def header_logo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_logo", value)

    @property
    @pulumi.getter(name="headerTexts")
    def header_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]]:
        """
        (Updatable) Header text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "header_texts")

    @header_texts.setter
    def header_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileHeaderTextArgs']]]]):
        pulumi.set(self, "header_texts", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfDaysRedirectUrlIsValid")
    def number_of_days_redirect_url_is_valid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of days redirect URL is valid

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "number_of_days_redirect_url_is_valid")

    @number_of_days_redirect_url_is_valid.setter
    def number_of_days_redirect_url_is_valid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_days_redirect_url_is_valid", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="showOnLoginPage")
    def show_on_login_page(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A Boolean value that indicates whether the profile should be displayed on login page

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login_page")

    @show_on_login_page.setter
    def show_on_login_page(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "show_on_login_page", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]]:
        """
        (Updatable) **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none User Attributes
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSelfRegistrationProfileUserAttributeArgs']]]]):
        pulumi.set(self, "user_attributes", value)


@pulumi.type_token("oci:Identity/domainsSelfRegistrationProfile:DomainsSelfRegistrationProfile")
class DomainsSelfRegistrationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email_required: Optional[pulumi.Input[builtins.bool]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 after_submit_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileAfterSubmitTextArgs', 'DomainsSelfRegistrationProfileAfterSubmitTextArgsDict']]]]] = None,
                 allowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 consent_text_present: Optional[pulumi.Input[builtins.bool]] = None,
                 consent_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileConsentTextArgs', 'DomainsSelfRegistrationProfileConsentTextArgsDict']]]]] = None,
                 default_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDefaultGroupArgs', 'DomainsSelfRegistrationProfileDefaultGroupArgsDict']]]]] = None,
                 disallowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDisplayNameArgs', 'DomainsSelfRegistrationProfileDisplayNameArgsDict']]]]] = None,
                 email_template: Optional[pulumi.Input[Union['DomainsSelfRegistrationProfileEmailTemplateArgs', 'DomainsSelfRegistrationProfileEmailTemplateArgsDict']]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 footer_logo: Optional[pulumi.Input[builtins.str]] = None,
                 footer_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileFooterTextArgs', 'DomainsSelfRegistrationProfileFooterTextArgsDict']]]]] = None,
                 header_logo: Optional[pulumi.Input[builtins.str]] = None,
                 header_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileHeaderTextArgs', 'DomainsSelfRegistrationProfileHeaderTextArgsDict']]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_days_redirect_url_is_valid: Optional[pulumi.Input[builtins.int]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 show_on_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileTagArgs', 'DomainsSelfRegistrationProfileTagArgsDict']]]]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileUserAttributeArgs', 'DomainsSelfRegistrationProfileUserAttributeArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Self Registration Profile resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a self-registration profile.

        ## Import

        SelfRegistrationProfiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSelfRegistrationProfile:DomainsSelfRegistrationProfile test_self_registration_profile "idcsEndpoint/{idcsEndpoint}/selfRegistrationProfiles/{selfRegistrationProfileId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activation_email_required: (Updatable) **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        :param pulumi.Input[builtins.bool] active: (Updatable) A Boolean value that indicates whether the profile is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileAfterSubmitTextArgs', 'DomainsSelfRegistrationProfileAfterSubmitTextArgsDict']]]] after_submit_texts: (Updatable) Text to be displayed on UI after doing self registration
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_email_domains: (Updatable) A Multivalue String value for Email domains which are valid for this profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.bool] consent_text_present: (Updatable) A boolean value that indicates whether the consent text is present.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileConsentTextArgs', 'DomainsSelfRegistrationProfileConsentTextArgsDict']]]] consent_texts: (Updatable) Consent text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDefaultGroupArgs', 'DomainsSelfRegistrationProfileDefaultGroupArgsDict']]]] default_groups: (Updatable) Default groups assigned to the user
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_email_domains: (Updatable) A Multivalue String Value for Email domains to be handled as exceptions
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDisplayNameArgs', 'DomainsSelfRegistrationProfileDisplayNameArgsDict']]]] display_names: (Updatable) Registration page name
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsSelfRegistrationProfileEmailTemplateArgs', 'DomainsSelfRegistrationProfileEmailTemplateArgsDict']] email_template: (Updatable) Email template
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] footer_logo: (Updatable) References to footer logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileFooterTextArgs', 'DomainsSelfRegistrationProfileFooterTextArgsDict']]]] footer_texts: (Updatable) Footer text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] header_logo: (Updatable) Reference to header logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileHeaderTextArgs', 'DomainsSelfRegistrationProfileHeaderTextArgsDict']]]] header_texts: (Updatable) Header text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.str] name: (Updatable) Name of the profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.int] number_of_days_redirect_url_is_valid: (Updatable) Number of days redirect URL is valid
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login_page: (Updatable) A Boolean value that indicates whether the profile should be displayed on login page
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileTagArgs', 'DomainsSelfRegistrationProfileTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileUserAttributeArgs', 'DomainsSelfRegistrationProfileUserAttributeArgsDict']]]] user_attributes: (Updatable) **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none User Attributes
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsSelfRegistrationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Self Registration Profile resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a self-registration profile.

        ## Import

        SelfRegistrationProfiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSelfRegistrationProfile:DomainsSelfRegistrationProfile test_self_registration_profile "idcsEndpoint/{idcsEndpoint}/selfRegistrationProfiles/{selfRegistrationProfileId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsSelfRegistrationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsSelfRegistrationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email_required: Optional[pulumi.Input[builtins.bool]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 after_submit_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileAfterSubmitTextArgs', 'DomainsSelfRegistrationProfileAfterSubmitTextArgsDict']]]]] = None,
                 allowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 consent_text_present: Optional[pulumi.Input[builtins.bool]] = None,
                 consent_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileConsentTextArgs', 'DomainsSelfRegistrationProfileConsentTextArgsDict']]]]] = None,
                 default_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDefaultGroupArgs', 'DomainsSelfRegistrationProfileDefaultGroupArgsDict']]]]] = None,
                 disallowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDisplayNameArgs', 'DomainsSelfRegistrationProfileDisplayNameArgsDict']]]]] = None,
                 email_template: Optional[pulumi.Input[Union['DomainsSelfRegistrationProfileEmailTemplateArgs', 'DomainsSelfRegistrationProfileEmailTemplateArgsDict']]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 footer_logo: Optional[pulumi.Input[builtins.str]] = None,
                 footer_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileFooterTextArgs', 'DomainsSelfRegistrationProfileFooterTextArgsDict']]]]] = None,
                 header_logo: Optional[pulumi.Input[builtins.str]] = None,
                 header_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileHeaderTextArgs', 'DomainsSelfRegistrationProfileHeaderTextArgsDict']]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_days_redirect_url_is_valid: Optional[pulumi.Input[builtins.int]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 show_on_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileTagArgs', 'DomainsSelfRegistrationProfileTagArgsDict']]]]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileUserAttributeArgs', 'DomainsSelfRegistrationProfileUserAttributeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsSelfRegistrationProfileArgs.__new__(DomainsSelfRegistrationProfileArgs)

            if activation_email_required is None and not opts.urn:
                raise TypeError("Missing required property 'activation_email_required'")
            __props__.__dict__["activation_email_required"] = activation_email_required
            __props__.__dict__["active"] = active
            __props__.__dict__["after_submit_texts"] = after_submit_texts
            __props__.__dict__["allowed_email_domains"] = allowed_email_domains
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            if consent_text_present is None and not opts.urn:
                raise TypeError("Missing required property 'consent_text_present'")
            __props__.__dict__["consent_text_present"] = consent_text_present
            __props__.__dict__["consent_texts"] = consent_texts
            __props__.__dict__["default_groups"] = default_groups
            __props__.__dict__["disallowed_email_domains"] = disallowed_email_domains
            if display_names is None and not opts.urn:
                raise TypeError("Missing required property 'display_names'")
            __props__.__dict__["display_names"] = display_names
            if email_template is None and not opts.urn:
                raise TypeError("Missing required property 'email_template'")
            __props__.__dict__["email_template"] = email_template
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["footer_logo"] = footer_logo
            __props__.__dict__["footer_texts"] = footer_texts
            __props__.__dict__["header_logo"] = header_logo
            __props__.__dict__["header_texts"] = header_texts
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["name"] = name
            if number_of_days_redirect_url_is_valid is None and not opts.urn:
                raise TypeError("Missing required property 'number_of_days_redirect_url_is_valid'")
            __props__.__dict__["number_of_days_redirect_url_is_valid"] = number_of_days_redirect_url_is_valid
            __props__.__dict__["ocid"] = ocid
            if redirect_url is None and not opts.urn:
                raise TypeError("Missing required property 'redirect_url'")
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            if show_on_login_page is None and not opts.urn:
                raise TypeError("Missing required property 'show_on_login_page'")
            __props__.__dict__["show_on_login_page"] = show_on_login_page
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_attributes"] = user_attributes
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsSelfRegistrationProfile, __self__).__init__(
            'oci:Identity/domainsSelfRegistrationProfile:DomainsSelfRegistrationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_email_required: Optional[pulumi.Input[builtins.bool]] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            after_submit_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileAfterSubmitTextArgs', 'DomainsSelfRegistrationProfileAfterSubmitTextArgsDict']]]]] = None,
            allowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            attributes: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            consent_text_present: Optional[pulumi.Input[builtins.bool]] = None,
            consent_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileConsentTextArgs', 'DomainsSelfRegistrationProfileConsentTextArgsDict']]]]] = None,
            default_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDefaultGroupArgs', 'DomainsSelfRegistrationProfileDefaultGroupArgsDict']]]]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            disallowed_email_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDisplayNameArgs', 'DomainsSelfRegistrationProfileDisplayNameArgsDict']]]]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            email_template: Optional[pulumi.Input[Union['DomainsSelfRegistrationProfileEmailTemplateArgs', 'DomainsSelfRegistrationProfileEmailTemplateArgsDict']]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            footer_logo: Optional[pulumi.Input[builtins.str]] = None,
            footer_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileFooterTextArgs', 'DomainsSelfRegistrationProfileFooterTextArgsDict']]]]] = None,
            header_logo: Optional[pulumi.Input[builtins.str]] = None,
            header_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileHeaderTextArgs', 'DomainsSelfRegistrationProfileHeaderTextArgsDict']]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileIdcsCreatedByArgs', 'DomainsSelfRegistrationProfileIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs', 'DomainsSelfRegistrationProfileIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileMetaArgs', 'DomainsSelfRegistrationProfileMetaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            number_of_days_redirect_url_is_valid: Optional[pulumi.Input[builtins.int]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            show_on_login_page: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileTagArgs', 'DomainsSelfRegistrationProfileTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
            user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileUserAttributeArgs', 'DomainsSelfRegistrationProfileUserAttributeArgsDict']]]]] = None) -> 'DomainsSelfRegistrationProfile':
        """
        Get an existing DomainsSelfRegistrationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] activation_email_required: (Updatable) **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        :param pulumi.Input[builtins.bool] active: (Updatable) A Boolean value that indicates whether the profile is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileAfterSubmitTextArgs', 'DomainsSelfRegistrationProfileAfterSubmitTextArgsDict']]]] after_submit_texts: (Updatable) Text to be displayed on UI after doing self registration
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_email_domains: (Updatable) A Multivalue String value for Email domains which are valid for this profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] consent_text_present: (Updatable) A boolean value that indicates whether the consent text is present.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileConsentTextArgs', 'DomainsSelfRegistrationProfileConsentTextArgsDict']]]] consent_texts: (Updatable) Consent text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDefaultGroupArgs', 'DomainsSelfRegistrationProfileDefaultGroupArgsDict']]]] default_groups: (Updatable) Default groups assigned to the user
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_email_domains: (Updatable) A Multivalue String Value for Email domains to be handled as exceptions
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileDisplayNameArgs', 'DomainsSelfRegistrationProfileDisplayNameArgsDict']]]] display_names: (Updatable) Registration page name
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsSelfRegistrationProfileEmailTemplateArgs', 'DomainsSelfRegistrationProfileEmailTemplateArgsDict']] email_template: (Updatable) Email template
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: complex
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] footer_logo: (Updatable) References to footer logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileFooterTextArgs', 'DomainsSelfRegistrationProfileFooterTextArgsDict']]]] footer_texts: (Updatable) Footer text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] header_logo: (Updatable) Reference to header logo
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileHeaderTextArgs', 'DomainsSelfRegistrationProfileHeaderTextArgsDict']]]] header_texts: (Updatable) Header text
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * idcsMultiLanguage: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileIdcsCreatedByArgs', 'DomainsSelfRegistrationProfileIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileIdcsLastModifiedByArgs', 'DomainsSelfRegistrationProfileIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileMetaArgs', 'DomainsSelfRegistrationProfileMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) Name of the profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.int] number_of_days_redirect_url_is_valid: (Updatable) Number of days redirect URL is valid
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login_page: (Updatable) A Boolean value that indicates whether the profile should be displayed on login page
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileTagArgs', 'DomainsSelfRegistrationProfileTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSelfRegistrationProfileUserAttributeArgs', 'DomainsSelfRegistrationProfileUserAttributeArgsDict']]]] user_attributes: (Updatable) **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none User Attributes
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsSelfRegistrationProfileState.__new__(_DomainsSelfRegistrationProfileState)

        __props__.__dict__["activation_email_required"] = activation_email_required
        __props__.__dict__["active"] = active
        __props__.__dict__["after_submit_texts"] = after_submit_texts
        __props__.__dict__["allowed_email_domains"] = allowed_email_domains
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["consent_text_present"] = consent_text_present
        __props__.__dict__["consent_texts"] = consent_texts
        __props__.__dict__["default_groups"] = default_groups
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["disallowed_email_domains"] = disallowed_email_domains
        __props__.__dict__["display_names"] = display_names
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["email_template"] = email_template
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["footer_logo"] = footer_logo
        __props__.__dict__["footer_texts"] = footer_texts
        __props__.__dict__["header_logo"] = header_logo
        __props__.__dict__["header_texts"] = header_texts
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_days_redirect_url_is_valid"] = number_of_days_redirect_url_is_valid
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["show_on_login_page"] = show_on_login_page
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["user_attributes"] = user_attributes
        return DomainsSelfRegistrationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationEmailRequired")
    def activation_email_required(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not
        """
        return pulumi.get(self, "activation_email_required")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A Boolean value that indicates whether the profile is enabled or not

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="afterSubmitTexts")
    def after_submit_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileAfterSubmitText']]:
        """
        (Updatable) Text to be displayed on UI after doing self registration

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "after_submit_texts")

    @property
    @pulumi.getter(name="allowedEmailDomains")
    def allowed_email_domains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A Multivalue String value for Email domains which are valid for this profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_email_domains")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="consentTextPresent")
    def consent_text_present(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean value that indicates whether the consent text is present.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "consent_text_present")

    @property
    @pulumi.getter(name="consentTexts")
    def consent_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileConsentText']]:
        """
        (Updatable) Consent text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "consent_texts")

    @property
    @pulumi.getter(name="defaultGroups")
    def default_groups(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileDefaultGroup']]:
        """
        (Updatable) Default groups assigned to the user

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "default_groups")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="disallowedEmailDomains")
    def disallowed_email_domains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A Multivalue String Value for Email domains to be handled as exceptions

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_email_domains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileDisplayName']]:
        """
        (Updatable) Registration page name

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="emailTemplate")
    def email_template(self) -> pulumi.Output['outputs.DomainsSelfRegistrationProfileEmailTemplate']:
        """
        (Updatable) Email template

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "email_template")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="footerLogo")
    def footer_logo(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) References to footer logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "footer_logo")

    @property
    @pulumi.getter(name="footerTexts")
    def footer_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileFooterText']]:
        """
        (Updatable) Footer text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "footer_texts")

    @property
    @pulumi.getter(name="headerLogo")
    def header_logo(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Reference to header logo

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        """
        return pulumi.get(self, "header_logo")

    @property
    @pulumi.getter(name="headerTexts")
    def header_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileHeaderText']]:
        """
        (Updatable) Header text

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * idcsMultiLanguage: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "header_texts")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfDaysRedirectUrlIsValid")
    def number_of_days_redirect_url_is_valid(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Number of days redirect URL is valid

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "number_of_days_redirect_url_is_valid")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\"pending verification\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\"verified\\" state, this link will be used to verify user's email.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="showOnLoginPage")
    def show_on_login_page(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A Boolean value that indicates whether the profile should be displayed on login page

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login_page")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> pulumi.Output[Sequence['outputs.DomainsSelfRegistrationProfileUserAttribute']]:
        """
        (Updatable) **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none User Attributes
        """
        return pulumi.get(self, "user_attributes")

