# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsSocialIdentityProviderArgs', 'DomainsSocialIdentityProvider']

@pulumi.input_type
class DomainsSocialIdentityProviderArgs:
    def __init__(__self__, *,
                 account_linking_enabled: pulumi.Input[builtins.bool],
                 consumer_key: pulumi.Input[builtins.str],
                 consumer_secret: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 idcs_endpoint: pulumi.Input[builtins.str],
                 registration_enabled: pulumi.Input[builtins.bool],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 service_provider_name: pulumi.Input[builtins.str],
                 show_on_login: pulumi.Input[builtins.bool],
                 access_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 admin_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 authz_url: Optional[pulumi.Input[builtins.str]] = None,
                 auto_redirect_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_credential_in_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 clock_skew_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 id_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 jit_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]] = None,
                 jit_prov_group_static_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 relay_idp_param_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 social_jit_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsSocialIdentityProvider resource.
        :param pulumi.Input[builtins.bool] account_linking_enabled: (Updatable) Whether account linking is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_key: (Updatable) Social IDP Client Application Client ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_secret: (Updatable) Social IDP Client Application Client Secret
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * idcsSensitive: encrypt
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] enabled: (Updatable) Whether the IDP is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.bool] registration_enabled: (Updatable) Whether registration is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] service_provider_name: Service Provider Name
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login: (Updatable) Whether show on login
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] access_token_url: (Updatable) Social IDP Access token URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admin_scopes: (Updatable) Admin scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] authz_url: (Updatable) Social IDP Authorization URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] auto_redirect_enabled: (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.
               
               **Added In:** 2310202314
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] client_credential_in_payload: (Updatable) Whether the client credential is contained in payload
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.int] clock_skew_in_seconds: (Updatable) Social IDP allowed clock skew time
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) Social IDP description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] discovery_url: (Updatable) Discovery URL
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] icon_url: (Updatable) ICON URL for social idp
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] id_attribute: Id attribute used for account linking
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]] jit_prov_assigned_groups: (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.bool] jit_prov_group_static_list_enabled: (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: (Updatable) Social provider name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] profile_url: (Updatable) Social IDP User profile URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) redirect URL for social idp
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] refresh_token_url: (Updatable) Social IDP Refresh token URL
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]] relay_idp_param_mappings: (Updatable) Relay Param variable for Social IDP
               
               **Added In:** 2305190132
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [relayParamKey]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: (Updatable) Scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] social_jit_provisioning_enabled: (Updatable) Whether Social JIT Provisioning is enabled
               
               **Added In:** 2307282043
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] status: (Updatable) Status
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "account_linking_enabled", account_linking_enabled)
        pulumi.set(__self__, "consumer_key", consumer_key)
        pulumi.set(__self__, "consumer_secret", consumer_secret)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "registration_enabled", registration_enabled)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "service_provider_name", service_provider_name)
        pulumi.set(__self__, "show_on_login", show_on_login)
        if access_token_url is not None:
            pulumi.set(__self__, "access_token_url", access_token_url)
        if admin_scopes is not None:
            pulumi.set(__self__, "admin_scopes", admin_scopes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if authz_url is not None:
            pulumi.set(__self__, "authz_url", authz_url)
        if auto_redirect_enabled is not None:
            pulumi.set(__self__, "auto_redirect_enabled", auto_redirect_enabled)
        if client_credential_in_payload is not None:
            pulumi.set(__self__, "client_credential_in_payload", client_credential_in_payload)
        if clock_skew_in_seconds is not None:
            pulumi.set(__self__, "clock_skew_in_seconds", clock_skew_in_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if id_attribute is not None:
            pulumi.set(__self__, "id_attribute", id_attribute)
        if jit_prov_assigned_groups is not None:
            pulumi.set(__self__, "jit_prov_assigned_groups", jit_prov_assigned_groups)
        if jit_prov_group_static_list_enabled is not None:
            pulumi.set(__self__, "jit_prov_group_static_list_enabled", jit_prov_group_static_list_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if refresh_token_url is not None:
            pulumi.set(__self__, "refresh_token_url", refresh_token_url)
        if relay_idp_param_mappings is not None:
            pulumi.set(__self__, "relay_idp_param_mappings", relay_idp_param_mappings)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if social_jit_provisioning_enabled is not None:
            pulumi.set(__self__, "social_jit_provisioning_enabled", social_jit_provisioning_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountLinkingEnabled")
    def account_linking_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Whether account linking is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "account_linking_enabled")

    @account_linking_enabled.setter
    def account_linking_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "account_linking_enabled", value)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Social IDP Client Application Client ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Social IDP Client Application Client Secret

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * idcsSensitive: encrypt
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_secret")

    @consumer_secret.setter
    def consumer_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_secret", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Whether the IDP is enabled or not

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="registrationEnabled")
    def registration_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Whether registration is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "registration_enabled")

    @registration_enabled.setter
    def registration_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "registration_enabled", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> pulumi.Input[builtins.str]:
        """
        Service Provider Name

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_provider_name")

    @service_provider_name.setter
    def service_provider_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_provider_name", value)

    @property
    @pulumi.getter(name="showOnLogin")
    def show_on_login(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Whether show on login

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login")

    @show_on_login.setter
    def show_on_login(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "show_on_login", value)

    @property
    @pulumi.getter(name="accessTokenUrl")
    def access_token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Access token URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_url")

    @access_token_url.setter
    def access_token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_token_url", value)

    @property
    @pulumi.getter(name="adminScopes")
    def admin_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Admin scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "admin_scopes")

    @admin_scopes.setter
    def admin_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admin_scopes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="authzUrl")
    def authz_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Authorization URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authz_url")

    @authz_url.setter
    def authz_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authz_url", value)

    @property
    @pulumi.getter(name="autoRedirectEnabled")
    def auto_redirect_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

        **Added In:** 2310202314

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_redirect_enabled")

    @auto_redirect_enabled.setter
    def auto_redirect_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_redirect_enabled", value)

    @property
    @pulumi.getter(name="clientCredentialInPayload")
    def client_credential_in_payload(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the client credential is contained in payload

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "client_credential_in_payload")

    @client_credential_in_payload.setter
    def client_credential_in_payload(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_credential_in_payload", value)

    @property
    @pulumi.getter(name="clockSkewInSeconds")
    def clock_skew_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Social IDP allowed clock skew time

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_in_seconds")

    @clock_skew_in_seconds.setter
    def clock_skew_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "clock_skew_in_seconds", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Discovery URL

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "discovery_url", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) ICON URL for social idp

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id attribute used for account linking

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_attribute")

    @id_attribute.setter
    def id_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id_attribute", value)

    @property
    @pulumi.getter(name="jitProvAssignedGroups")
    def jit_prov_assigned_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]]:
        """
        (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_assigned_groups")

    @jit_prov_assigned_groups.setter
    def jit_prov_assigned_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]]):
        pulumi.set(self, "jit_prov_assigned_groups", value)

    @property
    @pulumi.getter(name="jitProvGroupStaticListEnabled")
    def jit_prov_group_static_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_group_static_list_enabled")

    @jit_prov_group_static_list_enabled.setter
    def jit_prov_group_static_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "jit_prov_group_static_list_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social provider name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP User profile URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_url", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) redirect URL for social idp

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="refreshTokenUrl")
    def refresh_token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Refresh token URL

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_url")

    @refresh_token_url.setter
    def refresh_token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_token_url", value)

    @property
    @pulumi.getter(name="relayIdpParamMappings")
    def relay_idp_param_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]]:
        """
        (Updatable) Relay Param variable for Social IDP

        **Added In:** 2305190132

        **SCIM++ Properties:**
        * idcsCompositeKey: [relayParamKey]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "relay_idp_param_mappings")

    @relay_idp_param_mappings.setter
    def relay_idp_param_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]]):
        pulumi.set(self, "relay_idp_param_mappings", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="socialJitProvisioningEnabled")
    def social_jit_provisioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether Social JIT Provisioning is enabled

        **Added In:** 2307282043

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "social_jit_provisioning_enabled")

    @social_jit_provisioning_enabled.setter
    def social_jit_provisioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "social_jit_provisioning_enabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsSocialIdentityProviderState:
    def __init__(__self__, *,
                 access_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 account_linking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 admin_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 authz_url: Optional[pulumi.Input[builtins.str]] = None,
                 auto_redirect_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_credential_in_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 clock_skew_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_key: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_secret: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 id_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 jit_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]] = None,
                 jit_prov_group_static_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderMetaArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 registration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 relay_idp_param_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 show_on_login: Optional[pulumi.Input[builtins.bool]] = None,
                 social_jit_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsSocialIdentityProvider resources.
        :param pulumi.Input[builtins.str] access_token_url: (Updatable) Social IDP Access token URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] account_linking_enabled: (Updatable) Whether account linking is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admin_scopes: (Updatable) Admin scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] authz_url: (Updatable) Social IDP Authorization URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] auto_redirect_enabled: (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.
               
               **Added In:** 2310202314
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] client_credential_in_payload: (Updatable) Whether the client credential is contained in payload
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.int] clock_skew_in_seconds: (Updatable) Social IDP allowed clock skew time
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_key: (Updatable) Social IDP Client Application Client ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_secret: (Updatable) Social IDP Client Application Client Secret
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * idcsSensitive: encrypt
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) Social IDP description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] discovery_url: (Updatable) Discovery URL
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] enabled: (Updatable) Whether the IDP is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] icon_url: (Updatable) ICON URL for social idp
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] id_attribute: Id attribute used for account linking
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]] jit_prov_assigned_groups: (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.bool] jit_prov_group_static_list_enabled: (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) Social provider name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] profile_url: (Updatable) Social IDP User profile URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) redirect URL for social idp
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] refresh_token_url: (Updatable) Social IDP Refresh token URL
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] registration_enabled: (Updatable) Whether registration is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]] relay_idp_param_mappings: (Updatable) Relay Param variable for Social IDP
               
               **Added In:** 2305190132
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [relayParamKey]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: (Updatable) Scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] service_provider_name: Service Provider Name
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login: (Updatable) Whether show on login
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] social_jit_provisioning_enabled: (Updatable) Whether Social JIT Provisioning is enabled
               
               **Added In:** 2307282043
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] status: (Updatable) Status
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if access_token_url is not None:
            pulumi.set(__self__, "access_token_url", access_token_url)
        if account_linking_enabled is not None:
            pulumi.set(__self__, "account_linking_enabled", account_linking_enabled)
        if admin_scopes is not None:
            pulumi.set(__self__, "admin_scopes", admin_scopes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if authz_url is not None:
            pulumi.set(__self__, "authz_url", authz_url)
        if auto_redirect_enabled is not None:
            pulumi.set(__self__, "auto_redirect_enabled", auto_redirect_enabled)
        if client_credential_in_payload is not None:
            pulumi.set(__self__, "client_credential_in_payload", client_credential_in_payload)
        if clock_skew_in_seconds is not None:
            pulumi.set(__self__, "clock_skew_in_seconds", clock_skew_in_seconds)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if consumer_secret is not None:
            pulumi.set(__self__, "consumer_secret", consumer_secret)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if id_attribute is not None:
            pulumi.set(__self__, "id_attribute", id_attribute)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if jit_prov_assigned_groups is not None:
            pulumi.set(__self__, "jit_prov_assigned_groups", jit_prov_assigned_groups)
        if jit_prov_group_static_list_enabled is not None:
            pulumi.set(__self__, "jit_prov_group_static_list_enabled", jit_prov_group_static_list_enabled)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if refresh_token_url is not None:
            pulumi.set(__self__, "refresh_token_url", refresh_token_url)
        if registration_enabled is not None:
            pulumi.set(__self__, "registration_enabled", registration_enabled)
        if relay_idp_param_mappings is not None:
            pulumi.set(__self__, "relay_idp_param_mappings", relay_idp_param_mappings)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)
        if show_on_login is not None:
            pulumi.set(__self__, "show_on_login", show_on_login)
        if social_jit_provisioning_enabled is not None:
            pulumi.set(__self__, "social_jit_provisioning_enabled", social_jit_provisioning_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter(name="accessTokenUrl")
    def access_token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Access token URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_url")

    @access_token_url.setter
    def access_token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_token_url", value)

    @property
    @pulumi.getter(name="accountLinkingEnabled")
    def account_linking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether account linking is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "account_linking_enabled")

    @account_linking_enabled.setter
    def account_linking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "account_linking_enabled", value)

    @property
    @pulumi.getter(name="adminScopes")
    def admin_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Admin scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "admin_scopes")

    @admin_scopes.setter
    def admin_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admin_scopes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="authzUrl")
    def authz_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Authorization URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authz_url")

    @authz_url.setter
    def authz_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authz_url", value)

    @property
    @pulumi.getter(name="autoRedirectEnabled")
    def auto_redirect_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

        **Added In:** 2310202314

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_redirect_enabled")

    @auto_redirect_enabled.setter
    def auto_redirect_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_redirect_enabled", value)

    @property
    @pulumi.getter(name="clientCredentialInPayload")
    def client_credential_in_payload(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the client credential is contained in payload

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "client_credential_in_payload")

    @client_credential_in_payload.setter
    def client_credential_in_payload(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_credential_in_payload", value)

    @property
    @pulumi.getter(name="clockSkewInSeconds")
    def clock_skew_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Social IDP allowed clock skew time

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_in_seconds")

    @clock_skew_in_seconds.setter
    def clock_skew_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "clock_skew_in_seconds", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Client Application Client ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Client Application Client Secret

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * idcsSensitive: encrypt
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_secret")

    @consumer_secret.setter
    def consumer_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_secret", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Discovery URL

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "discovery_url", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the IDP is enabled or not

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) ICON URL for social idp

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id attribute used for account linking

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_attribute")

    @id_attribute.setter
    def id_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id_attribute", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="jitProvAssignedGroups")
    def jit_prov_assigned_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]]:
        """
        (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_assigned_groups")

    @jit_prov_assigned_groups.setter
    def jit_prov_assigned_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderJitProvAssignedGroupArgs']]]]):
        pulumi.set(self, "jit_prov_assigned_groups", value)

    @property
    @pulumi.getter(name="jitProvGroupStaticListEnabled")
    def jit_prov_group_static_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_group_static_list_enabled")

    @jit_prov_group_static_list_enabled.setter
    def jit_prov_group_static_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "jit_prov_group_static_list_enabled", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social provider name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP User profile URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_url", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) redirect URL for social idp

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="refreshTokenUrl")
    def refresh_token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Social IDP Refresh token URL

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_url")

    @refresh_token_url.setter
    def refresh_token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_token_url", value)

    @property
    @pulumi.getter(name="registrationEnabled")
    def registration_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether registration is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "registration_enabled")

    @registration_enabled.setter
    def registration_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registration_enabled", value)

    @property
    @pulumi.getter(name="relayIdpParamMappings")
    def relay_idp_param_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]]:
        """
        (Updatable) Relay Param variable for Social IDP

        **Added In:** 2305190132

        **SCIM++ Properties:**
        * idcsCompositeKey: [relayParamKey]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "relay_idp_param_mappings")

    @relay_idp_param_mappings.setter
    def relay_idp_param_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderRelayIdpParamMappingArgs']]]]):
        pulumi.set(self, "relay_idp_param_mappings", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Provider Name

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_provider_name")

    @service_provider_name.setter
    def service_provider_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_provider_name", value)

    @property
    @pulumi.getter(name="showOnLogin")
    def show_on_login(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether show on login

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login")

    @show_on_login.setter
    def show_on_login(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "show_on_login", value)

    @property
    @pulumi.getter(name="socialJitProvisioningEnabled")
    def social_jit_provisioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether Social JIT Provisioning is enabled

        **Added In:** 2307282043

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "social_jit_provisioning_enabled")

    @social_jit_provisioning_enabled.setter
    def social_jit_provisioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "social_jit_provisioning_enabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSocialIdentityProviderTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)


@pulumi.type_token("oci:Identity/domainsSocialIdentityProvider:DomainsSocialIdentityProvider")
class DomainsSocialIdentityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 account_linking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 admin_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 authz_url: Optional[pulumi.Input[builtins.str]] = None,
                 auto_redirect_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_credential_in_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 clock_skew_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 consumer_key: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 id_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 jit_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderJitProvAssignedGroupArgs', 'DomainsSocialIdentityProviderJitProvAssignedGroupArgsDict']]]]] = None,
                 jit_prov_group_static_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 registration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 relay_idp_param_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderRelayIdpParamMappingArgs', 'DomainsSocialIdentityProviderRelayIdpParamMappingArgsDict']]]]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 show_on_login: Optional[pulumi.Input[builtins.bool]] = None,
                 social_jit_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderTagArgs', 'DomainsSocialIdentityProviderTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Social Identity Provider resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a Social Identity Provider

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_social_identity_provider = oci.identity.DomainsSocialIdentityProvider("test_social_identity_provider",
            account_linking_enabled=social_identity_provider_account_linking_enabled,
            consumer_key=social_identity_provider_consumer_key,
            consumer_secret=social_identity_provider_consumer_secret,
            enabled=social_identity_provider_enabled,
            idcs_endpoint=test_domain["url"],
            name=social_identity_provider_name,
            registration_enabled=social_identity_provider_registration_enabled,
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:SocialIdentityProvider"],
            service_provider_name=social_identity_provider_service_provider_name,
            show_on_login=social_identity_provider_show_on_login,
            access_token_url=social_identity_provider_access_token_url,
            admin_scopes=social_identity_provider_admin_scope,
            authorization=social_identity_provider_authorization,
            authz_url=social_identity_provider_authz_url,
            auto_redirect_enabled=social_identity_provider_auto_redirect_enabled,
            client_credential_in_payload=social_identity_provider_client_credential_in_payload,
            clock_skew_in_seconds=social_identity_provider_clock_skew_in_seconds,
            description=social_identity_provider_description,
            discovery_url=social_identity_provider_discovery_url,
            icon_url=social_identity_provider_icon_url,
            id_attribute=social_identity_provider_id_attribute,
            jit_prov_assigned_groups=[{
                "value": social_identity_provider_jit_prov_assigned_groups_value,
            }],
            jit_prov_group_static_list_enabled=social_identity_provider_jit_prov_group_static_list_enabled,
            ocid=social_identity_provider_ocid,
            profile_url=social_identity_provider_profile_url,
            redirect_url=social_identity_provider_redirect_url,
            refresh_token_url=social_identity_provider_refresh_token_url,
            relay_idp_param_mappings=[{
                "relay_param_key": social_identity_provider_relay_idp_param_mappings_relay_param_key,
                "relay_param_value": social_identity_provider_relay_idp_param_mappings_relay_param_value,
            }],
            resource_type_schema_version=social_identity_provider_resource_type_schema_version,
            scopes=social_identity_provider_scope,
            social_jit_provisioning_enabled=social_identity_provider_social_jit_provisioning_enabled,
            status=social_identity_provider_status,
            tags=[{
                "key": social_identity_provider_tags_key,
                "value": social_identity_provider_tags_value,
            }])
        ```

        ## Import

        SocialIdentityProviders can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSocialIdentityProvider:DomainsSocialIdentityProvider test_social_identity_provider "idcsEndpoint/{idcsEndpoint}/socialIdentityProviders/{socialIdentityProviderId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_token_url: (Updatable) Social IDP Access token URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] account_linking_enabled: (Updatable) Whether account linking is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admin_scopes: (Updatable) Admin scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] authz_url: (Updatable) Social IDP Authorization URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] auto_redirect_enabled: (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.
               
               **Added In:** 2310202314
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] client_credential_in_payload: (Updatable) Whether the client credential is contained in payload
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.int] clock_skew_in_seconds: (Updatable) Social IDP allowed clock skew time
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_key: (Updatable) Social IDP Client Application Client ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_secret: (Updatable) Social IDP Client Application Client Secret
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * idcsSensitive: encrypt
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) Social IDP description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] discovery_url: (Updatable) Discovery URL
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] enabled: (Updatable) Whether the IDP is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] icon_url: (Updatable) ICON URL for social idp
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] id_attribute: Id attribute used for account linking
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderJitProvAssignedGroupArgs', 'DomainsSocialIdentityProviderJitProvAssignedGroupArgsDict']]]] jit_prov_assigned_groups: (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.bool] jit_prov_group_static_list_enabled: (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: (Updatable) Social provider name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] profile_url: (Updatable) Social IDP User profile URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) redirect URL for social idp
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] refresh_token_url: (Updatable) Social IDP Refresh token URL
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] registration_enabled: (Updatable) Whether registration is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderRelayIdpParamMappingArgs', 'DomainsSocialIdentityProviderRelayIdpParamMappingArgsDict']]]] relay_idp_param_mappings: (Updatable) Relay Param variable for Social IDP
               
               **Added In:** 2305190132
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [relayParamKey]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: (Updatable) Scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] service_provider_name: Service Provider Name
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login: (Updatable) Whether show on login
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] social_jit_provisioning_enabled: (Updatable) Whether Social JIT Provisioning is enabled
               
               **Added In:** 2307282043
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] status: (Updatable) Status
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderTagArgs', 'DomainsSocialIdentityProviderTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsSocialIdentityProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Social Identity Provider resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a Social Identity Provider

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_social_identity_provider = oci.identity.DomainsSocialIdentityProvider("test_social_identity_provider",
            account_linking_enabled=social_identity_provider_account_linking_enabled,
            consumer_key=social_identity_provider_consumer_key,
            consumer_secret=social_identity_provider_consumer_secret,
            enabled=social_identity_provider_enabled,
            idcs_endpoint=test_domain["url"],
            name=social_identity_provider_name,
            registration_enabled=social_identity_provider_registration_enabled,
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:SocialIdentityProvider"],
            service_provider_name=social_identity_provider_service_provider_name,
            show_on_login=social_identity_provider_show_on_login,
            access_token_url=social_identity_provider_access_token_url,
            admin_scopes=social_identity_provider_admin_scope,
            authorization=social_identity_provider_authorization,
            authz_url=social_identity_provider_authz_url,
            auto_redirect_enabled=social_identity_provider_auto_redirect_enabled,
            client_credential_in_payload=social_identity_provider_client_credential_in_payload,
            clock_skew_in_seconds=social_identity_provider_clock_skew_in_seconds,
            description=social_identity_provider_description,
            discovery_url=social_identity_provider_discovery_url,
            icon_url=social_identity_provider_icon_url,
            id_attribute=social_identity_provider_id_attribute,
            jit_prov_assigned_groups=[{
                "value": social_identity_provider_jit_prov_assigned_groups_value,
            }],
            jit_prov_group_static_list_enabled=social_identity_provider_jit_prov_group_static_list_enabled,
            ocid=social_identity_provider_ocid,
            profile_url=social_identity_provider_profile_url,
            redirect_url=social_identity_provider_redirect_url,
            refresh_token_url=social_identity_provider_refresh_token_url,
            relay_idp_param_mappings=[{
                "relay_param_key": social_identity_provider_relay_idp_param_mappings_relay_param_key,
                "relay_param_value": social_identity_provider_relay_idp_param_mappings_relay_param_value,
            }],
            resource_type_schema_version=social_identity_provider_resource_type_schema_version,
            scopes=social_identity_provider_scope,
            social_jit_provisioning_enabled=social_identity_provider_social_jit_provisioning_enabled,
            status=social_identity_provider_status,
            tags=[{
                "key": social_identity_provider_tags_key,
                "value": social_identity_provider_tags_value,
            }])
        ```

        ## Import

        SocialIdentityProviders can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSocialIdentityProvider:DomainsSocialIdentityProvider test_social_identity_provider "idcsEndpoint/{idcsEndpoint}/socialIdentityProviders/{socialIdentityProviderId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsSocialIdentityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsSocialIdentityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 account_linking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 admin_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 authz_url: Optional[pulumi.Input[builtins.str]] = None,
                 auto_redirect_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_credential_in_payload: Optional[pulumi.Input[builtins.bool]] = None,
                 clock_skew_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 consumer_key: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 id_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 jit_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderJitProvAssignedGroupArgs', 'DomainsSocialIdentityProviderJitProvAssignedGroupArgsDict']]]]] = None,
                 jit_prov_group_static_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 registration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 relay_idp_param_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderRelayIdpParamMappingArgs', 'DomainsSocialIdentityProviderRelayIdpParamMappingArgsDict']]]]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 show_on_login: Optional[pulumi.Input[builtins.bool]] = None,
                 social_jit_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderTagArgs', 'DomainsSocialIdentityProviderTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsSocialIdentityProviderArgs.__new__(DomainsSocialIdentityProviderArgs)

            __props__.__dict__["access_token_url"] = access_token_url
            if account_linking_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'account_linking_enabled'")
            __props__.__dict__["account_linking_enabled"] = account_linking_enabled
            __props__.__dict__["admin_scopes"] = admin_scopes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["authz_url"] = authz_url
            __props__.__dict__["auto_redirect_enabled"] = auto_redirect_enabled
            __props__.__dict__["client_credential_in_payload"] = client_credential_in_payload
            __props__.__dict__["clock_skew_in_seconds"] = clock_skew_in_seconds
            if consumer_key is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_key'")
            __props__.__dict__["consumer_key"] = consumer_key
            if consumer_secret is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_secret'")
            __props__.__dict__["consumer_secret"] = consumer_secret
            __props__.__dict__["description"] = description
            __props__.__dict__["discovery_url"] = discovery_url
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["icon_url"] = icon_url
            __props__.__dict__["id_attribute"] = id_attribute
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["jit_prov_assigned_groups"] = jit_prov_assigned_groups
            __props__.__dict__["jit_prov_group_static_list_enabled"] = jit_prov_group_static_list_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["profile_url"] = profile_url
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["refresh_token_url"] = refresh_token_url
            if registration_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'registration_enabled'")
            __props__.__dict__["registration_enabled"] = registration_enabled
            __props__.__dict__["relay_idp_param_mappings"] = relay_idp_param_mappings
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["scopes"] = scopes
            if service_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_provider_name'")
            __props__.__dict__["service_provider_name"] = service_provider_name
            if show_on_login is None and not opts.urn:
                raise TypeError("Missing required property 'show_on_login'")
            __props__.__dict__["show_on_login"] = show_on_login
            __props__.__dict__["social_jit_provisioning_enabled"] = social_jit_provisioning_enabled
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsSocialIdentityProvider, __self__).__init__(
            'oci:Identity/domainsSocialIdentityProvider:DomainsSocialIdentityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_url: Optional[pulumi.Input[builtins.str]] = None,
            account_linking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            admin_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            authz_url: Optional[pulumi.Input[builtins.str]] = None,
            auto_redirect_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            client_credential_in_payload: Optional[pulumi.Input[builtins.bool]] = None,
            clock_skew_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            consumer_key: Optional[pulumi.Input[builtins.str]] = None,
            consumer_secret: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            discovery_url: Optional[pulumi.Input[builtins.str]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            icon_url: Optional[pulumi.Input[builtins.str]] = None,
            id_attribute: Optional[pulumi.Input[builtins.str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderIdcsCreatedByArgs', 'DomainsSocialIdentityProviderIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderIdcsLastModifiedByArgs', 'DomainsSocialIdentityProviderIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            jit_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderJitProvAssignedGroupArgs', 'DomainsSocialIdentityProviderJitProvAssignedGroupArgsDict']]]]] = None,
            jit_prov_group_static_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderMetaArgs', 'DomainsSocialIdentityProviderMetaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            profile_url: Optional[pulumi.Input[builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[builtins.str]] = None,
            refresh_token_url: Optional[pulumi.Input[builtins.str]] = None,
            registration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            relay_idp_param_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderRelayIdpParamMappingArgs', 'DomainsSocialIdentityProviderRelayIdpParamMappingArgsDict']]]]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
            show_on_login: Optional[pulumi.Input[builtins.bool]] = None,
            social_jit_provisioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderTagArgs', 'DomainsSocialIdentityProviderTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainsSocialIdentityProvider':
        """
        Get an existing DomainsSocialIdentityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_token_url: (Updatable) Social IDP Access token URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] account_linking_enabled: (Updatable) Whether account linking is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admin_scopes: (Updatable) Admin scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] authz_url: (Updatable) Social IDP Authorization URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] auto_redirect_enabled: (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.
               
               **Added In:** 2310202314
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] client_credential_in_payload: (Updatable) Whether the client credential is contained in payload
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.int] clock_skew_in_seconds: (Updatable) Social IDP allowed clock skew time
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_key: (Updatable) Social IDP Client Application Client ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] consumer_secret: (Updatable) Social IDP Client Application Client Secret
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * idcsSensitive: encrypt
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) Social IDP description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] discovery_url: (Updatable) Discovery URL
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] enabled: (Updatable) Whether the IDP is enabled or not
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] icon_url: (Updatable) ICON URL for social idp
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] id_attribute: Id attribute used for account linking
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderIdcsCreatedByArgs', 'DomainsSocialIdentityProviderIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderIdcsLastModifiedByArgs', 'DomainsSocialIdentityProviderIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderJitProvAssignedGroupArgs', 'DomainsSocialIdentityProviderJitProvAssignedGroupArgsDict']]]] jit_prov_assigned_groups: (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.bool] jit_prov_group_static_list_enabled: (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 2309290043
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderMetaArgs', 'DomainsSocialIdentityProviderMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) Social provider name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] profile_url: (Updatable) Social IDP User profile URL
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] redirect_url: (Updatable) redirect URL for social idp
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] refresh_token_url: (Updatable) Social IDP Refresh token URL
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] registration_enabled: (Updatable) Whether registration is enabled
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderRelayIdpParamMappingArgs', 'DomainsSocialIdentityProviderRelayIdpParamMappingArgsDict']]]] relay_idp_param_mappings: (Updatable) Relay Param variable for Social IDP
               
               **Added In:** 2305190132
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [relayParamKey]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: (Updatable) Scope to request
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] service_provider_name: Service Provider Name
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] show_on_login: (Updatable) Whether show on login
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.bool] social_jit_provisioning_enabled: (Updatable) Whether Social JIT Provisioning is enabled
               
               **Added In:** 2307282043
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] status: (Updatable) Status
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSocialIdentityProviderTagArgs', 'DomainsSocialIdentityProviderTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsSocialIdentityProviderState.__new__(_DomainsSocialIdentityProviderState)

        __props__.__dict__["access_token_url"] = access_token_url
        __props__.__dict__["account_linking_enabled"] = account_linking_enabled
        __props__.__dict__["admin_scopes"] = admin_scopes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["authz_url"] = authz_url
        __props__.__dict__["auto_redirect_enabled"] = auto_redirect_enabled
        __props__.__dict__["client_credential_in_payload"] = client_credential_in_payload
        __props__.__dict__["clock_skew_in_seconds"] = clock_skew_in_seconds
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["consumer_key"] = consumer_key
        __props__.__dict__["consumer_secret"] = consumer_secret
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["discovery_url"] = discovery_url
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["id_attribute"] = id_attribute
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["jit_prov_assigned_groups"] = jit_prov_assigned_groups
        __props__.__dict__["jit_prov_group_static_list_enabled"] = jit_prov_group_static_list_enabled
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["profile_url"] = profile_url
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["refresh_token_url"] = refresh_token_url
        __props__.__dict__["registration_enabled"] = registration_enabled
        __props__.__dict__["relay_idp_param_mappings"] = relay_idp_param_mappings
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["service_provider_name"] = service_provider_name
        __props__.__dict__["show_on_login"] = show_on_login
        __props__.__dict__["social_jit_provisioning_enabled"] = social_jit_provisioning_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        return DomainsSocialIdentityProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenUrl")
    def access_token_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP Access token URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_url")

    @property
    @pulumi.getter(name="accountLinkingEnabled")
    def account_linking_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether account linking is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "account_linking_enabled")

    @property
    @pulumi.getter(name="adminScopes")
    def admin_scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Admin scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "admin_scopes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="authzUrl")
    def authz_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP Authorization URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authz_url")

    @property
    @pulumi.getter(name="autoRedirectEnabled")
    def auto_redirect_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

        **Added In:** 2310202314

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_redirect_enabled")

    @property
    @pulumi.getter(name="clientCredentialInPayload")
    def client_credential_in_payload(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether the client credential is contained in payload

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "client_credential_in_payload")

    @property
    @pulumi.getter(name="clockSkewInSeconds")
    def clock_skew_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Social IDP allowed clock skew time

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_in_seconds")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP Client Application Client ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP Client Application Client Secret

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * idcsSensitive: encrypt
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "consumer_secret")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Discovery URL

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "discovery_url")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether the IDP is enabled or not

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) ICON URL for social idp

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="idAttribute")
    def id_attribute(self) -> pulumi.Output[builtins.str]:
        """
        Id attribute used for account linking

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_attribute")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="jitProvAssignedGroups")
    def jit_prov_assigned_groups(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderJitProvAssignedGroup']]:
        """
        (Updatable) Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_assigned_groups")

    @property
    @pulumi.getter(name="jitProvGroupStaticListEnabled")
    def jit_prov_group_static_list_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 2309290043

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_prov_group_static_list_enabled")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social provider name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP User profile URL

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) redirect URL for social idp

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="refreshTokenUrl")
    def refresh_token_url(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Social IDP Refresh token URL

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_url")

    @property
    @pulumi.getter(name="registrationEnabled")
    def registration_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether registration is enabled

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "registration_enabled")

    @property
    @pulumi.getter(name="relayIdpParamMappings")
    def relay_idp_param_mappings(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderRelayIdpParamMapping']]:
        """
        (Updatable) Relay Param variable for Social IDP

        **Added In:** 2305190132

        **SCIM++ Properties:**
        * idcsCompositeKey: [relayParamKey]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "relay_idp_param_mappings")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Scope to request

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Provider Name

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_provider_name")

    @property
    @pulumi.getter(name="showOnLogin")
    def show_on_login(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether show on login

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_on_login")

    @property
    @pulumi.getter(name="socialJitProvisioningEnabled")
    def social_jit_provisioning_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether Social JIT Provisioning is enabled

        **Added In:** 2307282043

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "social_jit_provisioning_enabled")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Status

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsSocialIdentityProviderTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

