# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIdentityProvidersResult',
    'AwaitableGetIdentityProvidersResult',
    'get_identity_providers',
    'get_identity_providers_output',
]

@pulumi.output_type
class GetIdentityProvidersResult:
    """
    A collection of values returned by getIdentityProviders.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, identity_providers=None, name=None, protocol=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_providers and not isinstance(identity_providers, list):
            raise TypeError("Expected argument 'identity_providers' to be a list")
        pulumi.set(__self__, "identity_providers", identity_providers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the tenancy containing the `IdentityProvider`.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIdentityProvidersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityProviders")
    def identity_providers(self) -> Sequence['outputs.GetIdentityProvidersIdentityProviderResult']:
        """
        The list of identity_providers.
        """
        return pulumi.get(self, "identity_providers")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name you assign to the `IdentityProvider` during creation. The name must be unique across all `IdentityProvider` objects in the tenancy and cannot be changed. This is the name federated users see when choosing which identity provider to use when signing in to the Oracle Cloud Infrastructure Console.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol used for federation. Allowed value: `SAML2`.  Example: `SAML2`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetIdentityProvidersResult(GetIdentityProvidersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdentityProvidersResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            identity_providers=self.identity_providers,
            name=self.name,
            protocol=self.protocol,
            state=self.state)


def get_identity_providers(compartment_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetIdentityProvidersFilterArgs', 'GetIdentityProvidersFilterArgsDict']]] = None,
                           name: Optional[builtins.str] = None,
                           protocol: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdentityProvidersResult:
    """
    This data source provides the list of Identity Providers in Oracle Cloud Infrastructure Identity service.

    **Deprecated.** For more information, see [Deprecated IAM Service APIs](https://docs.cloud.oracle.com/iaas/Content/Identity/Reference/deprecatediamapis.htm).

    Lists all the identity providers in your tenancy. You must specify the identity provider type (e.g., `SAML2` for
    identity providers using the SAML2.0 protocol). You must specify your tenancy's OCID as the value for the
    compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_providers = oci.Identity.get_identity_providers(compartment_id=tenancy_ocid,
        protocol=identity_provider_protocol,
        name=identity_provider_name,
        state=identity_provider_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str protocol: The protocol used for federation.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIdentityProviders:getIdentityProviders', __args__, opts=opts, typ=GetIdentityProvidersResult).value

    return AwaitableGetIdentityProvidersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identity_providers=pulumi.get(__ret__, 'identity_providers'),
        name=pulumi.get(__ret__, 'name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        state=pulumi.get(__ret__, 'state'))
def get_identity_providers_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIdentityProvidersFilterArgs', 'GetIdentityProvidersFilterArgsDict']]]]] = None,
                                  name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  protocol: Optional[pulumi.Input[builtins.str]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIdentityProvidersResult]:
    """
    This data source provides the list of Identity Providers in Oracle Cloud Infrastructure Identity service.

    **Deprecated.** For more information, see [Deprecated IAM Service APIs](https://docs.cloud.oracle.com/iaas/Content/Identity/Reference/deprecatediamapis.htm).

    Lists all the identity providers in your tenancy. You must specify the identity provider type (e.g., `SAML2` for
    identity providers using the SAML2.0 protocol). You must specify your tenancy's OCID as the value for the
    compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_providers = oci.Identity.get_identity_providers(compartment_id=tenancy_ocid,
        protocol=identity_provider_protocol,
        name=identity_provider_name,
        state=identity_provider_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str protocol: The protocol used for federation.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getIdentityProviders:getIdentityProviders', __args__, opts=opts, typ=GetIdentityProvidersResult)
    return __ret__.apply(lambda __response__: GetIdentityProvidersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        identity_providers=pulumi.get(__response__, 'identity_providers'),
        name=pulumi.get(__response__, 'name'),
        protocol=pulumi.get(__response__, 'protocol'),
        state=pulumi.get(__response__, 'state')))
