# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IntegrationInstanceAlternateCustomEndpoint',
    'IntegrationInstanceAttachment',
    'IntegrationInstanceCustomEndpoint',
    'IntegrationInstanceDisasterRecoveryDetail',
    'IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail',
    'IntegrationInstanceIdcsInfo',
    'IntegrationInstanceNetworkEndpointDetails',
    'IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn',
    'IntegrationInstancePrivateEndpointOutboundConnection',
    'GetIntegrationInstanceAlternateCustomEndpointResult',
    'GetIntegrationInstanceAttachmentResult',
    'GetIntegrationInstanceCustomEndpointResult',
    'GetIntegrationInstanceDisasterRecoveryDetailResult',
    'GetIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult',
    'GetIntegrationInstanceIdcsInfoResult',
    'GetIntegrationInstanceNetworkEndpointDetailResult',
    'GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
    'GetIntegrationInstancePrivateEndpointOutboundConnectionResult',
    'GetIntegrationInstancesFilterResult',
    'GetIntegrationInstancesIntegrationInstanceResult',
    'GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult',
    'GetIntegrationInstancesIntegrationInstanceAttachmentResult',
    'GetIntegrationInstancesIntegrationInstanceCustomEndpointResult',
    'GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailResult',
    'GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult',
    'GetIntegrationInstancesIntegrationInstanceIdcsInfoResult',
    'GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult',
    'GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
    'GetIntegrationInstancesIntegrationInstancePrivateEndpointOutboundConnectionResult',
]

@pulumi.output_type
class IntegrationInstanceAlternateCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"
        elif key == "dnsType":
            suggest = "dns_type"
        elif key == "dnsZoneName":
            suggest = "dns_zone_name"
        elif key == "managedType":
            suggest = "managed_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceAlternateCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: builtins.str,
                 alias: Optional[builtins.str] = None,
                 certificate_secret_id: Optional[builtins.str] = None,
                 certificate_secret_version: Optional[builtins.int] = None,
                 dns_type: Optional[builtins.str] = None,
                 dns_zone_name: Optional[builtins.str] = None,
                 managed_type: Optional[builtins.str] = None):
        """
        :param builtins.str hostname: (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str dns_type: Type of DNS.
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "hostname", hostname)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        if dns_type is not None:
            pulumi.set(__self__, "dns_type", dns_type)
        if dns_zone_name is not None:
            pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        if managed_type is not None:
            pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def alias(self) -> Optional[builtins.str]:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> Optional[builtins.str]:
        """
        Type of DNS.
        """
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> Optional[builtins.str]:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> Optional[builtins.str]:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class IntegrationInstanceAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isImplicit":
            suggest = "is_implicit"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "targetInstanceUrl":
            suggest = "target_instance_url"
        elif key == "targetRole":
            suggest = "target_role"
        elif key == "targetServiceType":
            suggest = "target_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_implicit: Optional[builtins.bool] = None,
                 target_id: Optional[builtins.str] = None,
                 target_instance_url: Optional[builtins.str] = None,
                 target_role: Optional[builtins.str] = None,
                 target_service_type: Optional[builtins.str] = None):
        """
        :param builtins.bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param builtins.str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param builtins.str target_instance_url: The dataplane instance URL of the attached instance
        :param builtins.str target_role: The role of the target attachment.
               * `PARENT` - The target instance is the parent of this attachment.
               * `CHILD` - The target instance is the child of this attachment.
        :param builtins.str target_service_type: The type of the target instance, such as "FUSION".
        """
        if is_implicit is not None:
            pulumi.set(__self__, "is_implicit", is_implicit)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_instance_url is not None:
            pulumi.set(__self__, "target_instance_url", target_instance_url)
        if target_role is not None:
            pulumi.set(__self__, "target_role", target_role)
        if target_service_type is not None:
            pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> Optional[builtins.bool]:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[builtins.str]:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> Optional[builtins.str]:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> Optional[builtins.str]:
        """
        The role of the target attachment.
        * `PARENT` - The target instance is the parent of this attachment.
        * `CHILD` - The target instance is the child of this attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> Optional[builtins.str]:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class IntegrationInstanceCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsZoneName":
            suggest = "dns_zone_name"
        elif key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"
        elif key == "dnsType":
            suggest = "dns_type"
        elif key == "managedType":
            suggest = "managed_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_zone_name: builtins.str,
                 hostname: builtins.str,
                 alias: Optional[builtins.str] = None,
                 certificate_secret_id: Optional[builtins.str] = None,
                 certificate_secret_version: Optional[builtins.int] = None,
                 dns_type: Optional[builtins.str] = None,
                 managed_type: Optional[builtins.str] = None):
        """
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str hostname: (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str dns_type: Type of DNS.
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        pulumi.set(__self__, "hostname", hostname)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        if dns_type is not None:
            pulumi.set(__self__, "dns_type", dns_type)
        if managed_type is not None:
            pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> builtins.str:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        (Updatable) A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def alias(self) -> Optional[builtins.str]:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> Optional[builtins.str]:
        """
        Type of DNS.
        """
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> Optional[builtins.str]:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class IntegrationInstanceDisasterRecoveryDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRegionIntegrationInstanceDetails":
            suggest = "cross_region_integration_instance_details"
        elif key == "regionalInstanceUrl":
            suggest = "regional_instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceDisasterRecoveryDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceDisasterRecoveryDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceDisasterRecoveryDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_region_integration_instance_details: Optional[Sequence['outputs.IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail']] = None,
                 regional_instance_url: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None):
        """
        :param Sequence['IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailArgs'] cross_region_integration_instance_details: Details of integration instance created in cross region for disaster recovery.
        :param builtins.str regional_instance_url: Region specific instance url for the integration instance in the region
        :param builtins.str role: Role of the integration instance in the region
        """
        if cross_region_integration_instance_details is not None:
            pulumi.set(__self__, "cross_region_integration_instance_details", cross_region_integration_instance_details)
        if regional_instance_url is not None:
            pulumi.set(__self__, "regional_instance_url", regional_instance_url)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="crossRegionIntegrationInstanceDetails")
    def cross_region_integration_instance_details(self) -> Optional[Sequence['outputs.IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail']]:
        """
        Details of integration instance created in cross region for disaster recovery.
        """
        return pulumi.get(self, "cross_region_integration_instance_details")

    @property
    @pulumi.getter(name="regionalInstanceUrl")
    def regional_instance_url(self) -> Optional[builtins.str]:
        """
        Region specific instance url for the integration instance in the region
        """
        return pulumi.get(self, "regional_instance_url")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeRoleChanged":
            suggest = "time_role_changed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None,
                 time_role_changed: Optional[builtins.str] = None):
        """
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param builtins.str region: Cross region where integration instance is created
        :param builtins.str role: Role of the integration instance in the region
        :param builtins.str time_role_changed: Time when cross region integration instance role was changed
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if time_role_changed is not None:
            pulumi.set(__self__, "time_role_changed", time_role_changed)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Cross region where integration instance is created
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="timeRoleChanged")
    def time_role_changed(self) -> Optional[builtins.str]:
        """
        Time when cross region integration instance role was changed
        """
        return pulumi.get(self, "time_role_changed")


@pulumi.output_type
class IntegrationInstanceIdcsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idcsAppDisplayName":
            suggest = "idcs_app_display_name"
        elif key == "idcsAppId":
            suggest = "idcs_app_id"
        elif key == "idcsAppLocationUrl":
            suggest = "idcs_app_location_url"
        elif key == "idcsAppName":
            suggest = "idcs_app_name"
        elif key == "instancePrimaryAudienceUrl":
            suggest = "instance_primary_audience_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceIdcsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceIdcsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceIdcsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idcs_app_display_name: Optional[builtins.str] = None,
                 idcs_app_id: Optional[builtins.str] = None,
                 idcs_app_location_url: Optional[builtins.str] = None,
                 idcs_app_name: Optional[builtins.str] = None,
                 instance_primary_audience_url: Optional[builtins.str] = None):
        """
        :param builtins.str idcs_app_display_name: The IDCS application display name associated with the instance
        :param builtins.str idcs_app_id: The IDCS application ID associated with the instance
        :param builtins.str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param builtins.str idcs_app_name: The IDCS application name associated with the instance
        :param builtins.str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string
        """
        if idcs_app_display_name is not None:
            pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        if idcs_app_id is not None:
            pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        if idcs_app_location_url is not None:
            pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        if idcs_app_name is not None:
            pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        if instance_primary_audience_url is not None:
            pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> Optional[builtins.str]:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> Optional[builtins.str]:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> Optional[builtins.str]:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> Optional[builtins.str]:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> Optional[builtins.str]:
        """
        The URL used as the primary audience for integration flows in this instance type: string
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class IntegrationInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "allowlistedHttpIps":
            suggest = "allowlisted_http_ips"
        elif key == "allowlistedHttpVcns":
            suggest = "allowlisted_http_vcns"
        elif key == "isIntegrationVcnAllowlisted":
            suggest = "is_integration_vcn_allowlisted"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: builtins.str,
                 allowlisted_http_ips: Optional[Sequence[builtins.str]] = None,
                 allowlisted_http_vcns: Optional[Sequence['outputs.IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn']] = None,
                 is_integration_vcn_allowlisted: Optional[builtins.bool] = None):
        """
        :param builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param builtins.bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if allowlisted_http_ips is not None:
            pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        if allowlisted_http_vcns is not None:
            pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        if is_integration_vcn_allowlisted is not None:
            pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Optional[Sequence['outputs.IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn']]:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> Optional[builtins.bool]:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")


@pulumi.output_type
class IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistedIps":
            suggest = "allowlisted_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 allowlisted_ips: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param Sequence[builtins.str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        pulumi.set(__self__, "id", id)
        if allowlisted_ips is not None:
            pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")


@pulumi.output_type
class IntegrationInstancePrivateEndpointOutboundConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "outboundConnectionType":
            suggest = "outbound_connection_type"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationInstancePrivateEndpointOutboundConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationInstancePrivateEndpointOutboundConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationInstancePrivateEndpointOutboundConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nsg_ids: Optional[Sequence[builtins.str]] = None,
                 outbound_connection_type: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] nsg_ids: One or more Network security group Ids. This is an optional argument.
        :param builtins.str outbound_connection_type: The type of Outbound Connection.
        :param builtins.str subnet_id: Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if outbound_connection_type is not None:
            pulumi.set(__self__, "outbound_connection_type", outbound_connection_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more Network security group Ids. This is an optional argument.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="outboundConnectionType")
    def outbound_connection_type(self) -> Optional[builtins.str]:
        """
        The type of Outbound Connection.
        """
        return pulumi.get(self, "outbound_connection_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetIntegrationInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: builtins.str,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 dns_type: builtins.str,
                 dns_zone_name: builtins.str,
                 hostname: builtins.str,
                 managed_type: builtins.str):
        """
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "dns_type", dns_type)
        pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> builtins.str:
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> builtins.str:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> builtins.str:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class GetIntegrationInstanceAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: builtins.bool,
                 target_id: builtins.str,
                 target_instance_url: builtins.str,
                 target_role: builtins.str,
                 target_service_type: builtins.str):
        """
        :param builtins.bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param builtins.str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param builtins.str target_instance_url: The dataplane instance URL of the attached instance
        :param builtins.str target_role: The role of the target attachment.
               * `PARENT` - The target instance is the parent of this attachment.
               * `CHILD` - The target instance is the child of this attachment.
        :param builtins.str target_service_type: The type of the target instance, such as "FUSION".
        """
        pulumi.set(__self__, "is_implicit", is_implicit)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_instance_url", target_instance_url)
        pulumi.set(__self__, "target_role", target_role)
        pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> builtins.bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> builtins.str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> builtins.str:
        """
        The role of the target attachment.
        * `PARENT` - The target instance is the parent of this attachment.
        * `CHILD` - The target instance is the child of this attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> builtins.str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetIntegrationInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: builtins.str,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 dns_type: builtins.str,
                 dns_zone_name: builtins.str,
                 hostname: builtins.str,
                 managed_type: builtins.str):
        """
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "dns_type", dns_type)
        pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> builtins.str:
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> builtins.str:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> builtins.str:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class GetIntegrationInstanceDisasterRecoveryDetailResult(dict):
    def __init__(__self__, *,
                 cross_region_integration_instance_details: Sequence['outputs.GetIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult'],
                 regional_instance_url: builtins.str,
                 role: builtins.str):
        """
        :param Sequence['GetIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailArgs'] cross_region_integration_instance_details: Details of integration instance created in cross region for disaster recovery.
        :param builtins.str regional_instance_url: Region specific instance url for the integration instance in the region
        :param builtins.str role: Role of the integration instance in the region
        """
        pulumi.set(__self__, "cross_region_integration_instance_details", cross_region_integration_instance_details)
        pulumi.set(__self__, "regional_instance_url", regional_instance_url)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="crossRegionIntegrationInstanceDetails")
    def cross_region_integration_instance_details(self) -> Sequence['outputs.GetIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult']:
        """
        Details of integration instance created in cross region for disaster recovery.
        """
        return pulumi.get(self, "cross_region_integration_instance_details")

    @property
    @pulumi.getter(name="regionalInstanceUrl")
    def regional_instance_url(self) -> builtins.str:
        """
        Region specific instance url for the integration instance in the region
        """
        return pulumi.get(self, "regional_instance_url")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 region: builtins.str,
                 role: builtins.str,
                 time_role_changed: builtins.str):
        """
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param builtins.str region: Cross region where integration instance is created
        :param builtins.str role: Role of the integration instance in the region
        :param builtins.str time_role_changed: Time when cross region integration instance role was changed
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "time_role_changed", time_role_changed)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Cross region where integration instance is created
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="timeRoleChanged")
    def time_role_changed(self) -> builtins.str:
        """
        Time when cross region integration instance role was changed
        """
        return pulumi.get(self, "time_role_changed")


@pulumi.output_type
class GetIntegrationInstanceIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: builtins.str,
                 idcs_app_id: builtins.str,
                 idcs_app_location_url: builtins.str,
                 idcs_app_name: builtins.str,
                 instance_primary_audience_url: builtins.str):
        """
        :param builtins.str idcs_app_display_name: The IDCS application display name associated with the instance
        :param builtins.str idcs_app_id: The IDCS application ID associated with the instance
        :param builtins.str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param builtins.str idcs_app_name: The IDCS application name associated with the instance
        :param builtins.str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string* `instance_design_time_url` - The Integration Instance Design Time URL
        """
        pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> builtins.str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> builtins.str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> builtins.str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> builtins.str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> builtins.str:
        """
        The URL used as the primary audience for integration flows in this instance type: string* `instance_design_time_url` - The Integration Instance Design Time URL
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetIntegrationInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 is_integration_vcn_allowlisted: builtins.bool,
                 network_endpoint_type: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param builtins.bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        :param builtins.str network_endpoint_type: The type of network endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> builtins.bool:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")


@pulumi.output_type
class GetIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ips: Sequence[builtins.str],
                 id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetIntegrationInstancePrivateEndpointOutboundConnectionResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[builtins.str],
                 outbound_connection_type: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] nsg_ids: One or more Network security group Ids. This is an optional argument.
        :param builtins.str outbound_connection_type: The type of Outbound Connection.
        :param builtins.str subnet_id: Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "outbound_connection_type", outbound_connection_type)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        One or more Network security group Ids. This is an optional argument.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="outboundConnectionType")
    def outbound_connection_type(self) -> builtins.str:
        """
        The type of Outbound Connection.
        """
        return pulumi.get(self, "outbound_connection_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetIntegrationInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceResult(dict):
    def __init__(__self__, *,
                 alternate_custom_endpoints: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult'],
                 attachments: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAttachmentResult'],
                 compartment_id: builtins.str,
                 consumption_model: builtins.str,
                 custom_endpoints: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceCustomEndpointResult'],
                 data_retention_period: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 disaster_recovery_details: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailResult'],
                 display_name: builtins.str,
                 domain_id: builtins.str,
                 enable_process_automation_trigger: builtins.int,
                 extend_data_retention_trigger: builtins.int,
                 failover_trigger: builtins.int,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 idcs_at: builtins.str,
                 idcs_infos: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceIdcsInfoResult'],
                 instance_design_time_url: builtins.str,
                 instance_url: builtins.str,
                 integration_instance_type: builtins.str,
                 is_byol: builtins.bool,
                 is_disaster_recovery_enabled: builtins.bool,
                 is_file_server_enabled: builtins.bool,
                 is_visual_builder_enabled: builtins.bool,
                 lifecycle_details: builtins.str,
                 message_packs: builtins.int,
                 network_endpoint_details: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult'],
                 private_endpoint_outbound_connections: Sequence['outputs.GetIntegrationInstancesIntegrationInstancePrivateEndpointOutboundConnectionResult'],
                 shape: builtins.str,
                 state: builtins.str,
                 state_message: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param Sequence['GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointArgs'] alternate_custom_endpoints: A list of alternate custom endpoints used for the integration instance URL.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceAttachmentArgs'] attachments: A list of associated attachments to other services
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str consumption_model: The entitlement used for billing purposes.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceCustomEndpointArgs'] custom_endpoints: Details for a custom endpoint for the integration instance.
        :param builtins.str data_retention_period: Data retention period set for given integration instance
        :param Mapping[str, builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailArgs'] disaster_recovery_details: Disaster recovery details for the integration instance created in the region.
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceIdcsInfoArgs'] idcs_infos: Information for IDCS access
        :param builtins.str instance_url: The Integration Instance URL.
        :param builtins.str integration_instance_type: Standard or Enterprise type, Oracle Integration Generation 2 uses ENTERPRISE and STANDARD, Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param builtins.bool is_byol: Bring your own license.
        :param builtins.bool is_disaster_recovery_enabled: Is Disaster Recovery enabled for the integrationInstance
        :param builtins.bool is_file_server_enabled: The file server is enabled or not.
        :param builtins.bool is_visual_builder_enabled: Visual Builder is enabled or not.
        :param builtins.str lifecycle_details: Additional details of lifecycleState or substates
        :param builtins.int message_packs: The number of configured message packs (if any)
        :param Sequence['GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param Sequence['GetIntegrationInstancesIntegrationInstancePrivateEndpointOutboundConnectionArgs'] private_endpoint_outbound_connections: Base representation for Outbound Connection (Reverse Connection).
        :param builtins.str shape: Shape
        :param builtins.str state: Life cycle state to query on.
        :param builtins.str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        pulumi.set(__self__, "attachments", attachments)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "consumption_model", consumption_model)
        pulumi.set(__self__, "custom_endpoints", custom_endpoints)
        pulumi.set(__self__, "data_retention_period", data_retention_period)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "disaster_recovery_details", disaster_recovery_details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "enable_process_automation_trigger", enable_process_automation_trigger)
        pulumi.set(__self__, "extend_data_retention_trigger", extend_data_retention_trigger)
        pulumi.set(__self__, "failover_trigger", failover_trigger)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_at", idcs_at)
        pulumi.set(__self__, "idcs_infos", idcs_infos)
        pulumi.set(__self__, "instance_design_time_url", instance_design_time_url)
        pulumi.set(__self__, "instance_url", instance_url)
        pulumi.set(__self__, "integration_instance_type", integration_instance_type)
        pulumi.set(__self__, "is_byol", is_byol)
        pulumi.set(__self__, "is_disaster_recovery_enabled", is_disaster_recovery_enabled)
        pulumi.set(__self__, "is_file_server_enabled", is_file_server_enabled)
        pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "message_packs", message_packs)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "private_endpoint_outbound_connections", private_endpoint_outbound_connections)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the integration instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceAttachmentResult']:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> builtins.str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceCustomEndpointResult']:
        """
        Details for a custom endpoint for the integration instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @property
    @pulumi.getter(name="dataRetentionPeriod")
    def data_retention_period(self) -> builtins.str:
        """
        Data retention period set for given integration instance
        """
        return pulumi.get(self, "data_retention_period")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disasterRecoveryDetails")
    def disaster_recovery_details(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailResult']:
        """
        Disaster recovery details for the integration instance created in the region.
        """
        return pulumi.get(self, "disaster_recovery_details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> builtins.str:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="enableProcessAutomationTrigger")
    def enable_process_automation_trigger(self) -> builtins.int:
        return pulumi.get(self, "enable_process_automation_trigger")

    @property
    @pulumi.getter(name="extendDataRetentionTrigger")
    def extend_data_retention_trigger(self) -> builtins.int:
        return pulumi.get(self, "extend_data_retention_trigger")

    @property
    @pulumi.getter(name="failoverTrigger")
    def failover_trigger(self) -> builtins.int:
        return pulumi.get(self, "failover_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> builtins.str:
        return pulumi.get(self, "idcs_at")

    @property
    @pulumi.getter(name="idcsInfos")
    def idcs_infos(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceIdcsInfoResult']:
        """
        Information for IDCS access
        """
        return pulumi.get(self, "idcs_infos")

    @property
    @pulumi.getter(name="instanceDesignTimeUrl")
    def instance_design_time_url(self) -> builtins.str:
        return pulumi.get(self, "instance_design_time_url")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> builtins.str:
        """
        The Integration Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="integrationInstanceType")
    def integration_instance_type(self) -> builtins.str:
        """
        Standard or Enterprise type, Oracle Integration Generation 2 uses ENTERPRISE and STANDARD, Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        """
        return pulumi.get(self, "integration_instance_type")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> builtins.bool:
        """
        Bring your own license.
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isDisasterRecoveryEnabled")
    def is_disaster_recovery_enabled(self) -> builtins.bool:
        """
        Is Disaster Recovery enabled for the integrationInstance
        """
        return pulumi.get(self, "is_disaster_recovery_enabled")

    @property
    @pulumi.getter(name="isFileServerEnabled")
    def is_file_server_enabled(self) -> builtins.bool:
        """
        The file server is enabled or not.
        """
        return pulumi.get(self, "is_file_server_enabled")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> builtins.bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional details of lifecycleState or substates
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="messagePacks")
    def message_packs(self) -> builtins.int:
        """
        The number of configured message packs (if any)
        """
        return pulumi.get(self, "message_packs")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="privateEndpointOutboundConnections")
    def private_endpoint_outbound_connections(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstancePrivateEndpointOutboundConnectionResult']:
        """
        Base representation for Outbound Connection (Reverse Connection).
        """
        return pulumi.get(self, "private_endpoint_outbound_connections")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        Shape
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Life cycle state to query on.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: builtins.str,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 dns_type: builtins.str,
                 dns_zone_name: builtins.str,
                 hostname: builtins.str,
                 managed_type: builtins.str):
        """
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "dns_type", dns_type)
        pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> builtins.str:
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> builtins.str:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> builtins.str:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceAttachmentResult(dict):
    def __init__(__self__, *,
                 is_implicit: builtins.bool,
                 target_id: builtins.str,
                 target_instance_url: builtins.str,
                 target_role: builtins.str,
                 target_service_type: builtins.str):
        """
        :param builtins.bool is_implicit: * If role == `PARENT`, the attached instance was created by this service instance
               * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        :param builtins.str target_id: The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        :param builtins.str target_instance_url: The dataplane instance URL of the attached instance
        :param builtins.str target_role: The role of the target attachment.
               * `PARENT` - The target instance is the parent of this attachment.
               * `CHILD` - The target instance is the child of this attachment.
        :param builtins.str target_service_type: The type of the target instance, such as "FUSION".
        """
        pulumi.set(__self__, "is_implicit", is_implicit)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_instance_url", target_instance_url)
        pulumi.set(__self__, "target_role", target_role)
        pulumi.set(__self__, "target_service_type", target_service_type)

    @property
    @pulumi.getter(name="isImplicit")
    def is_implicit(self) -> builtins.bool:
        """
        * If role == `PARENT`, the attached instance was created by this service instance
        * If role == `CHILD`, this instance was created from attached instance on behalf of a user
        """
        return pulumi.get(self, "is_implicit")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The OCID of the target instance (which could be any other Oracle Cloud Infrastructure PaaS/SaaS resource), to which this instance is attached.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetInstanceUrl")
    def target_instance_url(self) -> builtins.str:
        """
        The dataplane instance URL of the attached instance
        """
        return pulumi.get(self, "target_instance_url")

    @property
    @pulumi.getter(name="targetRole")
    def target_role(self) -> builtins.str:
        """
        The role of the target attachment.
        * `PARENT` - The target instance is the parent of this attachment.
        * `CHILD` - The target instance is the child of this attachment.
        """
        return pulumi.get(self, "target_role")

    @property
    @pulumi.getter(name="targetServiceType")
    def target_service_type(self) -> builtins.str:
        """
        The type of the target instance, such as "FUSION".
        """
        return pulumi.get(self, "target_service_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 alias: builtins.str,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 dns_type: builtins.str,
                 dns_zone_name: builtins.str,
                 hostname: builtins.str,
                 managed_type: builtins.str):
        """
        :param builtins.str alias: When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        :param builtins.str dns_zone_name: DNS Zone name
        :param builtins.str hostname: A custom hostname to be used for the integration instance URL, in FQDN format.
        :param builtins.str managed_type: Indicates if custom endpoint is managed by oracle or customer.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "dns_type", dns_type)
        pulumi.set(__self__, "dns_zone_name", dns_zone_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "managed_type", managed_type)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        When creating the DNS CNAME record for the custom hostname, this value must be specified in the rdata.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).* `dns_type` - Type of DNS.
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter(name="dnsType")
    def dns_type(self) -> builtins.str:
        return pulumi.get(self, "dns_type")

    @property
    @pulumi.getter(name="dnsZoneName")
    def dns_zone_name(self) -> builtins.str:
        """
        DNS Zone name
        """
        return pulumi.get(self, "dns_zone_name")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the integration instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="managedType")
    def managed_type(self) -> builtins.str:
        """
        Indicates if custom endpoint is managed by oracle or customer.
        """
        return pulumi.get(self, "managed_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailResult(dict):
    def __init__(__self__, *,
                 cross_region_integration_instance_details: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult'],
                 regional_instance_url: builtins.str,
                 role: builtins.str):
        """
        :param Sequence['GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailArgs'] cross_region_integration_instance_details: Details of integration instance created in cross region for disaster recovery.
        :param builtins.str regional_instance_url: Region specific instance url for the integration instance in the region
        :param builtins.str role: Role of the integration instance in the region
        """
        pulumi.set(__self__, "cross_region_integration_instance_details", cross_region_integration_instance_details)
        pulumi.set(__self__, "regional_instance_url", regional_instance_url)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="crossRegionIntegrationInstanceDetails")
    def cross_region_integration_instance_details(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult']:
        """
        Details of integration instance created in cross region for disaster recovery.
        """
        return pulumi.get(self, "cross_region_integration_instance_details")

    @property
    @pulumi.getter(name="regionalInstanceUrl")
    def regional_instance_url(self) -> builtins.str:
        """
        Region specific instance url for the integration instance in the region
        """
        return pulumi.get(self, "regional_instance_url")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceDisasterRecoveryDetailCrossRegionIntegrationInstanceDetailResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 region: builtins.str,
                 role: builtins.str,
                 time_role_changed: builtins.str):
        """
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param builtins.str region: Cross region where integration instance is created
        :param builtins.str role: Role of the integration instance in the region
        :param builtins.str time_role_changed: Time when cross region integration instance role was changed
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "time_role_changed", time_role_changed)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Cross region where integration instance is created
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Role of the integration instance in the region
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="timeRoleChanged")
    def time_role_changed(self) -> builtins.str:
        """
        Time when cross region integration instance role was changed
        """
        return pulumi.get(self, "time_role_changed")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceIdcsInfoResult(dict):
    def __init__(__self__, *,
                 idcs_app_display_name: builtins.str,
                 idcs_app_id: builtins.str,
                 idcs_app_location_url: builtins.str,
                 idcs_app_name: builtins.str,
                 instance_primary_audience_url: builtins.str):
        """
        :param builtins.str idcs_app_display_name: The IDCS application display name associated with the instance
        :param builtins.str idcs_app_id: The IDCS application ID associated with the instance
        :param builtins.str idcs_app_location_url: URL for the location of the IDCS Application (used by IDCS APIs)
        :param builtins.str idcs_app_name: The IDCS application name associated with the instance
        :param builtins.str instance_primary_audience_url: The URL used as the primary audience for integration flows in this instance type: string* `instance_design_time_url` - The Integration Instance Design Time URL
        """
        pulumi.set(__self__, "idcs_app_display_name", idcs_app_display_name)
        pulumi.set(__self__, "idcs_app_id", idcs_app_id)
        pulumi.set(__self__, "idcs_app_location_url", idcs_app_location_url)
        pulumi.set(__self__, "idcs_app_name", idcs_app_name)
        pulumi.set(__self__, "instance_primary_audience_url", instance_primary_audience_url)

    @property
    @pulumi.getter(name="idcsAppDisplayName")
    def idcs_app_display_name(self) -> builtins.str:
        """
        The IDCS application display name associated with the instance
        """
        return pulumi.get(self, "idcs_app_display_name")

    @property
    @pulumi.getter(name="idcsAppId")
    def idcs_app_id(self) -> builtins.str:
        """
        The IDCS application ID associated with the instance
        """
        return pulumi.get(self, "idcs_app_id")

    @property
    @pulumi.getter(name="idcsAppLocationUrl")
    def idcs_app_location_url(self) -> builtins.str:
        """
        URL for the location of the IDCS Application (used by IDCS APIs)
        """
        return pulumi.get(self, "idcs_app_location_url")

    @property
    @pulumi.getter(name="idcsAppName")
    def idcs_app_name(self) -> builtins.str:
        """
        The IDCS application name associated with the instance
        """
        return pulumi.get(self, "idcs_app_name")

    @property
    @pulumi.getter(name="instancePrimaryAudienceUrl")
    def instance_primary_audience_url(self) -> builtins.str:
        """
        The URL used as the primary audience for integration flows in this instance type: string* `instance_design_time_url` - The Integration Instance Design Time URL
        """
        return pulumi.get(self, "instance_primary_audience_url")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 is_integration_vcn_allowlisted: builtins.bool,
                 network_endpoint_type: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param builtins.bool is_integration_vcn_allowlisted: The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        :param builtins.str network_endpoint_type: The type of network endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "is_integration_vcn_allowlisted", is_integration_vcn_allowlisted)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="isIntegrationVcnAllowlisted")
    def is_integration_vcn_allowlisted(self) -> builtins.bool:
        """
        The Integration service's VCN is allow-listed to allow integrations to call back into other integrations
        """
        return pulumi.get(self, "is_integration_vcn_allowlisted")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ips: Sequence[builtins.str],
                 id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ips", allowlisted_ips)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIps")
    def allowlisted_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ips")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetIntegrationInstancesIntegrationInstancePrivateEndpointOutboundConnectionResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[builtins.str],
                 outbound_connection_type: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] nsg_ids: One or more Network security group Ids. This is an optional argument.
        :param builtins.str outbound_connection_type: The type of Outbound Connection.
        :param builtins.str subnet_id: Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "outbound_connection_type", outbound_connection_type)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        One or more Network security group Ids. This is an optional argument.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="outboundConnectionType")
    def outbound_connection_type(self) -> builtins.str:
        """
        The type of Outbound Connection.
        """
        return pulumi.get(self, "outbound_connection_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Customer Private Network VCN Subnet OCID. This is a required argument.
        """
        return pulumi.get(self, "subnet_id")


