# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 inventory_log: pulumi.Input['FleetInventoryLogArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_advanced_features_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_log: Optional[pulumi.Input['FleetOperationLogArgs']] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        :param pulumi.Input['FleetInventoryLogArgs'] inventory_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] description: (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[builtins.bool] is_advanced_features_enabled: (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        :param pulumi.Input['FleetOperationLogArgs'] operation_log: (Updatable) Custom Log for inventory or operation log.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "inventory_log", inventory_log)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_advanced_features_enabled is not None:
            pulumi.set(__self__, "is_advanced_features_enabled", is_advanced_features_enabled)
        if operation_log is not None:
            pulumi.set(__self__, "operation_log", operation_log)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inventoryLog")
    def inventory_log(self) -> pulumi.Input['FleetInventoryLogArgs']:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "inventory_log")

    @inventory_log.setter
    def inventory_log(self, value: pulumi.Input['FleetInventoryLogArgs']):
        pulumi.set(self, "inventory_log", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAdvancedFeaturesEnabled")
    def is_advanced_features_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        """
        return pulumi.get(self, "is_advanced_features_enabled")

    @is_advanced_features_enabled.setter
    def is_advanced_features_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_advanced_features_enabled", value)

    @property
    @pulumi.getter(name="operationLog")
    def operation_log(self) -> Optional[pulumi.Input['FleetOperationLogArgs']]:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "operation_log")

    @operation_log.setter
    def operation_log(self, value: Optional[pulumi.Input['FleetOperationLogArgs']]):
        pulumi.set(self, "operation_log", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 approximate_application_count: Optional[pulumi.Input[builtins.int]] = None,
                 approximate_installation_count: Optional[pulumi.Input[builtins.int]] = None,
                 approximate_java_server_count: Optional[pulumi.Input[builtins.int]] = None,
                 approximate_jre_count: Optional[pulumi.Input[builtins.int]] = None,
                 approximate_managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 inventory_log: Optional[pulumi.Input['FleetInventoryLogArgs']] = None,
                 is_advanced_features_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_export_setting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_log: Optional[pulumi.Input['FleetOperationLogArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[builtins.int] approximate_application_count: The approximate count of all unique applications in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_installation_count: The approximate count of all unique Java installations in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_java_server_count: The approximate count of all unique Java servers in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_jre_count: The approximate count of all unique Java Runtimes in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_managed_instance_count: The approximate count of all unique managed instances in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] description: (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input['FleetInventoryLogArgs'] inventory_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[builtins.bool] is_advanced_features_enabled: (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        :param pulumi.Input[builtins.bool] is_export_setting_enabled: Whether or not export setting is enabled in this Fleet.
        :param pulumi.Input['FleetOperationLogArgs'] operation_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The creation date and time of the Fleet (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        if approximate_application_count is not None:
            pulumi.set(__self__, "approximate_application_count", approximate_application_count)
        if approximate_installation_count is not None:
            pulumi.set(__self__, "approximate_installation_count", approximate_installation_count)
        if approximate_java_server_count is not None:
            pulumi.set(__self__, "approximate_java_server_count", approximate_java_server_count)
        if approximate_jre_count is not None:
            pulumi.set(__self__, "approximate_jre_count", approximate_jre_count)
        if approximate_managed_instance_count is not None:
            pulumi.set(__self__, "approximate_managed_instance_count", approximate_managed_instance_count)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inventory_log is not None:
            pulumi.set(__self__, "inventory_log", inventory_log)
        if is_advanced_features_enabled is not None:
            pulumi.set(__self__, "is_advanced_features_enabled", is_advanced_features_enabled)
        if is_export_setting_enabled is not None:
            pulumi.set(__self__, "is_export_setting_enabled", is_export_setting_enabled)
        if operation_log is not None:
            pulumi.set(__self__, "operation_log", operation_log)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="approximateApplicationCount")
    def approximate_application_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The approximate count of all unique applications in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_application_count")

    @approximate_application_count.setter
    def approximate_application_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approximate_application_count", value)

    @property
    @pulumi.getter(name="approximateInstallationCount")
    def approximate_installation_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The approximate count of all unique Java installations in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_installation_count")

    @approximate_installation_count.setter
    def approximate_installation_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approximate_installation_count", value)

    @property
    @pulumi.getter(name="approximateJavaServerCount")
    def approximate_java_server_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The approximate count of all unique Java servers in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_java_server_count")

    @approximate_java_server_count.setter
    def approximate_java_server_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approximate_java_server_count", value)

    @property
    @pulumi.getter(name="approximateJreCount")
    def approximate_jre_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The approximate count of all unique Java Runtimes in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_jre_count")

    @approximate_jre_count.setter
    def approximate_jre_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approximate_jre_count", value)

    @property
    @pulumi.getter(name="approximateManagedInstanceCount")
    def approximate_managed_instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The approximate count of all unique managed instances in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_managed_instance_count")

    @approximate_managed_instance_count.setter
    def approximate_managed_instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approximate_managed_instance_count", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inventoryLog")
    def inventory_log(self) -> Optional[pulumi.Input['FleetInventoryLogArgs']]:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "inventory_log")

    @inventory_log.setter
    def inventory_log(self, value: Optional[pulumi.Input['FleetInventoryLogArgs']]):
        pulumi.set(self, "inventory_log", value)

    @property
    @pulumi.getter(name="isAdvancedFeaturesEnabled")
    def is_advanced_features_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        """
        return pulumi.get(self, "is_advanced_features_enabled")

    @is_advanced_features_enabled.setter
    def is_advanced_features_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_advanced_features_enabled", value)

    @property
    @pulumi.getter(name="isExportSettingEnabled")
    def is_export_setting_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not export setting is enabled in this Fleet.
        """
        return pulumi.get(self, "is_export_setting_enabled")

    @is_export_setting_enabled.setter
    def is_export_setting_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_export_setting_enabled", value)

    @property
    @pulumi.getter(name="operationLog")
    def operation_log(self) -> Optional[pulumi.Input['FleetOperationLogArgs']]:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "operation_log")

    @operation_log.setter
    def operation_log(self, value: Optional[pulumi.Input['FleetOperationLogArgs']]):
        pulumi.set(self, "operation_log", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation date and time of the Fleet (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Jms/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 inventory_log: Optional[pulumi.Input[Union['FleetInventoryLogArgs', 'FleetInventoryLogArgsDict']]] = None,
                 is_advanced_features_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_log: Optional[pulumi.Input[Union['FleetOperationLogArgs', 'FleetOperationLogArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Fleet resource in Oracle Cloud Infrastructure Jms service.

        Create a new Fleet using the information provided.

        `inventoryLog` is now a required parameter for CreateFleet API.
        Update existing applications using this API
        before July 15, 2022 to ensure the applications continue to work.
        See the [Service Change Notice](https://docs.oracle.com/en-us/iaas/Content/servicechanges.htm#JMS) for more details.
        Migrate existing fleets using the `UpdateFleet` API to set the `inventoryLog` parameter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet = oci.jms.Fleet("test_fleet",
            compartment_id=compartment_id,
            display_name=fleet_display_name,
            inventory_log={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=fleet_description,
            freeform_tags={
                "bar-key": "value",
            },
            is_advanced_features_enabled=fleet_is_advanced_features_enabled,
            operation_log={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            })
        ```

        ## Import

        Fleets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleet:Fleet test_fleet "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] description: (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[Union['FleetInventoryLogArgs', 'FleetInventoryLogArgsDict']] inventory_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[builtins.bool] is_advanced_features_enabled: (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        :param pulumi.Input[Union['FleetOperationLogArgs', 'FleetOperationLogArgsDict']] operation_log: (Updatable) Custom Log for inventory or operation log.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fleet resource in Oracle Cloud Infrastructure Jms service.

        Create a new Fleet using the information provided.

        `inventoryLog` is now a required parameter for CreateFleet API.
        Update existing applications using this API
        before July 15, 2022 to ensure the applications continue to work.
        See the [Service Change Notice](https://docs.oracle.com/en-us/iaas/Content/servicechanges.htm#JMS) for more details.
        Migrate existing fleets using the `UpdateFleet` API to set the `inventoryLog` parameter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet = oci.jms.Fleet("test_fleet",
            compartment_id=compartment_id,
            display_name=fleet_display_name,
            inventory_log={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=fleet_description,
            freeform_tags={
                "bar-key": "value",
            },
            is_advanced_features_enabled=fleet_is_advanced_features_enabled,
            operation_log={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            })
        ```

        ## Import

        Fleets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleet:Fleet test_fleet "id"
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 inventory_log: Optional[pulumi.Input[Union['FleetInventoryLogArgs', 'FleetInventoryLogArgsDict']]] = None,
                 is_advanced_features_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_log: Optional[pulumi.Input[Union['FleetOperationLogArgs', 'FleetOperationLogArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if inventory_log is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_log'")
            __props__.__dict__["inventory_log"] = inventory_log
            __props__.__dict__["is_advanced_features_enabled"] = is_advanced_features_enabled
            __props__.__dict__["operation_log"] = operation_log
            __props__.__dict__["approximate_application_count"] = None
            __props__.__dict__["approximate_installation_count"] = None
            __props__.__dict__["approximate_java_server_count"] = None
            __props__.__dict__["approximate_jre_count"] = None
            __props__.__dict__["approximate_managed_instance_count"] = None
            __props__.__dict__["is_export_setting_enabled"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(Fleet, __self__).__init__(
            'oci:Jms/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approximate_application_count: Optional[pulumi.Input[builtins.int]] = None,
            approximate_installation_count: Optional[pulumi.Input[builtins.int]] = None,
            approximate_java_server_count: Optional[pulumi.Input[builtins.int]] = None,
            approximate_jre_count: Optional[pulumi.Input[builtins.int]] = None,
            approximate_managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            inventory_log: Optional[pulumi.Input[Union['FleetInventoryLogArgs', 'FleetInventoryLogArgsDict']]] = None,
            is_advanced_features_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_export_setting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            operation_log: Optional[pulumi.Input[Union['FleetOperationLogArgs', 'FleetOperationLogArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] approximate_application_count: The approximate count of all unique applications in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_installation_count: The approximate count of all unique Java installations in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_java_server_count: The approximate count of all unique Java servers in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_jre_count: The approximate count of all unique Java Runtimes in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.int] approximate_managed_instance_count: The approximate count of all unique managed instances in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] description: (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[Union['FleetInventoryLogArgs', 'FleetInventoryLogArgsDict']] inventory_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[builtins.bool] is_advanced_features_enabled: (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        :param pulumi.Input[builtins.bool] is_export_setting_enabled: Whether or not export setting is enabled in this Fleet.
        :param pulumi.Input[Union['FleetOperationLogArgs', 'FleetOperationLogArgsDict']] operation_log: (Updatable) Custom Log for inventory or operation log.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The creation date and time of the Fleet (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["approximate_application_count"] = approximate_application_count
        __props__.__dict__["approximate_installation_count"] = approximate_installation_count
        __props__.__dict__["approximate_java_server_count"] = approximate_java_server_count
        __props__.__dict__["approximate_jre_count"] = approximate_jre_count
        __props__.__dict__["approximate_managed_instance_count"] = approximate_managed_instance_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inventory_log"] = inventory_log
        __props__.__dict__["is_advanced_features_enabled"] = is_advanced_features_enabled
        __props__.__dict__["is_export_setting_enabled"] = is_export_setting_enabled
        __props__.__dict__["operation_log"] = operation_log
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approximateApplicationCount")
    def approximate_application_count(self) -> pulumi.Output[builtins.int]:
        """
        The approximate count of all unique applications in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_application_count")

    @property
    @pulumi.getter(name="approximateInstallationCount")
    def approximate_installation_count(self) -> pulumi.Output[builtins.int]:
        """
        The approximate count of all unique Java installations in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_installation_count")

    @property
    @pulumi.getter(name="approximateJavaServerCount")
    def approximate_java_server_count(self) -> pulumi.Output[builtins.int]:
        """
        The approximate count of all unique Java servers in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_java_server_count")

    @property
    @pulumi.getter(name="approximateJreCount")
    def approximate_jre_count(self) -> pulumi.Output[builtins.int]:
        """
        The approximate count of all unique Java Runtimes in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_jre_count")

    @property
    @pulumi.getter(name="approximateManagedInstanceCount")
    def approximate_managed_instance_count(self) -> pulumi.Output[builtins.int]:
        """
        The approximate count of all unique managed instances in the Fleet in the past seven days. This metric is provided on a best-effort manner, and isn't taken into account when computing the resource ETag.
        """
        return pulumi.get(self, "approximate_managed_instance_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The Fleet's description. If nothing is provided, the Fleet description will be null.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the Fleet. The displayName must be unique for Fleets in the same compartment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="inventoryLog")
    def inventory_log(self) -> pulumi.Output['outputs.FleetInventoryLog']:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "inventory_log")

    @property
    @pulumi.getter(name="isAdvancedFeaturesEnabled")
    def is_advanced_features_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether or not advanced features are enabled in this Fleet. Deprecated, use `/fleets/{fleetId}/advanceFeatureConfiguration` API instead.
        """
        return pulumi.get(self, "is_advanced_features_enabled")

    @property
    @pulumi.getter(name="isExportSettingEnabled")
    def is_export_setting_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not export setting is enabled in this Fleet.
        """
        return pulumi.get(self, "is_export_setting_enabled")

    @property
    @pulumi.getter(name="operationLog")
    def operation_log(self) -> pulumi.Output['outputs.FleetOperationLog']:
        """
        (Updatable) Custom Log for inventory or operation log.
        """
        return pulumi.get(self, "operation_log")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The creation date and time of the Fleet (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

