# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJavaDownloadsJavaDownloadTokenResult',
    'AwaitableGetJavaDownloadsJavaDownloadTokenResult',
    'get_java_downloads_java_download_token',
    'get_java_downloads_java_download_token_output',
]

@pulumi.output_type
class GetJavaDownloadsJavaDownloadTokenResult:
    """
    A collection of values returned by getJavaDownloadsJavaDownloadToken.
    """
    def __init__(__self__, compartment_id=None, created_bies=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_default=None, java_download_token_id=None, java_version=None, last_updated_bies=None, license_types=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_expires=None, time_last_used=None, time_updated=None, value=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if java_download_token_id and not isinstance(java_download_token_id, str):
            raise TypeError("Expected argument 'java_download_token_id' to be a str")
        pulumi.set(__self__, "java_download_token_id", java_download_token_id)
        if java_version and not isinstance(java_version, str):
            raise TypeError("Expected argument 'java_version' to be a str")
        pulumi.set(__self__, "java_version", java_version)
        if last_updated_bies and not isinstance(last_updated_bies, list):
            raise TypeError("Expected argument 'last_updated_bies' to be a list")
        pulumi.set(__self__, "last_updated_bies", last_updated_bies)
        if license_types and not isinstance(license_types, list):
            raise TypeError("Expected argument 'license_types' to be a list")
        pulumi.set(__self__, "license_types", license_types)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expires and not isinstance(time_expires, str):
            raise TypeError("Expected argument 'time_expires' to be a str")
        pulumi.set(__self__, "time_expires", time_expires)
        if time_last_used and not isinstance(time_last_used, str):
            raise TypeError("Expected argument 'time_last_used' to be a str")
        pulumi.set(__self__, "time_last_used", time_last_used)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetJavaDownloadsJavaDownloadTokenCreatedByResult']:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        User provided description of the JavaDownloadToken.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name of the principal.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> builtins.bool:
        """
        A flag to indicate if the token is default.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="javaDownloadTokenId")
    def java_download_token_id(self) -> builtins.str:
        return pulumi.get(self, "java_download_token_id")

    @property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> builtins.str:
        """
        The associated Java version of the JavaDownloadToken.
        """
        return pulumi.get(self, "java_version")

    @property
    @pulumi.getter(name="lastUpdatedBies")
    def last_updated_bies(self) -> Sequence['outputs.GetJavaDownloadsJavaDownloadTokenLastUpdatedByResult']:
        """
        An authorized principal.
        """
        return pulumi.get(self, "last_updated_bies")

    @property
    @pulumi.getter(name="licenseTypes")
    def license_types(self) -> Sequence[builtins.str]:
        """
        The license type(s) associated with the JavaDownloadToken.
        """
        return pulumi.get(self, "license_types")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Possible lifecycle substates.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the JavaDownloadToken.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the JavaDownloadToken was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> builtins.str:
        """
        The expiry time of the JavaDownloadToken, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_expires")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> builtins.str:
        """
        The time the JavaDownloadToken was last used for download, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_last_used")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the JavaDownloadToken was updated, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Uniquely generated value for the JavaDownloadToken.
        """
        return pulumi.get(self, "value")


class AwaitableGetJavaDownloadsJavaDownloadTokenResult(GetJavaDownloadsJavaDownloadTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaDownloadsJavaDownloadTokenResult(
            compartment_id=self.compartment_id,
            created_bies=self.created_bies,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_default=self.is_default,
            java_download_token_id=self.java_download_token_id,
            java_version=self.java_version,
            last_updated_bies=self.last_updated_bies,
            license_types=self.license_types,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_expires=self.time_expires,
            time_last_used=self.time_last_used,
            time_updated=self.time_updated,
            value=self.value)


def get_java_downloads_java_download_token(java_download_token_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaDownloadsJavaDownloadTokenResult:
    """
    This data source provides details about a specific Java Download Token resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Gets a JavaDownloadToken by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_token = oci.Jms.get_java_downloads_java_download_token(java_download_token_id=test_java_download_token_oci_jms_java_downloads_java_download_token["id"])
    ```


    :param builtins.str java_download_token_id: Unique JavaDownloadToken identifier.
    """
    __args__ = dict()
    __args__['javaDownloadTokenId'] = java_download_token_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaDownloadsJavaDownloadToken:getJavaDownloadsJavaDownloadToken', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadTokenResult).value

    return AwaitableGetJavaDownloadsJavaDownloadTokenResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        java_download_token_id=pulumi.get(__ret__, 'java_download_token_id'),
        java_version=pulumi.get(__ret__, 'java_version'),
        last_updated_bies=pulumi.get(__ret__, 'last_updated_bies'),
        license_types=pulumi.get(__ret__, 'license_types'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expires=pulumi.get(__ret__, 'time_expires'),
        time_last_used=pulumi.get(__ret__, 'time_last_used'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        value=pulumi.get(__ret__, 'value'))
def get_java_downloads_java_download_token_output(java_download_token_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJavaDownloadsJavaDownloadTokenResult]:
    """
    This data source provides details about a specific Java Download Token resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Gets a JavaDownloadToken by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_token = oci.Jms.get_java_downloads_java_download_token(java_download_token_id=test_java_download_token_oci_jms_java_downloads_java_download_token["id"])
    ```


    :param builtins.str java_download_token_id: Unique JavaDownloadToken identifier.
    """
    __args__ = dict()
    __args__['javaDownloadTokenId'] = java_download_token_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJavaDownloadsJavaDownloadToken:getJavaDownloadsJavaDownloadToken', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadTokenResult)
    return __ret__.apply(lambda __response__: GetJavaDownloadsJavaDownloadTokenResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_bies=pulumi.get(__response__, 'created_bies'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        java_download_token_id=pulumi.get(__response__, 'java_download_token_id'),
        java_version=pulumi.get(__response__, 'java_version'),
        last_updated_bies=pulumi.get(__response__, 'last_updated_bies'),
        license_types=pulumi.get(__response__, 'license_types'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_expires=pulumi.get(__response__, 'time_expires'),
        time_last_used=pulumi.get(__response__, 'time_last_used'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        value=pulumi.get(__response__, 'value')))
