# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogAnalyticsResourceCategoriesManagementArgs', 'LogAnalyticsResourceCategoriesManagement']

@pulumi.input_type
class LogAnalyticsResourceCategoriesManagementArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[builtins.str],
                 resource_categories: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 resource_id: pulumi.Input[builtins.str],
                 resource_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a LogAnalyticsResourceCategoriesManagement resource.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_categories: The list of categories to be assigned to the resource.
        :param pulumi.Input[builtins.str] resource_id: The resource unique identifier for which catagories are managed.
        :param pulumi.Input[builtins.str] resource_type: The resource type of the resource for which categories are managed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_categories", resource_categories)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceCategories")
    def resource_categories(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of categories to be assigned to the resource.
        """
        return pulumi.get(self, "resource_categories")

    @resource_categories.setter
    def resource_categories(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "resource_categories", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource unique identifier for which catagories are managed.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The resource type of the resource for which categories are managed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class _LogAnalyticsResourceCategoriesManagementState:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsResourceCategoriesManagement resources.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_categories: The list of categories to be assigned to the resource.
        :param pulumi.Input[builtins.str] resource_id: The resource unique identifier for which catagories are managed.
        :param pulumi.Input[builtins.str] resource_type: The resource type of the resource for which categories are managed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_categories is not None:
            pulumi.set(__self__, "resource_categories", resource_categories)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceCategories")
    def resource_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of categories to be assigned to the resource.
        """
        return pulumi.get(self, "resource_categories")

    @resource_categories.setter
    def resource_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_categories", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource unique identifier for which catagories are managed.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource type of the resource for which categories are managed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.type_token("oci:LogAnalytics/logAnalyticsResourceCategoriesManagement:LogAnalyticsResourceCategoriesManagement")
class LogAnalyticsResourceCategoriesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Log Analytics Resource Categories Management resource in Oracle Cloud Infrastructure Log Analytics service.

        Updates the category assignments of DASHBOARD and SAVEDSEARCH resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_resource_categories_management = oci.log_analytics.LogAnalyticsResourceCategoriesManagement("test_log_analytics_resource_categories_management",
            namespace=log_analytics_resource_categories_management_namespace,
            resource_id=oci_log_analytics_resource_categories_management_resource_id,
            resource_type=log_analytics_resource_categories_management_resource_type,
            resource_categories=log_analytics_resource_categories_management_resource_categories)
        ```

        ## Import

        LogAnalyticsResourceCategoriesManagement cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_categories: The list of categories to be assigned to the resource.
        :param pulumi.Input[builtins.str] resource_id: The resource unique identifier for which catagories are managed.
        :param pulumi.Input[builtins.str] resource_type: The resource type of the resource for which categories are managed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsResourceCategoriesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log Analytics Resource Categories Management resource in Oracle Cloud Infrastructure Log Analytics service.

        Updates the category assignments of DASHBOARD and SAVEDSEARCH resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_resource_categories_management = oci.log_analytics.LogAnalyticsResourceCategoriesManagement("test_log_analytics_resource_categories_management",
            namespace=log_analytics_resource_categories_management_namespace,
            resource_id=oci_log_analytics_resource_categories_management_resource_id,
            resource_type=log_analytics_resource_categories_management_resource_type,
            resource_categories=log_analytics_resource_categories_management_resource_categories)
        ```

        ## Import

        LogAnalyticsResourceCategoriesManagement cannot be imported.

        :param str resource_name: The name of the resource.
        :param LogAnalyticsResourceCategoriesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsResourceCategoriesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsResourceCategoriesManagementArgs.__new__(LogAnalyticsResourceCategoriesManagementArgs)

            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if resource_categories is None and not opts.urn:
                raise TypeError("Missing required property 'resource_categories'")
            __props__.__dict__["resource_categories"] = resource_categories
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
        super(LogAnalyticsResourceCategoriesManagement, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsResourceCategoriesManagement:LogAnalyticsResourceCategoriesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            resource_categories: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None) -> 'LogAnalyticsResourceCategoriesManagement':
        """
        Get an existing LogAnalyticsResourceCategoriesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_categories: The list of categories to be assigned to the resource.
        :param pulumi.Input[builtins.str] resource_id: The resource unique identifier for which catagories are managed.
        :param pulumi.Input[builtins.str] resource_type: The resource type of the resource for which categories are managed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsResourceCategoriesManagementState.__new__(_LogAnalyticsResourceCategoriesManagementState)

        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_categories"] = resource_categories
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_type"] = resource_type
        return LogAnalyticsResourceCategoriesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceCategories")
    def resource_categories(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of categories to be assigned to the resource.
        """
        return pulumi.get(self, "resource_categories")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The resource unique identifier for which catagories are managed.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The resource type of the resource for which categories are managed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

