# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FileStorageLustreFileSystemMaintenanceWindow',
    'FileStorageLustreFileSystemRootSquashConfiguration',
    'GetFileStorageLustreFileSystemMaintenanceWindowResult',
    'GetFileStorageLustreFileSystemRootSquashConfigurationResult',
    'GetFileStorageLustreFileSystemsFilterResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult',
]

@pulumi.output_type
class FileStorageLustreFileSystemMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "timeStart":
            suggest = "time_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileStorageLustreFileSystemMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileStorageLustreFileSystemMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileStorageLustreFileSystemMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[builtins.str] = None,
                 time_start: Optional[builtins.str] = None):
        """
        :param builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if time_start is not None:
            pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[builtins.str]:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[builtins.str]:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class FileStorageLustreFileSystemRootSquashConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientExceptions":
            suggest = "client_exceptions"
        elif key == "identitySquash":
            suggest = "identity_squash"
        elif key == "squashGid":
            suggest = "squash_gid"
        elif key == "squashUid":
            suggest = "squash_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileStorageLustreFileSystemRootSquashConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileStorageLustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileStorageLustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_exceptions: Optional[Sequence[builtins.str]] = None,
                 identity_squash: Optional[builtins.str] = None,
                 squash_gid: Optional[builtins.str] = None,
                 squash_uid: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] client_exceptions: (Updatable) A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param builtins.str identity_squash: (Updatable) Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param builtins.str squash_gid: (Updatable) The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param builtins.str squash_uid: (Updatable) The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        if client_exceptions is not None:
            pulumi.set(__self__, "client_exceptions", client_exceptions)
        if identity_squash is not None:
            pulumi.set(__self__, "identity_squash", identity_squash)
        if squash_gid is not None:
            pulumi.set(__self__, "squash_gid", squash_gid)
        if squash_uid is not None:
            pulumi.set(__self__, "squash_uid", squash_uid)

    @property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> Optional[builtins.str]:
        """
        (Updatable) Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> Optional[builtins.str]:
        """
        (Updatable) The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> Optional[builtins.str]:
        """
        (Updatable) The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


@pulumi.output_type
class GetFileStorageLustreFileSystemMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 time_start: builtins.str):
        """
        :param builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class GetFileStorageLustreFileSystemRootSquashConfigurationResult(dict):
    def __init__(__self__, *,
                 client_exceptions: Sequence[builtins.str],
                 identity_squash: builtins.str,
                 squash_gid: builtins.str,
                 squash_uid: builtins.str):
        """
        :param Sequence[builtins.str] client_exceptions: A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param builtins.str identity_squash: Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param builtins.str squash_gid: The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param builtins.str squash_uid: The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        pulumi.set(__self__, "client_exceptions", client_exceptions)
        pulumi.set(__self__, "identity_squash", identity_squash)
        pulumi.set(__self__, "squash_gid", squash_gid)
        pulumi.set(__self__, "squash_uid", squash_uid)

    @property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Sequence[builtins.str]:
        """
        A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> builtins.str:
        """
        Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> builtins.str:
        """
        The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> builtins.str:
        """
        The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


@pulumi.output_type
class GetFileStorageLustreFileSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 capacity_in_gbs: builtins.int,
                 cluster_placement_group_id: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 file_system_description: builtins.str,
                 file_system_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 kms_key_id: builtins.str,
                 lifecycle_details: builtins.str,
                 lnet: builtins.str,
                 maintenance_windows: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult'],
                 major_version: builtins.str,
                 management_service_address: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 performance_tier: builtins.str,
                 root_squash_configurations: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult'],
                 state: builtins.str,
                 subnet_id: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_billing_cycle_end: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.int capacity_in_gbs: Capacity of the Lustre file system in GB.
        :param builtins.str cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param builtins.str file_system_description: Short description of the Lustre file system. Avoid entering confidential information.
        :param builtins.str file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param builtins.str lifecycle_details: A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param builtins.str lnet: Type of network used by clients to mount the file system.   Example: `tcp`
        :param Sequence['GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowArgs'] maintenance_windows: The preferred day and time to perform maintenance.
        :param builtins.str major_version: Major version of Lustre running in the Lustre file system.  Example: `2.15`
        :param builtins.str management_service_address: The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        :param Sequence[builtins.str] nsg_ids: A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param builtins.str performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param Sequence['GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationArgs'] root_squash_configurations: An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_billing_cycle_end: The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "file_system_description", file_system_description)
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lnet", lnet)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "major_version", major_version)
        pulumi.set(__self__, "management_service_address", management_service_address)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "performance_tier", performance_tier)
        pulumi.set(__self__, "root_squash_configurations", root_squash_configurations)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> builtins.int:
        """
        Capacity of the Lustre file system in GB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> builtins.str:
        """
        Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> builtins.str:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def lnet(self) -> builtins.str:
        """
        Type of network used by clients to mount the file system.   Example: `tcp`
        """
        return pulumi.get(self, "lnet")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult']:
        """
        The preferred day and time to perform maintenance.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> builtins.str:
        """
        Major version of Lustre running in the Lustre file system.  Example: `2.15`
        """
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="managementServiceAddress")
    def management_service_address(self) -> builtins.str:
        """
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        """
        return pulumi.get(self, "management_service_address")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> builtins.str:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @property
    @pulumi.getter(name="rootSquashConfigurations")
    def root_squash_configurations(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult']:
        """
        An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configurations")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> builtins.str:
        """
        The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 time_start: builtins.str):
        """
        :param builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult(dict):
    def __init__(__self__, *,
                 client_exceptions: Sequence[builtins.str],
                 identity_squash: builtins.str,
                 squash_gid: builtins.str,
                 squash_uid: builtins.str):
        """
        :param Sequence[builtins.str] client_exceptions: A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param builtins.str identity_squash: Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param builtins.str squash_gid: The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param builtins.str squash_uid: The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        pulumi.set(__self__, "client_exceptions", client_exceptions)
        pulumi.set(__self__, "identity_squash", identity_squash)
        pulumi.set(__self__, "squash_gid", squash_gid)
        pulumi.set(__self__, "squash_uid", squash_uid)

    @property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Sequence[builtins.str]:
        """
        A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> builtins.str:
        """
        Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> builtins.str:
        """
        The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> builtins.str:
        """
        The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


