# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReplicationSourcesResult',
    'AwaitableGetReplicationSourcesResult',
    'get_replication_sources',
    'get_replication_sources_output',
]

@pulumi.output_type
class GetReplicationSourcesResult:
    """
    A collection of values returned by getReplicationSources.
    """
    def __init__(__self__, bucket=None, filters=None, id=None, namespace=None, replication_sources=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if replication_sources and not isinstance(replication_sources, list):
            raise TypeError("Expected argument 'replication_sources' to be a list")
        pulumi.set(__self__, "replication_sources", replication_sources)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReplicationSourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="replicationSources")
    def replication_sources(self) -> Sequence['outputs.GetReplicationSourcesReplicationSourceResult']:
        """
        The list of replication_sources.
        """
        return pulumi.get(self, "replication_sources")


class AwaitableGetReplicationSourcesResult(GetReplicationSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationSourcesResult(
            bucket=self.bucket,
            filters=self.filters,
            id=self.id,
            namespace=self.namespace,
            replication_sources=self.replication_sources)


def get_replication_sources(bucket: Optional[builtins.str] = None,
                            filters: Optional[Sequence[Union['GetReplicationSourcesFilterArgs', 'GetReplicationSourcesFilterArgsDict']]] = None,
                            namespace: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationSourcesResult:
    """
    This data source provides the list of Replication Sources in Oracle Cloud Infrastructure Object Storage service.

    List the replication sources of a destination bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_sources = oci.ObjectStorage.get_replication_sources(bucket=replication_source_bucket,
        namespace=replication_source_namespace)
    ```


    :param builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param builtins.str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getReplicationSources:getReplicationSources', __args__, opts=opts, typ=GetReplicationSourcesResult).value

    return AwaitableGetReplicationSourcesResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        replication_sources=pulumi.get(__ret__, 'replication_sources'))
def get_replication_sources_output(bucket: Optional[pulumi.Input[builtins.str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReplicationSourcesFilterArgs', 'GetReplicationSourcesFilterArgsDict']]]]] = None,
                                   namespace: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicationSourcesResult]:
    """
    This data source provides the list of Replication Sources in Oracle Cloud Infrastructure Object Storage service.

    List the replication sources of a destination bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_sources = oci.ObjectStorage.get_replication_sources(bucket=replication_source_bucket,
        namespace=replication_source_namespace)
    ```


    :param builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param builtins.str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ObjectStorage/getReplicationSources:getReplicationSources', __args__, opts=opts, typ=GetReplicationSourcesResult)
    return __ret__.apply(lambda __response__: GetReplicationSourcesResult(
        bucket=pulumi.get(__response__, 'bucket'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        replication_sources=pulumi.get(__response__, 'replication_sources')))
