# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 admin_email: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 idcs_access_token: pulumi.Input[builtins.str],
                 object_storage_namespace: pulumi.Input[builtins.str],
                 tenancy_id: pulumi.Input[builtins.str],
                 tenancy_name: pulumi.Input[builtins.str],
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dr_region: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_access_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_usage_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 waf_primary_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] admin_email: Admin Email for Notification
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[builtins.str] idcs_access_token: Identity Cloud Service access token identifying a stripe and service administrator user
        :param pulumi.Input[builtins.str] object_storage_namespace: Object Storage Namespace of Tenancy
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier
        :param pulumi.Input[builtins.str] tenancy_name: Tenancy Name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] add_on_features: (Updatable) a list of add-on features for the ocm instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) OceInstance description
        :param pulumi.Input[builtins.str] dr_region: (Updatable) disaster recovery paired ragion name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] instance_access_type: Flag indicating whether the instance access is private or public
        :param pulumi.Input[builtins.str] instance_license_type: (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        :param pulumi.Input[builtins.str] instance_usage_type: (Updatable) Instance type based on its usage
        :param pulumi.Input[builtins.str] name: OceInstance Name
        :param pulumi.Input[builtins.str] upgrade_schedule: Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        :param pulumi.Input[builtins.str] waf_primary_domain: (Updatable) Web Application Firewall(WAF) primary domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "admin_email", admin_email)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        pulumi.set(__self__, "object_storage_namespace", object_storage_namespace)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "tenancy_name", tenancy_name)
        if add_on_features is not None:
            pulumi.set(__self__, "add_on_features", add_on_features)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dr_region is not None:
            pulumi.set(__self__, "dr_region", dr_region)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_access_type is not None:
            pulumi.set(__self__, "instance_access_type", instance_access_type)
        if instance_license_type is not None:
            pulumi.set(__self__, "instance_license_type", instance_license_type)
        if instance_usage_type is not None:
            pulumi.set(__self__, "instance_usage_type", instance_usage_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if upgrade_schedule is not None:
            pulumi.set(__self__, "upgrade_schedule", upgrade_schedule)
        if waf_primary_domain is not None:
            pulumi.set(__self__, "waf_primary_domain", waf_primary_domain)

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> pulumi.Input[builtins.str]:
        """
        Admin Email for Notification
        """
        return pulumi.get(self, "admin_email")

    @admin_email.setter
    def admin_email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_email", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Input[builtins.str]:
        """
        Identity Cloud Service access token identifying a stripe and service administrator user
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="objectStorageNamespace")
    def object_storage_namespace(self) -> pulumi.Input[builtins.str]:
        """
        Object Storage Namespace of Tenancy
        """
        return pulumi.get(self, "object_storage_namespace")

    @object_storage_namespace.setter
    def object_storage_namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_storage_namespace", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Input[builtins.str]:
        """
        Tenancy Identifier
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> pulumi.Input[builtins.str]:
        """
        Tenancy Name
        """
        return pulumi.get(self, "tenancy_name")

    @tenancy_name.setter
    def tenancy_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenancy_name", value)

    @property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) a list of add-on features for the ocm instance
        """
        return pulumi.get(self, "add_on_features")

    @add_on_features.setter
    def add_on_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "add_on_features", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) OceInstance description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="drRegion")
    def dr_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) disaster recovery paired ragion name
        """
        return pulumi.get(self, "dr_region")

    @dr_region.setter
    def dr_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dr_region", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceAccessType")
    def instance_access_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Flag indicating whether the instance access is private or public
        """
        return pulumi.get(self, "instance_access_type")

    @instance_access_type.setter
    def instance_access_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_access_type", value)

    @property
    @pulumi.getter(name="instanceLicenseType")
    def instance_license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        """
        return pulumi.get(self, "instance_license_type")

    @instance_license_type.setter
    def instance_license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_license_type", value)

    @property
    @pulumi.getter(name="instanceUsageType")
    def instance_usage_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Instance type based on its usage
        """
        return pulumi.get(self, "instance_usage_type")

    @instance_usage_type.setter
    def instance_usage_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_usage_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OceInstance Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="upgradeSchedule")
    def upgrade_schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        """
        return pulumi.get(self, "upgrade_schedule")

    @upgrade_schedule.setter
    def upgrade_schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upgrade_schedule", value)

    @property
    @pulumi.getter(name="wafPrimaryDomain")
    def waf_primary_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Web Application Firewall(WAF) primary domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "waf_primary_domain")

    @waf_primary_domain.setter
    def waf_primary_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_primary_domain", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_email: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dr_region: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 guid: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_tenancy: Optional[pulumi.Input[builtins.str]] = None,
                 instance_access_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_usage_type: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_storage_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_name: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 waf_primary_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] add_on_features: (Updatable) a list of add-on features for the ocm instance
        :param pulumi.Input[builtins.str] admin_email: Admin Email for Notification
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) OceInstance description
        :param pulumi.Input[builtins.str] dr_region: (Updatable) disaster recovery paired ragion name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] guid: Unique GUID identifier that is immutable on creation
        :param pulumi.Input[builtins.str] idcs_access_token: Identity Cloud Service access token identifying a stripe and service administrator user
        :param pulumi.Input[builtins.str] idcs_tenancy: IDCS Tenancy Identifier
        :param pulumi.Input[builtins.str] instance_access_type: Flag indicating whether the instance access is private or public
        :param pulumi.Input[builtins.str] instance_license_type: (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        :param pulumi.Input[builtins.str] instance_usage_type: (Updatable) Instance type based on its usage
        :param pulumi.Input[builtins.str] lifecycle_details: Details of the current state of the instance lifecycle
        :param pulumi.Input[builtins.str] name: OceInstance Name
        :param pulumi.Input[builtins.str] object_storage_namespace: Object Storage Namespace of Tenancy
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] service: SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        :param pulumi.Input[builtins.str] state: The current state of the instance lifecycle.
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier
        :param pulumi.Input[builtins.str] tenancy_name: Tenancy Name
        :param pulumi.Input[builtins.str] time_created: The time the the OceInstance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the OceInstance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] upgrade_schedule: Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        :param pulumi.Input[builtins.str] waf_primary_domain: (Updatable) Web Application Firewall(WAF) primary domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if add_on_features is not None:
            pulumi.set(__self__, "add_on_features", add_on_features)
        if admin_email is not None:
            pulumi.set(__self__, "admin_email", admin_email)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dr_region is not None:
            pulumi.set(__self__, "dr_region", dr_region)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if idcs_access_token is not None:
            pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if idcs_tenancy is not None:
            pulumi.set(__self__, "idcs_tenancy", idcs_tenancy)
        if instance_access_type is not None:
            pulumi.set(__self__, "instance_access_type", instance_access_type)
        if instance_license_type is not None:
            pulumi.set(__self__, "instance_license_type", instance_license_type)
        if instance_usage_type is not None:
            pulumi.set(__self__, "instance_usage_type", instance_usage_type)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage_namespace is not None:
            pulumi.set(__self__, "object_storage_namespace", object_storage_namespace)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if tenancy_name is not None:
            pulumi.set(__self__, "tenancy_name", tenancy_name)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if upgrade_schedule is not None:
            pulumi.set(__self__, "upgrade_schedule", upgrade_schedule)
        if waf_primary_domain is not None:
            pulumi.set(__self__, "waf_primary_domain", waf_primary_domain)

    @property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) a list of add-on features for the ocm instance
        """
        return pulumi.get(self, "add_on_features")

    @add_on_features.setter
    def add_on_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "add_on_features", value)

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Admin Email for Notification
        """
        return pulumi.get(self, "admin_email")

    @admin_email.setter
    def admin_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_email", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) OceInstance description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="drRegion")
    def dr_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) disaster recovery paired ragion name
        """
        return pulumi.get(self, "dr_region")

    @dr_region.setter
    def dr_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dr_region", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique GUID identifier that is immutable on creation
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity Cloud Service access token identifying a stripe and service administrator user
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="idcsTenancy")
    def idcs_tenancy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IDCS Tenancy Identifier
        """
        return pulumi.get(self, "idcs_tenancy")

    @idcs_tenancy.setter
    def idcs_tenancy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_tenancy", value)

    @property
    @pulumi.getter(name="instanceAccessType")
    def instance_access_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Flag indicating whether the instance access is private or public
        """
        return pulumi.get(self, "instance_access_type")

    @instance_access_type.setter
    def instance_access_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_access_type", value)

    @property
    @pulumi.getter(name="instanceLicenseType")
    def instance_license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        """
        return pulumi.get(self, "instance_license_type")

    @instance_license_type.setter
    def instance_license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_license_type", value)

    @property
    @pulumi.getter(name="instanceUsageType")
    def instance_usage_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Instance type based on its usage
        """
        return pulumi.get(self, "instance_usage_type")

    @instance_usage_type.setter
    def instance_usage_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_usage_type", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Details of the current state of the instance lifecycle
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OceInstance Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStorageNamespace")
    def object_storage_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object Storage Namespace of Tenancy
        """
        return pulumi.get(self, "object_storage_namespace")

    @object_storage_namespace.setter
    def object_storage_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_storage_namespace", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the instance lifecycle.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy Identifier
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy Name
        """
        return pulumi.get(self, "tenancy_name")

    @tenancy_name.setter
    def tenancy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_name", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the OceInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the OceInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upgradeSchedule")
    def upgrade_schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        """
        return pulumi.get(self, "upgrade_schedule")

    @upgrade_schedule.setter
    def upgrade_schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upgrade_schedule", value)

    @property
    @pulumi.getter(name="wafPrimaryDomain")
    def waf_primary_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Web Application Firewall(WAF) primary domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "waf_primary_domain")

    @waf_primary_domain.setter
    def waf_primary_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_primary_domain", value)


@pulumi.type_token("oci:Oce/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_email: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dr_region: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 instance_access_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_usage_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_storage_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_name: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 waf_primary_domain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Oce Instance resource in Oracle Cloud Infrastructure Content and Experience service.

        Creates a new OceInstance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oce_instance = oci.oce.Instance("test_oce_instance",
            admin_email=oce_instance_admin_email,
            compartment_id=compartment_id,
            idcs_access_token=oce_instance_idcs_access_token,
            name=oce_instance_name,
            object_storage_namespace=oce_instance_object_storage_namespace,
            tenancy_id=test_tenancy["id"],
            tenancy_name=test_tenancy["name"],
            add_on_features=oce_instance_add_on_features,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=oce_instance_description,
            dr_region=oce_instance_dr_region,
            freeform_tags={
                "bar-key": "value",
            },
            instance_access_type=oce_instance_instance_access_type,
            instance_license_type=oce_instance_instance_license_type,
            instance_usage_type=oce_instance_instance_usage_type,
            upgrade_schedule=oce_instance_upgrade_schedule,
            waf_primary_domain=oce_instance_waf_primary_domain)
        ```

        ## Import

        OceInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Oce/instance:Instance test_oce_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] add_on_features: (Updatable) a list of add-on features for the ocm instance
        :param pulumi.Input[builtins.str] admin_email: Admin Email for Notification
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) OceInstance description
        :param pulumi.Input[builtins.str] dr_region: (Updatable) disaster recovery paired ragion name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_access_token: Identity Cloud Service access token identifying a stripe and service administrator user
        :param pulumi.Input[builtins.str] instance_access_type: Flag indicating whether the instance access is private or public
        :param pulumi.Input[builtins.str] instance_license_type: (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        :param pulumi.Input[builtins.str] instance_usage_type: (Updatable) Instance type based on its usage
        :param pulumi.Input[builtins.str] name: OceInstance Name
        :param pulumi.Input[builtins.str] object_storage_namespace: Object Storage Namespace of Tenancy
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier
        :param pulumi.Input[builtins.str] tenancy_name: Tenancy Name
        :param pulumi.Input[builtins.str] upgrade_schedule: Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        :param pulumi.Input[builtins.str] waf_primary_domain: (Updatable) Web Application Firewall(WAF) primary domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Oce Instance resource in Oracle Cloud Infrastructure Content and Experience service.

        Creates a new OceInstance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oce_instance = oci.oce.Instance("test_oce_instance",
            admin_email=oce_instance_admin_email,
            compartment_id=compartment_id,
            idcs_access_token=oce_instance_idcs_access_token,
            name=oce_instance_name,
            object_storage_namespace=oce_instance_object_storage_namespace,
            tenancy_id=test_tenancy["id"],
            tenancy_name=test_tenancy["name"],
            add_on_features=oce_instance_add_on_features,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=oce_instance_description,
            dr_region=oce_instance_dr_region,
            freeform_tags={
                "bar-key": "value",
            },
            instance_access_type=oce_instance_instance_access_type,
            instance_license_type=oce_instance_instance_license_type,
            instance_usage_type=oce_instance_instance_usage_type,
            upgrade_schedule=oce_instance_upgrade_schedule,
            waf_primary_domain=oce_instance_waf_primary_domain)
        ```

        ## Import

        OceInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Oce/instance:Instance test_oce_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_email: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dr_region: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 instance_access_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_usage_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_storage_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_name: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 waf_primary_domain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["add_on_features"] = add_on_features
            if admin_email is None and not opts.urn:
                raise TypeError("Missing required property 'admin_email'")
            __props__.__dict__["admin_email"] = admin_email
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["dr_region"] = dr_region
            __props__.__dict__["freeform_tags"] = freeform_tags
            if idcs_access_token is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_access_token'")
            __props__.__dict__["idcs_access_token"] = None if idcs_access_token is None else pulumi.Output.secret(idcs_access_token)
            __props__.__dict__["instance_access_type"] = instance_access_type
            __props__.__dict__["instance_license_type"] = instance_license_type
            __props__.__dict__["instance_usage_type"] = instance_usage_type
            __props__.__dict__["name"] = name
            if object_storage_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'object_storage_namespace'")
            __props__.__dict__["object_storage_namespace"] = object_storage_namespace
            if tenancy_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenancy_id'")
            __props__.__dict__["tenancy_id"] = tenancy_id
            if tenancy_name is None and not opts.urn:
                raise TypeError("Missing required property 'tenancy_name'")
            __props__.__dict__["tenancy_name"] = tenancy_name
            __props__.__dict__["upgrade_schedule"] = upgrade_schedule
            __props__.__dict__["waf_primary_domain"] = waf_primary_domain
            __props__.__dict__["guid"] = None
            __props__.__dict__["idcs_tenancy"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["service"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsAccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'oci:Oce/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            admin_email: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dr_region: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            guid: Optional[pulumi.Input[builtins.str]] = None,
            idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
            idcs_tenancy: Optional[pulumi.Input[builtins.str]] = None,
            instance_access_type: Optional[pulumi.Input[builtins.str]] = None,
            instance_license_type: Optional[pulumi.Input[builtins.str]] = None,
            instance_usage_type: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            object_storage_namespace: Optional[pulumi.Input[builtins.str]] = None,
            service: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
            tenancy_name: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            upgrade_schedule: Optional[pulumi.Input[builtins.str]] = None,
            waf_primary_domain: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] add_on_features: (Updatable) a list of add-on features for the ocm instance
        :param pulumi.Input[builtins.str] admin_email: Admin Email for Notification
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) OceInstance description
        :param pulumi.Input[builtins.str] dr_region: (Updatable) disaster recovery paired ragion name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] guid: Unique GUID identifier that is immutable on creation
        :param pulumi.Input[builtins.str] idcs_access_token: Identity Cloud Service access token identifying a stripe and service administrator user
        :param pulumi.Input[builtins.str] idcs_tenancy: IDCS Tenancy Identifier
        :param pulumi.Input[builtins.str] instance_access_type: Flag indicating whether the instance access is private or public
        :param pulumi.Input[builtins.str] instance_license_type: (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        :param pulumi.Input[builtins.str] instance_usage_type: (Updatable) Instance type based on its usage
        :param pulumi.Input[builtins.str] lifecycle_details: Details of the current state of the instance lifecycle
        :param pulumi.Input[builtins.str] name: OceInstance Name
        :param pulumi.Input[builtins.str] object_storage_namespace: Object Storage Namespace of Tenancy
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] service: SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        :param pulumi.Input[builtins.str] state: The current state of the instance lifecycle.
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenancy_id: Tenancy Identifier
        :param pulumi.Input[builtins.str] tenancy_name: Tenancy Name
        :param pulumi.Input[builtins.str] time_created: The time the the OceInstance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the OceInstance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] upgrade_schedule: Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        :param pulumi.Input[builtins.str] waf_primary_domain: (Updatable) Web Application Firewall(WAF) primary domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["add_on_features"] = add_on_features
        __props__.__dict__["admin_email"] = admin_email
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["dr_region"] = dr_region
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["guid"] = guid
        __props__.__dict__["idcs_access_token"] = idcs_access_token
        __props__.__dict__["idcs_tenancy"] = idcs_tenancy
        __props__.__dict__["instance_access_type"] = instance_access_type
        __props__.__dict__["instance_license_type"] = instance_license_type
        __props__.__dict__["instance_usage_type"] = instance_usage_type
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["object_storage_namespace"] = object_storage_namespace
        __props__.__dict__["service"] = service
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["tenancy_name"] = tenancy_name
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upgrade_schedule"] = upgrade_schedule
        __props__.__dict__["waf_primary_domain"] = waf_primary_domain
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) a list of add-on features for the ocm instance
        """
        return pulumi.get(self, "add_on_features")

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> pulumi.Output[builtins.str]:
        """
        Admin Email for Notification
        """
        return pulumi.get(self, "admin_email")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) OceInstance description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="drRegion")
    def dr_region(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) disaster recovery paired ragion name
        """
        return pulumi.get(self, "dr_region")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def guid(self) -> pulumi.Output[builtins.str]:
        """
        Unique GUID identifier that is immutable on creation
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Output[builtins.str]:
        """
        Identity Cloud Service access token identifying a stripe and service administrator user
        """
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="idcsTenancy")
    def idcs_tenancy(self) -> pulumi.Output[builtins.str]:
        """
        IDCS Tenancy Identifier
        """
        return pulumi.get(self, "idcs_tenancy")

    @property
    @pulumi.getter(name="instanceAccessType")
    def instance_access_type(self) -> pulumi.Output[builtins.str]:
        """
        Flag indicating whether the instance access is private or public
        """
        return pulumi.get(self, "instance_access_type")

    @property
    @pulumi.getter(name="instanceLicenseType")
    def instance_license_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Flag indicating whether the instance license is new cloud or bring your own license
        """
        return pulumi.get(self, "instance_license_type")

    @property
    @pulumi.getter(name="instanceUsageType")
    def instance_usage_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Instance type based on its usage
        """
        return pulumi.get(self, "instance_usage_type")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Details of the current state of the instance lifecycle
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        OceInstance Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorageNamespace")
    def object_storage_namespace(self) -> pulumi.Output[builtins.str]:
        """
        Object Storage Namespace of Tenancy
        """
        return pulumi.get(self, "object_storage_namespace")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the instance lifecycle.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy Identifier
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy Name
        """
        return pulumi.get(self, "tenancy_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the the OceInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the OceInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeSchedule")
    def upgrade_schedule(self) -> pulumi.Output[builtins.str]:
        """
        Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        """
        return pulumi.get(self, "upgrade_schedule")

    @property
    @pulumi.getter(name="wafPrimaryDomain")
    def waf_primary_domain(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Web Application Firewall(WAF) primary domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "waf_primary_domain")

