# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupArgs', 'ManagedInstanceGroup']

@pulumi.input_type
class ManagedInstanceGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroup resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[builtins.str] display_name: (Updatable) Managed Instance Group identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the managed instance group
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance OCIDs to be added to the managed instance group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] os_family: The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Managed Instance Group identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Information specified by the user about the managed instance group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of managed instance OCIDs to be added to the managed instance group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_family", value)


@pulumi.input_type
class _ManagedInstanceGroupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManagedInstanceArgs']]]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroup resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the managed instance group
        :param pulumi.Input[builtins.str] display_name: (Updatable) Managed Instance Group identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance OCIDs to be added to the managed instance group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManagedInstanceArgs']]] managed_instances: list of Managed Instances in the group
        :param pulumi.Input[builtins.str] os_family: The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        :param pulumi.Input[builtins.str] state: The current state of the Software Source.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if managed_instance_count is not None:
            pulumi.set(__self__, "managed_instance_count", managed_instance_count)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if managed_instances is not None:
            pulumi.set(__self__, "managed_instances", managed_instances)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Information specified by the user about the managed instance group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Managed Instance Group identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="managedInstanceCount")
    def managed_instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "managed_instance_count")

    @managed_instance_count.setter
    def managed_instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "managed_instance_count", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of managed instance OCIDs to be added to the managed instance group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManagedInstanceArgs']]]]:
        """
        list of Managed Instances in the group
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManagedInstanceArgs']]]]):
        pulumi.set(self, "managed_instances", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("oci:OsManagement/managedInstanceGroup:ManagedInstanceGroup")
class ManagedInstanceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group resource in Oracle Cloud Infrastructure OS Management service.

        Creates a new Managed Instance Group on the management system.
        This will not contain any managed instances after it is first created,
        and they must be added later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group = oci.os_management.ManagedInstanceGroup("test_managed_instance_group",
            compartment_id=compartment_id,
            display_name=managed_instance_group_display_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=managed_instance_group_description,
            freeform_tags={
                "bar-key": "value",
            },
            os_family=managed_instance_group_os_family,
            managed_instance_ids=managed_instance_group_managed_instance_ids)
        ```

        ## Import

        ManagedInstanceGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagement/managedInstanceGroup:ManagedInstanceGroup test_managed_instance_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the managed instance group
        :param pulumi.Input[builtins.str] display_name: (Updatable) Managed Instance Group identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance OCIDs to be added to the managed instance group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] os_family: The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group resource in Oracle Cloud Infrastructure OS Management service.

        Creates a new Managed Instance Group on the management system.
        This will not contain any managed instances after it is first created,
        and they must be added later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group = oci.os_management.ManagedInstanceGroup("test_managed_instance_group",
            compartment_id=compartment_id,
            display_name=managed_instance_group_display_name,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=managed_instance_group_description,
            freeform_tags={
                "bar-key": "value",
            },
            os_family=managed_instance_group_os_family,
            managed_instance_ids=managed_instance_group_managed_instance_ids)
        ```

        ## Import

        ManagedInstanceGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagement/managedInstanceGroup:ManagedInstanceGroup test_managed_instance_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupArgs.__new__(ManagedInstanceGroupArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["managed_instance_ids"] = managed_instance_ids
            __props__.__dict__["os_family"] = os_family
            __props__.__dict__["managed_instance_count"] = None
            __props__.__dict__["managed_instances"] = None
            __props__.__dict__["state"] = None
        super(ManagedInstanceGroup, __self__).__init__(
            'oci:OsManagement/managedInstanceGroup:ManagedInstanceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
            managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManagedInstanceArgs', 'ManagedInstanceGroupManagedInstanceArgsDict']]]]] = None,
            os_family: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedInstanceGroup':
        """
        Get an existing ManagedInstanceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the managed instance group
        :param pulumi.Input[builtins.str] display_name: (Updatable) Managed Instance Group identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance OCIDs to be added to the managed instance group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManagedInstanceArgs', 'ManagedInstanceGroupManagedInstanceArgsDict']]]] managed_instances: list of Managed Instances in the group
        :param pulumi.Input[builtins.str] os_family: The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        :param pulumi.Input[builtins.str] state: The current state of the Software Source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupState.__new__(_ManagedInstanceGroupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["managed_instance_count"] = managed_instance_count
        __props__.__dict__["managed_instance_ids"] = managed_instance_ids
        __props__.__dict__["managed_instances"] = managed_instances
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["state"] = state
        return ManagedInstanceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Information specified by the user about the managed instance group
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Managed Instance Group identifier
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="managedInstanceCount")
    def managed_instance_count(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "managed_instance_count")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of managed instance OCIDs to be added to the managed instance group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupManagedInstance']]:
        """
        list of Managed Instances in the group
        """
        return pulumi.get(self, "managed_instances")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[builtins.str]:
        """
        The Operating System type of the managed instance(s) on which this scheduled job will operate. If not specified, this defaults to Linux.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")

