# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LifecycleStageRebootManagementArgs', 'LifecycleStageRebootManagement']

@pulumi.input_type
class LifecycleStageRebootManagementArgs:
    def __init__(__self__, *,
                 lifecycle_stage_id: pulumi.Input[builtins.str],
                 reboot_timeout_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 work_request_details: Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a LifecycleStageRebootManagement resource.
        :param pulumi.Input[builtins.str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[builtins.int] reboot_timeout_in_mins: The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        :param pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if reboot_timeout_in_mins is not None:
            pulumi.set(__self__, "reboot_timeout_in_mins", reboot_timeout_in_mins)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="rebootTimeoutInMins")
    def reboot_timeout_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        """
        return pulumi.get(self, "reboot_timeout_in_mins")

    @reboot_timeout_in_mins.setter
    def reboot_timeout_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reboot_timeout_in_mins", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _LifecycleStageRebootManagementState:
    def __init__(__self__, *,
                 lifecycle_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 reboot_timeout_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 work_request_details: Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering LifecycleStageRebootManagement resources.
        :param pulumi.Input[builtins.str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[builtins.int] reboot_timeout_in_mins: The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        :param pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if lifecycle_stage_id is not None:
            pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if reboot_timeout_in_mins is not None:
            pulumi.set(__self__, "reboot_timeout_in_mins", reboot_timeout_in_mins)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="rebootTimeoutInMins")
    def reboot_timeout_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        """
        return pulumi.get(self, "reboot_timeout_in_mins")

    @reboot_timeout_in_mins.setter
    def reboot_timeout_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reboot_timeout_in_mins", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['LifecycleStageRebootManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.type_token("oci:OsManagementHub/lifecycleStageRebootManagement:LifecycleStageRebootManagement")
class LifecycleStageRebootManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 reboot_timeout_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 work_request_details: Optional[pulumi.Input[Union['LifecycleStageRebootManagementWorkRequestDetailsArgs', 'LifecycleStageRebootManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Lifecycle Stage Reboot Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Reboots all managed instances in the specified lifecycle stage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_stage_reboot_management = oci.os_management_hub.LifecycleStageRebootManagement("test_lifecycle_stage_reboot_management",
            lifecycle_stage_id=test_lifecycle_stage["id"],
            reboot_timeout_in_mins=lifecycle_stage_reboot_management_reboot_timeout_in_mins,
            work_request_details={
                "description": lifecycle_stage_reboot_management_work_request_details_description,
                "display_name": lifecycle_stage_reboot_management_work_request_details_display_name,
            })
        ```

        ## Import

        LifecycleStageRebootManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleStageRebootManagement:LifecycleStageRebootManagement test_lifecycle_stage_reboot_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[builtins.int] reboot_timeout_in_mins: The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        :param pulumi.Input[Union['LifecycleStageRebootManagementWorkRequestDetailsArgs', 'LifecycleStageRebootManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecycleStageRebootManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Lifecycle Stage Reboot Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Reboots all managed instances in the specified lifecycle stage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_stage_reboot_management = oci.os_management_hub.LifecycleStageRebootManagement("test_lifecycle_stage_reboot_management",
            lifecycle_stage_id=test_lifecycle_stage["id"],
            reboot_timeout_in_mins=lifecycle_stage_reboot_management_reboot_timeout_in_mins,
            work_request_details={
                "description": lifecycle_stage_reboot_management_work_request_details_description,
                "display_name": lifecycle_stage_reboot_management_work_request_details_display_name,
            })
        ```

        ## Import

        LifecycleStageRebootManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleStageRebootManagement:LifecycleStageRebootManagement test_lifecycle_stage_reboot_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param LifecycleStageRebootManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecycleStageRebootManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 reboot_timeout_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 work_request_details: Optional[pulumi.Input[Union['LifecycleStageRebootManagementWorkRequestDetailsArgs', 'LifecycleStageRebootManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecycleStageRebootManagementArgs.__new__(LifecycleStageRebootManagementArgs)

            if lifecycle_stage_id is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_stage_id'")
            __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
            __props__.__dict__["reboot_timeout_in_mins"] = reboot_timeout_in_mins
            __props__.__dict__["work_request_details"] = work_request_details
        super(LifecycleStageRebootManagement, __self__).__init__(
            'oci:OsManagementHub/lifecycleStageRebootManagement:LifecycleStageRebootManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            lifecycle_stage_id: Optional[pulumi.Input[builtins.str]] = None,
            reboot_timeout_in_mins: Optional[pulumi.Input[builtins.int]] = None,
            work_request_details: Optional[pulumi.Input[Union['LifecycleStageRebootManagementWorkRequestDetailsArgs', 'LifecycleStageRebootManagementWorkRequestDetailsArgsDict']]] = None) -> 'LifecycleStageRebootManagement':
        """
        Get an existing LifecycleStageRebootManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[builtins.int] reboot_timeout_in_mins: The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        :param pulumi.Input[Union['LifecycleStageRebootManagementWorkRequestDetailsArgs', 'LifecycleStageRebootManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecycleStageRebootManagementState.__new__(_LifecycleStageRebootManagementState)

        __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
        __props__.__dict__["reboot_timeout_in_mins"] = reboot_timeout_in_mins
        __props__.__dict__["work_request_details"] = work_request_details
        return LifecycleStageRebootManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter(name="rebootTimeoutInMins")
    def reboot_timeout_in_mins(self) -> pulumi.Output[builtins.int]:
        """
        The number of minutes the service waits for the reboot to complete. If the instances in the stage don't reboot  within this time, the reboot job status is set to failed.
        """
        return pulumi.get(self, "reboot_timeout_in_mins")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.LifecycleStageRebootManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

