# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrivateEndpointReachableIpResult',
    'AwaitableGetPrivateEndpointReachableIpResult',
    'get_private_endpoint_reachable_ip',
    'get_private_endpoint_reachable_ip_output',
]

@pulumi.output_type
class GetPrivateEndpointReachableIpResult:
    """
    A collection of values returned by getPrivateEndpointReachableIp.
    """
    def __init__(__self__, id=None, ip_address=None, private_endpoint_id=None, private_ip=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        An IP address for the Resource Manager service to use for connection to the private resource.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        return pulumi.get(self, "private_ip")


class AwaitableGetPrivateEndpointReachableIpResult(GetPrivateEndpointReachableIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateEndpointReachableIpResult(
            id=self.id,
            ip_address=self.ip_address,
            private_endpoint_id=self.private_endpoint_id,
            private_ip=self.private_ip)


def get_private_endpoint_reachable_ip(private_endpoint_id: Optional[builtins.str] = None,
                                      private_ip: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateEndpointReachableIpResult:
    """
    This data source provides details about a specific Private Endpoint Reachable Ip resource in Oracle Cloud Infrastructure Resource Manager service.

    Gets the alternative IP address of the private resource. This IP will be used by Resource Manager Service to connect to the private resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_endpoint_reachable_ip = oci.ResourceManager.get_private_endpoint_reachable_ip(private_endpoint_id=test_private_endpoint["id"],
        private_ip=private_endpoint_reachable_ip_private_ip)
    ```


    :param builtins.str private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
    :param builtins.str private_ip: The IP address of the resource in the private subnet.
    """
    __args__ = dict()
    __args__['privateEndpointId'] = private_endpoint_id
    __args__['privateIp'] = private_ip
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ResourceManager/getPrivateEndpointReachableIp:getPrivateEndpointReachableIp', __args__, opts=opts, typ=GetPrivateEndpointReachableIpResult).value

    return AwaitableGetPrivateEndpointReachableIpResult(
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'))
def get_private_endpoint_reachable_ip_output(private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                             private_ip: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateEndpointReachableIpResult]:
    """
    This data source provides details about a specific Private Endpoint Reachable Ip resource in Oracle Cloud Infrastructure Resource Manager service.

    Gets the alternative IP address of the private resource. This IP will be used by Resource Manager Service to connect to the private resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_endpoint_reachable_ip = oci.ResourceManager.get_private_endpoint_reachable_ip(private_endpoint_id=test_private_endpoint["id"],
        private_ip=private_endpoint_reachable_ip_private_ip)
    ```


    :param builtins.str private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
    :param builtins.str private_ip: The IP address of the resource in the private subnet.
    """
    __args__ = dict()
    __args__['privateEndpointId'] = private_endpoint_id
    __args__['privateIp'] = private_ip
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ResourceManager/getPrivateEndpointReachableIp:getPrivateEndpointReachableIp', __args__, opts=opts, typ=GetPrivateEndpointReachableIpResult)
    return __ret__.apply(lambda __response__: GetPrivateEndpointReachableIpResult(
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        private_endpoint_id=pulumi.get(__response__, 'private_endpoint_id'),
        private_ip=pulumi.get(__response__, 'private_ip')))
