/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import bridge.SingleDeployedContract;
import bridge.SourceLanguage;
import bridge.SourceTypeDescription;
import bridge.StorageLayout;
import bridge.VerificationQuery;
import bridge.types.SolidityTypeDescription;
import cli.ConverterKt;
import config.Config;
import disassembler.DisassembledEVMBytecode;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import log.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import preprocessing.ProverInputPreprocessor;
import scene.ContractClassIdentifiers;
import scene.ContractUniverse;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractLoader;
import scene.IContractSource;
import scene.IContractWithSource;
import scene.IPerContractClassCache;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.TrivialSceneFactory;
import spec.CVL;
import spec.CVLAstBuilder;
import spec.DummyTypeResolver;
import spec.cvlast.CVLAst;
import spec.cvlast.SolidityContract;
import spec.cvlast.typechecker.CVLError;
import tac.DummyStorageInfo;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;
import utils.CVLSerializerModules;
import utils.CollectingResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\tJ*\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u000f\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lpreprocessing/ProverInputPreprocessor;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "_main", "", "args", "", "", "astCb", "Lkotlin/Function1;", "Lspec/cvlast/CVLAst;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getCertoraVerifyFile", "", "Lbridge/VerificationQuery;", "filepath", "outForLSPServer", "ast", "parseInputFileNames", "Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "([Ljava/lang/String;)Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "setConfigFromMetadata", "metadataElem", "Lkotlinx/serialization/json/JsonObject;", "withSpec", "Lutils/CollectingResult;", "Lspec/cvlast/typechecker/CVLError;", "verifyFile", "withSpecAndContractBuildInformation", "Lspec/CVL;", "buildFile", "BasicContractSource", "InputFileNames", "Shared"})
public final class ProverInputPreprocessor {
    @NotNull
    public static final ProverInputPreprocessor INSTANCE = new ProverInputPreprocessor();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, json.1.INSTANCE, 1, null);

    private ProverInputPreprocessor() {
    }

    private final List<VerificationQuery> getCertoraVerifyFile(String filepath) {
        String it = FilesKt.readText$default(new File(filepath), null, 1, null);
        boolean bl = false;
        return (List)json.decodeFromString(BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), it);
    }

    private final void setConfigFromMetadata(JsonObject metadataElem) {
        String string = ProverInputPreprocessor.setConfigFromMetadata$getRulesFromMetadata(metadataElem);
        if (string == null) {
            return;
        }
        String rules = string;
        Config.INSTANCE.getRuleChoice().set((Serializable)ConverterKt.getStringSetConverter().getConvert().invoke(rules));
    }

    /*
     * WARNING - void declaration
     */
    private final CollectingResult<List<CVL>, CVLError> withSpecAndContractBuildInformation(String buildFile, String verifyFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<VerificationQuery> verify = this.getCertoraVerifyFile(verifyFile);
        BasicContractSource contractSource = new BasicContractSource(buildFile);
        IScene scene = TrivialSceneFactory.INSTANCE.getScene(contractSource);
        Iterable iterable = verify;
        CollectingResult.Companion companion = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v;
            VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            System.out.println((Object)("Type checking " + v.getPrimary_contract()));
            collection.add(new CVLAstBuilder(v.toCVLInput(), contractSource.instances(), ((IContractWithSource)((Object)scene.getContract(new SolidityContract(v.getPrimary_contract())))).getSrc(), scene, null).build());
        }
        return companion.flatten((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CollectingResult<List<CVLAst>, CVLError> withSpec(@NotNull String verifyFile) {
        Collection<CollectingResult<CVLAst, CVLError>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(verifyFile, "verifyFile");
        List<VerificationQuery> verify = this.getCertoraVerifyFile(verifyFile);
        Iterable iterable = verify;
        CollectingResult.Companion companion = CollectingResult.Companion;
        CollectingResult.Companion companion2 = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v;
            VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(v.toCVLInput().getRawCVLAst(new DummyTypeResolver(new SolidityContract(v.getPrimary_contract()))));
        }
        collection = (List)destination$iv$iv;
        CollectingResult<List<CVLAst>, CVLError> cvlAstList2 = companion2.map(companion.flatten(collection), withSpec.cvlAstList.2.INSTANCE);
        return cvlAstList2;
    }

    @ExperimentalSerializationApi
    public final void outForLSPServer(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        StringFormat $this$encodeToString$iv = CVLSerializerModules.INSTANCE.getLspServerFormat();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv, Reflection.typeOf(CVLAst.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull($this$cast$iv$iv$iv, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        System.out.println((Object)$this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, ast2));
    }

    private final InputFileNames parseInputFileNames(String[] args2) {
        String internalDirectory;
        String string;
        String string2;
        String buildFileName;
        Options options = new Options();
        String metadataFileOpt = "m";
        String verifyFileOpt = "v";
        String buildFileOpt = "b";
        String internalDirOpt = "d";
        options.addOption(metadataFileOpt, true, "metadata json file");
        options.addOption(verifyFileOpt, true, "verify json file");
        options.addOption(buildFileOpt, true, "build json file");
        options.addOption(internalDirOpt, true, "internal directory");
        CommandLine cmdLineArgs = new DefaultParser().parse(options, args2);
        String metadataFileName = cmdLineArgs.getOptionValue(metadataFileOpt);
        String string3 = cmdLineArgs.getOptionValue(buildFileOpt);
        if (string3 == null) {
            string3 = buildFileName = args2.length == 2 ? args2[0] : null;
        }
        if ((string2 = cmdLineArgs.getOptionValue(verifyFileOpt)) == null) {
            switch (args2.length) {
                case 2: {
                    string = args2[1];
                    break;
                }
                case 1: {
                    string = args2[0];
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else {
            string = string2;
        }
        String verifyFileName = string;
        String string4 = internalDirectory = cmdLineArgs.getOptionValue(internalDirOpt);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            Config.INSTANCE.getCertoraBuildDirectory().set((Serializable)((Object)it));
        }
        return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void _main(@NotNull String[] args2, @NotNull Function1<? super CVLAst, Unit> astCb) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(astCb, "astCb");
        try {
            try {
                void $this$map$iv;
                Object object;
                Object object2;
                Object stdin;
                CollectingResult<List<CVL>, CVLError> collectingResult;
                InputFileNames inputFileNames = this.parseInputFileNames(args2);
                String metadataFileName = inputFileNames.getMetadataFileName();
                String buildFileName = inputFileNames.getBuildFileName();
                String verifyFileName = inputFileNames.getVerifyFileName();
                if (metadataFileName != null) {
                    try {
                        JsonObject metadataElem = JsonElementKt.getJsonObject(Json.Default.parseToJsonElement(FilesKt.readText$default(new File(metadataFileName), null, 1, null)));
                        this.setConfigFromMetadata(metadataElem);
                    }
                    catch (Exception e) {
                        Logger.Companion.alwaysWarn("Error in parsing input file " + metadataFileName);
                        throw e;
                    }
                }
                if (buildFileName != null && verifyFileName != null) {
                    collectingResult = this.withSpecAndContractBuildInformation(buildFileName, verifyFileName);
                } else if (verifyFileName != null) {
                    collectingResult = CollectingResult.Companion.map(this.withSpec(verifyFileName), (Function1)new Function1<List<? extends CVLAst>, Unit>(astCb){
                        final /* synthetic */ Function1<CVLAst, Unit> $astCb;
                        {
                            this.$astCb = $astCb;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull List<CVLAst> asts) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(asts, "asts");
                            Iterable iterable = asts;
                            Function1<CVLAst, Unit> function1 = this.$astCb;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                CVLAst ast2 = (CVLAst)element$iv;
                                boolean bl = false;
                                function1.invoke(ast2);
                            }
                        }
                    });
                } else if (buildFileName == null) {
                    Collection<CollectingResult<CVLAst, CVLError>> collection;
                    void $this$mapTo$iv$iv;
                    String string = ConsoleKt.readLine();
                    Intrinsics.checkNotNull(string);
                    stdin = string;
                    List verify = (List)json.decodeFromString(BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), (String)stdin);
                    Iterable iterable = verify;
                    object2 = CollectingResult.Companion;
                    object = CollectingResult.Companion;
                    boolean $i$f$map = false;
                    void var12_21 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void v;
                        VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv2;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(v.toCVLInput().getRawCVLAst(new DummyTypeResolver(new SolidityContract(v.getPrimary_contract()))));
                    }
                    collection = (List)destination$iv$iv;
                    collectingResult = ((CollectingResult.Companion)object).map(((CollectingResult.Companion)object2).flatten(collection), (Function1)new Function1<List<? extends CVLAst>, Unit>(astCb){
                        final /* synthetic */ Function1<CVLAst, Unit> $astCb;
                        {
                            this.$astCb = $astCb;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull List<CVLAst> asts) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(asts, "asts");
                            Iterable iterable = asts;
                            Function1<CVLAst, Unit> function1 = this.$astCb;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                CVLAst ast2 = (CVLAst)element$iv;
                                boolean bl = false;
                                function1.invoke(ast2);
                            }
                        }
                    });
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv2;
                    stdin = args2;
                    object = System.err;
                    boolean $i$f$map = false;
                    $this$map$iv = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl = false;
                        object2.add(it);
                    }
                    ((PrintStream)object).println("Bad input to CVL typechecker: " + (List)destination$iv$iv);
                    collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
                }
                CollectingResult<List<CVL>, CVLError> result2 = collectingResult;
                result2.resultOrExitProcess(1, _main.1.INSTANCE);
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CVLAstBuilder.CVLParsingException.CUPParser cUPParser) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CVLAstBuilder.CVLParsingException.Kotlinization e) {
                System.err.println(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Throwable e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        catch (Throwable throwable) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String setConfigFromMetadata$getRulesFromMetadata(JsonObject metadataElem) {
        try {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            JsonElement settings;
            JsonElement jsonElement;
            JsonElement jsonElement2 = (JsonElement)JsonElementKt.getJsonObject(metadataElem).get((Object)"args");
            if (jsonElement2 == null) {
                jsonElement = null;
            } else {
                JsonObject jsonObject = JsonElementKt.getJsonObject(jsonElement2);
                jsonElement = settings = jsonObject == null ? null : (JsonElement)jsonObject.get((Object)"settings");
            }
            if (settings == null || settings instanceof JsonNull) {
                return null;
            }
            if (!(settings instanceof JsonArray)) {
                Logger.Companion.alwaysWarn("Cannot process metadata settings as they are not in array format");
                return null;
            }
            Iterable $this$filter$iv = (Iterable)Json.Default.decodeFromString(BuiltinSerializersKt.ListSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE)), JsonElementKt.getJsonArray(settings).toString());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, "=", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                String it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                List setting = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
                Pair pair2 = TuplesKt.to(setting.get(0), setting.get(1));
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map ruleMap = destination$iv$iv2;
            String string = (String)ruleMap.get("-rule");
            if (string == null) {
                string = (String)ruleMap.get("-rules");
            }
            return string;
        }
        catch (Exception e) {
            Logger.Companion.alwaysWarn("Could not parse settings from metadata", e);
            return null;
        }
    }

    public static final /* synthetic */ Json access$getJson$p() {
        return json;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0010H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lpreprocessing/ProverInputPreprocessor$BasicContractSource;", "Lscene/IContractSource;", "Lscene/IContractLoader;", "file", "", "(Ljava/lang/String;)V", "buildResources", "", "Lbridge/SingleDeployedContract;", "getBuildResources", "()Ljava/util/Map;", "buildResources$delegate", "Lkotlin/Lazy;", "getFile", "()Ljava/lang/String;", "instances", "", "Lbridge/ContractInstanceInSDC;", "getInstances", "()Ljava/util/List;", "instances$delegate", "aliases", "", "Ljava/math/BigInteger;", "load", "Lscene/IContractClass;", "sdc", "cache", "Lscene/IPerContractClassCache;", "Shared"})
    public static final class BasicContractSource
    implements IContractSource,
    IContractLoader {
        @NotNull
        private final String file;
        @NotNull
        private final Lazy buildResources$delegate;
        @NotNull
        private final Lazy instances$delegate;

        public BasicContractSource(@NotNull String file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.buildResources$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends SingleDeployedContract>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<String, SingleDeployedContract> invoke() {
                    String it = FilesKt.readText$default(new File(this.this$0.getFile()), null, 1, null);
                    boolean bl = false;
                    return (Map)ProverInputPreprocessor.access$getJson$p().decodeFromString(BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), it);
                }
            });
            this.instances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ContractInstanceInSDC> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Map $this$mapNotNull$iv = BasicContractSource.access$getBuildResources(this.this$0);
                    boolean $i$f$mapNotNull = false;
                    Map map2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        ContractInstanceInSDC it$iv$iv;
                        Map.Entry<K, V> element$iv$iv$iv;
                        Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = object.next();
                        boolean bl = false;
                        Map.Entry<K, V> $dstr$_u24__u24$v = element$iv$iv;
                        boolean bl2 = false;
                        SingleDeployedContract v = (SingleDeployedContract)$dstr$_u24__u24$v.getValue();
                        if (v.getPrimary_contract() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void contractInstanceInSDC;
                        object = (ContractInstanceInSDC)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        BigInteger bigInteger = contractInstanceInSDC.getAddress();
                        Map<K, V> map3 = MapsKt.emptyMap();
                        String string = contractInstanceInSDC.getName();
                        StorageLayout storageLayout = contractInstanceInSDC.getStorageLayout();
                        Set<SourceTypeDescription> set = contractInstanceInSDC.getTypes();
                        Set<SolidityTypeDescription> set2 = contractInstanceInSDC.getSolidityTypes();
                        List<Method> list = contractInstanceInSDC.getMethods();
                        List<Method> list2 = contractInstanceInSDC.getAllMethods();
                        Map<String, Method> map4 = contractInstanceInSDC.getInternalFunctions();
                        String string2 = contractInstanceInSDC.getOriginal_file();
                        SourceLanguage sourceLanguage = contractInstanceInSDC.getLang();
                        collection.add(new ContractInstanceInSDC(string, string2, sourceLanguage, "", bigInteger, list, "", "", "", null, null, storageLayout, set, set2, map3, null, null, null, null, null, list2, map4, null, 5211648, null));
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        private final Map<String, SingleDeployedContract> getBuildResources() {
            Lazy lazy = this.buildResources$delegate;
            return (Map)lazy.getValue();
        }

        private final List<ContractInstanceInSDC> getInstances() {
            Lazy lazy = this.instances$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc, @NotNull IPerContractClassCache cache2) {
            Intrinsics.checkNotNullParameter(sdc, "sdc");
            Intrinsics.checkNotNullParameter(cache2, "cache");
            return new IContractClass(sdc){
                final /* synthetic */ ContractInstanceInSDC $sdc;
                {
                    this.$sdc = $sdc;
                }

                @Nullable
                public ITACMethod getConstructor() {
                    return null;
                }

                @Nullable
                public ITACMethod getMethodBySigHash(@NotNull BigInteger sig) {
                    Intrinsics.checkNotNullParameter(sig, "sig");
                    return null;
                }

                @Nullable
                public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique attr) {
                    Intrinsics.checkNotNullParameter(attr, "attr");
                    return null;
                }

                @NotNull
                public IStorageInfo getStorage() {
                    return DummyStorageInfo.INSTANCE;
                }

                @Nullable
                public TACStorageLayout getStorageLayout() {
                    StorageLayout storageLayout = this.$sdc.getStorageLayout();
                    return storageLayout == null ? null : storageLayout.toTACStorageLayout();
                }

                @NotNull
                public Collection<ITACMethod> getDeclaredMethods() {
                    return CollectionsKt.emptyList();
                }

                public void mapMethods(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p) {
                    Intrinsics.checkNotNullParameter(scene, "scene");
                    Intrinsics.checkNotNullParameter(p, "p");
                }

                @NotNull
                public IContractClass fork() {
                    return this;
                }

                @NotNull
                public BigInteger getInstanceId() {
                    return this.$sdc.getAddress();
                }

                @NotNull
                public String getName() {
                    return this.$sdc.getName();
                }

                @NotNull
                public Map<BigInteger, ITACMethod> getMethods() {
                    return MapsKt.emptyMap();
                }

                @Nullable
                public ITACMethod getWholeContractMethod() {
                    return null;
                }

                @Nullable
                public ITACMethod getConstructorMethod() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getBytecode() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getConstructorBytecode() {
                    return null;
                }

                @NotNull
                public ContractInstanceInSDC getSrc() {
                    return this.$sdc;
                }

                @NotNull
                public ITACSymbol getAddressSym() {
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public ContractClassIdentifiers toIdentifiers() {
                    return IContractClass.DefaultImpls.toIdentifiers(this);
                }

                @NotNull
                public ITACMethod getWholeContract() {
                    return IContractClass.DefaultImpls.getWholeContract(this);
                }

                @NotNull
                public List<ITACMethod> getMethods() {
                    return IContractClass.DefaultImpls.getMethods(this);
                }

                @NotNull
                public Collection<ITACMethod> getStandardMethods() {
                    return IContractClass.DefaultImpls.getStandardMethods(this);
                }

                public void mapMethodsInPlace(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
                    IContractClass.DefaultImpls.mapMethodsInPlace(this, scene, p);
                }

                @NotNull
                public String getConstructorCodeName() {
                    return IContractClass.DefaultImpls.getConstructorCodeName(this);
                }

                @NotNull
                public IContractClass.ContractMemento saveState() {
                    return IContractClass.DefaultImpls.saveState(this);
                }

                public void restore(@NotNull IContractClass.ContractMemento m) {
                    IContractClass.DefaultImpls.restore(this, m);
                }

                @Nullable
                public ContractWithStateLinkInfo getContractStateLinks() {
                    return IContractClass.DefaultImpls.getContractStateLinks(this);
                }
            };
        }

        @Override
        @NotNull
        public List<ContractInstanceInSDC> instances() {
            return this.getInstances();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Set<BigInteger>> aliases() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInstances();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ContractInstanceInSDC contractInstanceInSDC = (ContractInstanceInSDC)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SetsKt.setOf(it.getAddress()));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.load(this, sdc);
        }

        @Override
        @NotNull
        public ContractUniverse contractUniverse() {
            return IContractSource.DefaultImpls.contractUniverse(this);
        }

        @Override
        @NotNull
        public IContractClass invoke(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.invoke(this, sdc);
        }

        public static final /* synthetic */ Map access$getBuildResources(BasicContractSource $this) {
            return $this.getBuildResources();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "", "metadataFileName", "", "buildFileName", "verifyFileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildFileName", "()Ljava/lang/String;", "getMetadataFileName", "getVerifyFileName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Shared"})
    public static final class InputFileNames {
        @Nullable
        private final String metadataFileName;
        @Nullable
        private final String buildFileName;
        @Nullable
        private final String verifyFileName;

        public InputFileNames(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            this.metadataFileName = metadataFileName;
            this.buildFileName = buildFileName;
            this.verifyFileName = verifyFileName;
        }

        @Nullable
        public final String getMetadataFileName() {
            return this.metadataFileName;
        }

        @Nullable
        public final String getBuildFileName() {
            return this.buildFileName;
        }

        @Nullable
        public final String getVerifyFileName() {
            return this.verifyFileName;
        }

        @Nullable
        public final String component1() {
            return this.metadataFileName;
        }

        @Nullable
        public final String component2() {
            return this.buildFileName;
        }

        @Nullable
        public final String component3() {
            return this.verifyFileName;
        }

        @NotNull
        public final InputFileNames copy(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
        }

        public static /* synthetic */ InputFileNames copy$default(InputFileNames inputFileNames, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = inputFileNames.metadataFileName;
            }
            if ((n & 2) != 0) {
                string2 = inputFileNames.buildFileName;
            }
            if ((n & 4) != 0) {
                string3 = inputFileNames.verifyFileName;
            }
            return inputFileNames.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "InputFileNames(metadataFileName=" + this.metadataFileName + ", buildFileName=" + this.buildFileName + ", verifyFileName=" + this.verifyFileName + ")";
        }

        public int hashCode() {
            int result2 = this.metadataFileName == null ? 0 : this.metadataFileName.hashCode();
            result2 = result2 * 31 + (this.buildFileName == null ? 0 : this.buildFileName.hashCode());
            result2 = result2 * 31 + (this.verifyFileName == null ? 0 : this.verifyFileName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileNames)) {
                return false;
            }
            InputFileNames inputFileNames = (InputFileNames)other;
            if (!Intrinsics.areEqual(this.metadataFileName, inputFileNames.metadataFileName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.buildFileName, inputFileNames.buildFileName)) {
                return false;
            }
            return Intrinsics.areEqual(this.verifyFileName, inputFileNames.verifyFileName);
        }
    }
}

